/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.internal.core.parser.ParserMessages;

public class QuickParseCallback
extends NullSourceElementRequestor
implements IQuickParseCallback {
    protected IASTCompilationUnit compUnit = null;
    protected List inclusions = new ArrayList();
    protected List macros = new ArrayList();
    protected boolean hasNoProblems = true;

    public Iterator getInclusions() {
        return this.inclusions.iterator();
    }

    public Iterator getMacros() {
        return this.macros.iterator();
    }

    public Iterator getDeclarations() {
        try {
            return this.compUnit.getDeclarations();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {
            return null;
        }
    }

    public void exitMethodBody(IASTMethod method) {
        method.setHasFunctionBody(true);
    }

    public void exitFunctionBody(IASTFunction function) {
        function.setHasFunctionBody(true);
    }

    public void exitCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.compUnit = compilationUnit;
    }

    public void exitInclusion(IASTInclusion inclusion) {
        this.inclusions.add(inclusion);
    }

    public void acceptMacro(IASTMacro macro) {
        this.macros.add(macro);
    }

    public IASTCompilationUnit getCompilationUnit() {
        return this.compUnit;
    }

    public Iterator iterateOffsetableElements() {
        return new OffsetableIterator();
    }

    public boolean acceptProblem(IProblem problem) {
        this.setHasNoProblems(false);
        return super.acceptProblem(problem);
    }

    public boolean hasNoProblems() {
        return this.hasNoProblems;
    }

    public void setHasNoProblems(boolean hasProblems) {
        this.hasNoProblems = hasProblems;
    }

    public class OffsetableIterator
    implements Iterator {
        private Iterator declarationIter;
        private final Iterator inclusionIter;
        private final Iterator macroIter;
        private IASTOffsetableElement currentMacro = null;
        private IASTOffsetableElement currentInclusion = null;
        private IASTOffsetableElement currentDeclaration = null;

        public OffsetableIterator() {
            this.declarationIter = QuickParseCallback.this.getDeclarations();
            this.inclusionIter = QuickParseCallback.this.getInclusions();
            this.macroIter = QuickParseCallback.this.getMacros();
            this.updateInclusionIterator();
            this.updateMacroIterator();
            this.updateDeclarationIterator();
        }

        private Object updateDeclarationIterator() {
            IASTOffsetableElement offsetable = this.currentDeclaration;
            if (this.declarationIter != null) {
                this.currentDeclaration = this.declarationIter.hasNext() ? (IASTOffsetableElement)this.declarationIter.next() : null;
            }
            return offsetable;
        }

        private Object updateMacroIterator() {
            IASTOffsetableElement offsetable = this.currentMacro;
            this.currentMacro = this.macroIter.hasNext() ? (IASTOffsetableElement)this.macroIter.next() : null;
            return offsetable;
        }

        private Object updateInclusionIterator() {
            IASTOffsetableElement offsetable = this.currentInclusion;
            this.currentInclusion = this.inclusionIter.hasNext() ? (IASTOffsetableElement)this.inclusionIter.next() : null;
            return offsetable;
        }

        public boolean hasNext() {
            return this.currentMacro != null || this.currentInclusion != null || this.currentDeclaration != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.currentMacro == null && this.currentInclusion == null) {
                return this.updateDeclarationIterator();
            }
            if (this.currentDeclaration == null && this.currentInclusion == null) {
                return this.updateMacroIterator();
            }
            if (this.currentMacro == null && this.currentDeclaration == null) {
                return this.updateInclusionIterator();
            }
            if (this.currentMacro == null) {
                if (this.currentDeclaration.getStartingOffset() < this.currentInclusion.getStartingOffset()) {
                    return this.updateDeclarationIterator();
                }
                return this.updateInclusionIterator();
            }
            if (this.currentInclusion == null) {
                if (this.currentDeclaration.getStartingOffset() < this.currentMacro.getStartingOffset()) {
                    return this.updateDeclarationIterator();
                }
                return this.updateMacroIterator();
            }
            if (this.currentDeclaration == null) {
                if (this.currentInclusion.getStartingOffset() < this.currentMacro.getStartingOffset()) {
                    return this.updateInclusionIterator();
                }
                return this.updateMacroIterator();
            }
            if (this.currentInclusion.getStartingOffset() < this.currentMacro.getStartingOffset() && this.currentInclusion.getStartingOffset() < this.currentDeclaration.getStartingOffset()) {
                return this.updateInclusionIterator();
            }
            if (this.currentMacro.getStartingOffset() < this.currentInclusion.getStartingOffset() && this.currentMacro.getStartingOffset() < this.currentDeclaration.getStartingOffset()) {
                return this.updateMacroIterator();
            }
            return this.updateDeclarationIterator();
        }

        public void remove() {
            throw new UnsupportedOperationException(ParserMessages.getString("QuickParseCallback.exception.constIterator"));
        }
    }
}

