/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.ctags;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class CtagsIndexer
implements IPDOMIndexer {
    public static final String ID = "org.eclipse.cdt.core.ctagsindexer";
    private ICProject project;
    private boolean useCtagsOnPath = true;
    private String ctagsCommand = "";
    private boolean useInternalCtagsFile = true;
    private String ctagsFileName = "";
    private static final String useCtagsOnPathId = "useCtagsOnPath";
    private static final String ctagsCommandId = "ctagsCommand";
    private static final String useInternalCtagsFileId = "useInternalCtagsFile";
    private static final String ctagsFileNameId = "ctagsFileName";

    public void handleDelta(ICElementDelta delta) throws CoreException {
        CCorePlugin.getPDOMManager().setIndexerId(this.project, "org.eclipse.cdt.core.nullindexer");
    }

    public void reindex() throws CoreException {
        CCorePlugin.getPDOMManager().setIndexerId(this.project, "org.eclipse.cdt.core.nullindexer");
    }

    public ICProject getProject() {
        return this.project;
    }

    public void setProject(ICProject project) {
        this.project = project;
    }

    private void loadPreferences() {
        IEclipsePreferences prefs = new ProjectScope(this.project.getProject()).getNode("org.eclipse.cdt.core");
        if (prefs == null) {
            return;
        }
        this.ctagsCommand = prefs.get(ctagsCommandId, null);
        if (this.ctagsCommand != null) {
            this.useCtagsOnPath = prefs.getBoolean(useCtagsOnPathId, CtagsIndexer.getDefaultUseCtagsOnPath());
            this.useInternalCtagsFile = prefs.getBoolean(useInternalCtagsFileId, CtagsIndexer.getDefaultUseInternalCtagsFile());
            this.ctagsFileName = prefs.get(ctagsFileNameId, CtagsIndexer.getDefaultCtagsFileName());
        } else {
            try {
                ICExtensionReference[] cext;
                ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(this.project.getProject(), false);
                if (desc != null && (cext = desc.get("org.eclipse.cdt.core.CIndexer")).length > 0) {
                    int i = 0;
                    while (i < cext.length) {
                        String orig = cext[i].getExtensionData("ctagslocationtype");
                        this.useCtagsOnPath = orig != null ? !orig.equals("ctags_path_specified") : CtagsIndexer.getDefaultUseCtagsOnPath();
                        orig = cext[i].getExtensionData("ctagslocation");
                        this.ctagsCommand = orig != null ? orig : CtagsIndexer.getDefaultCtagsCommand();
                        orig = cext[i].getExtensionData("ctagfiletype");
                        this.useInternalCtagsFile = orig != null ? !orig.equals("ctags_external") : CtagsIndexer.getDefaultUseInternalCtagsFile();
                        orig = cext[i].getExtensionData("ctagfilelocation");
                        this.ctagsFileName = orig != null ? orig : CtagsIndexer.getDefaultCtagsFileName();
                        ++i;
                    }
                }
            }
            catch (CoreException coreException) {}
            if (this.ctagsCommand == null) {
                this.useCtagsOnPath = CtagsIndexer.getDefaultUseCtagsOnPath();
                this.ctagsCommand = CtagsIndexer.getDefaultCtagsCommand();
                this.useInternalCtagsFile = CtagsIndexer.getDefaultUseInternalCtagsFile();
                this.ctagsFileName = CtagsIndexer.getDefaultCtagsFileName();
            }
        }
    }

    public void setPreferences(boolean useCtagsOnPath, String ctagsCommand, boolean useInternalCtagsFile, String ctagsFileName) throws CoreException {
        IEclipsePreferences prefs = new ProjectScope(this.project.getProject()).getNode("org.eclipse.cdt.core");
        if (prefs == null) {
            return;
        }
        boolean changed = false;
        if (this.useCtagsOnPath != useCtagsOnPath) {
            this.useCtagsOnPath = useCtagsOnPath;
            prefs.putBoolean(useCtagsOnPathId, useCtagsOnPath);
            changed = true;
        }
        if (!this.ctagsCommand.equals(ctagsCommand)) {
            this.ctagsCommand = ctagsCommand;
            prefs.put(ctagsCommandId, ctagsCommand);
            changed = true;
        }
        if (this.useInternalCtagsFile != useInternalCtagsFile) {
            this.useInternalCtagsFile = useInternalCtagsFile;
            prefs.putBoolean(useInternalCtagsFileId, useInternalCtagsFile);
            changed = true;
        }
        if (!this.ctagsFileName.equals(ctagsFileName)) {
            this.ctagsFileName = ctagsFileName;
            prefs.put(ctagsFileNameId, ctagsFileName);
            changed = true;
        }
        if (changed) {
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                CCorePlugin.log(e);
            }
            this.reindex();
        }
    }

    public boolean useCtagsOnPath() {
        return this.useCtagsOnPath;
    }

    public String getCtagsCommand() {
        return this.ctagsCommand;
    }

    public String getResolvedCtagsCommand() {
        return this.useCtagsOnPath ? "ctags" : this.ctagsCommand;
    }

    public boolean useInternalCtagsFile() {
        return this.useInternalCtagsFile;
    }

    public String getCtagsFileName() {
        return this.ctagsFileName;
    }

    public String getResolvedCtagsFileName() {
        if (this.useInternalCtagsFile) {
            return CCorePlugin.getDefault().getStateLocation().append(String.valueOf(this.project.getElementName()) + ".ctags").toOSString();
        }
        return this.ctagsFileName;
    }

    public static boolean getDefaultUseCtagsOnPath() {
        IPreferencesService prefService = Platform.getPreferencesService();
        return prefService.getBoolean("org.eclipse.cdt.core", useCtagsOnPathId, true, null);
    }

    public static String getDefaultCtagsCommand() {
        IPreferencesService prefService = Platform.getPreferencesService();
        return prefService.getString("org.eclipse.cdt.core", ctagsCommandId, "", null);
    }

    public static boolean getDefaultUseInternalCtagsFile() {
        IPreferencesService prefService = Platform.getPreferencesService();
        return prefService.getBoolean("org.eclipse.cdt.core", useInternalCtagsFileId, true, null);
    }

    public static String getDefaultCtagsFileName() {
        IPreferencesService prefService = Platform.getPreferencesService();
        return prefService.getString("org.eclipse.cdt.core", ctagsFileNameId, "", null);
    }

    public static void setDefaultPreferences(boolean useCtagsOnPath, String ctagsCommand, boolean useInternalCtagsFile, String ctagsFileName) {
        IEclipsePreferences prefs = new InstanceScope().getNode("org.eclipse.cdt.core");
        if (prefs == null) {
            return;
        }
        prefs.putBoolean(useCtagsOnPathId, useCtagsOnPath);
        prefs.put(ctagsCommandId, ctagsCommand);
        prefs.putBoolean(useInternalCtagsFileId, useInternalCtagsFile);
        prefs.put(ctagsFileNameId, ctagsFileName);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
    }
}

