/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.fast;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMCodeReaderFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.indexer.fast.PDOMFastIndexer;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMFastIndexerJob
implements IPDOMIndexerTask {
    protected final PDOMFastIndexer indexer;
    protected final PDOM pdom;
    protected final PDOMCodeReaderFactory codeReaderFactory;
    protected int errorCount;
    protected final int MAX_ERRORS = 10;

    public PDOMFastIndexerJob(PDOMFastIndexer indexer) throws CoreException {
        this.indexer = indexer;
        this.pdom = (PDOM)CCorePlugin.getPDOMManager().getPDOM(indexer.getProject());
        this.codeReaderFactory = new PDOMCodeReaderFactory(this.pdom);
    }

    public IPDOMIndexer getIndexer() {
        return this.indexer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addTU(ITranslationUnit tu) throws InterruptedException, CoreException {
        ILanguage language = tu.getLanguage();
        if (language == null) {
            return;
        }
        IASTTranslationUnit ast = language.getASTTranslationUnit(tu, this.codeReaderFactory, 9);
        if (ast == null) {
            return;
        }
        this.codeReaderFactory.clearMacros();
        this.pdom.acquireWriteLock();
        try {
            this.addSymbols(language, ast);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.pdom.releaseWriteLock();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.pdom.releaseWriteLock();
            return;
        }
    }

    protected void addSymbols(ILanguage language, IASTTranslationUnit ast) throws InterruptedException, CoreException {
        final PDOMLinkage linkage = this.pdom.getLinkage(language);
        if (linkage == null) {
            return;
        }
        IASTPreprocessorIncludeStatement[] includes = ast.getIncludeDirectives();
        int i = 0;
        while (i < includes.length) {
            IASTPreprocessorIncludeStatement include = includes[i];
            IASTFileLocation sourceLoc = include.getFileLocation();
            String sourcePath = sourceLoc != null ? sourceLoc.getFileName() : ast.getFilePath();
            PDOMFile sourceFile = this.codeReaderFactory.getCachedFile(sourcePath);
            String destPath = include.getPath();
            PDOMFile destFile = this.codeReaderFactory.getCachedFile(destPath);
            sourceFile.addIncludeTo(destFile);
            ++i;
        }
        IASTPreprocessorMacroDefinition[] macros = ast.getMacroDefinitions();
        int i2 = 0;
        while (i2 < macros.length) {
            IASTPreprocessorMacroDefinition macro = macros[i2];
            IASTFileLocation sourceLoc = macro.getFileLocation();
            if (sourceLoc != null) {
                String filename = sourceLoc.getFileName();
                PDOMFile sourceFile = this.codeReaderFactory.getCachedFile(filename);
                sourceFile.addMacro(macro);
            }
            ++i2;
        }
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitNames = true;
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTName name) {
                try {
                    IASTFileLocation nameLoc = name.getFileLocation();
                    if (nameLoc != null) {
                        linkage.addName(name, PDOMFastIndexerJob.this.codeReaderFactory.getCachedFile(nameLoc.getFileName()));
                    }
                    return 3;
                }
                catch (Throwable e) {
                    CCorePlugin.log(e);
                    return ++PDOMFastIndexerJob.this.errorCount > 10 ? 2 : 3;
                }
            }
        });
    }
}

