/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.StorableEnvironment;
import org.eclipse.cdt.managedbuilder.internal.macros.StorableMacros;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManagedProject
extends BuildObject
implements IManagedProject {
    private static final String EMPTY_STRING = new String();
    private static final IConfiguration[] emptyConfigs = new IConfiguration[0];
    private IProjectType projectType;
    private String projectTypeId;
    private IResource owner;
    private List configList;
    private Map configMap;
    private boolean isDirty = false;
    private boolean isValid = true;
    private boolean resolved = true;
    private StorableMacros userDefinedMacros;
    private StorableEnvironment userDefinedEnvironment;

    protected ManagedProject(IResource owner) {
        this.owner = owner;
    }

    public ManagedProject(IResource owner, IProjectType projectType) {
        this(owner);
        this.projectType = projectType;
        int id = ManagedBuildManager.getRandomNumber();
        this.setId(String.valueOf(owner.getName()) + "." + projectType.getId() + "." + id);
        this.setName(projectType.getName());
        this.setManagedBuildRevision(projectType.getManagedBuildRevision());
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(owner);
        buildInfo.setManagedProject(this);
        this.setDirty(true);
    }

    public ManagedProject(ManagedBuildInfo buildInfo, Element element, String managedBuildRevision) {
        this(buildInfo.getOwner());
        this.setManagedBuildRevision(managedBuildRevision);
        if (this.loadFromProject(element)) {
            boolean isSupportAvailable = this.projectType.checkForMigrationSupport();
            if (!isSupportAvailable) {
                this.setValid(false);
            }
            NodeList configElements = element.getChildNodes();
            int i = 0;
            while (i < configElements.getLength()) {
                Node configElement = configElements.item(i);
                if (configElement.getNodeName().equals("configuration")) {
                    new Configuration(this, (Element)configElement, managedBuildRevision);
                } else if (configElement.getNodeName().equals("macros")) {
                    this.userDefinedMacros = new StorableMacros((Element)configElement);
                }
                ++i;
            }
        } else {
            this.setValid(false);
        }
        buildInfo.setManagedProject(this);
    }

    protected boolean loadFromProject(Element element) {
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.projectTypeId = element.getAttribute("projectType");
        if (this.projectTypeId != null && this.projectTypeId.length() > 0) {
            this.projectType = ManagedBuildManager.getExtensionProjectType(this.projectTypeId);
            if (this.projectType == null) {
                return false;
            }
        }
        return true;
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.projectType != null) {
            element.setAttribute("projectType", this.projectType.getId());
        }
        List configElements = this.getConfigurationList();
        ListIterator iter = configElements.listIterator();
        while (iter.hasNext()) {
            Configuration config = (Configuration)iter.next();
            Element configElement = doc.createElement("configuration");
            element.appendChild(configElement);
            config.serialize(doc, configElement);
        }
        if (this.userDefinedMacros != null) {
            Element macrosElement = doc.createElement("macros");
            element.appendChild(macrosElement);
            this.userDefinedMacros.serialize(doc, macrosElement);
        }
        if (this.userDefinedEnvironment != null) {
            EnvironmentVariableProvider.fUserSupplier.storeEnvironment(this, true);
        }
        this.isDirty = false;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public void updateOwner(IResource resource) {
        if (!resource.equals((Object)this.owner)) {
            this.owner = resource;
        }
    }

    public IProjectType getProjectType() {
        return this.projectType;
    }

    public IConfiguration createConfiguration(IConfiguration parent, String id) {
        Configuration config = new Configuration(this, (Configuration)parent, id, false, false);
        ManagedBuildManager.performValueHandlerEvent(config, 1);
        return config;
    }

    public IConfiguration createConfigurationClone(IConfiguration parent, String id) {
        Configuration config = new Configuration(this, (Configuration)parent, id, true, false);
        ManagedBuildManager.performValueHandlerEvent(config, 1);
        return config;
    }

    public IConfiguration getConfiguration(String id) {
        return (IConfiguration)this.getConfigurationMap().get(id);
    }

    public IConfiguration[] getConfigurations() {
        IConfiguration[] configs = new IConfiguration[this.getConfigurationList().size()];
        ListIterator iter = this.getConfigurationList().listIterator();
        int i = 0;
        while (iter.hasNext()) {
            Configuration config = (Configuration)iter.next();
            configs[i++] = config;
        }
        return configs;
    }

    public void removeConfiguration(String id) {
        final String removeId = id;
        if (this.getConfigurationMap().get(id) == null) {
            return;
        }
        IWorkspaceRunnable remover = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ListIterator iter = ManagedProject.this.getConfigurationList().listIterator();
                while (iter.hasNext()) {
                    IConfiguration config = (IConfiguration)iter.next();
                    if (!config.getId().equals(removeId)) continue;
                    IResource proj = config.getOwner();
                    IManagedBuildInfo info = null;
                    if (proj instanceof IProject) {
                        info = ManagedBuildManager.getBuildInfo(proj);
                    }
                    IConfiguration currentConfig = null;
                    boolean isCurrent = true;
                    if (info != null && !(currentConfig = info.getDefaultConfiguration()).getId().equals(removeId)) {
                        info.setDefaultConfiguration(config);
                        isCurrent = false;
                    }
                    ((IProject)proj).build(15, monitor);
                    ManagedBuildManager.performValueHandlerEvent(config, 2);
                    PropertyManager.getInstance().clearProperties(config);
                    ManagedProject.this.getConfigurationList().remove(config);
                    ManagedProject.this.getConfigurationMap().remove(removeId);
                    if (info == null) break;
                    if (!isCurrent) {
                        info.setDefaultConfiguration(currentConfig);
                        break;
                    }
                    String[] configs = info.getConfigurationNames();
                    if (configs.length <= 0) break;
                    info.setDefaultConfiguration(configs[0]);
                    break;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(remover, null);
        }
        catch (CoreException coreException) {}
        this.setDirty(true);
    }

    public void addConfiguration(Configuration configuration) {
        if (!configuration.isTemporary()) {
            this.getConfigurationList().add(configuration);
            this.getConfigurationMap().put(configuration.getId(), configuration);
        }
    }

    private List getConfigurationList() {
        if (this.configList == null) {
            this.configList = new ArrayList();
        }
        return this.configList;
    }

    public Map getConfigurationMap() {
        if (this.configMap == null) {
            this.configMap = new HashMap();
        }
        return this.configMap;
    }

    public String getDefaultArtifactName() {
        String name = new String();
        String[] tokens = this.getOwner().getName().split("\\s");
        int index = 0;
        while (index < tokens.length) {
            name = String.valueOf(name) + tokens[index];
            ++index;
        }
        return name;
    }

    public boolean resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.projectTypeId != null && this.projectTypeId.length() > 0) {
                this.projectType = ManagedBuildManager.getExtensionProjectType(this.projectTypeId);
                if (this.projectType == null) {
                    return false;
                }
            }
            Iterator configIter = this.getConfigurationList().iterator();
            while (configIter.hasNext()) {
                Configuration current = (Configuration)configIter.next();
                current.resolveReferences();
            }
        }
        return true;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        if (this.userDefinedMacros != null && this.userDefinedMacros.isDirty()) {
            return true;
        }
        if (this.userDefinedEnvironment != null && this.userDefinedEnvironment.isDirty()) {
            return true;
        }
        ListIterator iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            Configuration current = (Configuration)iter.next();
            if (!current.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            ListIterator iter = this.getConfigurationList().listIterator();
            while (iter.hasNext()) {
                Configuration current = (Configuration)iter.next();
                current.setDirty(false);
            }
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getProjectType() != null) {
            return this.getProjectType().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }

    public StorableMacros getUserDefinedMacros() {
        if (this.userDefinedMacros == null) {
            this.userDefinedMacros = new StorableMacros();
        }
        return this.userDefinedMacros;
    }

    public StorableEnvironment getUserDefinedEnvironmet() {
        return this.userDefinedEnvironment;
    }

    public void setUserDefinedEnvironmet(StorableEnvironment env) {
        this.userDefinedEnvironment = env;
    }

    public void updateManagedBuildRevision(String revision) {
        super.updateManagedBuildRevision(revision);
        Iterator iter = this.getConfigurationList().iterator();
        while (iter.hasNext()) {
            Configuration cfg = (Configuration)iter.next();
            cfg.updateManagedBuildRevision(revision);
        }
    }

    public void setProjectType(IProjectType projectType) {
        if (this.projectType != projectType) {
            this.projectType = projectType;
            this.projectTypeId = this.projectType == null ? null : this.projectType.getId();
        }
    }
}

