/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class JoinLinesAction
extends TextEditorAction {
    ITextEditor theEditor;

    public JoinLinesAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        IDocument theDocument;
        if (this.theEditor != null && this.isEnabled() && this.canModifyEditor() && (theDocument = this.getDocument(this.theEditor)) != null) {
            try {
                ITextSelection theSelection = this.getSelection(this.theEditor);
                if (theSelection != null) {
                    int currentLine = theSelection.getEndLine();
                    int lineOffset = theDocument.getLineOffset(currentLine);
                    int lineLength = theDocument.getLineLength(currentLine);
                    String delim = theDocument.getLineDelimiter(currentLine);
                    int delimLength = delim.length();
                    int newLineEnd = lineOffset + lineLength - delimLength;
                    theDocument.replace(newLineEnd, delimLength, null);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void update() {
        super.update();
        if (this.isEnabled() && this.canModifyEditor()) {
            this.theEditor = this.getTextEditor();
        }
    }

    private IDocument getDocument(ITextEditor editor) {
        IDocument theDocument = null;
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider != null) {
            theDocument = documentProvider.getDocument((Object)editor.getEditorInput());
        }
        return theDocument;
    }

    private ITextSelection getSelection(ITextEditor editor) {
        ISelection selection;
        ITextSelection theSelection = null;
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            theSelection = (ITextSelection)selection;
        }
        return theSelection;
    }
}

