/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast.gnu.c;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.cdt.internal.core.dom.parser.c.GCCParserExtensionConfiguration;
import org.eclipse.cdt.internal.core.dom.parser.c.GNUCSourceParser;
import org.eclipse.cdt.internal.core.parser.scanner2.DOMScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMCodeReaderFactory;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCLinkageFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public class GCCLanguage
extends PlatformObject
implements ILanguage {
    protected static final GCCScannerExtensionConfiguration C_GNU_SCANNER_EXTENSION = new GCCScannerExtensionConfiguration();
    public static final String ID = "org.eclipse.cdt.core.gcc";
    private static final GCCLanguage myDefault = new GCCLanguage();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static GCCLanguage getDefault() {
        return myDefault;
    }

    public String getId() {
        return ID;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new PDOMCLinkageFactory();
        }
        return super.getAdapter(adapter);
    }

    public IASTTranslationUnit getASTTranslationUnit(ITranslationUnit file, int style) throws CoreException {
        ICodeReaderFactory fileCreator;
        if ((style & 6) != 0) {
            IPDOM iPDOM = CCorePlugin.getPDOMManager().getPDOM(file.getCProject());
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.internal.core.pdom.PDOM");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PDOM pdom = (PDOM)iPDOM.getAdapter(clazz);
            fileCreator = new PDOMCodeReaderFactory(pdom);
        } else {
            fileCreator = SavedCodeReaderFactory.getInstance();
        }
        return this.getASTTranslationUnit(file, fileCreator, style);
    }

    public IASTTranslationUnit getASTTranslationUnit(ITranslationUnit file, ICodeReaderFactory codeReaderFactory, int style) throws CoreException {
        CodeReader reader;
        IFile rfile;
        String path;
        IResource resource = file.getResource();
        ICProject project = file.getCProject();
        IProject rproject = project.getProject();
        IScannerInfo scanInfo = null;
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(rproject);
        if (provider != null) {
            Object infoResource = resource != null ? resource : rproject;
            IScannerInfo buildScanInfo = provider.getScannerInformation((IResource)infoResource);
            if (buildScanInfo != null) {
                scanInfo = buildScanInfo;
            } else {
                if ((style & 8) != 0) {
                    return null;
                }
                scanInfo = new ScannerInfo();
            }
        }
        String string = path = (rfile = (IFile)file.getResource()) != null ? rfile.getLocation().toOSString() : file.getPath().toOSString();
        if (file instanceof IWorkingCopy) {
            reader = new CodeReader(path, file.getContents());
        } else {
            reader = codeReaderFactory.createCodeReaderForTranslationUnit(path);
            if (reader == null) {
                return null;
            }
        }
        GCCScannerExtensionConfiguration scannerExtensionConfiguration = C_GNU_SCANNER_EXTENSION;
        DOMScanner scanner = new DOMScanner(reader, scanInfo, ParserMode.COMPLETE_PARSE, ParserLanguage.C, ParserFactory.createDefaultLogService(), scannerExtensionConfiguration, codeReaderFactory);
        GNUCSourceParser parser = new GNUCSourceParser(scanner, ParserMode.COMPLETE_PARSE, ParserUtil.getParserLogService(), new GCCParserExtensionConfiguration());
        IASTTranslationUnit ast = parser.parse();
        if ((style & 1) != 0) {
            ast.setIndex(CCorePlugin.getPDOMManager().getPDOM(file.getCProject()));
        }
        return ast;
    }

    public ASTCompletionNode getCompletionNode(IWorkingCopy workingCopy, int offset) throws CoreException {
        IResource resource = workingCopy.getResource();
        ICProject project = workingCopy.getCProject();
        IProject rproject = project.getProject();
        IScannerInfo scanInfo = null;
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(rproject);
        if (provider != null) {
            IResource infoResource = resource != null ? resource : rproject;
            IScannerInfo buildScanInfo = provider.getScannerInformation(infoResource);
            scanInfo = buildScanInfo != null ? buildScanInfo : new ScannerInfo();
        }
        ICodeReaderFactory fileCreator = CDOM.getInstance().getCodeReaderFactory(2);
        String path = resource != null ? resource.getLocation().toOSString() : workingCopy.getOriginalElement().getPath().toOSString();
        CodeReader reader = new CodeReader(path, workingCopy.getContents());
        GCCScannerExtensionConfiguration scannerExtensionConfiguration = C_GNU_SCANNER_EXTENSION;
        DOMScanner scanner = new DOMScanner(reader, scanInfo, ParserMode.COMPLETE_PARSE, ParserLanguage.C, ParserFactory.createDefaultLogService(), scannerExtensionConfiguration, fileCreator);
        scanner.setContentAssistMode(offset);
        GNUCSourceParser parser = new GNUCSourceParser(scanner, ParserMode.COMPLETION_PARSE, ParserUtil.getParserLogService(), new GCCParserExtensionConfiguration());
        parser.parse();
        ASTCompletionNode node = parser.getCompletionNode();
        if (node != null) {
            node.count = scanner.getCount();
        }
        return node;
    }

    public IASTName[] getSelectedNames(IASTTranslationUnit ast, int start, int length) {
        IASTNode selectedNode = ast.selectNodeForLocation(ast.getFilePath(), start, length);
        if (selectedNode == null) {
            return new IASTName[0];
        }
        if (selectedNode instanceof IASTName) {
            return new IASTName[]{(IASTName)selectedNode};
        }
        NameCollector collector = new NameCollector();
        selectedNode.accept(collector);
        return collector.getNames();
    }

    public IContributedModelBuilder createModelBuilder(ITranslationUnit tu) {
        return null;
    }

    private static class NameCollector
    extends CASTVisitor {
        private List nameList;

        private NameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName name) {
            this.nameList.add(name);
            return 3;
        }

        public IASTName[] getNames() {
            return this.nameList.toArray(new IASTName[this.nameList.size()]);
        }
    }
}

