/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMPointerType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMQualifierType;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMLinkage
extends PDOMNamedNode {
    private static final int ID_OFFSET = 12;
    private static final int NEXT_OFFSET = 16;
    private static final int INDEX_OFFSET = 20;
    protected static final int RECORD_SIZE = 24;
    protected static final int LINKAGE = 0;
    static final int POINTER_TYPE = 1;
    static final int QUALIFIER_TYPE = 2;
    protected static final int LAST_NODE_TYPE = 2;

    public PDOMLinkage(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected PDOMLinkage(PDOM pdom, String languageId, char[] name) throws CoreException {
        super(pdom, null, name);
        Database db = pdom.getDB();
        db.putInt(this.record + 12, db.newString(languageId).getRecord());
        pdom.insertLinkage(this);
    }

    protected int getRecordSize() {
        return 24;
    }

    public static IString getId(PDOM pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        int namerec = db.getInt(record + 12);
        return db.getString(namerec);
    }

    public abstract ILanguage getLanguage();

    public static int getNextLinkageRecord(PDOM pdom, int record) throws CoreException {
        return pdom.getDB().getInt(record + 16);
    }

    public PDOMLinkage getNextLinkage() throws CoreException {
        return this.pdom.getLinkage(this.pdom.getDB().getInt(this.record + 16));
    }

    public void setNext(int nextrec) throws CoreException {
        this.pdom.getDB().putInt(this.record + 16, nextrec);
    }

    public BTree getIndex() throws CoreException {
        return new BTree(this.pdom.getDB(), this.record + 20);
    }

    public void accept(final IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        this.getIndex().accept(new IBTreeVisitor(){

            public int compare(int record) throws CoreException {
                return 1;
            }

            public boolean visit(int record) throws CoreException {
                PDOMBinding binding = PDOMLinkage.this.pdom.getBinding(record);
                if (binding != null && visitor.visit(binding)) {
                    binding.accept(visitor);
                }
                return true;
            }
        });
    }

    public PDOMLinkage getLinkage() throws CoreException {
        return this;
    }

    protected void addChild(PDOMNamedNode child) throws CoreException {
        this.getIndex().insert(child.getRecord(), child.getIndexComparator());
    }

    public PDOMNode getNode(int record) throws CoreException {
        switch (PDOMNode.getNodeType(this.pdom, record)) {
            case 1: {
                return new PDOMPointerType(this.pdom, record);
            }
            case 2: {
                return new PDOMQualifierType(this.pdom, record);
            }
        }
        return null;
    }

    public PDOMNode addType(PDOMNode parent, IType type) throws CoreException {
        if (type instanceof IPointerType) {
            return new PDOMPointerType(this.pdom, parent, (IPointerType)type);
        }
        if (type instanceof IQualifierType) {
            return new PDOMQualifierType(this.pdom, parent, (IQualifierType)type);
        }
        return null;
    }

    public abstract PDOMBinding addName(IASTName var1, PDOMFile var2) throws CoreException;

    public abstract PDOMBinding adaptBinding(IBinding var1) throws CoreException;

    public abstract IBinding resolveBinding(IASTName var1) throws CoreException;

    public abstract void findBindings(Pattern var1, List var2) throws CoreException;

    protected static final class MatchBinding
    implements IBTreeVisitor {
        private final PDOM pdom;
        private final List bindings;
        private final Pattern pattern;

        public MatchBinding(PDOM pdom, Pattern pattern, List bindings) {
            this.pdom = pdom;
            this.bindings = bindings;
            this.pattern = pattern;
        }

        public boolean visit(int record) throws CoreException {
            Matcher matcher;
            if (record == 0) {
                return true;
            }
            PDOMBinding binding = this.pdom.getBinding(record);
            if (binding != null && (matcher = this.pattern.matcher(binding.getName())).matches()) {
                this.bindings.add(binding);
            }
            return true;
        }

        public int compare(int record) throws CoreException {
            return 1;
        }
    }
}

