/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.ctags;

import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunction;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCVariable;
import org.eclipse.cdt.internal.core.pdom.indexer.ctags.CtagsBindingFinder;
import org.eclipse.core.runtime.CoreException;

public class CtagsCName
implements IASTName,
IASTFileLocation {
    private final PDOMLinkage linkage;
    private final String fileName;
    private final int lineNum;
    private final String elementName;
    private final Map fields;
    private PDOMBinding binding;
    private int kind;
    private static final int K_UNKNOWN = 0;
    private static final int K_CLASS = 1;
    private static final int K_MACRO = 2;
    private static final int K_ENUMERATOR = 3;
    private static final int K_FUNCTION = 4;
    private static final int K_ENUM = 5;
    private static final int K_MEMBER = 6;
    private static final int K_NAMESPACE = 7;
    private static final int K_PROTOTYPE = 8;
    private static final int K_STRUCT = 9;
    private static final int K_TYPEDEF = 10;
    private static final int K_UNION = 11;
    private static final int K_VARIABLE = 12;
    private static final int K_EXTERNALVAR = 13;
    private static final String[] kinds;

    static {
        String[] stringArray = new String[14];
        stringArray[1] = "class";
        stringArray[2] = "macro";
        stringArray[3] = "enumerator";
        stringArray[4] = "function";
        stringArray[5] = "enum";
        stringArray[6] = "member";
        stringArray[7] = "namespace";
        stringArray[8] = "prototype";
        stringArray[9] = "struct";
        stringArray[10] = "typedef";
        stringArray[11] = "union";
        stringArray[12] = "variable";
        stringArray[13] = "externvar";
        kinds = stringArray;
    }

    public CtagsCName(PDOMLinkage linkage, String fileName, int lineNum, String elementName, Map fields) throws CoreException {
        this.linkage = linkage;
        this.fileName = fileName;
        this.lineNum = lineNum;
        this.elementName = elementName;
        this.fields = fields;
        this.kind = 0;
        String kindField = (String)fields.get("kind");
        if (kindField != null) {
            int i = 1;
            while (i < kinds.length) {
                if (kindField.equals(kinds[i])) {
                    this.kind = i;
                    break;
                }
                ++i;
            }
        }
    }

    public void addToPDOM(PDOMFile file) throws CoreException {
        this.linkage.addName(this, file);
    }

    public IBinding getBinding() {
        return this.binding;
    }

    public boolean isDeclaration() {
        throw new PDOMNotImplementedError();
    }

    public boolean isDefinition() {
        return true;
    }

    public boolean isReference() {
        return false;
    }

    private PDOMBinding makeNewBinding(IPDOMNode scope) throws CoreException {
        switch (this.kind) {
            case 12: {
                return new PDOMCVariable(this.linkage.getPDOM(), (PDOMNode)scope, this);
            }
            case 4: {
                return new PDOMCFunction(this.linkage.getPDOM(), (PDOMNode)scope, this);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBinding resolveBinding() {
        try {
            PDOMLinkage scope = this.linkage;
            int[] types = null;
            switch (this.kind) {
                case 12: {
                    types = new int[]{3};
                    break;
                }
                case 4: {
                    types = new int[]{4};
                    break;
                }
                default: {
                    return null;
                }
            }
            CtagsBindingFinder finder = new CtagsBindingFinder(this.elementName, types);
            scope.accept(finder);
            PDOMBinding[] bindings = finder.getBindings();
            if (bindings.length == 0) {
                this.binding = this.makeNewBinding(scope);
                return this.binding;
            }
            if (bindings.length == 1) {
                this.binding = bindings[0];
                return this.binding;
            }
            this.binding = bindings[0];
            return this.binding;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IBinding[] resolvePrefix() {
        throw new PDOMNotImplementedError();
    }

    public void setBinding(IBinding binding) {
        throw new PDOMNotImplementedError();
    }

    public char[] toCharArray() {
        return this.elementName.toCharArray();
    }

    public boolean accept(ASTVisitor visitor) {
        throw new PDOMNotImplementedError();
    }

    public String getContainingFilename() {
        return this.fileName;
    }

    public IASTFileLocation getFileLocation() {
        return this;
    }

    public IASTNodeLocation[] getNodeLocations() {
        throw new PDOMNotImplementedError();
    }

    public IASTNode getParent() {
        throw new PDOMNotImplementedError();
    }

    public ASTNodeProperty getPropertyInParent() {
        throw new PDOMNotImplementedError();
    }

    public String getRawSignature() {
        throw new PDOMNotImplementedError();
    }

    public IASTTranslationUnit getTranslationUnit() {
        throw new PDOMNotImplementedError();
    }

    public void setParent(IASTNode node) {
        throw new PDOMNotImplementedError();
    }

    public void setPropertyInParent(ASTNodeProperty property) {
        throw new PDOMNotImplementedError();
    }

    public int getEndingLineNumber() {
        throw new PDOMNotImplementedError();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getStartingLineNumber() {
        return this.lineNum;
    }

    public IASTFileLocation asFileLocation() {
        throw new PDOMNotImplementedError();
    }

    public int getNodeLength() {
        return -1;
    }

    public int getNodeOffset() {
        return this.lineNum;
    }
}

