/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CElementHyperlink;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.texteditor.ITextEditor;

public class CElementHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;
    private Set fgKeywords;

    public CElementHyperlinkDetector(ITextEditor editor) {
        this.fTextEditor = editor;
        this.fgKeywords = KeywordSets.getKeywords((KeywordSetKey)KeywordSetKey.ALL, (ParserLanguage)ParserLanguage.CPP);
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || canShowMultipleHyperlinks || !(this.fTextEditor instanceof CEditor)) {
            return null;
        }
        IAction openAction = this.fTextEditor.getAction("OpenDeclarations");
        if (openAction == null) {
            return null;
        }
        int offset = region.getOffset();
        IDocument document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
        IRegion cregion = this.selectWord(document, offset);
        if (cregion != null) {
            return new IHyperlink[]{new CElementHyperlink(cregion, openAction)};
        }
        return null;
    }

    private IRegion selectWord(IDocument document, int anchor) {
        String selWord;
        int end;
        int length;
        int start;
        char c;
        block18: {
            block17: {
                block16: {
                    try {
                        if (!Character.isJavaIdentifierPart(document.getChar(anchor))) {
                            return null;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                    boolean isNumber = false;
                    int offset = anchor;
                    char oldC = 'a';
                    while (offset >= 0) {
                        c = document.getChar(offset);
                        if (!Character.isJavaIdentifierPart(c)) {
                            if (!Character.isDigit(oldC)) break;
                            isNumber = true;
                            break;
                        }
                        oldC = c;
                        --offset;
                    }
                    start = offset;
                    offset = anchor;
                    length = document.getLength();
                    while (offset < length) {
                        c = document.getChar(offset);
                        if (!Character.isJavaIdentifierPart(c)) break;
                        ++offset;
                    }
                    end = offset;
                    if (start == end) {
                        return new Region(start, 0);
                    }
                    if (!isNumber) break block16;
                    return null;
                }
                selWord = null;
                String slas = document.get(start, 1);
                selWord = slas.equals("\n") || slas.equals("\t") || slas.equals(" ") || slas.equals(">") || slas.equals(".") || slas.equals("(") ? document.get(start + 1, end - start - 1) : document.get(start, end - start);
                if (!this.isKeyWord(selWord)) break block17;
                return null;
            }
            char charX = selWord.charAt(0);
            if (charX != '\"' && charX != '.' && charX != '<' && charX != '>') break block18;
            return null;
        }
        try {
            if (selWord.equals("#include")) {
                int end2 = end;
                while (!Character.isJavaIdentifierPart(document.getChar(end2))) {
                    ++end2;
                }
                while (end2 < length) {
                    c = document.getChar(end2);
                    if (!Character.isJavaIdentifierPart(c) && c != '.') break;
                    ++end2;
                }
                int finalEnd = end2;
                selWord = document.get(start, finalEnd - start);
                end = finalEnd + 1;
                --start;
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isKeyWord(String selWord) {
        Iterator i = this.fgKeywords.iterator();
        while (i.hasNext()) {
            String tempWord = (String)i.next();
            if (!selWord.equals(tempWord)) continue;
            return true;
        }
        return false;
    }
}

