/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.parser.util.HashTable;

public abstract class ObjectTable
extends HashTable
implements Cloneable {
    protected Object[] keyTable = new Object[this.capacity()];

    public ObjectTable(int initialSize) {
        super(initialSize);
    }

    public Object clone() {
        ObjectTable newTable = (ObjectTable)super.clone();
        int size = this.capacity();
        newTable.keyTable = new Object[size];
        System.arraycopy(this.keyTable, 0, newTable.keyTable, 0, this.keyTable.length);
        return newTable;
    }

    public List toList() {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        int size = this.size();
        int i = 0;
        while (i < size) {
            list.add(this.keyAt(i));
            ++i;
        }
        return list;
    }

    public Object keyAt(int i) {
        if (i < 0 || i > this.currEntry) {
            return null;
        }
        return this.keyTable[i];
    }

    public void clear() {
        super.clear();
        int i = 0;
        while (i < this.keyTable.length) {
            this.keyTable[i] = null;
            ++i;
        }
    }

    protected final int hash(int pos) {
        return this.hash(this.keyTable[pos]);
    }

    private int hash(Object obj) {
        return obj.hashCode() & this.capacity() * 2 - 1;
    }

    protected void resize(int size) {
        Object[] oldKeyTable = this.keyTable;
        this.keyTable = new Object[size];
        System.arraycopy(oldKeyTable, 0, this.keyTable, 0, oldKeyTable.length);
        super.resize(size);
    }

    protected final int add(Object obj) {
        int pos = this.lookup(obj);
        if (pos != -1) {
            return pos;
        }
        if (this.currEntry + 1 >= this.capacity()) {
            this.resize();
        }
        ++this.currEntry;
        this.keyTable[this.currEntry] = obj;
        this.linkIntoHashTable(this.currEntry, this.hash(obj));
        return this.currEntry;
    }

    protected void removeEntry(int i) {
        int hash = this.hash(this.keyTable[i]);
        if (i < this.currEntry) {
            System.arraycopy(this.keyTable, i + 1, this.keyTable, i, this.currEntry - i);
        }
        this.keyTable[this.currEntry] = null;
        this.removeEntry(i, hash);
    }

    protected final int lookup(Object buffer) {
        if (this.hashTable != null) {
            int hash = this.hash(buffer);
            if (this.hashTable[hash] == 0) {
                return -1;
            }
            int i = this.hashTable[hash] - 1;
            if (buffer.equals(this.keyTable[i])) {
                return i;
            }
            i = this.nextTable[i] - 1;
            while (i >= 0 && this.nextTable[i] != i + 1) {
                if (buffer.equals(this.keyTable[i])) {
                    return i;
                }
                i = this.nextTable[i] - 1;
            }
            return -1;
        }
        int i = 0;
        while (i <= this.currEntry) {
            if (buffer.equals(this.keyTable[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        return this.lookup(key) != -1;
    }

    public Object[] keyArray() {
        Object[] keys = new Object[this.size()];
        System.arraycopy(this.keyTable, 0, keys, 0, keys.length);
        return keys;
    }

    public Object[] keyArray(Class c) {
        Object[] keys = (Object[])Array.newInstance(c, this.size());
        System.arraycopy(this.keyTable, 0, keys, 0, keys.length);
        return keys;
    }
}

