/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.ctags;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.indexer.ctags.CtagsIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.ctags.CtagsIndexerJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class CtagsHandleDelta
extends CtagsIndexerJob {
    private final ICElementDelta delta;
    private List added = new ArrayList();
    private List changed = new ArrayList();
    private List removed = new ArrayList();

    public CtagsHandleDelta(CtagsIndexer indexer, ICElementDelta delta) throws CoreException {
        super(indexer);
        this.delta = delta;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            long start = System.currentTimeMillis();
            this.processDelta(this.delta);
            int count = this.changed.size() + this.added.size() + this.removed.size();
            if (count > 0) {
                ITranslationUnit tu;
                monitor.beginTask("Indexing", count);
                Iterator i = this.changed.iterator();
                while (i.hasNext()) {
                    tu = (ITranslationUnit)i.next();
                    monitor.subTask(tu.getElementName());
                    this.changeTU(tu);
                    monitor.worked(1);
                }
                i = this.added.iterator();
                while (i.hasNext()) {
                    tu = (ITranslationUnit)i.next();
                    monitor.subTask(tu.getElementName());
                    this.addTU(tu);
                    monitor.worked(1);
                }
                i = this.removed.iterator();
                while (i.hasNext()) {
                    tu = (ITranslationUnit)i.next();
                    monitor.subTask(tu.getElementName());
                    this.removeTU(tu);
                    monitor.worked(1);
                }
                String showTimings = Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/pdomtimings");
                if (showTimings != null && showTimings.equalsIgnoreCase("true")) {
                    System.out.println("PDOM Full Delta Time: " + (System.currentTimeMillis() - start));
                }
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processDelta(ICElementDelta delta) throws CoreException {
        int flags = delta.getFlags();
        if ((flags & 8) != 0) {
            ICElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.processDelta(children[i]);
                ++i;
            }
        }
        ICElement element = delta.getElement();
        switch (element.getElementType()) {
            case 60: {
                ITranslationUnit tu = (ITranslationUnit)element;
                switch (delta.getKind()) {
                    case 4: {
                        if ((flags & 1) == 0) return;
                        this.changed.add(tu);
                        break;
                    }
                    case 1: {
                        if (tu.isWorkingCopy()) return;
                        this.added.add(tu);
                        break;
                    }
                    case 2: {
                        if (tu.isWorkingCopy()) return;
                        this.removed.add(tu);
                    }
                }
                return;
            }
        }
    }

    protected void addTU(ITranslationUnit tu) throws CoreException, InterruptedException {
        IPath path = ((IFile)tu.getResource()).getLocation();
        this.runCtags(path);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void changeTU(ITranslationUnit tu) throws CoreException, InterruptedException {
        IPath path = ((IFile)tu.getResource()).getLocation();
        this.pdom.acquireWriteLock();
        try {
            PDOMFile file = this.pdom.getFile(path);
            if (file != null) {
                file.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.pdom.releaseWriteLock();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.pdom.releaseWriteLock();
        }
        this.runCtags(path);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeTU(ITranslationUnit tu) throws CoreException, InterruptedException {
        this.pdom.acquireWriteLock();
        try {
            IPath path = ((IFile)tu.getResource()).getLocation();
            PDOMFile file = this.pdom.getFile(path);
            if (file != null) {
                file.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.pdom.releaseWriteLock();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.pdom.releaseWriteLock();
            return;
        }
    }
}

