/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildCPathEntryContainer;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGeneratorType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ManagedBuildInfo
implements IManagedBuildInfo,
IScannerInfo {
    public static final IContainerEntry containerEntry = CoreModel.newContainerEntry((IPath)new Path("org.eclipse.cdt.managedbuilder.MANAGED_CONTAINER"));
    private static final QualifiedName defaultConfigProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "defaultConfig");
    public static final String MAJOR_SEPERATOR = ";";
    public static final String MINOR_SEPERATOR = "::";
    private static final String EMPTY_STRING = new String();
    private IManagedProject managedProject;
    private ICProject cProject;
    private IConfiguration defaultConfig;
    private String defaultConfigId;
    private boolean isDirty;
    private boolean isValid = false;
    private IResource owner;
    private boolean rebuildNeeded;
    private String version;
    private IConfiguration selectedConfig;
    private List targetList;
    private Map targetMap;
    private boolean isReadOnly = false;
    private boolean bIsContainerInited = false;

    public ManagedBuildInfo(IResource owner) {
        this.owner = owner;
        this.cProject = CoreModel.getDefault().create(owner.getProject());
        this.isDirty = false;
        this.rebuildNeeded = true;
        IProject project = owner.getProject();
        this.defaultConfigId = null;
        try {
            this.defaultConfigId = project.getPersistentProperty(defaultConfigProperty);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public ManagedBuildInfo(IResource owner, Element element, String managedBuildRevision) {
        this(owner);
        NodeList projNodes = element.getElementsByTagName("project");
        int projIndex = projNodes.getLength() - 1;
        while (projIndex >= 0) {
            ManagedProject proj = new ManagedProject(this, (Element)projNodes.item(projIndex), managedBuildRevision);
            if (!proj.resolveReferences()) {
                proj.setValid(false);
            }
            --projIndex;
        }
        this.rebuildNeeded = false;
        this.version = managedBuildRevision;
    }

    public void setManagedProject(IManagedProject managedProject) {
        this.managedProject = managedProject;
    }

    public IManagedProject getManagedProject() {
        return this.managedProject;
    }

    public boolean buildsFileType(String srcExt) {
        IConfiguration config = this.getDefaultConfiguration();
        ITool[] tools = config.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool != null && tool.buildsFileType(srcExt)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public String getBuildArtifactExtension() {
        String ext = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            ext = config.getArtifactExtension();
        }
        return ext;
    }

    public String getBuildArtifactName() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getArtifactName();
        }
        return name;
    }

    public String getCleanCommand() {
        String command = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            command = config.getCleanCommand();
        }
        return command;
    }

    public String getConfigurationName() {
        IConfiguration config = this.getDefaultConfiguration();
        return config == null ? new String() : config.getName();
    }

    public String[] getConfigurationNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        IConfiguration[] configs = this.managedProject.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration configuration = configs[i];
            configNames.add(configuration.getName());
            ++i;
        }
        configNames.trimToSize();
        return configNames.toArray(new String[configNames.size()]);
    }

    public ICProject getCProject() {
        return this.cProject;
    }

    public IConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null && this.managedProject != null) {
            if (this.defaultConfigId != null) {
                this.defaultConfig = this.managedProject.getConfiguration(this.defaultConfigId);
            }
            if (this.defaultConfig == null) {
                IConfiguration[] configs = this.managedProject.getConfigurations();
                int i = 0;
                while (i < configs.length) {
                    if (configs[i].isSupported()) {
                        this.defaultConfig = configs[i];
                        this.defaultConfigId = this.defaultConfig.getId();
                        break;
                    }
                    ++i;
                }
                if (this.defaultConfig == null && configs.length > 0) {
                    this.defaultConfig = configs[0];
                    this.defaultConfigId = this.defaultConfig.getId();
                }
            }
        }
        return this.defaultConfig;
    }

    public Map getDefinedSymbols() {
        HashMap symbols = this.getMacroPathEntries();
        return symbols;
    }

    public IManagedDependencyGeneratorType getDependencyGenerator(String sourceExtension) {
        try {
            if (this.getDefaultConfiguration() != null) {
                ITool[] tools = this.getDefaultConfiguration().getFilteredTools();
                int index = 0;
                while (index < tools.length) {
                    if (tools[index].buildsFileType(sourceExtension)) {
                        return tools[index].getDependencyGeneratorForExtension(sourceExtension);
                    }
                    ++index;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return null;
    }

    private ITool[] getFilteredTools() {
        IConfiguration config = this.getDefaultConfiguration();
        return config.getFilteredTools();
    }

    public String getFlagsForSource(String extension) {
        return this.getToolFlagsForSource(extension, null, null);
    }

    public String getToolFlagsForSource(String extension, IPath inputLocation, IPath outputLocation) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool != null && tool.buildsFileType(extension)) {
                try {
                    return tool.getToolCommandFlagsString(inputLocation, outputLocation);
                }
                catch (BuildException buildException) {
                    return null;
                }
            }
            ++index;
        }
        return null;
    }

    public String getFlagsForConfiguration(String extension) {
        return this.getToolFlagsForConfiguration(extension, null, null);
    }

    public String getToolFlagsForConfiguration(String extension, IPath inputLocation, IPath outputLocation) {
        String ext = extension == null ? new String() : extension;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                try {
                    return tool.getToolCommandFlagsString(inputLocation, outputLocation);
                }
                catch (BuildException buildException) {
                    return null;
                }
            }
            ++index;
        }
        return null;
    }

    private ArrayList getIncludePathEntries() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] entries = this.cProject.getResolvedPathEntries();
                int index = 0;
                while (index < entries.length) {
                    IIncludeEntry include;
                    int kind = entries[index].getEntryKind();
                    if (kind == 16 && (include = (IIncludeEntry)entries[index]).isSystemInclude()) {
                        IPath entryPath = include.getFullIncludePath();
                        paths.add(entryPath.toString());
                    }
                    ++index;
                }
            }
            catch (CModelException cModelException) {
                paths.clear();
                return paths;
            }
        }
        return paths;
    }

    public String[] getIncludePaths() {
        ArrayList paths = this.getIncludePathEntries();
        return paths.toArray(new String[paths.size()]);
    }

    public String[] getLibsForConfiguration(String extension) {
        Vector<String> libs = new Vector<String>();
        ITool tool = this.getDefaultConfiguration().calculateTargetTool();
        if (tool == null) {
            tool = this.getToolFromOutputExtension(extension);
        }
        if (tool != null) {
            IOption[] opts = tool.getOptions();
            int i = 0;
            while (i < opts.length) {
                block11: {
                    IOption option = opts[i];
                    try {
                        IOptionApplicability applicabilitytCalculator;
                        if (option.getValueType() != 6 || (applicabilitytCalculator = option.getApplicabilityCalculator()) != null && !applicabilitytCalculator.isOptionUsedInCommandLine(this.getDefaultConfiguration(), tool, option)) break block11;
                        String command = option.getCommand();
                        String[] allLibs = option.getLibraries();
                        int j = 0;
                        while (j < allLibs.length) {
                            try {
                                String[] resolved = ManagedBuildManager.getBuildMacroProvider().resolveStringListValueToMakefileFormat(allLibs[j], "", " ", 2, new OptionContextData(option, tool));
                                if (resolved != null && resolved.length > 0) {
                                    int k = 0;
                                    while (k < resolved.length) {
                                        String string = resolved[k];
                                        if (string.length() > 0) {
                                            libs.add(String.valueOf(command) + string);
                                        }
                                        ++k;
                                    }
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++i;
            }
        }
        return libs.toArray(new String[libs.size()]);
    }

    private HashMap getMacroPathEntries() {
        HashMap<String, String> macros = new HashMap<String, String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] entries = this.cProject.getResolvedPathEntries();
                int index = 0;
                while (index < entries.length) {
                    if (entries[index].getEntryKind() == 64) {
                        IMacroEntry macro = (IMacroEntry)entries[index];
                        macros.put(macro.getMacroName(), macro.getMacroValue());
                    }
                    ++index;
                }
            }
            catch (CModelException cModelException) {
                macros.clear();
                return macros;
            }
        }
        return macros;
    }

    public String getBuildArguments() {
        IToolChain toolChain;
        IBuilder builder;
        if (this.getDefaultConfiguration() != null && (builder = (toolChain = this.getDefaultConfiguration().getToolChain()).getBuilder()) != null) {
            return builder.getArguments();
        }
        return new String("-k");
    }

    public String getBuildCommand() {
        IToolChain toolChain;
        IBuilder builder;
        if (this.getDefaultConfiguration() != null && (builder = (toolChain = this.getDefaultConfiguration().getToolChain()).getBuilder()) != null) {
            return builder.getCommand();
        }
        return new String("make");
    }

    public String getPrebuildStep() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getPrebuildStep();
        }
        return name;
    }

    public String getPostbuildStep() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getPostbuildStep();
        }
        return name;
    }

    public String getPreannouncebuildStep() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getPreannouncebuildStep();
        }
        return name;
    }

    public String getPostannouncebuildStep() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getPostannouncebuildStep();
        }
        return name;
    }

    public String getOutputExtension(String resourceExtension) {
        String outputExtension = null;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            outputExtension = tool.getOutputExtension(resourceExtension);
            if (outputExtension != null) {
                return outputExtension;
            }
            ++index;
        }
        return null;
    }

    public String getOutputFlag(String outputExt) {
        String ext = outputExt == null ? new String() : outputExt;
        String flags = new String();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputFlag();
            }
            ++index;
        }
        return flags;
    }

    public String getOutputPrefix(String outputExtension) {
        String ext = outputExtension == null ? new String() : outputExtension;
        String flags = new String();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputPrefix();
            }
            ++index;
        }
        return flags;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public String getToolForSource(String sourceExtension) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(sourceExtension)) {
                return tool.getToolCommand();
            }
            ++index;
        }
        return null;
    }

    public String getToolForConfiguration(String extension) {
        String ext = extension == null ? new String() : extension;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                return tool.getToolCommand();
            }
            ++index;
        }
        return null;
    }

    public ITool getToolFromInputExtension(String sourceExtension) {
        IConfiguration config = this.getDefaultConfiguration();
        return config.getToolFromInputExtension(sourceExtension);
    }

    public ITool getToolFromOutputExtension(String extension) {
        IConfiguration config = this.getDefaultConfiguration();
        return config.getToolFromOutputExtension(extension);
    }

    public IManagedCommandLineInfo generateCommandLineInfo(String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources) {
        return this.generateToolCommandLineInfo(sourceExtension, flags, outputFlag, outputPrefix, outputName, inputResources, null, null);
    }

    public IManagedCommandLineInfo generateToolCommandLineInfo(String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, IPath inputLocation, IPath outputLocation) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(sourceExtension)) {
                String cmd = tool.getToolCommand();
                try {
                    String resolvedCommand = null;
                    resolvedCommand = inputLocation != null && inputLocation.toString().indexOf(" ") != -1 || outputLocation != null && outputLocation.toString().indexOf(" ") != -1 ? ManagedBuildManager.getBuildMacroProvider().resolveValue(cmd, "", " ", 1, new FileContextData(inputLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, "", " ", 1, new FileContextData(inputLocation, outputLocation, null, tool));
                    resolvedCommand = resolvedCommand.trim();
                    if (resolvedCommand.length() > 0) {
                        cmd = resolvedCommand;
                    }
                }
                catch (BuildMacroException buildMacroException) {}
                IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
                return gen.generateCommandLineInfo(tool, cmd, flags, outputFlag, outputPrefix, outputName, inputResources, tool.getCommandLinePattern());
            }
            ++index;
        }
        return null;
    }

    public String[] getUserObjectsForConfiguration(String extension) {
        Vector<String> objs = new Vector<String>();
        ITool tool = this.getDefaultConfiguration().calculateTargetTool();
        if (tool == null) {
            tool = this.getToolFromOutputExtension(extension);
        }
        if (tool != null) {
            IOption[] opts = tool.getOptions();
            int i = 0;
            while (i < opts.length) {
                block9: {
                    IOption option = opts[i];
                    try {
                        String[] unresolved;
                        if (option.getValueType() != 7 || (unresolved = option.getUserObjects()) == null || unresolved.length <= 0) break block9;
                        int k = 0;
                        while (k < unresolved.length) {
                            try {
                                String[] resolved = ManagedBuildManager.getBuildMacroProvider().resolveStringListValueToMakefileFormat(unresolved[k], "", " ", 2, new OptionContextData(option, tool));
                                if (resolved != null && resolved.length > 0) {
                                    objs.addAll(Arrays.asList(resolved));
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            ++k;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++i;
            }
        }
        return objs.toArray(new String[objs.size()]);
    }

    public String getVersion() {
        return this.version;
    }

    public void initializePathEntries() {
        if (!this.isValid()) {
            return;
        }
        try {
            ManagedBuildCPathEntryContainer container = new ManagedBuildCPathEntryContainer(this.getOwner().getProject());
            CoreModel.setPathEntryContainer((ICProject[])new ICProject[]{this.cProject}, (IPathEntryContainer)container, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CModelException cModelException) {}
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        if (this.managedProject != null) {
            return this.managedProject.isDirty();
        }
        return false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isHeaderFile(String ext) {
        IConfiguration config = this.getDefaultConfiguration();
        return config.isHeaderFile(ext);
    }

    public boolean isContainerInited() {
        return this.bIsContainerInited;
    }

    public boolean needsRebuild() {
        if (this.rebuildNeeded) {
            return true;
        }
        if (this.getDefaultConfiguration() != null) {
            return this.getDefaultConfiguration().needsRebuild();
        }
        return false;
    }

    private void persistDefaultConfiguration() {
        IProject project = this.owner.getProject();
        try {
            if (this.defaultConfigId != null) {
                project.setPersistentProperty(defaultConfigProperty, this.defaultConfigId.toString().trim());
            }
        }
        catch (CoreException coreException) {}
    }

    public void serialize(Document doc, Element element) {
        if (this.managedProject != null) {
            Element projElement = doc.createElement("project");
            element.appendChild(projElement);
            this.managedProject.serialize(doc, projElement);
        } else {
            ListIterator iter = this.getTargets().listIterator();
            while (iter.hasNext()) {
                Target targ = (Target)iter.next();
                Element targetElement = doc.createElement("target");
                element.appendChild(targetElement);
                targ.serialize(doc, targetElement);
            }
        }
        this.persistDefaultConfiguration();
        this.setDirty(false);
    }

    public void setDefaultConfiguration(IConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        if (!configuration.equals(this.getDefaultConfiguration())) {
            this.defaultConfig = configuration;
            this.defaultConfigId = configuration.getId();
            IProject proj = this.getOwner().getProject();
            IResource cdtbuildFile = proj.findMember(".cdtbuild");
            if (cdtbuildFile != null) {
                try {
                    cdtbuildFile.touch((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
            this.persistDefaultConfiguration();
        }
    }

    public boolean setDefaultConfiguration(String configName) {
        if (configName != null) {
            IConfiguration[] configs = this.managedProject.getConfigurations();
            int index = configs.length - 1;
            while (index >= 0) {
                IConfiguration config = configs[index];
                if (configName.equalsIgnoreCase(config.getName())) {
                    this.setDefaultConfiguration(config);
                    return true;
                }
                --index;
            }
        }
        return false;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (this.managedProject != null) {
            this.managedProject.setDirty(isDirty);
        }
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void setReadOnly(boolean readOnly) {
        if (!readOnly && this.isReadOnly) {
            this.setDirty(true);
        }
        this.isReadOnly = readOnly;
    }

    public void setRebuildState(boolean rebuild) {
        this.rebuildNeeded = rebuild;
        if (this.getDefaultConfiguration() != null) {
            this.getDefaultConfiguration().setRebuildState(rebuild);
        }
    }

    public void setVersion(String version) {
        if (version != null && !version.equals(this.version)) {
            this.version = version;
        }
        this.updateRevision(version);
    }

    public void setContainerInited(boolean bInited) {
        this.bIsContainerInited = bInited;
    }

    public String toString() {
        return "Managed build information for " + this.owner.getName();
    }

    public void updateOwner(IResource resource) {
        if (resource != null && !this.owner.equals((Object)resource)) {
            this.owner = resource;
            this.managedProject.updateOwner(resource);
            this.cProject = CoreModel.getDefault().create(this.owner.getProject());
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public IConfiguration getSelectedConfiguration() {
        return this.selectedConfig;
    }

    public void setSelectedConfiguration(IConfiguration config) {
        this.selectedConfig = config;
    }

    public void addTarget(ITarget target) {
        this.getTargetMap().put(target.getId(), target);
        this.getTargets().add(target);
        this.setDirty(true);
    }

    public void removeTarget(String id) {
        this.getTargets().remove(this.getTarget(id));
        this.getTargetMap().remove(id);
        this.setDirty(true);
    }

    public ITarget getTarget(String id) {
        return (ITarget)this.getTargetMap().get(id);
    }

    private Map getTargetMap() {
        if (this.targetMap == null) {
            this.targetMap = new HashMap();
        }
        return this.targetMap;
    }

    public List getTargets() {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
        }
        return this.targetList;
    }

    private String getCWD() {
        String cwd = "";
        IBuildEnvironmentVariable cwdvar = ManagedBuildManager.getEnvironmentVariableProvider().getVariable("CWD", this.getDefaultConfiguration(), false, true);
        if (cwdvar != null) {
            cwd = cwdvar.getValue().replace('\\', '/');
        }
        return cwd;
    }

    private List processPath(List list, String path, int context, Object obj) {
        if (path != null) {
            if (context != 0) {
                try {
                    String[] paths = ManagedBuildManager.getBuildMacroProvider().resolveStringListValue(path, "", " ", context, obj);
                    if (paths != null) {
                        int i = 0;
                        while (i < paths.length) {
                            list.add(this.checkPath(paths[i]));
                            ++i;
                        }
                    }
                }
                catch (BuildMacroException buildMacroException) {}
            } else {
                list.add(this.checkPath(path));
            }
        }
        return list;
    }

    private String checkPath(String p) {
        String cwd;
        if (p == null) {
            return "";
        }
        if (p.length() > 1 && p.startsWith("\"") && p.endsWith("\"")) {
            p = p.substring(1, p.length() - 1);
        }
        if (".".equals(p) && (cwd = this.getCWD()).length() > 0) {
            p = cwd;
        }
        if (!new Path(p).isAbsolute() && (cwd = this.getCWD()).length() > 0) {
            p = String.valueOf(cwd) + "/" + p;
        }
        return p;
    }

    public IPathEntry[] getManagedBuildValues() {
        ArrayList<IPathEntry> entries = new ArrayList<IPathEntry>();
        int i = 0;
        IPathEntry[] a = this.getManagedBuildValues(16);
        if (a != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        if ((a = this.getManagedBuildValues(1)) != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        if ((a = this.getManagedBuildValues(64)) != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    public IPathEntry[] getManagedBuildBuiltIns() {
        ArrayList<IPathEntry> entries = new ArrayList<IPathEntry>();
        int i = 0;
        IPathEntry[] a = this.getManagedBuildBuiltIns(16);
        if (a != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        if ((a = this.getManagedBuildBuiltIns(1)) != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        if ((a = this.getManagedBuildBuiltIns(64)) != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    public IPathEntry[] getManagedBuildValues(int entryType) {
        List entries = this.getOptionValues(entryType, false);
        if (entryType == 16) {
            IEnvironmentVariableProvider env = ManagedBuildManager.getEnvironmentVariableProvider();
            entries = this.addIncludes(entries, env.getBuildPaths(this.getDefaultConfiguration(), 1), (IPath)Path.EMPTY, 0, null);
        }
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    public IPathEntry[] getManagedBuildBuiltIns(int entryType) {
        List entries = this.getOptionValues(entryType, true);
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    private List getOptionValues(int entryType, boolean builtIns) {
        List entries = new ArrayList();
        IConfiguration cfg = this.getDefaultConfiguration();
        entries = this.readToolsOptions(entryType, entries, builtIns, cfg);
        return entries;
    }

    private List readToolsOptions(int entryType, List entries, boolean builtIns, IBuildObject obj) {
        ITool[] t = null;
        Path resPath = Path.EMPTY;
        if (entryType != 16 && entryType != 64) {
            return entries;
        }
        if (obj instanceof IResourceConfiguration) {
            resPath = new Path(((IResourceConfiguration)obj).getResourcePath()).removeFirstSegments(1);
            t = ((IResourceConfiguration)obj).getToolsToInvoke();
        } else if (obj instanceof IConfiguration) {
            t = ((IConfiguration)obj).getFilteredTools();
        } else {
            return entries;
        }
        if (t == null) {
            return entries;
        }
        int i = 0;
        while (i < t.length) {
            IOption[] op = t[i].getOptions();
            int j = 0;
            while (j < op.length) {
                IOptionApplicability applicabilityCalculator = op[j].getApplicabilityCalculator();
                if (applicabilityCalculator == null || applicabilityCalculator.isOptionUsedInCommandLine(obj, t[i], op[j])) {
                    try {
                        OptionContextData ocd;
                        if (entryType == 16 && op[j].getValueType() == 4) {
                            ocd = new OptionContextData(op[j], t[i]);
                            this.addIncludes(entries, builtIns ? op[j].getBuiltIns() : op[j].getIncludePaths(), (IPath)resPath, 2, ocd);
                        } else if (entryType == 1 && op[j].getValueType() == 6) {
                            ocd = new OptionContextData(op[j], t[i]);
                            this.addLibraries(entries, builtIns ? op[j].getBuiltIns() : op[j].getLibraries(), (IPath)resPath, 2, ocd);
                        } else if (entryType == 64 && op[j].getValueType() == 5) {
                            ocd = new OptionContextData(op[j], t[i]);
                            this.addSymbols(entries, builtIns ? op[j].getBuiltIns() : op[j].getDefinedSymbols(), (IPath)resPath, 2, ocd);
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++j;
            }
            ++i;
        }
        return entries;
    }

    protected List addIncludes(List entries, String[] values, IPath resPath, int context, Object obj) {
        return this.addPaths(entries, values, resPath, context, obj, 16);
    }

    protected List addPaths(List entries, String[] values, IPath resPath, int context, Object obj, int type) {
        if (values != null && values.length > 0) {
            ArrayList list = new ArrayList();
            int k = 0;
            while (k < values.length) {
                this.processPath(list, values[k], context, obj);
                ++k;
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                IIncludeEntry entry = null;
                switch (type) {
                    case 16: {
                        entry = CoreModel.newIncludeEntry((IPath)resPath, (IPath)Path.EMPTY, (IPath)new Path((String)iter.next()), (boolean)true);
                        break;
                    }
                    case 1: {
                        entry = CoreModel.newLibraryEntry((IPath)resPath, (IPath)Path.EMPTY, (IPath)new Path((String)iter.next()), null, null, null, (boolean)true);
                    }
                }
                if (entry == null || entries.contains(entry)) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    protected List addLibraries(List entries, String[] values, IPath resPath, int context, Object obj) {
        return this.addPaths(entries, values, resPath, context, obj, 1);
    }

    protected List addSymbols(List entries, String[] values, IPath resPath, int context, Object obj) {
        if (values == null) {
            return entries;
        }
        int i = 0;
        while (i < values.length) {
            try {
                String[] res = ManagedBuildManager.getBuildMacroProvider().resolveStringListValue(values[i], "", " ", context, obj);
                if (res != null) {
                    int k = 0;
                    while (k < res.length) {
                        this.createMacroEntry(entries, res[k], resPath);
                        ++k;
                    }
                }
            }
            catch (BuildMacroException buildMacroException) {}
            ++i;
        }
        return entries;
    }

    private List createMacroEntry(List entries, String val, IPath resPath) {
        if (val != null && val.length() != 0) {
            String[] tokens = val.split("=");
            String key = tokens[0].trim();
            String value = tokens.length > 1 ? tokens[1].trim() : new String();
            boolean add = true;
            ListIterator entryIter = entries.listIterator();
            while (entryIter.hasNext()) {
                IPathEntry entry = (IPathEntry)entryIter.next();
                if (entry.getEntryKind() != 64 || !((IMacroEntry)entry).getMacroName().equals(key) || !((IMacroEntry)entry).getMacroValue().equals(value)) continue;
                add = false;
                break;
            }
            if (add) {
                entries.add(CoreModel.newMacroEntry((IPath)resPath, (String)key, (String)value));
            }
        }
        return entries;
    }

    public void updateRevision(String revision) {
        if (this.managedProject != null) {
            ((ManagedProject)this.managedProject).updateManagedBuildRevision(revision);
        }
    }
}

