/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThreadStorage;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThreadStorageDescriptor;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.ThreadStorageDescriptor;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackInfoDepth;
import org.eclipse.cdt.debug.mi.core.command.MIStackListFrames;
import org.eclipse.cdt.debug.mi.core.command.MIStackSelectFrame;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackInfoDepthInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListFramesInfo;

public class Thread
extends CObject
implements ICDIThread {
    static ICDIStackFrame[] noStack = new ICDIStackFrame[0];
    int id;
    String name;
    StackFrame currentFrame;
    List currentFrames;
    int stackdepth = 0;
    public static final int STACKFRAME_DEFAULT_DEPTH = 200;

    public Thread(Target target, int threadId) {
        this(target, threadId, null);
    }

    public Thread(Target target, int threadId, String threadName) {
        super(target);
        this.id = threadId;
        this.name = threadName;
    }

    public int getId() {
        return this.id;
    }

    public void clearState() {
        this.stackdepth = 0;
        this.currentFrame = null;
        this.currentFrames = null;
    }

    public String toString() {
        String str = Integer.toString(this.id);
        if (this.name != null) {
            str = String.valueOf(str) + " " + this.name;
        }
        return str;
    }

    public void updateState() {
        try {
            this.getCurrentStackFrame();
        }
        catch (CDIException cDIException) {}
    }

    public StackFrame getCurrentStackFrame() throws CDIException {
        ICDIStackFrame[] frames;
        if (this.currentFrame == null && (frames = this.getStackFrames(0, 0)).length > 0) {
            this.currentFrame = (StackFrame)frames[0];
        }
        return this.currentFrame;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIStackFrame[] getStackFrames() throws CDIException {
        block11: {
            int depth = this.getStackFrameCount();
            if (this.currentFrames != null && this.currentFrames.size() >= depth) break block11;
            this.currentFrames = new ArrayList();
            Target target = (Target)this.getTarget();
            ICDIThread currentThread = target.getCurrentThread();
            target.setCurrentThread(this, false);
            try {
                try {
                    MISession mi = target.getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    MIStackListFrames frames = factory.createMIStackListFrames();
                    mi.postCommand(frames);
                    MIStackListFramesInfo info = frames.getMIStackListFramesInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    MIFrame[] miFrames = info.getMIFrames();
                    int i = 0;
                    while (i < miFrames.length) {
                        this.currentFrames.add(new StackFrame(this, miFrames[i], depth - miFrames[i].getLevel()));
                        ++i;
                    }
                }
                catch (MIException mIException) {
                }
                catch (CDIException cDIException) {}
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                target.setCurrentThread(currentThread, false);
                throw throwable;
            }
            {
                Object var10_13 = null;
            }
            target.setCurrentThread(currentThread, false);
            if (this.currentFrame == null) {
                int i = 0;
                while (i < this.currentFrames.size()) {
                    ICDIStackFrame stack = (ICDIStackFrame)this.currentFrames.get(i);
                    if (stack.getLevel() == depth) {
                        this.currentFrame = (StackFrame)stack;
                    }
                    ++i;
                }
            }
        }
        return this.currentFrames.toArray(noStack);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getStackFrameCount() throws CDIException {
        if (this.stackdepth != 0) return this.stackdepth;
        Target target = (Target)this.getTarget();
        ICDIThread currentThread = target.getCurrentThread();
        target.setCurrentThread(this, false);
        try {
            try {
                MISession mi = target.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIStackInfoDepth depth = factory.createMIStackInfoDepth();
                mi.postCommand(depth);
                MIStackInfoDepthInfo info = null;
                try {
                    info = depth.getMIStackInfoDepthInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    this.stackdepth = info.getDepth();
                }
                catch (MIException mIException) {
                    depth = factory.createMIStackInfoDepth();
                    mi.postCommand(depth);
                    info = depth.getMIStackInfoDepthInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    this.stackdepth = info.getDepth();
                    if (this.stackdepth > 0) {
                        --this.stackdepth;
                    }
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            target.setCurrentThread(currentThread, false);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        target.setCurrentThread(currentThread, false);
        return this.stackdepth;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIStackFrame[] getStackFrames(int low, int high) throws CDIException {
        block11: {
            if (this.currentFrames != null && this.currentFrames.size() >= high) break block11;
            this.currentFrames = new ArrayList();
            Target target = (Target)this.getTarget();
            ICDIThread currentThread = target.getCurrentThread();
            target.setCurrentThread(this, false);
            try {
                try {
                    int depth = this.getStackFrameCount();
                    int upperBound = high < depth ? Math.min(depth, 200) : depth;
                    MISession mi = target.getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    MIStackListFrames frames = factory.createMIStackListFrames(0, upperBound);
                    mi.postCommand(frames);
                    MIStackListFramesInfo info = frames.getMIStackListFramesInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    MIFrame[] miFrames = info.getMIFrames();
                    int i = 0;
                    while (i < miFrames.length) {
                        this.currentFrames.add(new StackFrame(this, miFrames[i], depth - miFrames[i].getLevel()));
                        ++i;
                    }
                }
                catch (MIException mIException) {
                }
                catch (CDIException cDIException) {}
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                target.setCurrentThread(currentThread, false);
                throw throwable;
            }
            {
                Object var13_16 = null;
            }
            target.setCurrentThread(currentThread, false);
            if (this.currentFrame == null) {
                int i = 0;
                while (i < this.currentFrames.size()) {
                    StackFrame f = (StackFrame)this.currentFrames.get(i);
                    if (f.getMIFrame().getLevel() == 0) {
                        this.currentFrame = f;
                    }
                    ++i;
                }
            }
        }
        List list = high - low + 1 <= this.currentFrames.size() ? this.currentFrames.subList(low, high + 1) : this.currentFrames;
        return list.toArray(noStack);
    }

    public void setCurrentStackFrame(StackFrame stackframe, boolean doUpdate) throws CDIException {
        Thread aThread;
        int frameLevel = 0;
        if (stackframe != null) {
            frameLevel = stackframe.getLevel();
        }
        if (this.currentFrame != null && this.currentFrame.getLevel() == frameLevel && stackframe != null && (aThread = (Thread)stackframe.getThread()) != null && aThread.getId() == this.getId()) {
            return;
        }
        try {
            Target target = (Target)this.getTarget();
            MISession mi = target.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            int miLevel = this.getStackFrameCount() - frameLevel;
            MIStackSelectFrame frame = factory.createMIStackSelectFrame(miLevel);
            target.setCurrentThread(this, doUpdate);
            mi.postCommand(frame);
            MIInfo info = frame.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            this.currentFrame = stackframe;
            if (doUpdate) {
                VariableManager varMgr;
                Session session = (Session)target.getSession();
                RegisterManager regMgr = session.getRegisterManager();
                if (regMgr.isAutoUpdate()) {
                    regMgr.update(target);
                }
                if ((varMgr = session.getVariableManager()).isAutoUpdate()) {
                    varMgr.update(target);
                }
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void stepInto() throws CDIException {
        this.stepInto(1);
    }

    public void stepInto(int count) throws CDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepInto(count);
    }

    public void stepIntoInstruction() throws CDIException {
        this.stepIntoInstruction(1);
    }

    public void stepIntoInstruction(int count) throws CDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepIntoInstruction(count);
    }

    public void stepOver() throws CDIException {
        this.stepOver(1);
    }

    public void stepOver(int count) throws CDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepOver(count);
    }

    public void stepOverInstruction() throws CDIException {
        this.stepOverInstruction(1);
    }

    public void stepOverInstruction(int count) throws CDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepOverInstruction(count);
    }

    public void stepReturn() throws CDIException {
        this.getCurrentStackFrame().stepReturn();
    }

    public void runUntil(ICDILocation location) throws CDIException {
        this.stepUntil(location);
    }

    public void stepUntil(ICDILocation location) throws CDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().stepUntil(location);
    }

    public boolean isSuspended() {
        return this.getTarget().isSuspended();
    }

    public void suspend() throws CDIException {
        this.getTarget().suspend();
    }

    public void resume() throws CDIException {
        this.resume(false);
    }

    public void resume(boolean passSignal) throws CDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().resume(passSignal);
    }

    public void resume(ICDILocation location) throws CDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().resume(location);
    }

    public void resume(ICDISignal signal) throws CDIException {
        ((Target)this.getTarget()).setCurrentThread(this);
        this.getTarget().resume(signal);
    }

    public void jump(ICDILocation location) throws CDIException {
        this.resume(location);
    }

    public void signal() throws CDIException {
        this.resume(false);
    }

    public void signal(ICDISignal signal) throws CDIException {
        this.resume(signal);
    }

    public boolean equals(ICDIThread thread) {
        if (thread instanceof Thread) {
            Thread cthread = (Thread)thread;
            return this.id == cthread.getId();
        }
        return super.equals(thread);
    }

    public ICDIBreakpoint[] getBreakpoints() throws CDIException {
        Target target = (Target)this.getTarget();
        ICDIBreakpoint[] bps = target.getBreakpoints();
        ArrayList<ICDIBreakpoint> list = new ArrayList<ICDIBreakpoint>(bps.length);
        int i = 0;
        while (i < bps.length) {
            ICDICondition condition = bps[i].getCondition();
            if (condition != null) {
                String[] threadIds = condition.getThreadIds();
                int j = 0;
                while (j < threadIds.length) {
                    int tid = 0;
                    try {
                        tid = Integer.parseInt(threadIds[j]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (tid == this.getId()) {
                        list.add(bps[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new ICDIBreakpoint[list.size()]);
    }

    public ICDIThreadStorageDescriptor[] getThreadStorageDescriptors() throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager varMgr = session.getVariableManager();
        return varMgr.getThreadStorageDescriptors(this);
    }

    public ICDIThreadStorage createThreadStorage(ICDIThreadStorageDescriptor varDesc) throws CDIException {
        if (varDesc instanceof ThreadStorageDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager varMgr = session.getVariableManager();
            return varMgr.createThreadStorage((ThreadStorageDescriptor)varDesc);
        }
        return null;
    }
}

