/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class PDOMPointerType
extends PDOMNode
implements IPointerType,
ITypeContainer {
    private static final int FLAGS = 9;
    private static final int TYPE = 12;
    private static final int RECORD_SIZE = 13;
    private static final int CONST = 1;
    private static final int VOLATILE = 2;

    public PDOMPointerType(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMPointerType(PDOM pdom, PDOMNode parent, IPointerType type) throws CoreException {
        super(pdom, parent);
        PDOMNode targetTypeNode;
        Database db = pdom.getDB();
        IType targetType = ((ITypeContainer)((Object)type)).getType();
        if (type != null && (targetTypeNode = this.getLinkage().addType(this, targetType)) != null) {
            db.putInt(this.record + 12, targetTypeNode.getRecord());
        }
        byte flags = 0;
        if (type.isConst()) {
            flags = (byte)(flags | 1);
        }
        if (type.isVolatile()) {
            flags = (byte)(flags | 2);
        }
        db.putByte(this.record + 9, flags);
    }

    protected int getRecordSize() {
        return 13;
    }

    public int getNodeType() {
        return 1;
    }

    private byte getFlags() throws CoreException {
        return this.pdom.getDB().getByte(this.record + 9);
    }

    public IType getType() throws DOMException {
        try {
            PDOMNode node = this.getLinkage().getNode(this.pdom.getDB().getInt(this.record + 12));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isConst() throws DOMException {
        try {
            return (this.getFlags() & 1) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isVolatile() throws DOMException {
        try {
            return (this.getFlags() & 2) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isSameType(IType type) {
        return this.equals(type);
    }

    public void setType(IType type) {
        throw new PDOMNotImplementedError();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            CCorePlugin.log(e);
            return null;
        }
    }
}

