/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStream;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.TypedRegion;

public class BuildConsolePartition
extends TypedRegion {
    private BuildConsoleStream fStream;
    public static final String CONSOLE_PARTITION_TYPE = String.valueOf(CUIPlugin.getPluginId()) + ".CONSOLE_PARTITION_TYPE";

    public BuildConsolePartition(BuildConsoleStream stream, int offset, int length) {
        super(offset, length, CONSOLE_PARTITION_TYPE);
        this.fStream = stream;
    }

    public boolean equals(Object partition) {
        if (super.equals(partition)) {
            return this.fStream.equals(((BuildConsolePartition)((Object)partition)).getStream());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.fStream.hashCode();
    }

    public BuildConsoleStream getStream() {
        return this.fStream;
    }

    public boolean canBeCombinedWith(BuildConsolePartition partition) {
        boolean overlap;
        int start = this.getOffset();
        int end = start + this.getLength();
        int otherStart = partition.getOffset();
        int otherEnd = otherStart + partition.getLength();
        boolean bl = overlap = otherStart >= start && otherStart <= end || start >= otherStart && start <= otherEnd;
        return overlap && this.getType().equals(partition.getType()) && this.getStream().equals(partition.getStream());
    }

    public BuildConsolePartition combineWith(BuildConsolePartition partition) {
        int start = this.getOffset();
        int end = start + this.getLength();
        int otherStart = partition.getOffset();
        int otherEnd = otherStart + partition.getLength();
        int theStart = Math.min(start, otherStart);
        int theEnd = Math.max(end, otherEnd);
        return this.createNewPartition(theStart, theEnd - theStart);
    }

    public BuildConsolePartition createNewPartition(int offset, int length) {
        return new BuildConsolePartition(this.getStream(), offset, length);
    }
}

