/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinerProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.StandardCElementLabelProvider;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class COutlineInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3 {
    private static final String STORE_RESTORE_SIZE = "ENABLE_RESTORE_SIZE";
    private static final String STORE_RESTORE_LOCATION = "ENABLE_RESTORE_LOCATION";
    private static final String STORE_SORT_ENABLED = "ENABLE_SORT";
    private static final int BORDER = 1;
    private static final int RIGHT_MARGIN = 3;
    private static final int MIN_WIDTH = 300;
    CEditor fEditor;
    Shell fShell;
    Composite fComposite;
    TreeViewer fTreeViewer;
    Text fFilterText;
    IContentProvider fTreeContentProvider;
    OutlineSorter fSorter;
    Rectangle fBounds;
    Rectangle fTrim;
    boolean fIsDeactivationActive;
    private Listener fDeactivateListener;
    private ShellListener fShellListener;
    private ControlListener fControlListener;
    boolean fSort = true;
    ToolBar fToolBar;
    private Composite fToolbarComposite;
    private MenuManager fViewMenuManager;

    public COutlineInformationControl(CEditor editor, Shell parent, int shellStyle, int treeStyle) {
        this.fEditor = editor;
        this.createShell(parent, shellStyle);
        this.createComposite();
        this.createToolbar();
        this.createHorizontalSeparator();
        this.createTreeeViewer(treeStyle);
    }

    public void setInformation(String information) {
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        if (maxWidth > -1 && maxHeight > -1) {
            GridData gd = new GridData(1808);
            if (maxWidth > -1) {
                gd.widthHint = maxWidth < 300 ? 300 : maxWidth;
            }
            if (maxHeight > -1) {
                gd.heightHint = maxHeight;
            }
            this.fTreeViewer.getTree().setLayoutData((Object)gd);
        }
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public void setVisible(boolean visible) {
        if (visible || this.fIsDeactivationActive) {
            this.fShell.setVisible(visible);
        }
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void setLocation(Point location) {
        this.fTrim = this.fShell.computeTrim(0, 0, 0, 0);
        Point compositeLocation = this.fComposite.getLocation();
        location.x += this.fTrim.x - compositeLocation.x;
        location.y += this.fTrim.y - compositeLocation.y;
        this.fShell.setLocation(location);
    }

    public void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.removeShellListener(this.fShellListener);
            this.fShell.removeListener(27, this.fDeactivateListener);
            this.fShell.dispose();
            this.fFilterText.dispose();
            this.fComposite.dispose();
        } else {
            this.fShell = null;
            this.fComposite = null;
            this.fTreeViewer = null;
            this.fFilterText = null;
            this.fDeactivateListener = null;
            this.fShellListener = null;
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fTreeViewer.getTree().setForeground(foreground);
        this.fFilterText.setForeground(foreground);
        this.fComposite.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fTreeViewer.getTree().setBackground(background);
        this.fFilterText.setBackground(background);
        this.fComposite.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fShell.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fShell.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && ((Tree)this.fTreeViewer.getControl()).getItemCount() > 0;
    }

    public Rectangle getBounds() {
        return this.fBounds;
    }

    public Rectangle computeTrim() {
        if (this.fTrim != null) {
            return this.fTrim;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public boolean restoresLocation() {
        return this.getSettings().getBoolean(STORE_RESTORE_LOCATION);
    }

    public boolean restoresSize() {
        return this.getSettings().getBoolean(STORE_RESTORE_SIZE);
    }

    MenuManager getViewMenuManager() {
        if (this.fViewMenuManager == null) {
            this.fViewMenuManager = new MenuManager();
            this.fViewMenuManager.add((IAction)new SortAction());
            this.fViewMenuManager.add((IContributionItem)new Separator());
            this.fViewMenuManager.add((IAction)new RememberBoundsAction());
            this.fViewMenuManager.add((IAction)new MoveAction());
        }
        return this.fViewMenuManager;
    }

    private void createShell(Shell parent, int shellStyle) {
        this.fShell = new Shell(parent, shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        int border = (shellStyle & 8) == 0 ? 0 : 1;
        this.fShell.setLayout((Layout)new BorderFillLayout(border));
        this.createDeactivationListener();
        this.fShell.addListener(27, this.fDeactivateListener);
        this.fIsDeactivationActive = true;
        this.createShellListener();
        this.fShell.addShellListener(this.fShellListener);
        this.createControlListener();
        this.fShell.addControlListener(this.fControlListener);
    }

    private void createComposite() {
        this.fComposite = new Composite((Composite)this.fShell, 16);
        GridLayout layout = new GridLayout(1, false);
        this.fComposite.setLayout((Layout)layout);
        this.fComposite.setLayoutData((Object)new GridData(768));
    }

    private void createTreeeViewer(int treeStyle) {
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        this.fTreeViewer = new ProblemTreeViewer(this.fComposite, treeStyle);
        Tree tree = this.fTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        this.fTreeContentProvider = new CContentOutlinerProvider(this.fTreeViewer);
        this.fSorter = new OutlineSorter();
        this.fTreeViewer.setContentProvider(this.fTreeContentProvider);
        if (this.getSettings().getBoolean(STORE_SORT_ENABLED)) {
            this.fTreeViewer.setSorter((ViewerSorter)this.fSorter);
        }
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingCLabelProvider(new StandardCElementLabelProvider(), true));
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.fTreeViewer.setInput((Object)manager.getWorkingCopy(this.fEditor.getEditorInput()));
        tree.addKeyListener(this.createKeyListenerForTreeViewer());
        tree.addSelectionListener(this.createSelectionListenerForTreeViewer());
        tree.addMouseMoveListener(this.createMouseMoveListenerForTreeViewer());
        tree.addMouseListener(this.createMouseListenerForTreeViewer());
    }

    private void createHorizontalSeparator() {
        Label separator = new Label(this.fComposite, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    private void createToolbar() {
        this.fToolbarComposite = new Composite(this.fComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fToolbarComposite.setLayout((Layout)layout);
        this.fToolbarComposite.setLayoutData((Object)new GridData(768));
        this.createFilterText();
        this.createViewMenu();
    }

    private void createFilterText() {
        this.fFilterText = new Text(this.fToolbarComposite, 0);
        GridData data = new GridData(768);
        GC gc = new GC((Drawable)this.fComposite);
        gc.setFont(this.fComposite.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(this.createKeyListenerForFilterContol());
        this.fFilterText.addModifyListener(this.createModifyListenerForFilterControl());
    }

    private void createViewMenu() {
        this.fToolBar = new ToolBar(this.fToolbarComposite, 0x800000);
        ToolItem viewMenuButton = new ToolItem(this.fToolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        data.verticalAlignment = 1;
        this.fToolBar.setLayoutData((Object)data);
        viewMenuButton.setImage(CPluginImages.get("org.eclipse.cdt.ui.view_menu.gif"));
        this.createSelectionListenerForOptions(viewMenuButton);
    }

    private void createSelectionListenerForOptions(ToolItem viewMenuButton) {
        viewMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                COutlineInformationControl.this.fIsDeactivationActive = false;
                Menu menu = COutlineInformationControl.this.getViewMenuManager().createContextMenu((Control)COutlineInformationControl.this.fShell);
                Rectangle bounds = COutlineInformationControl.this.fToolBar.getBounds();
                Point topLeft = COutlineInformationControl.this.fShell.toDisplay(new Point(bounds.x, bounds.y + bounds.height));
                menu.setLocation(topLeft.x, topLeft.y);
                menu.setVisible(true);
            }
        });
    }

    private MouseListener createMouseListenerForTreeViewer() {
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Tree tree = COutlineInformationControl.this.fTreeViewer.getTree();
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        CElement selectedElement = (CElement)selection.getData();
                        COutlineInformationControl.this.fEditor.setSelection((ICElement)selectedElement);
                        COutlineInformationControl.this.dispose();
                    }
                    if (COutlineInformationControl.this.fComposite != null && !COutlineInformationControl.this.fComposite.isDisposed()) {
                        COutlineInformationControl.this.fBounds = COutlineInformationControl.this.fComposite.getBounds();
                    }
                }
            }
        };
        return mouseListener;
    }

    private MouseMoveListener createMouseMoveListenerForTreeViewer() {
        MouseMoveListener moveListener = new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                Tree tree = COutlineInformationControl.this.fTreeViewer.getTree();
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = COutlineInformationControl.this.fTreeViewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = COutlineInformationControl.this.fTreeViewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        };
        return moveListener;
    }

    private SelectionListener createSelectionListenerForTreeViewer() {
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TreeItem[] selection = ((Tree)COutlineInformationControl.this.fTreeViewer.getControl()).getSelection();
                if (selection.length > 0) {
                    CElement selectedElement = (CElement)selection[0].getData();
                    COutlineInformationControl.this.fEditor.setSelection((ICElement)selectedElement);
                    COutlineInformationControl.this.dispose();
                }
            }
        };
        return selectionListener;
    }

    private KeyListener createKeyListenerForTreeViewer() {
        KeyListener listener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    COutlineInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        return listener;
    }

    private ModifyListener createModifyListenerForFilterControl() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                ((CContentOutlinerProvider)COutlineInformationControl.this.fTreeContentProvider).updateFilter(text);
            }
        };
        return modifyListener;
    }

    private KeyListener createKeyListenerForFilterContol() {
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int cfr_ignored_0 = e.keyCode;
                if (e.keyCode == 0x1000002) {
                    COutlineInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    COutlineInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    COutlineInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        return keyListener;
    }

    private void createControlListener() {
        this.fControlListener = new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                COutlineInformationControl.this.fBounds = COutlineInformationControl.this.fShell.getBounds();
                if (COutlineInformationControl.this.fTrim != null) {
                    Point location = COutlineInformationControl.this.fComposite.getLocation();
                    COutlineInformationControl.this.fBounds.x = COutlineInformationControl.this.fBounds.x - COutlineInformationControl.this.fTrim.x + location.x;
                    COutlineInformationControl.this.fBounds.y = COutlineInformationControl.this.fBounds.y - COutlineInformationControl.this.fTrim.y + location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                COutlineInformationControl.this.fBounds = COutlineInformationControl.this.fShell.getBounds();
                if (COutlineInformationControl.this.fTrim != null) {
                    Point location = COutlineInformationControl.this.fComposite.getLocation();
                    COutlineInformationControl.this.fBounds.x = COutlineInformationControl.this.fBounds.x - COutlineInformationControl.this.fTrim.x + location.x;
                    COutlineInformationControl.this.fBounds.y = COutlineInformationControl.this.fBounds.y - COutlineInformationControl.this.fTrim.y + location.y;
                }
            }
        };
    }

    private void createDeactivationListener() {
        this.fDeactivateListener = new Listener(){

            public void handleEvent(Event event) {
                if (COutlineInformationControl.this.fIsDeactivationActive) {
                    COutlineInformationControl.this.dispose();
                }
            }
        };
    }

    private void createShellListener() {
        this.fShellListener = new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (e.widget == COutlineInformationControl.this.fShell && COutlineInformationControl.this.fShell.getShells().length == 0) {
                    COutlineInformationControl.this.fIsDeactivationActive = true;
                }
            }
        };
    }

    IDialogSettings getSettings() {
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection("org.eclipse.jdt.internal.ui.text.QuickOutline");
        if (settings == null) {
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection("org.eclipse.jdt.internal.ui.text.QuickOutline");
        }
        return settings;
    }

    private static class BorderFillLayout
    extends Layout {
        final int fBorderSize;

        public BorderFillLayout(int borderSize) {
            if (borderSize < 0) {
                throw new IllegalArgumentException();
            }
            this.fBorderSize = borderSize;
        }

        public int getBorderSize() {
            return this.fBorderSize;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(0, 0);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Point size = children[i].computeSize(wHint, hHint, flushCache);
                    minSize.x = Math.max(minSize.x, size.x);
                    minSize.y = Math.max(minSize.y, size.y);
                    ++i;
                }
            }
            minSize.x += this.fBorderSize * 2 + 3;
            minSize.y += this.fBorderSize * 2;
            return minSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(composite.getClientArea().width, composite.getClientArea().height);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    child.setSize(minSize.x - this.fBorderSize * 2, minSize.y - this.fBorderSize * 2);
                    child.setLocation(this.fBorderSize, this.fBorderSize);
                    ++i;
                }
            }
        }
    }

    private class OutlineSorter
    extends ViewerSorter {
        private OutlineSorter() {
        }

        public void sort(Viewer viewer, Object[] elements) {
            if (COutlineInformationControl.this.fSort) {
                super.sort(viewer, elements);
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            if (e1 instanceof CElementGrouping && e2 instanceof CElement) {
                result = -1;
            } else if (e1 instanceof CElement && e2 instanceof CElementGrouping) {
                result = 1;
            } else {
                String elName2;
                String elName1;
                int elType2;
                int elType1;
                if (e1 instanceof CElement && e2 instanceof CElement) {
                    CElement cel1 = (CElement)e1;
                    CElement cel2 = (CElement)e2;
                    elType1 = cel1.getElementType();
                    elType2 = cel2.getElementType();
                    elName1 = cel1.getElementName();
                    elName2 = cel2.getElementName();
                } else {
                    CElementGrouping cel1 = (CElementGrouping)((Object)e1);
                    CElementGrouping cel2 = (CElementGrouping)((Object)e2);
                    elType1 = cel1.getType();
                    elType2 = cel2.getType();
                    elName1 = ((Object)((Object)cel1)).toString();
                    elName2 = ((Object)((Object)cel2)).toString();
                }
                result = elType1 == elType2 ? elName1.compareTo(elName2) : (elType1 > elType2 ? -1 : (elType1 < elType2 ? 1 : 0));
            }
            return result;
        }
    }

    private class RememberBoundsAction
    extends Action {
        RememberBoundsAction() {
            super(ActionMessages.getString("COutlineInformationControl.viewMenu.remember.label"), 2);
            this.setChecked(COutlineInformationControl.this.getSettings().getBoolean(COutlineInformationControl.STORE_RESTORE_LOCATION));
        }

        public void run() {
            IDialogSettings settings = COutlineInformationControl.this.getSettings();
            boolean newValue = this.isChecked();
            settings.put(COutlineInformationControl.STORE_RESTORE_LOCATION, newValue);
            settings.put(COutlineInformationControl.STORE_RESTORE_SIZE, newValue);
            COutlineInformationControl.this.fIsDeactivationActive = true;
        }
    }

    private class MoveAction
    extends Action {
        MoveAction() {
            super(ActionMessages.getString("COutlineInformationControl.viewMenu.move.label"), 1);
        }

        public void run() {
            Tracker tracker = new Tracker(COutlineInformationControl.this.fShell.getDisplay(), 0);
            tracker.setStippled(true);
            Rectangle[] r = new Rectangle[]{COutlineInformationControl.this.fFilterText.getShell().getBounds()};
            tracker.setRectangles(r);
            if (tracker.open()) {
                COutlineInformationControl.this.fShell.setBounds(tracker.getRectangles()[0]);
            }
        }
    }

    private class SortAction
    extends Action {
        SortAction() {
            super(ActionMessages.getString("COutlineInformationControl.viewMenu.sort.label"), 2);
            this.setChecked(COutlineInformationControl.this.getSettings().getBoolean(COutlineInformationControl.STORE_SORT_ENABLED));
        }

        public void run() {
            boolean newValue = this.isChecked();
            if (newValue) {
                COutlineInformationControl.this.fTreeViewer.setSorter((ViewerSorter)COutlineInformationControl.this.fSorter);
            } else {
                COutlineInformationControl.this.fTreeViewer.setSorter(null);
            }
            COutlineInformationControl.this.getSettings().put(COutlineInformationControl.STORE_SORT_ENABLED, newValue);
            COutlineInformationControl.this.fIsDeactivationActive = true;
        }
    }
}

