/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.indexer.ctags.CtagsIndexer;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.index.AbstractIndexerPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class CTagsIndexerBlock
extends AbstractIndexerPage {
    protected CtagsIndexer ctagsIndexer;
    protected boolean internalTagsFile = true;
    protected Button internalCTagsFile;
    protected Button externalCTagsFile;
    protected Button browseButton;
    protected Text cTagsFile;
    protected boolean useDefaultCTags = true;
    protected Button useCTagsPath;
    protected Button useCTagsExecutable;
    protected Button browseButtonCTagsExec;
    protected Text cTagsExecutable;
    public static final String PREF_INTOREXT_CTAGS = "org.eclipse.cdt.ui.intorextctags";
    public static final String PREF_CTAGS_FILE_LOCATION_CTAGS = "org.eclipse.cdt.ui.ctagsfilelocation";
    public static final String PREF_CTAGS_INDEXINCLUDEFILES = "org.eclipse.cdt.ui.ctagsindexincludes";
    public static final String PREF_CTAGS_LOCATION_TYPE = "org.eclipse.cdt.ui.ctagslocationtype";
    public static final String PREF_CTAGS_LOCATION = "org.eclipse.cdt.ui.ctagslocation";

    public void initialize(ICProject project) {
        this.currentProject = project;
        try {
            this.loadPersistedValues(project);
        }
        catch (CoreException coreException) {}
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CUIMessages.getString("IndexerOptiosn.task.savingAttributes "), 1);
        if (this.ctagsIndexer != null) {
            this.ctagsIndexer.setPreferences(this.useDefaultCTags, this.cTagsExecutable.getText(), this.internalTagsFile, this.cTagsFile.getText());
        } else {
            CtagsIndexer.setDefaultPreferences((boolean)this.useDefaultCTags, (String)this.cTagsExecutable.getText(), (boolean)this.internalTagsFile, (String)this.cTagsFile.getText());
        }
    }

    public void performDefaults() {
        this.internalTagsFile = true;
        this.internalCTagsFile.setSelection(true);
        this.externalCTagsFile.setSelection(false);
        this.cTagsFile.setText("");
        this.browseButton.setEnabled(false);
        this.useDefaultCTags = true;
        this.useCTagsPath.setSelection(true);
        this.useCTagsExecutable.setSelection(false);
        this.cTagsExecutable.setText("");
        this.browseButtonCTagsExec.setEnabled(false);
    }

    public void createControl(Composite parent) {
        Composite page = ControlFactory.createComposite(parent, 1);
        Group cTagsExecutableGroup = ControlFactory.createGroup(page, CUIMessages.getString("CTagsIndexerBlock.ctagsLocation"), 3);
        GridData gd3 = (GridData)cTagsExecutableGroup.getLayoutData();
        gd3.grabExcessHorizontalSpace = true;
        gd3.horizontalAlignment = 4;
        SelectionAdapter cTagsListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTagsIndexerBlock.this.useDefaultCTags = CTagsIndexerBlock.this.useCTagsPath.getSelection();
                if (CTagsIndexerBlock.this.useDefaultCTags) {
                    CTagsIndexerBlock.this.setCommandState();
                }
            }
        };
        this.useCTagsPath = ControlFactory.createRadioButton((Composite)cTagsExecutableGroup, CUIMessages.getString("CTagsIndexerBlock.radioButtonCTagsDefault"), "CTagsDefault", (SelectionListener)cTagsListener);
        ((GridData)this.useCTagsPath.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.useCTagsPath.getLayoutData()).grabExcessHorizontalSpace = true;
        this.useCTagsPath.setSelection(this.internalTagsFile);
        this.useCTagsExecutable = ControlFactory.createRadioButton((Composite)cTagsExecutableGroup, CUIMessages.getString("CTagsIndexerBlock.radioButtonCTagsSpecified"), "CTafsSpecified", (SelectionListener)cTagsListener);
        ((GridData)this.useCTagsExecutable.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.useCTagsExecutable.getLayoutData()).grabExcessHorizontalSpace = true;
        this.cTagsExecutable = ControlFactory.createTextField((Composite)cTagsExecutableGroup);
        ((GridData)this.cTagsExecutable.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.cTagsExecutable.getLayoutData()).grabExcessHorizontalSpace = true;
        this.browseButtonCTagsExec = ControlFactory.createPushButton((Composite)cTagsExecutableGroup, CUIMessages.getString("CTagsIndexerBlock.browseButton"));
        ((GridData)this.browseButtonCTagsExec.getLayoutData()).widthHint = SWTUtil.getButtonWidthHint(this.browseButtonCTagsExec);
        this.browseButtonCTagsExec.setEnabled(false);
        this.browseButtonCTagsExec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.handleBrowseButtonSelected();
            }

            void handleBrowseButtonSelected() {
                CTagsIndexerBlock.this.cTagsExecutable.setText(CTagsIndexerBlock.this.openFileBrowser());
            }
        });
        Group group = ControlFactory.createGroup(page, CUIMessages.getString("CTagsIndexerBlock.blockName"), 3);
        GridData gd = (GridData)group.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        SelectionAdapter cListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTagsIndexerBlock.this.internalTagsFile = CTagsIndexerBlock.this.internalCTagsFile.getSelection();
                if (CTagsIndexerBlock.this.internalTagsFile) {
                    CTagsIndexerBlock.this.setFilenameState();
                }
            }
        };
        this.internalCTagsFile = ControlFactory.createRadioButton((Composite)group, CUIMessages.getString("CTagsIndexerBlock.radioButtonInternal"), "Internal", (SelectionListener)cListener);
        ((GridData)this.internalCTagsFile.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.internalCTagsFile.getLayoutData()).grabExcessHorizontalSpace = true;
        this.internalCTagsFile.setSelection(this.internalTagsFile);
        this.externalCTagsFile = ControlFactory.createRadioButton((Composite)group, CUIMessages.getString("CTagsIndexerBlock.radioButtonExternal"), "External", (SelectionListener)cListener);
        ((GridData)this.externalCTagsFile.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.externalCTagsFile.getLayoutData()).grabExcessHorizontalSpace = true;
        this.cTagsFile = ControlFactory.createTextField((Composite)group);
        ((GridData)this.cTagsFile.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.cTagsFile.getLayoutData()).grabExcessHorizontalSpace = true;
        this.browseButton = ControlFactory.createPushButton((Composite)group, CUIMessages.getString("CTagsIndexerBlock.browseButton"));
        ((GridData)this.browseButton.getLayoutData()).widthHint = SWTUtil.getButtonWidthHint(this.browseButton);
        this.browseButton.setEnabled(false);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.handleBrowseButtonSelected();
            }

            private void handleBrowseButtonSelected() {
                CTagsIndexerBlock.this.cTagsFile.setText(CTagsIndexerBlock.this.openFileBrowser());
            }
        });
        this.setControl((Control)page);
    }

    String openFileBrowser() {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(CUIMessages.getString("CTagsIndexerBlock.fileBrowser"));
        String fileName = dialog.open();
        if (fileName == null) {
            return "";
        }
        return fileName;
    }

    public void loadPersistedValues(ICProject project) throws CoreException {
        IPDOMIndexer indexer = CCorePlugin.getPDOMManager().getIndexer(project);
        if (!(indexer instanceof CtagsIndexer)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "Wrong indexer", null));
        }
        this.ctagsIndexer = (CtagsIndexer)indexer;
        this.useDefaultCTags = this.ctagsIndexer.useCtagsOnPath();
        this.cTagsExecutable.setText(this.ctagsIndexer.getCtagsCommand());
        this.setCommandState();
        this.internalTagsFile = this.ctagsIndexer.useInternalCtagsFile();
        this.cTagsFile.setText(this.ctagsIndexer.getCtagsFileName());
        this.setFilenameState();
    }

    private void setCommandState() {
        this.useCTagsPath.setSelection(this.useDefaultCTags);
        this.useCTagsExecutable.setSelection(!this.useDefaultCTags);
        this.browseButtonCTagsExec.setEnabled(!this.useDefaultCTags);
    }

    private void setFilenameState() {
        this.internalCTagsFile.setSelection(this.internalTagsFile);
        this.externalCTagsFile.setSelection(!this.internalTagsFile);
        this.browseButton.setEnabled(!this.internalTagsFile);
    }

    public void loadPreferences() {
        this.useDefaultCTags = CtagsIndexer.getDefaultUseCtagsOnPath();
        this.cTagsExecutable.setText(CtagsIndexer.getDefaultCtagsCommand());
        this.setCommandState();
        this.internalTagsFile = CtagsIndexer.getDefaultUseInternalCtagsFile();
        this.cTagsFile.setText(CtagsIndexer.getDefaultCtagsFileName());
        this.setFilenameState();
    }

    public void removePreferences() {
        this.prefStore.setToDefault(PREF_CTAGS_FILE_LOCATION_CTAGS);
        this.prefStore.setToDefault(PREF_INTOREXT_CTAGS);
    }
}

