/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.codemanipulation.AddIncludesOperation;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class AddIncludeOnSelectionAction
extends Action
implements IUpdate {
    private ITextEditor fEditor;
    private IRequiredInclude[] fRequiredIncludes;
    private String[] fUsings;

    public AddIncludeOnSelectionAction(ITextEditor editor) {
        super(CEditorMessages.getString("AddIncludeOnSelection.label"));
        this.setToolTipText(CEditorMessages.getString("AddIncludeOnSelection.tooltip"));
        this.setDescription(CEditorMessages.getString("AddIncludeOnSelection.description"));
        this.fEditor = editor;
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.add_includes_on_selection_action_context");
    }

    private void addInclude(ITranslationUnit tu) {
        AddIncludesOperation op = new AddIncludesOperation(tu, this.fRequiredIncludes, this.fUsings, false);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(op), op.getScheduleRule());
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.getString("AddIncludeOnSelection.error.message1"), null);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected ITranslationUnit getTranslationUnit() {
        IWorkingCopy unit = null;
        if (this.fEditor != null) {
            IEditorInput editorInput = this.fEditor.getEditorInput();
            unit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        }
        return unit;
    }

    private Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    public void run() {
        ITranslationUnit tu = this.getTranslationUnit();
        if (tu != null) {
            this.extractIncludes(this.fEditor);
            this.addInclude(tu);
        }
        this.fUsings = null;
        this.fRequiredIncludes = null;
    }

    private void extractIncludes(ITextEditor editor) {
        if (editor == null) {
            return;
        }
        ISelection s = editor.getSelectionProvider().getSelection();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (s.isEmpty() || !(s instanceof ITextSelection) || doc == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)s;
        try {
            IRegion region = CWordFinder.findWord(doc, selection.getOffset());
            if (region == null || region.getLength() == 0) {
                return;
            }
            String name = doc.get(region.getOffset(), region.getLength());
            if (name.length() == 0) {
                return;
            }
            IFunctionSummary fs = this.findContribution(name);
            if (fs != null) {
                this.fRequiredIncludes = fs.getIncludes();
                String ns = fs.getNamespace();
                if (ns != null && ns.length() > 0) {
                    this.fUsings = new String[]{fs.getNamespace()};
                }
            }
            if (this.fRequiredIncludes == null) {
                // empty if block
            }
            if (this.fRequiredIncludes == null) {
                // empty if block
            }
        }
        catch (BadLocationException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)CEditorMessages.getString("AddIncludeOnSelection.error.message3"), (String)(String.valueOf(CEditorMessages.getString("AddIncludeOnSelection.error.message4")) + e.getMessage()));
        }
    }

    private IFunctionSummary findContribution(final String name) {
        final IFunctionSummary[] fs = new IFunctionSummary[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ICHelpInvocationContext context = new ICHelpInvocationContext(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IProject getProject() {
                        ITranslationUnit u = this.getTranslationUnit();
                        if (u != null) {
                            return u.getCProject().getProject();
                        }
                        return null;
                    }

                    public ITranslationUnit getTranslationUnit() {
                        return 1.access$0(this.this$1).getTranslationUnit();
                    }
                };
                fs[0] = CHelpProviderManager.getDefault().getFunctionInfo(context, name);
            }

            static /* synthetic */ AddIncludeOnSelectionAction access$0(1 var0) {
                return var0.AddIncludeOnSelectionAction.this;
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.getString("AddIncludeOnSelection.error.message1"), null);
        }
        catch (InterruptedException interruptedException) {}
        return fs[0];
    }

    public void setContentEditor(ITextEditor editor) {
        this.fEditor = editor;
    }

    public void update() {
        this.setEnabled(true);
    }

    class RequiredIncludes
    implements IRequiredInclude {
        String name;
        boolean isStandard;

        RequiredIncludes(String n) {
            this.name = n;
            this.isStandard = true;
        }

        RequiredIncludes(String n, boolean isStandard) {
            this.name = n;
            this.isStandard = isStandard;
        }

        public String getIncludeName() {
            return this.name;
        }

        public boolean isStandard() {
            return this.isStandard;
        }
    }
}

