/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.projectconverter;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.projectconverter.ConverterMessages;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class UpdateManagedProject30 {
    static void doProjectUpdate(IProgressMonitor monitor, final IProject project) throws CoreException {
        String[] projectName = new String[]{project.getName()};
        IFile file = project.getFile(".cdtbuild");
        File settingsFile = file.getLocation().toFile();
        if (!settingsFile.exists()) {
            monitor.done();
            return;
        }
        monitor.beginTask(ConverterMessages.getFormattedString("UpdateManagedProject20.0", projectName), 1);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        UpdateManagedProjectManager.backupFile(file, "_30backup", monitor, project);
        ((ManagedBuildInfo)info).setVersion(ManagedBuildManager.getBuildInfoVersion().toString());
        info.setValid(true);
        IWorkspace workspace = project.getWorkspace();
        ISchedulingRule rule1 = workspace.getRuleFactory().createRule((IResource)project);
        ISchedulingRule rule2 = workspace.getRuleFactory().refreshRule((IResource)project);
        ISchedulingRule rule = MultiRule.combine((ISchedulingRule)rule1, (ISchedulingRule)rule2);
        WorkspaceJob job = new WorkspaceJob(ConverterMessages.getResourceString("UpdateManagedProject.notice")){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ManagedBuildManager.saveBuildInfo(project, true);
                return Status.OK_STATUS;
            }
        };
        job.setRule(rule);
        job.schedule();
        monitor.done();
    }
}

