/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.math.BigInteger;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.mi.core.GDBTypeParser;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.RxThread;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Instruction;
import org.eclipse.cdt.debug.mi.core.cdi.model.MixedInstruction;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ArrayType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.BoolType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.CharType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.DerivedType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.DoubleType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.EnumType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FloatType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FunctionType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IntType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongLongType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.PointerType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ReferenceType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ShortType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.StructType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.Type;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.VoidType;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.WCharType;
import org.eclipse.cdt.debug.mi.core.command.CLIPType;
import org.eclipse.cdt.debug.mi.core.command.CLIWhatis;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataDisassemble;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentDirectory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowDirectories;
import org.eclipse.cdt.debug.mi.core.output.CLIPTypeInfo;
import org.eclipse.cdt.debug.mi.core.output.CLIWhatisInfo;
import org.eclipse.cdt.debug.mi.core.output.MIAsm;
import org.eclipse.cdt.debug.mi.core.output.MIDataDisassembleInfo;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowDirectoriesInfo;
import org.eclipse.cdt.debug.mi.core.output.MISrcAsm;

public class SourceManager
extends Manager {
    GDBTypeParser gdbTypeParser = new GDBTypeParser();

    public SourceManager(Session session) {
        super(session, false);
    }

    public void setSourcePaths(Target target, String[] dirs) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIEnvironmentDirectory dir = factory.createMIEnvironmentDirectory(true, dirs);
        try {
            mi.postCommand(dir);
            dir.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public String[] getSourcePaths(Target target) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShowDirectories dir = factory.createMIGDBShowDirectories();
        try {
            mi.postCommand(dir);
            MIGDBShowDirectoriesInfo info = dir.getMIGDBShowDirectoriesInfo();
            return info.getDirectories();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIInstruction[] getInstructions(Target target, String filename, int linenum) throws CDIException {
        return this.getInstructions(target, filename, linenum, -1);
    }

    public ICDIInstruction[] getInstructions(Target target, String filename, int linenum, int lines) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataDisassemble dis = factory.createMIDataDisassemble(filename, linenum, lines, false);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MIAsm[] asm = info.getMIAsms();
            ICDIInstruction[] instructions = new Instruction[asm.length];
            int i = 0;
            while (i < instructions.length) {
                instructions[i] = new Instruction(target, asm[i]);
                ++i;
            }
            return instructions;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIInstruction[] getInstructions(Target target, BigInteger start, BigInteger end) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        String hex = "0x";
        String sa = String.valueOf(hex) + start.toString(16);
        String ea = String.valueOf(hex) + end.toString(16);
        MIDataDisassemble dis = factory.createMIDataDisassemble(sa, ea, false);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MIAsm[] asm = info.getMIAsms();
            ICDIInstruction[] instructions = new Instruction[asm.length];
            int i = 0;
            while (i < instructions.length) {
                instructions[i] = new Instruction(target, asm[i]);
                ++i;
            }
            return instructions;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIMixedInstruction[] getMixedInstructions(Target target, String filename, int linenum) throws CDIException {
        return this.getMixedInstructions(target, filename, linenum, -1);
    }

    public ICDIMixedInstruction[] getMixedInstructions(Target target, String filename, int linenum, int lines) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataDisassemble dis = factory.createMIDataDisassemble(filename, linenum, lines, true);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MISrcAsm[] srcAsm = info.getMISrcAsms();
            ICDIMixedInstruction[] mixed = new ICDIMixedInstruction[srcAsm.length];
            int i = 0;
            while (i < mixed.length) {
                mixed[i] = new MixedInstruction(target, srcAsm[i]);
                ++i;
            }
            return mixed;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDIMixedInstruction[] getMixedInstructions(Target target, BigInteger start, BigInteger end) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        String hex = "0x";
        String sa = String.valueOf(hex) + start.toString(16);
        String ea = String.valueOf(hex) + end.toString(16);
        MIDataDisassemble dis = factory.createMIDataDisassemble(sa, ea, true);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MISrcAsm[] srcAsm = info.getMISrcAsms();
            ICDIMixedInstruction[] mixed = new ICDIMixedInstruction[srcAsm.length];
            int i = 0;
            while (i < mixed.length) {
                mixed[i] = new MixedInstruction(target, srcAsm[i]);
                ++i;
            }
            return mixed;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void update(Target target) throws CDIException {
    }

    public Type getType(Target target, String name) throws CDIException {
        if (name == null) {
            name = new String();
        }
        String typename = name.trim();
        GDBTypeParser.GDBType gdbType = this.gdbTypeParser.parse(typename);
        Type headType = null;
        Type type = null;
        Type aType = null;
        while (gdbType != null) {
            if (gdbType instanceof GDBTypeParser.GDBDerivedType) {
                switch (gdbType.getType()) {
                    case 3: {
                        int d = ((GDBTypeParser.GDBDerivedType)gdbType).getDimension();
                        aType = new ArrayType(target, gdbType.toString(), d);
                        break;
                    }
                    case 4: {
                        aType = new FunctionType(target, gdbType.toString());
                        break;
                    }
                    case 1: {
                        aType = new PointerType(target, gdbType.toString());
                        break;
                    }
                    case 2: {
                        aType = new ReferenceType(target, gdbType.toString());
                    }
                }
                gdbType = ((GDBTypeParser.GDBDerivedType)gdbType).getChild();
            } else {
                aType = this.toCDIType(target, gdbType.toString());
                gdbType = null;
            }
            if (type instanceof DerivedType) {
                ((DerivedType)type).setComponentType(aType);
            }
            if (headType == null) {
                headType = aType;
            }
            type = aType;
        }
        if (headType != null) {
            return headType;
        }
        throw new CDIException(CdiResources.getString("cdi.SourceManager.Unknown_type"));
    }

    Type toCDIType(Target target, String name) throws CDIException {
        String typename;
        if (name == null) {
            name = new String();
        }
        if ((typename = name.trim()).equals("char")) {
            return new CharType(target, typename);
        }
        if (typename.equals("wchar_t")) {
            return new WCharType(target, typename);
        }
        if (typename.equals("short")) {
            return new ShortType(target, typename);
        }
        if (typename.equals("int")) {
            return new IntType(target, typename);
        }
        if (typename.equals("long")) {
            return new LongType(target, typename);
        }
        if (typename.equals("unsigned")) {
            return new IntType(target, typename, true);
        }
        if (typename.equals("signed")) {
            return new IntType(target, typename);
        }
        if (typename.equals("bool")) {
            return new BoolType(target, typename);
        }
        if (typename.equals("_Bool")) {
            return new BoolType(target, typename);
        }
        if (typename.equals("float")) {
            return new FloatType(target, typename);
        }
        if (typename.equals("double")) {
            return new DoubleType(target, typename);
        }
        if (typename.equals("void")) {
            return new VoidType(target, typename);
        }
        if (typename.equals("enum")) {
            return new EnumType(target, typename);
        }
        if (typename.equals("union")) {
            return new StructType(target, typename);
        }
        if (typename.equals("struct")) {
            return new StructType(target, typename);
        }
        if (typename.equals("class")) {
            return new StructType(target, typename);
        }
        if (typename.equals("int8_t")) {
            return new CharType(target, typename);
        }
        if (typename.equals("int16_t")) {
            return new ShortType(target, typename);
        }
        if (typename.equals("int32_t")) {
            return new LongType(target, typename);
        }
        if (typename.equals("int64_t")) {
            return new LongLongType(target, typename);
        }
        if (typename.equals("int128_t")) {
            return new IntType(target, typename);
        }
        if (typename.equals("int8_t")) {
            return new CharType(target, typename);
        }
        if (typename.equals("uint8_t")) {
            return new CharType(target, typename, true);
        }
        if (typename.equals("int16_t")) {
            return new ShortType(target, typename);
        }
        if (typename.equals("uint16_t")) {
            return new ShortType(target, typename, true);
        }
        if (typename.equals("int32_t")) {
            return new LongType(target, typename);
        }
        if (typename.equals("uint32_t")) {
            return new LongType(target, typename, true);
        }
        if (typename.equals("int64_t")) {
            return new LongLongType(target, typename);
        }
        if (typename.equals("uint64_t")) {
            return new LongLongType(target, typename, true);
        }
        if (typename.equals("int128_t")) {
            return new IntType(target, typename);
        }
        if (typename.equals("uint128_t")) {
            return new IntType(target, typename, true);
        }
        StringTokenizer st = new StringTokenizer(typename);
        int count = st.countTokens();
        if (count == 2) {
            String first = st.nextToken();
            String second = st.nextToken();
            boolean isUnsigned = first.equals("unsigned") || second.equals("unsigned");
            boolean isSigned = first.equals("signed") || second.equals("signed");
            boolean isChar = first.equals("char") || second.equals("char");
            boolean isInt = first.equals("int") || second.equals("int");
            boolean isLong = first.equals("long") || second.equals("long");
            boolean isShort = first.equals("short") || second.equals("short");
            boolean isLongLong = first.equals("long") && second.equals("long");
            boolean isDouble = first.equals("double") || second.equals("double");
            boolean isFloat = first.equals("float") || second.equals("float");
            boolean isComplex = first.equals("complex") || second.equals("complex") || first.equals("_Complex") || second.equals("_Complex");
            boolean isImaginery = first.equals("_Imaginary") || second.equals("_Imaginary");
            boolean isStruct = first.equals("struct");
            boolean isClass = first.equals("class");
            boolean isUnion = first.equals("union");
            boolean isEnum = first.equals("enum");
            if (isChar && (isSigned || isUnsigned)) {
                return new CharType(target, typename, isUnsigned);
            }
            if (isShort && (isSigned || isUnsigned)) {
                return new ShortType(target, typename, isUnsigned);
            }
            if (isInt && (isSigned || isUnsigned)) {
                return new IntType(target, typename, isUnsigned);
            }
            if (isLong && (isInt || isSigned || isUnsigned)) {
                return new LongType(target, typename, isUnsigned);
            }
            if (isLongLong) {
                return new LongLongType(target, typename);
            }
            if (isDouble && (isLong || isComplex || isImaginery)) {
                return new DoubleType(target, typename, isComplex, isImaginery, isLong);
            }
            if (isFloat && (isComplex || isImaginery)) {
                return new FloatType(target, typename, isComplex, isImaginery);
            }
            if (isStruct) {
                return new StructType(target, typename);
            }
            if (isClass) {
                return new StructType(target, typename);
            }
            if (isUnion) {
                return new StructType(target, typename);
            }
            if (isEnum) {
                return new EnumType(target, typename);
            }
        } else if (count == 3) {
            boolean isImaginery;
            String first = st.nextToken();
            String second = st.nextToken();
            String third = st.nextToken();
            boolean isSigned = first.equals("signed") || second.equals("signed") || third.equals("signed");
            boolean unSigned = first.equals("unsigned") || second.equals("unsigned") || third.equals("unsigned");
            boolean isInt = first.equals("int") || second.equals("int") || third.equals("int");
            boolean isLong = first.equals("long") || second.equals("long") || third.equals("long");
            boolean isShort = first.equals("short") || second.equals("short") || third.equals("short");
            boolean isLongLong = first.equals("long") && second.equals("long") || second.equals("long") && third.equals("long");
            boolean isDouble = first.equals("double") || second.equals("double") || third.equals("double");
            boolean isComplex = first.equals("complex") || second.equals("complex") || third.equals("complex") || first.equals("_Complex") || second.equals("_Complex") || third.equals("_Complex");
            boolean bl = isImaginery = first.equals("_Imaginary") || second.equals("_Imaginary") || third.equals("_Imaginary");
            if (isShort && isInt && (isSigned || unSigned)) {
                return new ShortType(target, typename, unSigned);
            }
            if (isLong && isInt && (isSigned || unSigned)) {
                return new LongType(target, typename, unSigned);
            }
            if (isLongLong && (isSigned || unSigned)) {
                return new LongLongType(target, typename, unSigned);
            }
            if (isDouble && isLong && (isComplex || isImaginery)) {
                return new DoubleType(target, typename, isComplex, isImaginery, isLong);
            }
        } else if (count == 4) {
            boolean isLongLong;
            String first = st.nextToken();
            String second = st.nextToken();
            String third = st.nextToken();
            String fourth = st.nextToken();
            boolean unSigned = first.equals("unsigned") || second.equals("unsigned") || third.equals("unsigned") || fourth.equals("unsigned");
            boolean isSigned = first.equals("signed") || second.equals("signed") || third.equals("signed") || fourth.equals("signed");
            boolean isInt = first.equals("int") || second.equals("int") || third.equals("int") || fourth.equals("int");
            boolean bl = isLongLong = first.equals("long") && second.equals("long") || second.equals("long") && third.equals("long") || third.equals("long") && fourth.equals("long");
            if (isLongLong && isInt && (isSigned || unSigned)) {
                return new LongLongType(target, typename, unSigned);
            }
        }
        throw new CDIException(CdiResources.getString("cdi.SourceManager.Unknown_type"));
    }

    public String getDetailTypeNameFromVariable(StackFrame frame, String variable) throws CDIException {
        String string;
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
        try {
            string = this.getDetailTypeName(target, variable);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        return string;
    }

    public String getDetailTypeName(Target target, String typename) throws CDIException {
        try {
            MISession mi = target.getMISession();
            RxThread rxThread = mi.getRxThread();
            rxThread.setEnableConsole(false);
            CommandFactory factory = mi.getCommandFactory();
            CLIPType ptype = factory.createCLIPType(typename);
            mi.postCommand(ptype);
            CLIPTypeInfo info = ptype.getMIPtypeInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            String string = info.getType();
            Object var8_10 = null;
            MISession mi2 = target.getMISession();
            RxThread rxThread2 = mi2.getRxThread();
            rxThread2.setEnableConsole(true);
            return string;
        }
        catch (MIException e) {
            try {
                throw new MI2CDIException(e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                MISession mi2 = target.getMISession();
                RxThread rxThread2 = mi2.getRxThread();
                rxThread2.setEnableConsole(true);
                throw throwable;
            }
        }
    }

    public String getTypeNameFromVariable(StackFrame frame, String variable) throws CDIException {
        String string;
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
        try {
            string = this.getTypeName(target, variable);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        return string;
    }

    public String getTypeName(Target target, String variable) throws CDIException {
        MISession miSession = target.getMISession();
        try {
            RxThread rxThread = miSession.getRxThread();
            rxThread.setEnableConsole(false);
            CommandFactory factory = miSession.getCommandFactory();
            CLIWhatis whatis = factory.createCLIWhatis(variable);
            miSession.postCommand(whatis);
            CLIWhatisInfo info = whatis.getMIWhatisInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            String string = info.getType();
            Object var8_10 = null;
            RxThread rxThread2 = miSession.getRxThread();
            rxThread2.setEnableConsole(true);
            return string;
        }
        catch (MIException e) {
            try {
                throw new MI2CDIException(e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                RxThread rxThread2 = miSession.getRxThread();
                rxThread2.setEnableConsole(true);
                throw throwable;
            }
        }
    }
}

