/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class Util {
    private static final char[] DOUBLE_QUOTES = "''".toCharArray();
    private static final char[] SINGLE_QUOTE = "'".toCharArray();
    private static final int DEFAULT_READING_SIZE = 8192;
    protected static ResourceBundle bundle;
    private static final String bundleName = "org.eclipse.cdt.internal.core.messages";
    public static HashSet existingExternalFiles;

    static {
        Util.relocalize();
        existingExternalFiles = new HashSet();
    }

    public static String bind(String id, String binding1, String binding2) {
        return Util.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String binding) {
        return Util.bind(id, new String[]{binding});
    }

    public static String bind(String id, String[] bindings) {
        StringBuffer output;
        block9: {
            if (id == null) {
                return "No message available";
            }
            String message = null;
            try {
                message = bundle.getString(id);
            }
            catch (MissingResourceException missingResourceException) {
                return "Missing message: " + id + " in: " + bundleName;
            }
            char[] messageWithNoDoubleQuotes = CharOperation.replace(message.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            message = new String(messageWithNoDoubleQuotes);
            if (bindings == null) {
                return message;
            }
            int length = message.length();
            int start = -1;
            int end = length;
            output = new StringBuffer(80);
            while ((end = message.indexOf(123, start)) > -1) {
                output.append(message.substring(start + 1, end));
                start = message.indexOf(125, end);
                if (start > -1) {
                    int index = -1;
                    try {
                        index = Integer.parseInt(message.substring(end + 1, start));
                        output.append(bindings[index]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        output.append(message.substring(end + 1, start + 1));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        output.append("{missing " + Integer.toString(index) + "}");
                    }
                    continue;
                }
                output.append(message.substring(end, length));
                break block9;
            }
            output.append(message.substring(start + 1, length));
        }
        return output.toString();
    }

    public static String bind(String id) {
        return Util.bind(id, null);
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw e;
        }
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = Util.getInputStreamAsByteArray(stream, (int)file.length());
                Object var2_3 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_4 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getFileCharContent(File file, String encoding) throws IOException {
        char[] cArray;
        BufferedInputStream stream = null;
        try {
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                cArray = Util.getInputStreamAsCharArray(stream, (int)file.length(), encoding);
                Object var3_4 = null;
                if (stream == null) return cArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Object var3_5 = null;
                if (stream == null) return null;
                try {
                    ((InputStream)stream).close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (stream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            ((InputStream)stream).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)stream).close();
        return cArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = CharOperation.NO_CHAR;
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, 0, contents, 0, len);
            }
        }
        return contents;
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        File externalFile = new File(path.toOSString());
        if (!checkResourceExistence) {
            return externalFile;
        }
        if (existingExternalFiles.contains(externalFile)) {
            return externalFile;
        }
        if (externalFile.exists()) {
            existingExternalFiles.add(externalFile);
            return externalFile;
        }
        return null;
    }

    public static final boolean isExcluded(IResource resource, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2) {
            path = path.append("*");
        }
        return Util.isExcluded(path, exclusionPatterns);
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CharOperation.pathMatch(exclusionPatterns[i], path, true, '/')) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

