/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.IPDOMResolver;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTPreprocessorSelectionResult;
import org.eclipse.cdt.internal.core.dom.parser.IRequiresLocationInformation;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.parser.scanner2.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner2.InvalidPreprocessorNodeException;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.core.runtime.CoreException;

public class CASTTranslationUnit
extends CASTNode
implements IASTTranslationUnit,
IRequiresLocationInformation {
    private IASTDeclaration[] decls = null;
    private int declsPos = -1;
    private CScope compilationUnit = null;
    private ILocationResolver resolver;
    private IPDOM pdom;
    private static final IASTPreprocessorStatement[] EMPTY_PREPROCESSOR_STATEMENT_ARRAY = new IASTPreprocessorStatement[0];
    private static final IASTNodeLocation[] EMPTY_PREPROCESSOR_LOCATION_ARRAY = new IASTNodeLocation[0];
    private static final IASTPreprocessorMacroDefinition[] EMPTY_PREPROCESSOR_MACRODEF_ARRAY = new IASTPreprocessorMacroDefinition[0];
    private static final IASTPreprocessorIncludeStatement[] EMPTY_PREPROCESSOR_INCLUSION_ARRAY = new IASTPreprocessorIncludeStatement[0];
    private static final IASTProblem[] EMPTY_PROBLEM_ARRAY = new IASTProblem[0];
    private static final String EMPTY_STRING = "";
    private static final IASTName[] EMPTY_NAME_ARRAY = new IASTName[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public IASTTranslationUnit getTranslationUnit() {
        return this;
    }

    public void addDeclaration(IASTDeclaration d) {
        if (d != null) {
            ++this.declsPos;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.decls = (IASTDeclaration[])ArrayUtil.append(clazz, this.decls, d);
        }
    }

    public IASTDeclaration[] getDeclarations() {
        if (this.decls == null) {
            return IASTDeclaration.EMPTY_DECLARATION_ARRAY;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.decls = (IASTDeclaration[])ArrayUtil.removeNullsAfter(clazz, this.decls, this.declsPos);
        return this.decls;
    }

    public IScope getScope() {
        if (this.compilationUnit == null) {
            this.compilationUnit = new CScope(this);
        }
        return this.compilationUnit;
    }

    public IASTName[] getDeclarations(IBinding binding) {
        IASTName[] names;
        block8: {
            if (binding instanceof IMacroBinding) {
                if (this.resolver == null) {
                    return EMPTY_NAME_ARRAY;
                }
                return this.resolver.getDeclarations((IMacroBinding)binding);
            }
            names = CVisitor.getDeclarations(this, binding);
            if (names.length == 0 && this.pdom != null) {
                try {
                    binding = ((PDOM)this.pdom).getLinkage(this.getLanguage()).adaptBinding(binding);
                    if (binding == null) break block8;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.cdt.core.dom.IPDOMResolver");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    names = ((IPDOMResolver)this.pdom.getAdapter(clazz)).getDeclarations(binding);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                    return names;
                }
            }
        }
        return names;
    }

    public IASTName[] getDefinitions(IBinding binding) {
        Object[] names;
        block14: {
            if (binding instanceof IMacroBinding) {
                if (this.resolver == null) {
                    return EMPTY_NAME_ARRAY;
                }
                return this.resolver.getDeclarations((IMacroBinding)binding);
            }
            names = CVisitor.getDeclarations(this, binding);
            int i = 0;
            while (i < names.length) {
                if (!names[i].isDefinition()) {
                    names[i] = null;
                }
                ++i;
            }
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((names = (IASTName[])ArrayUtil.removeNulls(clazz, names)).length == 0 && this.pdom != null) {
                try {
                    binding = ((PDOM)this.pdom).getLinkage(this.getLanguage()).adaptBinding(binding);
                    if (binding == null) break block14;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.dom.IPDOMResolver");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    names = ((IPDOMResolver)this.pdom.getAdapter(clazz2)).getDefinitions(binding);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                    return names;
                }
            }
        }
        return names;
    }

    public IASTName[] getReferences(IBinding binding) {
        if (binding instanceof IMacroBinding) {
            if (this.resolver == null) {
                return EMPTY_NAME_ARRAY;
            }
            return this.resolver.getReferences((IMacroBinding)binding);
        }
        return CVisitor.getReferences(this, binding);
    }

    public IASTNodeLocation[] getLocationInfo(int offset, int length) {
        if (this.resolver == null) {
            return EMPTY_PREPROCESSOR_LOCATION_ARRAY;
        }
        return this.resolver.getLocations(offset, length);
    }

    public IASTNode selectNodeForLocation(String path, int realOffset, int realLength) {
        IASTNode node = null;
        ASTPreprocessorSelectionResult result = null;
        int globalOffset = 0;
        try {
            result = this.resolver.getPreprocessorNode(path, realOffset, realLength);
        }
        catch (InvalidPreprocessorNodeException ipne) {
            globalOffset = ipne.getGlobalOffset();
        }
        if (result != null && result.getSelectedNode() != null) {
            node = result.getSelectedNode();
        } else {
            int n = globalOffset = result == null ? globalOffset : result.getGlobalOffset();
            if (globalOffset >= 0) {
                CFindNodeForOffsetAction nodeFinder = new CFindNodeForOffsetAction(globalOffset, realLength);
                this.accept(nodeFinder);
                node = nodeFinder.getNode();
            }
        }
        return node;
    }

    public IASTPreprocessorMacroDefinition[] getMacroDefinitions() {
        if (this.resolver == null) {
            return EMPTY_PREPROCESSOR_MACRODEF_ARRAY;
        }
        IASTPreprocessorMacroDefinition[] result = this.resolver.getMacroDefinitions();
        return result;
    }

    public IASTPreprocessorIncludeStatement[] getIncludeDirectives() {
        if (this.resolver == null) {
            return EMPTY_PREPROCESSOR_INCLUSION_ARRAY;
        }
        IASTPreprocessorIncludeStatement[] result = this.resolver.getIncludeDirectives();
        return result;
    }

    public IASTPreprocessorStatement[] getAllPreprocessorStatements() {
        if (this.resolver == null) {
            return EMPTY_PREPROCESSOR_STATEMENT_ARRAY;
        }
        IASTPreprocessorStatement[] result = this.resolver.getAllPreprocessorStatements();
        return result;
    }

    public void setLocationResolver(ILocationResolver resolver) {
        this.resolver = resolver;
        resolver.setRootNode(this);
    }

    protected void finalize() throws Throwable {
        if (this.resolver != null) {
            this.resolver.cleanup();
        }
        super.finalize();
    }

    public IASTProblem[] getPreprocessorProblems() {
        if (this.resolver == null) {
            return EMPTY_PROBLEM_ARRAY;
        }
        IASTProblem[] result = this.resolver.getScannerProblems();
        int i = 0;
        while (i < result.length) {
            IASTProblem p = result[i];
            p.setParent(this);
            p.setPropertyInParent(IASTTranslationUnit.SCANNER_PROBLEM);
            ++i;
        }
        return result;
    }

    public String getUnpreprocessedSignature(IASTNodeLocation[] locations) {
        if (this.resolver == null) {
            return EMPTY_STRING;
        }
        return new String(this.resolver.getUnpreprocessedSignature(locations));
    }

    public String getFilePath() {
        if (this.resolver == null) {
            return EMPTY_STRING;
        }
        return new String(this.resolver.getTranslationUnitPath());
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitTranslationUnit) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTDeclaration[] ds = this.getDeclarations();
        int i = 0;
        while (i < ds.length) {
            if (!ds[i].accept(action)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IASTFileLocation flattenLocationsToFile(IASTNodeLocation[] nodeLocations) {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.flattenLocations(nodeLocations);
    }

    public IASTName[] getMacroExpansions() {
        if (this.resolver == null) {
            return EMPTY_NAME_ARRAY;
        }
        return this.resolver.getMacroExpansions();
    }

    public IASTTranslationUnit.IDependencyTree getDependencyTree() {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getDependencyTree();
    }

    public String getContainingFilename(int offset) {
        if (this.resolver == null) {
            return EMPTY_STRING;
        }
        return this.resolver.getContainingFilename(offset);
    }

    public ParserLanguage getParserLanguage() {
        return ParserLanguage.C;
    }

    public ILanguage getLanguage() {
        return new GCCLanguage();
    }

    public IPDOM getIndex() {
        return this.pdom;
    }

    public void setIndex(IPDOM pdom) {
        this.pdom = pdom;
    }

    private class CFindNodeForOffsetAction
    extends CASTVisitor {
        IASTNode foundNode;
        int offset;
        int length;

        public CFindNodeForOffsetAction(int offset, int length) {
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitInitializers = true;
            this.shouldVisitParameterDeclarations = true;
            this.shouldVisitDeclarators = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDesignators = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitTypeIds = true;
            this.shouldVisitEnumerators = true;
            this.foundNode = null;
            this.offset = 0;
            this.length = 0;
            this.offset = offset;
            this.length = length;
        }

        public int processNode(IASTNode node) {
            if (this.foundNode != null) {
                return 2;
            }
            if (node instanceof ASTNode && ((ASTNode)node).getOffset() == this.offset && ((ASTNode)node).getLength() == this.length) {
                this.foundNode = node;
                return 2;
            }
            if (node instanceof ASTNode && this.offset > ((ASTNode)node).getOffset() + ((ASTNode)node).getLength()) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof ASTNode && ((ASTNode)((Object)declaration)).getOffset() > this.offset) {
                return 2;
            }
            return this.processNode(declaration);
        }

        public int visit(IASTDeclarator declarator) {
            int ret = this.processNode(declarator);
            IASTPointerOperator[] ops = declarator.getPointerOperators();
            int i = 0;
            while (i < ops.length) {
                this.processNode(ops[i]);
                ++i;
            }
            if (declarator instanceof IASTArrayDeclarator) {
                IASTArrayModifier[] mods = ((IASTArrayDeclarator)declarator).getArrayModifiers();
                int i2 = 0;
                while (i2 < mods.length) {
                    this.processNode(mods[i2]);
                    ++i2;
                }
            }
            return ret;
        }

        public int visit(ICASTDesignator designator) {
            return this.processNode(designator);
        }

        public int visit(IASTDeclSpecifier declSpec) {
            return this.processNode(declSpec);
        }

        public int visit(IASTEnumerator enumerator) {
            return this.processNode((IASTNode)((Object)enumerator));
        }

        public int visit(IASTExpression expression) {
            return this.processNode(expression);
        }

        public int visit(IASTInitializer initializer) {
            return this.processNode(initializer);
        }

        public int visit(IASTName name) {
            if (name.toString() != null) {
                return this.processNode(name);
            }
            return 3;
        }

        public int visit(IASTParameterDeclaration parameterDeclaration) {
            return this.processNode(parameterDeclaration);
        }

        public int visit(IASTStatement statement) {
            return this.processNode(statement);
        }

        public int visit(IASTTypeId typeId) {
            return this.processNode(typeId);
        }

        public IASTNode getNode() {
            return this.foundNode;
        }
    }
}

