/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class DebugTextHover
implements ICEditorTextHover,
ITextHoverExtension,
ISelectionListener,
IPartListener {
    private static final int MAX_HOVER_INFO_SIZE = 100;
    protected ISelection fSelection = null;
    protected IEditorPart fEditor;
    static /* synthetic */ Class class$0;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ICStackFrame frame = this.getFrame();
        if (frame != null && frame.canEvaluate()) {
            String result;
            StringBuffer buffer;
            String expression;
            block14: {
                block13: {
                    block12: {
                        IDocument document;
                        block11: {
                            document = textViewer.getDocument();
                            if (document != null) break block11;
                            return null;
                        }
                        expression = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                        if (expression != null) break block12;
                        return null;
                    }
                    expression = expression.trim();
                    if (expression.length() != 0) break block13;
                    return null;
                }
                buffer = new StringBuffer();
                result = this.evaluateExpression(frame, expression);
                if (result != null) break block14;
                return null;
            }
            try {
                try {
                    if (result != null) {
                        DebugTextHover.appendVariable(buffer, DebugTextHover.makeHTMLSafe(expression), DebugTextHover.makeHTMLSafe(result.trim()));
                    }
                }
                catch (DebugException x) {
                    CDebugUIPlugin.log(x);
                }
                if (buffer.length() > 0) {
                    return buffer.toString();
                }
            }
            catch (BadLocationException x) {
                CDebugUIPlugin.log(x);
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        if (viewer != null) {
            return CDebugUIUtils.findWord(viewer.getDocument(), offset);
        }
        return null;
    }

    private String evaluateExpression(ICStackFrame frame, String expression) {
        String result = null;
        try {
            result = frame.evaluateExpressionToString(expression);
        }
        catch (DebugException debugException) {}
        return result;
    }

    private static void appendVariable(StringBuffer buffer, String expression, String value) throws DebugException {
        if (value.length() > 100) {
            value = String.valueOf(value.substring(0, 100)) + " ...";
        }
        buffer.append("<p>");
        buffer.append("<pre>").append(expression).append("</pre>");
        buffer.append(" = ");
        buffer.append("<b><pre>").append(value).append("</pre></b>");
        buffer.append("</p>");
    }

    public void setEditor(IEditorPart editor) {
        if (editor != null) {
            this.fEditor = editor;
            final IWorkbenchPage page = editor.getSite().getPage();
            page.addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            page.addPartListener((IPartListener)this);
            Runnable r = new Runnable(){

                public void run() {
                    DebugTextHover.this.fSelection = page.getSelection("org.eclipse.debug.ui.DebugView");
                }
            };
            CDebugUIPlugin.getStandardDisplay().asyncExec(r);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.fSelection = selection;
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.fEditor)) {
            IWorkbenchPage page = this.fEditor.getSite().getPage();
            page.removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            page.removePartListener((IPartListener)this);
            this.fSelection = null;
            this.fEditor = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected ICStackFrame getFrame() {
        Object el;
        IStructuredSelection selection;
        if (this.fSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)this.fSelection).size() == 1 && (el = selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)el;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICStackFrame)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return null;
    }

    private static String makeHTMLSafe(String string) {
        StringBuffer buffer = new StringBuffer(string.length());
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

