/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.preferences.PreferenceMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DebuggerTypesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected static String[] fgButtonLabels = new String[]{PreferenceMessages.getString("DebuggerTypesPage.0"), PreferenceMessages.getString("DebuggerTypesPage.1"), PreferenceMessages.getString("DebuggerTypesPage.2")};
    private DebuggerTypesDialogField fListField;
    private IWorkbench fWorkbench;
    private String fDefault;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        comp.setFont(font);
        Label viewerLabel = new Label(comp, 16384);
        viewerLabel.setText(PreferenceMessages.getString("DebuggerTypesPage.4"));
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        viewerLabel.setLayoutData((Object)gd);
        viewerLabel.setFont(font);
        this.fListField = new DebuggerTypesDialogField();
        this.fListField.setCheckAllButtonIndex(0);
        this.fListField.setUncheckAllButtonIndex(1);
        Dialog.applyDialogFont((Control)comp);
        this.fListField.doFillIntoGrid(comp, 3);
        this.initialize();
        this.getWorkbench().getHelpSystem().setHelp((Control)comp, ICDebugHelpContextIds.DEBUGGER_TYPES_PAGE);
        return comp;
    }

    public void init(IWorkbench workbench) {
        this.fWorkbench = workbench;
    }

    private IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    private void initialize() {
        ICDebugConfiguration dc = CDebugCorePlugin.getDefault().getDefaultDebugConfiguration();
        this.setDefault(dc != null ? dc.getID() : null);
        this.fListField.addElements(Arrays.asList(CDebugCorePlugin.getDefault().getDebugConfigurations()));
        this.fListField.setCheckedElements(Arrays.asList(CDebugCorePlugin.getDefault().getActiveDebugConfigurations()));
    }

    public boolean performOk() {
        CDebugCorePlugin.getDefault().saveDefaultDebugConfiguration(this.getDefault());
        List elements = this.fListField.getElements();
        elements.removeAll(this.fListField.getCheckedElements());
        CDebugCorePlugin.getDefault().saveFilteredDebugConfigurations(elements.toArray(new ICDebugConfiguration[elements.size()]));
        return super.performOk();
    }

    protected String getDefault() {
        return this.fDefault;
    }

    protected void setDefault(String defaultConfiguration) {
        this.fDefault = defaultConfiguration;
    }

    protected void performDefaults() {
        this.fListField.setCheckedElements(Arrays.asList(CDebugCorePlugin.getDefault().getDefaultActiveDebugConfigurations()));
        ICDebugConfiguration defaultConfiguration = CDebugCorePlugin.getDefault().getDefaultDefaultDebugConfiguration();
        if (defaultConfiguration != null) {
            this.setDefault(defaultConfiguration.getID());
        } else {
            List list = this.fListField.getCheckedElements();
            if (!list.isEmpty()) {
                this.setDefault(((ICDebugConfiguration)list.get(0)).getID());
            }
        }
        this.fListField.refresh();
        super.performDefaults();
    }

    class DebuggerTypesDialogField
    extends CheckedListDialogField {
        public DebuggerTypesDialogField() {
            super(new IListAdapter(){

                public void customButtonPressed(DialogField field, int index) {
                }

                public void selectionChanged(DialogField field) {
                }
            }, fgButtonLabels, (ILabelProvider)new DebuggerTypeLabelProvider());
        }

        public Control[] doFillIntoGrid(Composite parent, int nColumns) {
            PixelConverter converter = new PixelConverter((Control)parent);
            this.assertEnoughColumns(nColumns);
            Control list = this.getListControl(parent);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
            gd.horizontalSpan = nColumns - 2;
            gd.widthHint = converter.convertWidthInCharsToPixels(50);
            gd.heightHint = converter.convertHeightInCharsToPixels(6);
            list.setLayoutData((Object)gd);
            Composite buttons = this.getButtonBox(parent);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = false;
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
            gd.horizontalSpan = 1;
            buttons.setLayoutData((Object)gd);
            return new Control[]{list, buttons};
        }

        protected boolean getManagedButtonState(ISelection sel, int index) {
            if (index == 2 && sel instanceof IStructuredSelection) {
                Object o = ((IStructuredSelection)sel).getFirstElement();
                return o != null && this.isChecked(o);
            }
            return super.getManagedButtonState(sel, index);
        }

        protected boolean managedButtonPressed(int index) {
            if (index == 2) {
                List list = this.getSelectedElements();
                if (!list.isEmpty()) {
                    DebuggerTypesPage.this.setDefault(((ICDebugConfiguration)list.get(0)).getID());
                } else {
                    DebuggerTypesPage.this.setDefault(null);
                }
                this.refresh();
            }
            return super.managedButtonPressed(index);
        }

        protected int getListStyle() {
            return 2820;
        }

        protected void doCheckStateChanged(CheckStateChangedEvent e) {
            super.doCheckStateChanged(e);
            ICDebugConfiguration dc = (ICDebugConfiguration)e.getElement();
            if (dc.getID().equals(DebuggerTypesPage.this.getDefault()) && !e.getChecked()) {
                List list = this.getCheckedElements();
                DebuggerTypesPage.this.setDefault(list.size() > 0 ? ((ICDebugConfiguration)list.get(0)).getID() : null);
                this.refresh();
            } else if (e.getChecked() && DebuggerTypesPage.this.getDefault() == null) {
                DebuggerTypesPage.this.setDefault(((ICDebugConfiguration)e.getElement()).getID());
                this.refresh();
            }
        }

        public void checkAll(boolean state) {
            super.checkAll(state);
            List list = this.getCheckedElements();
            DebuggerTypesPage.this.setDefault(list.size() > 0 ? ((ICDebugConfiguration)list.get(0)).getID() : null);
            this.refresh();
        }
    }

    class DebuggerTypeLabelProvider
    extends LabelProvider {
        DebuggerTypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ICDebugConfiguration) {
                ICDebugConfiguration dc = (ICDebugConfiguration)element;
                String label = dc.getName();
                if (dc.getID().equals(DebuggerTypesPage.this.getDefault())) {
                    label = String.valueOf(label) + MessageFormat.format(" ({0})", PreferenceMessages.getString("DebuggerTypesPage.3"));
                }
                return label;
            }
            return super.getText(element);
        }
    }
}

