/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;

public class CPPASTOperatorName
extends CPPASTName
implements ICPPASTOperatorName {
    private static final int FIRST_CHAR_AFTER_OPERATOR = 8;
    private static final String LBRACKET = "[";
    private static final String RBRACKET = "]";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private boolean wasSet = false;

    public CPPASTOperatorName() {
    }

    public CPPASTOperatorName(char[] name) {
        super(name);
        this.wasSet = true;
        super.setName(this.enforceOpStandard(super.toString()));
    }

    public char[] toCharArray() {
        if (!this.wasSet) {
            super.setName(this.enforceOpStandard(super.toString()));
            this.wasSet = true;
        }
        return super.toCharArray();
    }

    public String toString() {
        if (!this.wasSet) {
            super.setName(this.enforceOpStandard(super.toString()));
            this.wasSet = true;
        }
        return super.toString();
    }

    public void setName(char[] name) {
        super.setName(this.enforceOpStandard(new String(name)));
        this.wasSet = true;
    }

    private char[] enforceOpStandard(String name) {
        if (name.indexOf("new", 8) >= 8 && name.indexOf(LBRACKET, 8) >= 8 && name.indexOf(RBRACKET, 8) >= 8) {
            return OPERATOR_NEW_ARRAY;
        }
        if (name.indexOf("delete", 8) >= 8 && name.indexOf(LBRACKET, 8) >= 8 && name.indexOf(RBRACKET, 8) >= 8) {
            return OPERATOR_DELETE_ARRAY;
        }
        if (name.indexOf("new", 8) >= 8) {
            return OPERATOR_NEW;
        }
        if (name.indexOf("delete", 8) >= 8) {
            return OPERATOR_DELETE;
        }
        if (name.indexOf("+=", 8) >= 8) {
            return OPERATOR_PLUS_ASSIGN;
        }
        if (name.indexOf("-=", 8) >= 8) {
            return OPERATOR_MINUS_ASSIGN;
        }
        if (name.indexOf("*=", 8) >= 8) {
            return OPERATOR_STAR_ASSIGN;
        }
        if (name.indexOf("/=", 8) >= 8) {
            return OPERATOR_DIV_ASSIGN;
        }
        if (name.indexOf("%=", 8) >= 8) {
            return OPERATOR_MOD_ASSIGN;
        }
        if (name.indexOf("^=", 8) >= 8) {
            return OPERATOR_XOR_ASSIGN;
        }
        if (name.indexOf("&=", 8) >= 8) {
            return OPERATOR_AMPER_ASSIGN;
        }
        if (name.indexOf("|=", 8) >= 8) {
            return OPERATOR_BITOR_ASSIGN;
        }
        if (name.indexOf(">>=", 8) >= 8) {
            return OPERATOR_SHIFTR_ASSIGN;
        }
        if (name.indexOf("<<=", 8) >= 8) {
            return OPERATOR_SHIFTL_ASSIGN;
        }
        if (name.indexOf("<<", 8) >= 8) {
            return OPERATOR_SHIFTL;
        }
        if (name.indexOf(">>", 8) >= 8) {
            return OPERATOR_SHIFTR;
        }
        if (name.indexOf("==", 8) >= 8) {
            return OPERATOR_EQUAL;
        }
        if (name.indexOf("!=", 8) >= 8) {
            return OPERATOR_NOTEQUAL;
        }
        if (name.indexOf("<=", 8) >= 8) {
            return OPERATOR_LTEQUAL;
        }
        if (name.indexOf(">=", 8) >= 8) {
            return OPERATOR_GTEQUAL;
        }
        if (name.indexOf("=", 8) >= 8) {
            return OPERATOR_ASSIGN;
        }
        if (name.indexOf("&&", 8) >= 8) {
            return OPERATOR_AND;
        }
        if (name.indexOf("||", 8) >= 8) {
            return OPERATOR_OR;
        }
        if (name.indexOf("++", 8) >= 8) {
            return OPERATOR_INCR;
        }
        if (name.indexOf("--", 8) >= 8) {
            return OPERATOR_DECR;
        }
        if (name.indexOf(",", 8) >= 8) {
            return OPERATOR_COMMA;
        }
        if (name.indexOf("->*", 8) >= 8) {
            return OPERATOR_ARROWSTAR;
        }
        if (name.indexOf("->", 8) >= 8) {
            return OPERATOR_ARROW;
        }
        if (name.indexOf(LPAREN, 8) >= 8 && name.indexOf(RPAREN, 8) >= 8) {
            return OPERATOR_PAREN;
        }
        if (name.indexOf(LBRACKET, 8) >= 8 && name.indexOf(RBRACKET, 8) >= 8) {
            return OPERATOR_BRACKET;
        }
        if (name.indexOf("+", 8) >= 8) {
            return OPERATOR_PLUS;
        }
        if (name.indexOf("-", 8) >= 8) {
            return OPERATOR_MINUS;
        }
        if (name.indexOf("*", 8) >= 8) {
            return OPERATOR_STAR;
        }
        if (name.indexOf("/", 8) >= 8) {
            return OPERATOR_DIV;
        }
        if (name.indexOf("%", 8) >= 8) {
            return OPERATOR_MOD;
        }
        if (name.indexOf("^", 8) >= 8) {
            return OPERATOR_XOR;
        }
        if (name.indexOf("&", 8) >= 8) {
            return OPERATOR_AMPER;
        }
        if (name.indexOf("|", 8) >= 8) {
            return OPERATOR_BITOR;
        }
        if (name.indexOf("~", 8) >= 8) {
            return OPERATOR_COMPL;
        }
        if (name.indexOf("!", 8) >= 8) {
            return OPERATOR_NOT;
        }
        if (name.indexOf("<", 8) >= 8) {
            return OPERATOR_LT;
        }
        if (name.indexOf(">", 8) >= 8) {
            return OPERATOR_GT;
        }
        return name.toCharArray();
    }
}

