/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleDocument;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStream;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;

public class BuildConsolePartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IConsole,
IPropertyChangeListener {
    List fPartitions = new ArrayList(5);
    private int fMaxLines;
    BuildConsoleStream fLastStream = null;
    BuildConsoleDocument fDocument;
    boolean killed;
    BuildConsoleManager fManager;
    Vector fQueue = new Vector(5);

    public BuildConsolePartitioner(BuildConsoleManager manager) {
        this.fManager = manager;
        this.fMaxLines = BuildConsolePreferencePage.buildConsoleLines();
        this.fDocument = new BuildConsoleDocument();
        this.fDocument.setDocumentPartitioner(this);
        this.connect((IDocument)this.fDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToDocument(String text, BuildConsoleStream stream) {
        boolean addToQueue = true;
        Vector vector = this.fQueue;
        synchronized (vector) {
            StreamEntry entry;
            int i = this.fQueue.size();
            if (i > 0 && (entry = (StreamEntry)this.fQueue.get(i - 1)).getStream() == stream && entry.size() < 10000) {
                entry.appendText(text);
                addToQueue = false;
            }
            if (addToQueue) {
                this.fQueue.add(new StreamEntry(text, stream));
            }
        }
        Runnable r = new Runnable(){

            public void run() {
                StreamEntry entry;
                try {
                    entry = (StreamEntry)BuildConsolePartitioner.this.fQueue.remove(0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return;
                }
                BuildConsolePartitioner.this.fLastStream = entry.getStream();
                try {
                    BuildConsolePartitioner.this.warnOfContentChange(BuildConsolePartitioner.this.fLastStream);
                    if (BuildConsolePartitioner.this.fLastStream == null) {
                        BuildConsolePartitioner.this.fDocument.set(entry.getText());
                    } else {
                        BuildConsolePartitioner.this.fDocument.replace(BuildConsolePartitioner.this.fDocument.getLength(), 0, entry.getText());
                        BuildConsolePartitioner.this.checkOverflow();
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        };
        Display display = CUIPlugin.getStandardDisplay();
        if (addToQueue && display != null) {
            display.asyncExec(r);
        }
    }

    void warnOfContentChange(BuildConsoleStream stream) {
        if (stream != null) {
            ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange((org.eclipse.ui.console.IConsole)stream.getConsole());
        }
        this.fManager.showConsole();
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocumentSize(int nLines) {
        this.fMaxLines = nLines;
        nLines = this.fDocument.getNumberOfLines();
        this.checkOverflow();
    }

    public void connect(IDocument document) {
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void disconnect() {
        this.fDocument.setDocumentPartitioner(null);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.killed = true;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{BuildConsolePartition.CONSOLE_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        ITypedRegion partition = this.getPartition(offset);
        if (partition != null) {
            return partition.getType();
        }
        return null;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        if (offset == 0 && length == this.fDocument.getLength()) {
            return this.fPartitions.toArray(new ITypedRegion[this.fPartitions.size()]);
        }
        int end = offset + length;
        ArrayList<ITypedRegion> list = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int partitionStart = partition.getOffset();
            int partitionEnd = partitionStart + partition.getLength();
            if (offset >= partitionStart && offset <= partitionEnd || offset < partitionStart && end >= partitionStart) {
                list.add(partition);
            }
            ++i;
        }
        return list.toArray(new ITypedRegion[list.size()]);
    }

    public ITypedRegion getPartition(int offset) {
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int start = partition.getOffset();
            int end = start + partition.getLength();
            if (offset >= start && offset < end) {
                return partition;
            }
            ++i;
        }
        return null;
    }

    public IRegion documentChanged2(DocumentEvent event) {
        String text = event.getText();
        if (this.getDocument().getLength() == 0) {
            this.fPartitions.clear();
            return new Region(0, 0);
        }
        this.addPartition(new BuildConsolePartition(this.fLastStream, event.getOffset(), text.length()));
        ITypedRegion[] affectedRegions = this.computePartitioning(event.getOffset(), text.length());
        if (affectedRegions.length == 0) {
            return null;
        }
        if (affectedRegions.length == 1) {
            return affectedRegions[0];
        }
        int affectedLength = affectedRegions[0].getLength();
        int i = 1;
        while (i < affectedRegions.length) {
            ITypedRegion region = affectedRegions[i];
            affectedLength += region.getLength();
            ++i;
        }
        return new Region(affectedRegions[0].getOffset(), affectedLength);
    }

    protected void checkOverflow() {
        int nLines;
        if (this.fMaxLines >= 0 && (nLines = this.fDocument.getNumberOfLines()) > this.fMaxLines + 1) {
            int overflow = 0;
            try {
                overflow = this.fDocument.getLineOffset(nLines - this.fMaxLines);
            }
            catch (BadLocationException badLocationException) {}
            ArrayList<BuildConsolePartition> newParitions = new ArrayList<BuildConsolePartition>(this.fPartitions.size());
            Iterator partitions = this.fPartitions.iterator();
            while (partitions.hasNext()) {
                ITypedRegion region = (ITypedRegion)partitions.next();
                if (!(region instanceof BuildConsolePartition)) continue;
                BuildConsolePartition messageConsolePartition = (BuildConsolePartition)region;
                BuildConsolePartition newPartition = null;
                int offset = region.getOffset();
                if (offset < overflow) {
                    int endOffset = offset + region.getLength();
                    if (endOffset >= overflow) {
                        int length = endOffset - overflow;
                        newPartition = messageConsolePartition.createNewPartition(0, length);
                    }
                } else {
                    newPartition = messageConsolePartition.createNewPartition(messageConsolePartition.getOffset() - overflow, messageConsolePartition.getLength());
                }
                if (newPartition == null) continue;
                newParitions.add(newPartition);
            }
            this.fPartitions = newParitions;
            try {
                this.fDocument.replace(0, overflow, "");
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private BuildConsolePartition addPartition(BuildConsolePartition partition) {
        if (this.fPartitions.isEmpty()) {
            this.fPartitions.add(partition);
        } else {
            int index = this.fPartitions.size() - 1;
            BuildConsolePartition last = (BuildConsolePartition)((Object)this.fPartitions.get(index));
            if (last.canBeCombinedWith(partition)) {
                partition = last.combineWith(partition);
                this.fPartitions.set(index, partition);
            } else {
                this.fPartitions.add(partition);
            }
        }
        return partition;
    }

    public IConsole getConsole() {
        return this;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "buildConsoleLines") {
            this.setDocumentSize(BuildConsolePreferencePage.buildConsoleLines());
        }
    }

    public void start(final IProject project) {
        Display display = CUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    BuildConsolePartitioner.this.fManager.startConsoleActivity(project);
                }
            });
        }
        if (BuildConsolePreferencePage.isClearBuildConsole()) {
            this.appendToDocument("", null);
        }
    }

    public ConsoleOutputStream getOutputStream() throws CoreException {
        return new BuildOutputStream(this.fManager.getStream(1));
    }

    public ConsoleOutputStream getInfoStream() throws CoreException {
        return new BuildOutputStream(this.fManager.getStream(0));
    }

    public ConsoleOutputStream getErrorStream() throws CoreException {
        return new BuildOutputStream(this.fManager.getStream(2));
    }

    class StreamEntry {
        private BuildConsoleStream fStream;
        private StringBuffer fText = null;

        StreamEntry(String text, BuildConsoleStream stream) {
            this.fText = new StringBuffer(text);
            this.fStream = stream;
        }

        public BuildConsoleStream getStream() {
            return this.fStream;
        }

        public void appendText(String text) {
            this.fText.append(text);
        }

        public int size() {
            return this.fText.length();
        }

        public String getText() {
            return this.fText.toString();
        }
    }

    public class BuildOutputStream
    extends ConsoleOutputStream {
        final BuildConsoleStream fStream;

        public BuildOutputStream(BuildConsoleStream stream) {
            this.fStream = stream;
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
            this.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            BuildConsolePartitioner.this.appendToDocument(new String(b, off, len), this.fStream);
        }
    }
}

