/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardPrefs;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewSourceFileGenerator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class NewClassCodeGenerator {
    private IPath fHeaderPath = null;
    private IPath fSourcePath = null;
    private String fClassName = null;
    private IQualifiedTypeName fNamespace = null;
    private String fLineDelimiter;
    private IBaseClassInfo[] fBaseClasses = null;
    private IMethodStub[] fMethodStubs = null;
    private ITranslationUnit fCreatedHeaderTU = null;
    private ITranslationUnit fCreatedSourceTU = null;
    private ICElement fCreatedClass = null;

    public NewClassCodeGenerator(IPath headerPath, IPath sourcePath, String className, String namespace, IBaseClassInfo[] baseClasses, IMethodStub[] methodStubs) {
        this.fHeaderPath = headerPath;
        this.fSourcePath = sourcePath;
        if (className != null && className.length() > 0) {
            this.fClassName = className;
        }
        if (namespace != null && namespace.length() > 0) {
            this.fNamespace = new QualifiedTypeName(namespace);
        }
        this.fBaseClasses = baseClasses;
        this.fMethodStubs = methodStubs;
        this.fLineDelimiter = NewSourceFileGenerator.getLineDelimiter();
    }

    public ICElement getCreatedClass() {
        return this.fCreatedClass;
    }

    public ITranslationUnit getCreatedHeaderTU() {
        return this.fCreatedHeaderTU;
    }

    public IFile getCreatedHeaderFile() {
        if (this.fCreatedHeaderTU != null) {
            return (IFile)this.fCreatedHeaderTU.getResource();
        }
        return null;
    }

    public ITranslationUnit getCreatedSourceTU() {
        return this.fCreatedSourceTU;
    }

    public IFile getCreatedSourceFile() {
        if (this.fCreatedSourceTU != null) {
            return (IFile)this.fCreatedSourceTU.getResource();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICElement createClass(IProgressMonitor monitor) throws CodeGeneratorException, CoreException, InterruptedException {
        IWorkingCopy sourceWorkingCopy;
        block15: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(NewClassWizardMessages.getString("NewClassCodeGeneration.createType.mainTask"), 400);
            ITranslationUnit headerTU = null;
            ITranslationUnit sourceTU = null;
            ICElement createdClass = null;
            IWorkingCopy headerWorkingCopy = null;
            sourceWorkingCopy = null;
            try {
                List privateMethods;
                List protectedMethods;
                List publicMethods;
                if (this.fHeaderPath != null) {
                    publicMethods = this.getStubs(ASTAccessVisibility.PUBLIC, false);
                    protectedMethods = this.getStubs(ASTAccessVisibility.PROTECTED, false);
                    privateMethods = this.getStubs(ASTAccessVisibility.PRIVATE, false);
                    IFile headerFile = NewSourceFileGenerator.createHeaderFile(this.fHeaderPath, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (headerFile != null) {
                        headerTU = (ITranslationUnit)CoreModel.getDefault().create(headerFile);
                    }
                    headerWorkingCopy = headerTU.getWorkingCopy();
                    String headerContent = this.constructHeaderFileContent(headerTU, publicMethods, protectedMethods, privateMethods, headerWorkingCopy.getBuffer().getContents(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    headerWorkingCopy.getBuffer().setContents(headerContent);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    headerWorkingCopy.reconcile();
                    headerWorkingCopy.commit(true, monitor);
                    monitor.worked(50);
                    this.fCreatedClass = createdClass = headerWorkingCopy.getElement(this.fClassName.toString());
                    this.fCreatedHeaderTU = headerTU;
                }
                if (this.fSourcePath != null) {
                    publicMethods = this.getStubs(ASTAccessVisibility.PUBLIC, true);
                    protectedMethods = this.getStubs(ASTAccessVisibility.PROTECTED, true);
                    privateMethods = this.getStubs(ASTAccessVisibility.PRIVATE, true);
                    if (publicMethods.isEmpty() && protectedMethods.isEmpty() && privateMethods.isEmpty()) {
                        monitor.worked(100);
                    } else {
                        IFile sourceFile = NewSourceFileGenerator.createSourceFile(this.fSourcePath, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        if (sourceFile != null) {
                            sourceTU = (ITranslationUnit)CoreModel.getDefault().create(sourceFile);
                        }
                        monitor.worked(50);
                        sourceWorkingCopy = sourceTU.getWorkingCopy();
                        String sourceContent = this.constructSourceFileContent(sourceTU, headerTU, publicMethods, protectedMethods, privateMethods, sourceWorkingCopy.getBuffer().getContents(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        sourceWorkingCopy.getBuffer().setContents(sourceContent);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        sourceWorkingCopy.reconcile();
                        sourceWorkingCopy.commit(true, monitor);
                        monitor.worked(50);
                        this.fCreatedSourceTU = sourceTU;
                    }
                }
                Object var12_14 = null;
                if (headerWorkingCopy == null) break block15;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (headerWorkingCopy != null) {
                    headerWorkingCopy.destroy();
                }
                if (sourceWorkingCopy != null) {
                    sourceWorkingCopy.destroy();
                }
                monitor.done();
                throw throwable;
            }
            headerWorkingCopy.destroy();
        }
        if (sourceWorkingCopy != null) {
            sourceWorkingCopy.destroy();
        }
        monitor.done();
        return this.fCreatedClass;
    }

    public String constructHeaderFileContent(ITranslationUnit headerTU, List publicMethods, List protectedMethods, List privateMethods, String oldContents, IProgressMonitor monitor) throws CodeGeneratorException {
        monitor.beginTask(NewClassWizardMessages.getString("NewClassCodeGeneration.createType.task.header"), 100);
        if (oldContents != null && oldContents.length() == 0) {
            oldContents = null;
        }
        StringBuffer text = new StringBuffer();
        int appendFirstCharPos = -1;
        if (oldContents != null) {
            int insertionPos = this.getClassDefInsertionPos(oldContents);
            if (insertionPos == -1) {
                text.append(oldContents);
            } else {
                int prependLastCharPos = insertionPos - 1;
                while (prependLastCharPos >= 0 && Character.isWhitespace(oldContents.charAt(prependLastCharPos))) {
                    --prependLastCharPos;
                }
                if (prependLastCharPos >= 0) {
                    text.append(oldContents.substring(0, prependLastCharPos + 1));
                }
                appendFirstCharPos = prependLastCharPos + 1;
            }
            text.append(this.fLineDelimiter);
            text.append(this.fLineDelimiter);
        }
        if (this.fBaseClasses != null && this.fBaseClasses.length > 0) {
            this.addBaseClassIncludes(headerTU, text, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            text.append(this.fLineDelimiter);
        }
        if (this.fNamespace != null) {
            this.beginNamespace(text);
        }
        text.append("class ");
        text.append(this.fClassName);
        this.addBaseClassInheritance(text);
        text.append(this.fLineDelimiter);
        text.append('{');
        text.append(this.fLineDelimiter);
        if (!(publicMethods.isEmpty() && protectedMethods.isEmpty() && privateMethods.isEmpty())) {
            this.addMethodDeclarations(publicMethods, protectedMethods, privateMethods, text);
        }
        text.append("};");
        text.append(this.fLineDelimiter);
        if (this.fNamespace != null) {
            this.endNamespace(text);
        }
        if (oldContents != null && appendFirstCharPos != -1) {
            text.append(this.fLineDelimiter);
            int len = oldContents.length();
            while (appendFirstCharPos < len && Character.isWhitespace(oldContents.charAt(appendFirstCharPos))) {
                ++appendFirstCharPos;
            }
            if (appendFirstCharPos < len) {
                text.append(oldContents.substring(appendFirstCharPos));
            }
        }
        String newContents = text.toString();
        monitor.done();
        return newContents;
    }

    private int getClassDefInsertionPos(String contents) {
        if (contents.length() == 0) {
            return -1;
        }
        int insertPos = contents.lastIndexOf("#endif");
        if (insertPos != -1 && (contents.indexOf(125, insertPos) != -1 || contents.indexOf(59, insertPos) != -1)) {
            return -1;
        }
        return insertPos;
    }

    private void beginNamespace(StringBuffer text) {
        int i = 0;
        while (i < this.fNamespace.segmentCount()) {
            text.append("namespace ");
            text.append(this.fNamespace.segment(i));
            text.append(this.fLineDelimiter);
            text.append('{');
            text.append(this.fLineDelimiter);
            text.append(this.fLineDelimiter);
            ++i;
        }
    }

    private void endNamespace(StringBuffer text) {
        int i = 0;
        while (i < this.fNamespace.segmentCount()) {
            text.append(this.fLineDelimiter);
            text.append("}");
            text.append(this.fLineDelimiter);
            ++i;
        }
    }

    private void addMethodDeclarations(List publicMethods, List protectedMethods, List privateMethods, StringBuffer text) {
        String code;
        IMethodStub stub;
        Iterator i;
        if (!publicMethods.isEmpty()) {
            text.append("public:");
            text.append(this.fLineDelimiter);
            i = publicMethods.iterator();
            while (i.hasNext()) {
                stub = (IMethodStub)i.next();
                code = stub.createMethodDeclaration(this.fClassName, this.fBaseClasses, this.fLineDelimiter);
                text.append('\t');
                text.append(code);
                text.append(this.fLineDelimiter);
            }
        }
        if (!protectedMethods.isEmpty()) {
            text.append("protected:");
            text.append(this.fLineDelimiter);
            i = protectedMethods.iterator();
            while (i.hasNext()) {
                stub = (IMethodStub)i.next();
                code = stub.createMethodDeclaration(this.fClassName, this.fBaseClasses, this.fLineDelimiter);
                text.append('\t');
                text.append(code);
                text.append(this.fLineDelimiter);
            }
        }
        if (!privateMethods.isEmpty()) {
            text.append("private:");
            text.append(this.fLineDelimiter);
            i = privateMethods.iterator();
            while (i.hasNext()) {
                stub = (IMethodStub)i.next();
                code = stub.createMethodDeclaration(this.fClassName, this.fBaseClasses, this.fLineDelimiter);
                text.append('\t');
                text.append(code);
                text.append(this.fLineDelimiter);
            }
        }
    }

    private List getStubs(ASTAccessVisibility access, boolean skipInline) {
        ArrayList<IMethodStub> list = new ArrayList<IMethodStub>();
        if (this.fMethodStubs != null) {
            int i = 0;
            while (i < this.fMethodStubs.length) {
                IMethodStub stub = this.fMethodStubs[i];
                if (!(stub.getAccess() != access || skipInline && stub.isInline())) {
                    list.add(stub);
                }
                ++i;
            }
        }
        return list;
    }

    private void addBaseClassInheritance(StringBuffer text) {
        if (this.fBaseClasses != null && this.fBaseClasses.length > 0) {
            text.append(" : ");
            int i = 0;
            while (i < this.fBaseClasses.length) {
                IBaseClassInfo baseClass = this.fBaseClasses[i];
                String baseClassName = baseClass.getType().getQualifiedTypeName().getFullyQualifiedName();
                if (i > 0) {
                    text.append(", ");
                }
                if (baseClass.getAccess() == ASTAccessVisibility.PRIVATE) {
                    text.append("private");
                } else if (baseClass.getAccess() == ASTAccessVisibility.PROTECTED) {
                    text.append("private");
                } else {
                    text.append("public");
                }
                text.append(' ');
                if (baseClass.isVirtual()) {
                    text.append("virtual ");
                }
                text.append(baseClassName);
                ++i;
            }
        }
    }

    private void addBaseClassIncludes(ITranslationUnit headerTU, StringBuffer text, IProgressMonitor monitor) throws CodeGeneratorException {
        IPath includePath;
        List newIncludePaths;
        monitor.beginTask(NewClassWizardMessages.getString("NewClassCodeGeneration.createType.task.header.includePaths"), 100);
        ICProject cProject = headerTU.getCProject();
        IProject project = cProject.getProject();
        IPath projectLocation = project.getLocation();
        IPath headerLocation = headerTU.getResource().getLocation();
        List includePaths = this.getIncludePaths(headerTU);
        List baseClassPaths = this.getBaseClassPaths(this.verifyBaseClasses());
        if (this.createIncludePaths() && !(newIncludePaths = this.getMissingIncludePaths(projectLocation, includePaths, baseClassPaths)).isEmpty()) {
            this.addIncludePaths(cProject, newIncludePaths, monitor);
        }
        ArrayList<IPath> systemIncludes = new ArrayList<IPath>();
        ArrayList<IPath> localIncludes = new ArrayList<IPath>();
        Iterator bcIter = baseClassPaths.iterator();
        while (bcIter.hasNext()) {
            IPath baseClassLocation = (IPath)bcIter.next();
            boolean isSystemIncludePath = false;
            IPath includePath2 = PathUtil.makeRelativePathToProjectIncludes((IPath)baseClassLocation, (IProject)project);
            if (includePath2 != null && !projectLocation.isPrefixOf(baseClassLocation)) {
                isSystemIncludePath = true;
            } else if (projectLocation.isPrefixOf(baseClassLocation) && projectLocation.isPrefixOf(headerLocation)) {
                includePath2 = PathUtil.makeRelativePath((IPath)baseClassLocation, (IPath)headerLocation.removeLastSegments(1));
            }
            if (includePath2 == null) {
                includePath2 = baseClassLocation;
            }
            includePath2 = includePath2.removeFirstSegments(includePath2.segmentCount() - 1);
            if (isSystemIncludePath) {
                systemIncludes.add(includePath2);
                continue;
            }
            localIncludes.add(includePath2);
        }
        Iterator i = systemIncludes.iterator();
        while (i.hasNext()) {
            includePath = (IPath)i.next();
            if (headerTU.getElementName().equals(includePath.toString())) continue;
            String include = this.getIncludeString(includePath.toString(), true);
            text.append(include);
            text.append(this.fLineDelimiter);
        }
        i = localIncludes.iterator();
        while (i.hasNext()) {
            includePath = (IPath)i.next();
            if (headerTU.getElementName().equals(includePath.toString())) continue;
            String include = this.getIncludeString(includePath.toString(), false);
            text.append(include);
            text.append(this.fLineDelimiter);
        }
        monitor.done();
    }

    private boolean verifyBaseClasses() {
        return NewClassWizardPrefs.verifyBaseClasses();
    }

    private boolean createIncludePaths() {
        return NewClassWizardPrefs.createIncludePaths();
    }

    private void addIncludePaths(ICProject cProject, List newIncludePaths, IProgressMonitor monitor) throws CodeGeneratorException {
        monitor.beginTask(NewClassWizardMessages.getString("NewClassCodeGeneration.createType.task.header.addIncludePaths"), 100);
        IPath addToResourcePath = cProject.getPath();
        try {
            int i;
            ArrayList<Object> pathEntryList = new ArrayList<Object>();
            ArrayList<IPathEntry> checkEntryList = new ArrayList<IPathEntry>();
            IPathEntry[] checkEntries = cProject.getResolvedPathEntries();
            IPathEntry[] pathEntries = cProject.getRawPathEntries();
            if (pathEntries != null) {
                i = 0;
                while (i < pathEntries.length) {
                    pathEntryList.add(pathEntries[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < checkEntries.length) {
                if (checkEntries[i] instanceof IIncludeEntry) {
                    checkEntryList.add(checkEntries[i]);
                }
                ++i;
            }
            Iterator ipIter = newIncludePaths.iterator();
            while (ipIter.hasNext()) {
                ICProject includeProject;
                IIncludeEntry entry;
                IPath folderToAdd = (IPath)ipIter.next();
                if (cProject.getPath().segment(0).equals(folderToAdd.segment(0)) || checkEntryList.contains(entry = CoreModel.newIncludeEntry((IPath)addToResourcePath, null, (IPath)(includeProject = PathUtil.getEnclosingProject((IPath)folderToAdd)).getProject().getLocation(), (boolean)true))) continue;
                pathEntryList.add(entry);
            }
            pathEntries = pathEntryList.toArray(new IPathEntry[pathEntryList.size()]);
            cProject.setRawPathEntries(pathEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
        }
        catch (CModelException e) {
            throw new CodeGeneratorException(e);
        }
        monitor.done();
    }

    private List getMissingIncludePaths(IPath projectLocation, List includePaths, List baseClassPaths) {
        ArrayList<IPath> newIncludePaths = new ArrayList<IPath>();
        Iterator bcIter = baseClassPaths.iterator();
        while (bcIter.hasNext()) {
            IPath baseClassLocation = (IPath)bcIter.next();
            if (projectLocation.isPrefixOf(baseClassLocation)) continue;
            IPath folderToAdd = baseClassLocation.removeLastSegments(1);
            IPath canonPath = PathUtil.getCanonicalPath((IPath)folderToAdd);
            if (canonPath != null) {
                folderToAdd = canonPath;
            }
            Iterator newIter = newIncludePaths.iterator();
            while (newIter.hasNext()) {
                IPath newFolder = (IPath)newIter.next();
                if (!newFolder.isPrefixOf(folderToAdd)) continue;
                folderToAdd = null;
                break;
            }
            if (folderToAdd == null) continue;
            boolean foundPath = false;
            Iterator ipIter = includePaths.iterator();
            while (ipIter.hasNext()) {
                IPath includePath = (IPath)ipIter.next();
                if (!includePath.isPrefixOf(folderToAdd) && !includePath.equals((Object)folderToAdd)) continue;
                foundPath = true;
                break;
            }
            if (foundPath) continue;
            Iterator newIter2 = newIncludePaths.iterator();
            while (newIter2.hasNext()) {
                IPath newFolder = (IPath)newIter2.next();
                if (!folderToAdd.isPrefixOf(newFolder)) continue;
                newIter2.remove();
            }
            if (newIncludePaths.contains(folderToAdd)) continue;
            newIncludePaths.add(folderToAdd);
        }
        return newIncludePaths;
    }

    private List getIncludePaths(ITranslationUnit headerTU) throws CodeGeneratorException {
        String[] includePaths;
        IScannerInfo info;
        IProject project = headerTU.getCProject().getProject();
        ICContainer sourceFolder = CModelUtil.getSourceFolder((ICElement)headerTU);
        if (sourceFolder == null) {
            throw new CodeGeneratorException("Could not find source folder");
        }
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null && (info = provider.getScannerInformation(sourceFolder.getResource())) != null && (includePaths = info.getIncludePaths()) != null) {
            ArrayList<Path> list = new ArrayList<Path>();
            int i = 0;
            while (i < includePaths.length) {
                Path path = new Path(includePaths[i]);
                if (!list.contains(path)) {
                    list.add(path);
                }
                ++i;
            }
            return list;
        }
        return null;
    }

    private List getBaseClassPaths(boolean verifyLocation) throws CodeGeneratorException {
        ArrayList<IPath> list = new ArrayList<IPath>();
        int i = 0;
        while (i < this.fBaseClasses.length) {
            IBaseClassInfo baseClass = this.fBaseClasses[i];
            ITypeReference ref = baseClass.getType().getResolvedReference();
            IPath baseClassLocation = null;
            if (ref != null) {
                baseClassLocation = ref.getLocation();
            }
            if (baseClassLocation == null) {
                if (verifyLocation) {
                    throw new CodeGeneratorException("Could not find base class " + baseClass.toString());
                }
            } else if (!list.contains(baseClassLocation)) {
                list.add(baseClassLocation);
            }
            ++i;
        }
        return list;
    }

    public String constructSourceFileContent(ITranslationUnit sourceTU, ITranslationUnit headerTU, List publicMethods, List protectedMethods, List privateMethods, String oldContents, IProgressMonitor monitor) {
        monitor.beginTask(NewClassWizardMessages.getString("NewClassCodeGeneration.createType.task.source"), 150);
        if (oldContents != null && oldContents.length() == 0) {
            oldContents = null;
        }
        StringBuffer text = new StringBuffer();
        String includeString = null;
        if (headerTU != null && (includeString = this.getHeaderIncludeString(sourceTU, headerTU, text, (IProgressMonitor)new SubProgressMonitor(monitor, 50))) != null && oldContents != null && this.hasInclude(oldContents, includeString)) {
            includeString = null;
        }
        if (includeString != null) {
            if (oldContents != null) {
                int insertionPos = this.getIncludeInsertionPos(oldContents);
                if (insertionPos == -1) {
                    text.append(oldContents);
                    text.append(this.fLineDelimiter);
                    text.append(includeString);
                    text.append(this.fLineDelimiter);
                } else {
                    text.append(oldContents.substring(0, insertionPos));
                    text.append(includeString);
                    text.append(this.fLineDelimiter);
                    text.append(oldContents.substring(insertionPos));
                }
            } else {
                text.append(includeString);
                text.append(this.fLineDelimiter);
            }
            text.append(this.fLineDelimiter);
        } else if (oldContents != null) {
            text.append(oldContents);
            text.append(this.fLineDelimiter);
        }
        if (!(publicMethods.isEmpty() && protectedMethods.isEmpty() && privateMethods.isEmpty())) {
            if (this.fNamespace != null) {
                this.beginNamespace(text);
            }
            this.addMethodBodies(publicMethods, protectedMethods, privateMethods, text, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (this.fNamespace != null) {
                this.endNamespace(text);
            }
        }
        String newContents = text.toString();
        monitor.done();
        return newContents;
    }

    private String getHeaderIncludeString(ITranslationUnit sourceTU, ITranslationUnit headerTU, StringBuffer text, IProgressMonitor monitor) {
        IProject project = headerTU.getCProject().getProject();
        IPath projectLocation = project.getLocation();
        IPath headerLocation = headerTU.getResource().getLocation();
        IPath sourceLocation = sourceTU.getResource().getLocation();
        IPath includePath = PathUtil.makeRelativePathToProjectIncludes((IPath)headerLocation, (IProject)project);
        boolean isSystemIncludePath = false;
        if (includePath != null && !projectLocation.isPrefixOf(headerLocation)) {
            isSystemIncludePath = true;
        } else if (projectLocation.isPrefixOf(headerLocation) && projectLocation.isPrefixOf(sourceLocation)) {
            includePath = PathUtil.makeRelativePath((IPath)headerLocation, (IPath)sourceLocation.removeLastSegments(1));
        }
        if (includePath == null) {
            includePath = headerLocation;
        }
        return this.getIncludeString(includePath.toString(), isSystemIncludePath);
    }

    private boolean hasInclude(String contents, String include) {
        int maxStartPos = contents.length() - include.length() - 1;
        if (maxStartPos < 0) {
            return false;
        }
        int startPos = 0;
        while (startPos <= maxStartPos) {
            int includePos = contents.indexOf(include, startPos);
            if (includePos == -1) {
                return false;
            }
            if (includePos == startPos) {
                return true;
            }
            int linePos = this.findFirstLineChar(contents, includePos);
            if (linePos == -1 || linePos == includePos) {
                return true;
            }
            boolean badLine = false;
            int pos = linePos;
            while (pos < includePos) {
                char c = contents.charAt(pos);
                if (!Character.isWhitespace(c)) {
                    badLine = true;
                    break;
                }
                ++pos;
            }
            if (!badLine) {
                return true;
            }
            startPos = includePos + include.length();
        }
        return false;
    }

    private int getIncludeInsertionPos(String contents) {
        int insertPos;
        int startPos;
        int eolPos;
        if (contents.length() == 0) {
            return -1;
        }
        int includePos = contents.lastIndexOf("#include ");
        if (includePos != -1 && (eolPos = this.findLastLineChar(contents, startPos = includePos + "#include ".length())) != -1 && (insertPos = eolPos + 1) < contents.length() - 1) {
            return insertPos;
        }
        return -1;
    }

    private void addMethodBodies(List publicMethods, List protectedMethods, List privateMethods, StringBuffer text, IProgressMonitor monitor) {
        String code;
        IMethodStub stub;
        Iterator i;
        if (!publicMethods.isEmpty()) {
            i = publicMethods.iterator();
            while (i.hasNext()) {
                stub = (IMethodStub)i.next();
                code = stub.createMethodImplementation(this.fClassName, this.fBaseClasses, this.fLineDelimiter);
                text.append(code);
                text.append(this.fLineDelimiter);
                if (!i.hasNext()) continue;
                text.append(this.fLineDelimiter);
            }
        }
        if (!protectedMethods.isEmpty()) {
            i = protectedMethods.iterator();
            while (i.hasNext()) {
                stub = (IMethodStub)i.next();
                code = stub.createMethodImplementation(this.fClassName, this.fBaseClasses, this.fLineDelimiter);
                text.append(code);
                text.append(this.fLineDelimiter);
                if (!i.hasNext()) continue;
                text.append(this.fLineDelimiter);
            }
        }
        if (!privateMethods.isEmpty()) {
            i = privateMethods.iterator();
            while (i.hasNext()) {
                stub = (IMethodStub)i.next();
                code = stub.createMethodImplementation(this.fClassName, this.fBaseClasses, this.fLineDelimiter);
                text.append(code);
                text.append(this.fLineDelimiter);
                if (!i.hasNext()) continue;
                text.append(this.fLineDelimiter);
            }
        }
    }

    private String getIncludeString(String fileName, boolean isSystemInclude) {
        StringBuffer buf = new StringBuffer();
        buf.append("#include ");
        if (isSystemInclude) {
            buf.append('<');
        } else {
            buf.append('\"');
        }
        buf.append(fileName);
        if (isSystemInclude) {
            buf.append('>');
        } else {
            buf.append('\"');
        }
        return buf.toString();
    }

    private int findLastLineChar(String contents, int startPos) {
        int endPos = contents.length() - 1;
        int linePos = startPos;
        while (linePos <= endPos) {
            char c = contents.charAt(linePos);
            if (c == '\r') {
                if (linePos < endPos && contents.charAt(linePos + 1) == '\n') {
                    return linePos + 1;
                }
                return linePos;
            }
            if (c == '\n') {
                return linePos;
            }
            ++linePos;
        }
        return -1;
    }

    private int findFirstLineChar(String contents, int startPos) {
        int linePos = startPos;
        while (linePos >= 0) {
            char c = contents.charAt(linePos);
            if (c == '\n' || c == '\r') {
                if (linePos + 1 < startPos) {
                    return linePos + 1;
                }
                return -1;
            }
            --linePos;
        }
        return -1;
    }

    public static class CodeGeneratorException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public CodeGeneratorException(String message) {
            super((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, message, null));
        }

        public CodeGeneratorException(Throwable e) {
            super((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, e.getMessage(), e));
        }
    }
}

