/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.errorparsers.tests;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.internal.errorparsers.tests.GenericErrorParserTests;

public class GCCErrorParserTests
extends GenericErrorParserTests {
    public static final String[] GCC_ERROR_STREAM1 = new String[]{"qcc -c -I/qnx630/target/qnx6/usr/include -I/qnx630/target/qnx6/usr/include/photon -V3.3.1,gcc_ntox86 -w5 -O2   -I. ../abmain.c abmain.o", "In file included from ../globals.h:9,", "                 from ../abmain.c:36:", "../_combolist.h:34:24: warning: no newline at end of file"};
    public static final int GCC_ERROR_STREAM1_WARNINGS = 1;
    public static final int GCC_ERROR_STREAM1_ERRORS = 0;
    public static final String[] GCC_ERROR_STREAM1_FILENAMES = new String[]{"_combolist.h"};
    public static final String[] GCC_ERROR_STREAM2 = new String[]{"C:/QNX630/workspace/System/inc/RPNEvaluator.hpp:234: warning: `", "\t   RPNEvaluator<NumericType>::OperandConstant' is implicitly a typename", "C:/QNX630/workspace/System/inc/RPNEvaluator.hpp:234: warning: implicit typename", "\t   is deprecated, please see the documentation for details"};
    public static final int GCC_ERROR_STREAM2_WARNINGS = 2;
    public static final int GCC_ERROR_STREAM2_ERRORS = 0;
    public static final String[] GCC_ERROR_STREAM2_FILENAMES = new String[]{"RPNEvaluator.hpp"};
    public static final String[] GCC_ERROR_STREAM2_DESCRIPTIONS = new String[]{"please see the documentation"};
    public static final String[] GCC_ERROR_STREAM3 = new String[]{"C:/QNX630/workspace/System/inc/RPNEvaluator.hpp:370: error: ISO C++ says that `", "   char& String::operator[](unsigned int)' and `operator[]' are ambiguous even ", "   though the worst conversion for the former is better than the worst ", "   conversion for the latter"};
    public static final int GCC_ERROR_STREAM3_WARNINGS = 0;
    public static final int GCC_ERROR_STREAM3_ERRORS = 1;
    public static final String[] GCC_ERROR_STREAM3_FILENAMES = new String[]{"RPNEvaluator.hpp"};
    public static final String[] GCC_ERROR_STREAM3_DESCRIPTIONS = new String[]{"ISO C++", "are ambiguous", "worst conversion", "conversion for the latter"};
    public static final String[] GCC_ERROR_STREAM4 = new String[]{"C:/QNX630/workspace/System/inc/RPNEvaluator.hpp: In member function `", "   NumericType RPNEvaluator<NumericType>::evaluate(const char*) [with ", "   NumericType = int8]':", "C:/QNX630/workspace/System/src/CommonScriptClasses.cpp:609:   instantiated from here", "C:/QNX630/workspace/System/inc/RPNEvaluator.hpp:370: error: ISO C++ says that `", "   char& String::operator[](unsigned int)' and `operator[]' are ambiguous even ", "   though the worst conversion for the former is better than the worst ", "   conversion for the latter"};
    public static final int GCC_ERROR_STREAM4_WARNINGS = 0;
    public static final int GCC_ERROR_STREAM4_ERRORS = 1;
    public static final String[] GCC_ERROR_STREAM4_FILENAMES = new String[]{"RPNEvaluator.hpp"};
    public static final String[] GCC_ERROR_STREAM4_DESCRIPTIONS = new String[]{"ISO C++", "are ambiguous", "worst conversion for", "conversion for the latter"};
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.internal.errorparsers.tests.GCCErrorParserTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        return testSuite;
    }

    public void testMultipleIncludesError() throws IOException {
        this.runParserTest(GCC_ERROR_STREAM1, 0, 1, GCC_ERROR_STREAM1_FILENAMES, null, new String[]{"org.eclipse.cdt.core.GCCErrorParser"});
    }

    public void testMultiLineDescriptionError() throws IOException {
        this.runParserTest(GCC_ERROR_STREAM2, 0, 2, GCC_ERROR_STREAM2_FILENAMES, GCC_ERROR_STREAM2_DESCRIPTIONS, new String[]{"org.eclipse.cdt.core.GCCErrorParser"});
    }

    public void testLongMultiLineDescriptionError() throws IOException {
        this.runParserTest(GCC_ERROR_STREAM3, 1, 0, GCC_ERROR_STREAM3_FILENAMES, GCC_ERROR_STREAM3_DESCRIPTIONS, new String[]{"org.eclipse.cdt.core.GCCErrorParser"});
    }

    public void testMultiFileMultiLineSingleError() throws IOException {
        this.runParserTest(GCC_ERROR_STREAM4, 1, 0, GCC_ERROR_STREAM4_FILENAMES, GCC_ERROR_STREAM4_DESCRIPTIONS, new String[]{"org.eclipse.cdt.core.GCCErrorParser"});
    }
}

