/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.errorparsers.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import junit.framework.TestCase;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class GenericErrorParserTests
extends TestCase {
    public static final String GCC_ERROR_PARSER_ID = "org.eclipse.cdt.core.GCCErrorParser";
    protected IProject fTempProject;

    public GenericErrorParserTests(String string) {
        super(string);
    }

    public GenericErrorParserTests() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fTempProject = ResourcesPlugin.getWorkspace().getRoot().getProject("temp-" + System.currentTimeMillis());
        if (!this.fTempProject.exists()) {
            this.fTempProject.create((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception exception) {}
        try {
            this.fTempProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {}
    }

    protected IProject getTempProject() {
        return this.fTempProject;
    }

    protected String makeStringFromArray(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    protected void transferInputStreamToOutputStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
        byArray = null;
    }

    protected void runParserTest(InputStream inputStream, int n, int n2, String[] stringArray, String[] stringArray2, String[] stringArray3) throws IOException {
        int n3;
        GenericErrorParserTests.assertNotNull((Object)inputStream);
        CountingMarkerGenerator countingMarkerGenerator = new CountingMarkerGenerator();
        IProject iProject = this.getTempProject();
        GenericErrorParserTests.assertNotNull((Object)iProject);
        ImaginaryFilesErrorParserManager imaginaryFilesErrorParserManager = new ImaginaryFilesErrorParserManager(iProject, countingMarkerGenerator, stringArray3);
        this.transferInputStreamToOutputStream(inputStream, imaginaryFilesErrorParserManager.getOutputStream(), 1024);
        imaginaryFilesErrorParserManager.close();
        imaginaryFilesErrorParserManager.reportProblems();
        if (n >= 0) {
            GenericErrorParserTests.assertEquals((int)n, (int)countingMarkerGenerator.numErrors);
        }
        if (n2 >= 0) {
            GenericErrorParserTests.assertEquals((int)n2, (int)countingMarkerGenerator.numWarnings);
        }
        if (stringArray != null) {
            GenericErrorParserTests.assertEquals((int)stringArray.length, (int)countingMarkerGenerator.uniqFiles.size());
            n3 = 0;
            while (n3 < stringArray.length) {
                IPath iPath = ((IFile)countingMarkerGenerator.uniqFiles.get(n3)).getLocation();
                GenericErrorParserTests.assertEquals((String)stringArray[n3], (String)iPath.lastSegment());
                ++n3;
            }
        }
        if (stringArray2 != null) {
            GenericErrorParserTests.assertNotNull((Object)countingMarkerGenerator.lastDescription);
            n3 = 0;
            while (n3 < stringArray2.length) {
                GenericErrorParserTests.assertTrue((boolean)countingMarkerGenerator.lastDescription.matches(stringArray2[n3]));
                ++n3;
            }
        }
    }

    protected void runParserTest(String[] stringArray, int n, int n2, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws IOException {
        String string = this.makeStringFromArray(stringArray, "\n");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.runParserTest(byteArrayInputStream, n, n2, stringArray2, stringArray3, stringArray4);
    }

    class FileNameComparator
    implements Comparator {
        FileNameComparator() {
        }

        public int compare(Object object, Object object2) {
            try {
                IFile iFile = (IFile)object;
                IFile iFile2 = (IFile)object2;
                return iFile.getName().compareToIgnoreCase(iFile2.getName());
            }
            catch (Exception exception) {
                return 1;
            }
        }
    }

    class CountingMarkerGenerator
    implements IMarkerGenerator {
        public int numErrors = 0;
        public int numWarnings = 0;
        public int numMarkers;
        public ArrayList uniqFiles = new ArrayList(0);
        public String lastDescription;
        private Comparator fFileNameComparator;

        public void addMarker(IResource iResource, int n, String string, int n2, String string2) {
            int n3 = Collections.binarySearch(this.uniqFiles, iResource, this.fFileNameComparator);
            if (n3 < 0) {
                this.uniqFiles.add(-1 * (n3 + 1), iResource);
            }
            if (n2 == 1) {
                ++this.numWarnings;
            } else if (n2 == 3 || n2 == 2) {
                ++this.numErrors;
            }
            this.lastDescription = string;
            ++this.numMarkers;
        }

        public CountingMarkerGenerator() {
            this.fFileNameComparator = new FileNameComparator();
        }
    }

    class ImaginaryFilesErrorParserManager
    extends ErrorParserManager {
        IProject fProject;

        public ImaginaryFilesErrorParserManager(IProject iProject, IMarkerGenerator iMarkerGenerator, String[] stringArray) {
            super(iProject, iMarkerGenerator, stringArray);
            this.fProject = iProject;
        }

        public IFile findFileName(String string) {
            IFile iFile;
            if (string.lastIndexOf(47) != -1) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            if (!(iFile = this.fProject.getFile(string)).exists()) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("TestFile".getBytes());
                    iFile.create((InputStream)byteArrayInputStream, true, (IProgressMonitor)new NullProgressMonitor());
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (Exception exception) {}
            }
            return iFile;
        }

        protected IFile findFileInWorkspace(IPath iPath) {
            IFile iFile = this.fProject.getFile(iPath.lastSegment());
            if (!iFile.exists()) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("TestFile".getBytes());
                    iFile.create((InputStream)byteArrayInputStream, true, (IProgressMonitor)new NullProgressMonitor());
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (Exception exception) {}
            }
            return iFile;
        }
    }
}

