/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.cdt.core.testplugin.util.ExpectedStrings;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ArchiveTests
extends TestCase {
    IWorkspace workspace = ResourcesPlugin.getWorkspace();
    IWorkspaceRoot root = this.workspace.getRoot();
    ICProject testProject;
    IFile cfile;
    IFile exefile;
    IFile libfile;
    IFile archfile;
    IFile objfile;
    Path cpath;
    Path exepath;
    Path libpath;
    Path archpath;
    Path objpath;
    NullProgressMonitor monitor = new NullProgressMonitor();
    static /* synthetic */ Class class$0;

    public ArchiveTests(String string) {
        super(string);
        if (this.workspace == null) {
            ArchiveTests.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            ArchiveTests.fail((String)"Workspace root was not setup");
        }
    }

    protected void setUp() throws Exception {
        this.testProject = CProjectHelper.createCProject("filetest", "none");
        if (this.testProject == null) {
            ArchiveTests.fail((String)"Unable to create project");
        }
        this.cfile = this.testProject.getProject().getFile("exetest.c");
        if (!this.cfile.exists()) {
            this.cfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/main.c"))), false, (IProgressMonitor)this.monitor);
        }
        this.cpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/main.c");
        this.objfile = this.testProject.getProject().getFile("exetest.o");
        if (!this.objfile.exists()) {
            this.objfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/x86/o.g/main.o"))), false, (IProgressMonitor)this.monitor);
        }
        this.objpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/main.o");
        this.exefile = this.testProject.getProject().getFile("test_g");
        if (!this.exefile.exists()) {
            this.exefile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/x86/o.g/exe_g"))), false, (IProgressMonitor)this.monitor);
        }
        this.exepath = new Path(this.workspace.getRoot().getLocation() + "/filetest/exe_g");
        this.archfile = this.testProject.getProject().getFile("libtestlib_g.a");
        if (!this.archfile.exists()) {
            this.archfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/testlib/x86/a.g/libtestlib_g.a"))), false, (IProgressMonitor)this.monitor);
        }
        this.libpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/libtestlib_g.so");
        this.libfile = this.testProject.getProject().getFile("libtestlib_g.so");
        if (!this.libfile.exists()) {
            this.libfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/testlib/x86/so.g/libtestlib_g.so"))), false, (IProgressMonitor)this.monitor);
        }
        this.archpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/libtestlib_g.a");
    }

    protected void tearDown() {
        CProjectHelper.delete(this.testProject);
    }

    public static TestSuite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.ArchiveTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ArchiveTests.suite());
    }

    public void testGetBinaries() throws CoreException, FileNotFoundException {
        String[] stringArray = new String[]{"test.o", "test2.o"};
        ExpectedStrings expectedStrings = new ExpectedStrings(stringArray);
        ExpectedStrings[] expectedStringsArray = new ExpectedStrings[2];
        stringArray[0] = "func1";
        stringArray[1] = "func2";
        expectedStringsArray[0] = new ExpectedStrings(stringArray);
        stringArray[0] = "test2func1";
        stringArray[1] = "test2func2";
        expectedStringsArray[1] = new ExpectedStrings(stringArray);
        IArchive iArchive = CProjectHelper.findArchive(this.testProject, "libtestlib_g.a");
        if (iArchive == null) {
            ArchiveTests.fail((String)"Could not find archive");
        }
        IBinary[] iBinaryArray = iArchive.getBinaries();
        int n = 0;
        while (n < iBinaryArray.length) {
            expectedStrings.foundString(iBinaryArray[n].getElementName());
            ICElement[] iCElementArray = iBinaryArray[n].getChildren();
            int n2 = 0;
            while (n2 < iCElementArray.length) {
                expectedStringsArray[n].foundString(iCElementArray[n2].getElementName());
                ++n2;
            }
            ++n;
        }
        ArchiveTests.assertTrue((String)expectedStrings.getMissingString(), (boolean)expectedStrings.gotAll());
        ArchiveTests.assertTrue((String)expectedStrings.getExtraString(), (!expectedStrings.gotExtra() ? 1 : 0) != 0);
        n = 0;
        while (n < expectedStringsArray.length) {
            ArchiveTests.assertTrue((String)("Binary " + expectedStrings.expStrings[n] + " " + expectedStringsArray[n].getMissingString()), (boolean)expectedStringsArray[n].gotAll());
            ArchiveTests.assertTrue((String)("Binary " + expectedStrings.expStrings[n] + " " + expectedStringsArray[n].getExtraString()), (!expectedStringsArray[n].gotExtra() ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testIsArchive() throws CoreException, FileNotFoundException {
        IArchive iArchive = CProjectHelper.findArchive(this.testProject, "libtestlib_g.a");
        ArchiveTests.assertTrue((String)"A archive", (iArchive != null ? 1 : 0) != 0);
        iArchive = null;
    }
}

