/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IFunctionTemplateDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IMethodTemplateDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CModelElementsTests
extends TestCase {
    private ICProject fCProject;
    private IFile headerFile;
    private IFile includedFile;
    private NullProgressMonitor monitor;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.CModelElementsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new CModelElementsTests("testCModelElements"));
        return testSuite;
    }

    public CModelElementsTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.monitor = new NullProgressMonitor();
        this.fCProject = CProjectHelper.createCCProject("TestProject1", "bin");
        this.headerFile = this.fCProject.getProject().getFile("CModelElementsTest.h");
        this.includedFile = this.fCProject.getProject().getFile("included.h");
        if (!this.headerFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/cfiles/CModelElementsTestStart.h")));
                this.headerFile.create((InputStream)fileInputStream, false, (IProgressMonitor)this.monitor);
                FileInputStream fileInputStream2 = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/cfiles/included.h")));
                this.includedFile.create((InputStream)fileInputStream2, false, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    protected void tearDown() {
        CProjectHelper.delete(this.fCProject);
    }

    public void testCModelElements() throws CModelException {
        ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(this.headerFile);
        iTranslationUnit.parse();
        this.checkInclude((IParent)iTranslationUnit);
        this.checkMacro((IParent)iTranslationUnit);
        List list = iTranslationUnit.getChildrenOfType(61);
        INamespace iNamespace = (INamespace)list.get(0);
        CModelElementsTests.assertEquals((String)iNamespace.getElementName(), (String)new String("MyPackage"));
        this.checkElementOffset((ICElement)iNamespace);
        this.checkLineNumbers((ICElement)iNamespace, 8, 130);
        this.checkClass((IParent)iNamespace);
        this.checkEnums((IParent)iNamespace);
        this.checkVariables((IParent)iNamespace);
        this.checkVariableDeclarations((IParent)iNamespace);
        this.checkFunctions((IParent)iNamespace);
        this.checkStructs((IParent)iNamespace);
        this.checkTemplates((IParent)iNamespace);
        this.checkArrays((IParent)iTranslationUnit);
    }

    private void checkInclude(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(75);
        IInclude iInclude = (IInclude)list.get(0);
        CModelElementsTests.assertEquals((String)iInclude.getElementName(), (String)new String("included.h"));
        this.checkElementOffset((ICElement)iInclude);
        this.checkLineNumbers((ICElement)iInclude, 2, 2);
    }

    private void checkMacro(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(79);
        IMacro iMacro = (IMacro)list.get(0);
        CModelElementsTests.assertEquals((String)iMacro.getElementName(), (String)new String("PRINT"));
        this.checkElementOffset((ICElement)iMacro);
        this.checkLineNumbers((ICElement)iMacro, 5, 5);
    }

    private void checkClass(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(65);
        IStructure iStructure = (IStructure)list.get(0);
        CModelElementsTests.assertEquals((String)iStructure.getElementName(), (String)new String("Hello"));
        this.checkElementOffset((ICElement)iStructure);
        this.checkLineNumbers((ICElement)iStructure, 12, 53);
        List list2 = iStructure.getChildrenOfType(72);
        IField iField = (IField)list2.get(0);
        CModelElementsTests.assertEquals((String)iField.getElementName(), (String)new String("x"));
        this.checkElementOffset((ICElement)iField);
        CModelElementsTests.assertEquals((String)iField.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((ICElement)iField, 17, 17);
        ASTAccessVisibility aSTAccessVisibility = iField.getVisibility();
        if (aSTAccessVisibility != ASTAccessVisibility.PROTECTED) {
            CModelElementsTests.fail((String)"visibility should be protected!");
        }
        List list3 = iStructure.getChildrenOfType(70);
        IMethod iMethod = (IMethod)list3.get(0);
        CModelElementsTests.assertEquals((String)iMethod.getElementName(), (String)new String("setX"));
        this.checkElementOffset((ICElement)iMethod);
        CModelElementsTests.assertEquals((String)iMethod.getReturnType(), (String)new String("void"));
        this.checkLineNumbers((ICElement)iMethod, 19, 22);
        int n = iMethod.getNumberOfParameters();
        if (n != 1) {
            CModelElementsTests.fail((String)"setX should have one parameter!");
        }
        String[] stringArray = iMethod.getParameterTypes();
        String string = stringArray[0];
        CModelElementsTests.assertEquals((String)string, (String)new String("int"));
        this.checkNestedNamespace((IParent)iStructure);
    }

    private void checkNestedNamespace(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(61);
        INamespace iNamespace = (INamespace)list.get(0);
        CModelElementsTests.assertEquals((String)iNamespace.getElementName(), (String)new String("MyNestedPackage"));
        this.checkElementOffset((ICElement)iNamespace);
        this.checkLineNumbers((ICElement)iNamespace, 25, 52);
        this.checkParentNestedClass((IParent)iNamespace);
        this.checkDerivedNestedClass((IParent)iNamespace);
    }

    private void checkParentNestedClass(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(65);
        IStructure iStructure = (IStructure)list.get(0);
        CModelElementsTests.assertEquals((String)iStructure.getElementName(), (String)new String("Y"));
        this.checkElementOffset((ICElement)iStructure);
        this.checkLineNumbers((ICElement)iStructure, 28, 35);
        List list2 = iStructure.getChildrenOfType(71);
        IMethodDeclaration iMethodDeclaration = (IMethodDeclaration)list2.get(0);
        CModelElementsTests.assertEquals((String)iMethodDeclaration.getElementName(), (String)new String("Y"));
        this.checkElementOffset((ICElement)iMethodDeclaration);
        CModelElementsTests.assertTrue((boolean)iMethodDeclaration.isConstructor());
        this.checkLineNumbers((ICElement)iMethodDeclaration, 32, 32);
        IMethodDeclaration iMethodDeclaration2 = (IMethodDeclaration)list2.get(1);
        CModelElementsTests.assertEquals((String)iMethodDeclaration2.getElementName(), (String)new String("~Y"));
        this.checkElementOffset((ICElement)iMethodDeclaration2);
        CModelElementsTests.assertTrue((boolean)iMethodDeclaration2.isDestructor());
        this.checkLineNumbers((ICElement)iMethodDeclaration2, 34, 34);
    }

    private void checkDerivedNestedClass(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(65);
        IStructure iStructure = (IStructure)list.get(1);
        CModelElementsTests.assertEquals((String)iStructure.getElementName(), (String)new String("X"));
        this.checkElementOffset((ICElement)iStructure);
        this.checkLineNumbers((ICElement)iStructure, 38, 51);
        List list2 = iStructure.getChildrenOfType(72);
        IField iField = (IField)list2.get(0);
        CModelElementsTests.assertEquals((String)iField.getElementName(), (String)new String("b"));
        this.checkElementOffset((ICElement)iField);
        CModelElementsTests.assertEquals((String)iField.getTypeName(), (String)new String("B"));
        this.checkLineNumbers((ICElement)iField, 42, 42);
        ASTAccessVisibility aSTAccessVisibility = iField.getVisibility();
        if (aSTAccessVisibility != ASTAccessVisibility.PRIVATE) {
            CModelElementsTests.fail((String)"visibility should be private!");
        }
        List list3 = iStructure.getChildrenOfType(70);
        IMethod iMethod = (IMethod)list3.get(0);
        CModelElementsTests.assertEquals((String)iMethod.getElementName(), (String)new String("X"));
        this.checkElementOffset((ICElement)iMethod);
        CModelElementsTests.assertTrue((boolean)iMethod.isConstructor());
        this.checkLineNumbers((ICElement)iMethod, 46, 48);
        List list4 = iStructure.getChildrenOfType(71);
        IMethodDeclaration iMethodDeclaration = (IMethodDeclaration)list4.get(0);
        CModelElementsTests.assertEquals((String)iMethodDeclaration.getElementName(), (String)new String("doNothing"));
        this.checkElementOffset((ICElement)iMethodDeclaration);
        CModelElementsTests.assertEquals((String)iMethodDeclaration.getReturnType(), (String)new String("int"));
        this.checkLineNumbers((ICElement)iMethodDeclaration, 50, 50);
    }

    private void checkEnums(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(63);
        IEnumeration iEnumeration = (IEnumeration)list.get(0);
        CModelElementsTests.assertEquals((String)iEnumeration.getElementName(), (String)new String(""));
        this.checkElementOffset((ICElement)iEnumeration);
        this.checkLineNumbers((ICElement)iEnumeration, 57, 61);
        List list2 = iEnumeration.getChildrenOfType(81);
        IEnumerator iEnumerator = (IEnumerator)list2.get(0);
        CModelElementsTests.assertEquals((String)iEnumerator.getElementName(), (String)new String("first"));
        CModelElementsTests.assertEquals((String)"1", (String)iEnumerator.getConstantExpression());
        this.checkElementOffset((ICElement)iEnumerator);
        IEnumerator iEnumerator2 = (IEnumerator)list2.get(1);
        CModelElementsTests.assertEquals((String)iEnumerator2.getElementName(), (String)new String("second"));
        this.checkElementOffset((ICElement)iEnumerator2);
        IEnumerator iEnumerator3 = (IEnumerator)list2.get(2);
        this.checkElementOffset((ICElement)iEnumerator3);
        CModelElementsTests.assertEquals((String)iEnumerator3.getElementName(), (String)new String("third"));
        this.checkElementOffset((ICElement)iEnumerator3);
        IEnumeration iEnumeration2 = (IEnumeration)list.get(1);
        CModelElementsTests.assertEquals((String)iEnumeration2.getElementName(), (String)new String("MyEnum"));
        this.checkElementOffset((ICElement)iEnumeration2);
        this.checkLineNumbers((ICElement)iEnumeration2, 64, 67);
        List list3 = iEnumeration2.getChildrenOfType(81);
        IEnumerator iEnumerator4 = (IEnumerator)list3.get(0);
        CModelElementsTests.assertEquals((String)iEnumerator4.getElementName(), (String)new String("f"));
        this.checkElementOffset((ICElement)iEnumerator4);
        IEnumerator iEnumerator5 = (IEnumerator)list3.get(1);
        CModelElementsTests.assertEquals((String)iEnumerator5.getElementName(), (String)new String("s"));
        this.checkElementOffset((ICElement)iEnumerator5);
        IEnumerator iEnumerator6 = (IEnumerator)list3.get(2);
        CModelElementsTests.assertEquals((String)iEnumerator6.getElementName(), (String)new String("t"));
        this.checkElementOffset((ICElement)iEnumerator6);
    }

    private void checkVariables(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(76);
        IVariable iVariable = (IVariable)list.get(0);
        CModelElementsTests.assertEquals((String)iVariable.getElementName(), (String)new String("v"));
        this.checkElementOffset((ICElement)iVariable);
        CModelElementsTests.assertEquals((String)iVariable.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((ICElement)iVariable, 71, 71);
        IVariable iVariable2 = (IVariable)list.get(1);
        CModelElementsTests.assertEquals((String)iVariable2.getElementName(), (String)new String("vuLong"));
        this.checkElementOffset((ICElement)iVariable2);
        CModelElementsTests.assertEquals((String)iVariable2.getTypeName(), (String)new String("unsigned long"));
        this.checkLineNumbers((ICElement)iVariable2, 73, 73);
        IVariable iVariable3 = (IVariable)list.get(2);
        CModelElementsTests.assertEquals((String)iVariable3.getElementName(), (String)new String("vuShort"));
        this.checkElementOffset((ICElement)iVariable3);
        CModelElementsTests.assertEquals((String)iVariable3.getTypeName(), (String)new String("unsigned short"));
        this.checkLineNumbers((ICElement)iVariable3, 75, 75);
        IVariable iVariable4 = (IVariable)list.get(3);
        CModelElementsTests.assertEquals((String)iVariable4.getElementName(), (String)new String("orig_malloc_hook"));
        this.checkElementOffset((ICElement)iVariable4);
        CModelElementsTests.assertEquals((String)iVariable4.getTypeName(), (String)new String("void*(*)(const char*, int, size_t)"));
        this.checkLineNumbers((ICElement)iVariable4, 81, 81);
    }

    private void checkVariableDeclarations(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(77);
        IVariableDeclaration iVariableDeclaration = (IVariableDeclaration)list.get(0);
        CModelElementsTests.assertEquals((String)iVariableDeclaration.getElementName(), (String)new String("evar"));
        this.checkElementOffset((ICElement)iVariableDeclaration);
        CModelElementsTests.assertEquals((String)iVariableDeclaration.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((ICElement)iVariableDeclaration, 79, 79);
    }

    private void checkFunctions(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(73);
        IFunctionDeclaration iFunctionDeclaration = (IFunctionDeclaration)list.get(0);
        CModelElementsTests.assertEquals((String)iFunctionDeclaration.getElementName(), (String)new String("foo"));
        this.checkElementOffset((ICElement)iFunctionDeclaration);
        CModelElementsTests.assertEquals((String)iFunctionDeclaration.getReturnType(), (String)new String("void"));
        this.checkLineNumbers((ICElement)iFunctionDeclaration, 85, 85);
        IFunctionDeclaration iFunctionDeclaration2 = (IFunctionDeclaration)list.get(1);
        CModelElementsTests.assertEquals((String)iFunctionDeclaration2.getElementName(), (String)new String("foo"));
        this.checkElementOffset((ICElement)iFunctionDeclaration2);
        CModelElementsTests.assertEquals((String)iFunctionDeclaration2.getReturnType(), (String)new String("char*"));
        this.checkLineNumbers((ICElement)iFunctionDeclaration2, 87, 88);
        int n = iFunctionDeclaration2.getNumberOfParameters();
        if (n != 2) {
            CModelElementsTests.fail((String)"foo should have two parameter!");
        }
        String[] stringArray = iFunctionDeclaration2.getParameterTypes();
        CModelElementsTests.assertEquals((String)stringArray[0], (String)new String("int&"));
        CModelElementsTests.assertEquals((String)stringArray[1], (String)new String("char**"));
        List list2 = iParent.getChildrenOfType(74);
        IFunction iFunction = (IFunction)list2.get(0);
        CModelElementsTests.assertEquals((String)iFunction.getElementName(), (String)new String("boo"));
        this.checkElementOffset((ICElement)iFunction);
        CModelElementsTests.assertEquals((String)iFunction.getReturnType(), (String)new String("void"));
        this.checkLineNumbers((ICElement)iFunction, 90, 92);
    }

    private void checkStructs(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(67);
        IStructure iStructure = (IStructure)list.get(0);
        CModelElementsTests.assertEquals((String)iStructure.getElementName(), (String)new String("MyStruct"));
        this.checkElementOffset((ICElement)iStructure);
        this.checkLineNumbers((ICElement)iStructure, 95, 97);
        List list2 = iStructure.getChildrenOfType(72);
        IField iField = (IField)list2.get(0);
        CModelElementsTests.assertEquals((String)iField.getElementName(), (String)new String("sint"));
        this.checkElementOffset((ICElement)iField);
        CModelElementsTests.assertEquals((String)iField.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((ICElement)iField, 96, 96);
        if (iField.getVisibility() != ASTAccessVisibility.PUBLIC) {
            CModelElementsTests.fail((String)"field visibility should be public!");
        }
        IStructure iStructure2 = (IStructure)list.get(1);
        CModelElementsTests.assertEquals((String)iStructure2.getElementName(), (String)new String(""));
        this.checkElementOffset((ICElement)iStructure2);
        this.checkLineNumbers((ICElement)iStructure2, 101, 103);
        List list3 = iStructure2.getChildrenOfType(72);
        IField iField2 = (IField)list3.get(0);
        CModelElementsTests.assertEquals((String)iField2.getElementName(), (String)new String("ss"));
        this.checkElementOffset((ICElement)iField2);
        CModelElementsTests.assertEquals((String)iField2.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((ICElement)iField2, 102, 102);
        if (iField2.getVisibility() != ASTAccessVisibility.PUBLIC) {
            CModelElementsTests.fail((String)"field visibility should be public!");
        }
        List list4 = iParent.getChildrenOfType(80);
        ITypeDef iTypeDef = (ITypeDef)list4.get(0);
        CModelElementsTests.assertEquals((String)iTypeDef.getElementName(), (String)new String("myStruct"));
        this.checkElementOffset((ICElement)iTypeDef);
        CModelElementsTests.assertEquals((String)iTypeDef.getTypeName(), (String)new String("struct MyStruct"));
        this.checkLineNumbers((ICElement)iTypeDef, 99, 99);
        ITypeDef iTypeDef2 = (ITypeDef)list4.get(1);
        CModelElementsTests.assertEquals((String)iTypeDef2.getElementName(), (String)new String("myTypedef"));
        this.checkElementOffset((ICElement)iTypeDef2);
        CModelElementsTests.assertEquals((String)iTypeDef2.getTypeName(), (String)new String(""));
        this.checkLineNumbers((ICElement)iTypeDef2, 101, 103);
        List list5 = iParent.getChildrenOfType(69);
        IStructure iStructure3 = (IStructure)list5.get(0);
        CModelElementsTests.assertEquals((String)iStructure3.getElementName(), (String)new String("U"));
        this.checkElementOffset((ICElement)iStructure3);
        this.checkLineNumbers((ICElement)iStructure3, 105, 107);
        List list6 = iStructure3.getChildrenOfType(72);
        IField iField3 = (IField)list6.get(0);
        CModelElementsTests.assertEquals((String)iField3.getElementName(), (String)new String("U1"));
        this.checkElementOffset((ICElement)iField3);
        CModelElementsTests.assertEquals((String)iField3.getTypeName(), (String)new String("int"));
        this.checkLineNumbers((ICElement)iField3, 106, 106);
        if (iField3.getVisibility() != ASTAccessVisibility.PUBLIC) {
            CModelElementsTests.fail((String)"field visibility should be public!");
        }
    }

    private void checkTemplates(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(88);
        IFunctionTemplateDeclaration iFunctionTemplateDeclaration = (IFunctionTemplateDeclaration)list.get(0);
        CModelElementsTests.assertEquals((String)iFunctionTemplateDeclaration.getElementName(), (String)new String("aTemplatedFunction"));
        this.checkElementOffset((ICElement)iFunctionTemplateDeclaration);
        iFunctionTemplateDeclaration.getTemplateSignature();
        CModelElementsTests.assertEquals((String)iFunctionTemplateDeclaration.getTemplateSignature(), (String)new String("aTemplatedFunction<A, B>(B) : A"));
        this.checkLineNumbers((ICElement)iFunctionTemplateDeclaration, 112, 113);
        List list2 = iParent.getChildrenOfType(65);
        IStructure iStructure = (IStructure)list2.get(1);
        this.checkLineNumbers((ICElement)iStructure, 115, 120);
        List list3 = iStructure.getChildrenOfType(90);
        IMethodTemplateDeclaration iMethodTemplateDeclaration = (IMethodTemplateDeclaration)list3.get(0);
        CModelElementsTests.assertEquals((String)iMethodTemplateDeclaration.getElementName(), (String)new String("aTemplatedMethod"));
        this.checkElementOffset((ICElement)iMethodTemplateDeclaration);
        CModelElementsTests.assertEquals((String)iMethodTemplateDeclaration.getTemplateSignature(), (String)new String("aTemplatedMethod<A, B>(B) : A"));
        this.checkLineNumbers((ICElement)iMethodTemplateDeclaration, 118, 119);
        CModelElementsTests.assertEquals((Object)iMethodTemplateDeclaration.getVisibility(), (Object)ASTAccessVisibility.PUBLIC);
        List list4 = iParent.getChildrenOfType(83);
        IStructureTemplate iStructureTemplate = (IStructureTemplate)list4.get(0);
        CModelElementsTests.assertEquals((String)iStructureTemplate.getElementName(), (String)new String("myarray"));
        this.checkElementOffset((ICElement)iStructureTemplate);
        CModelElementsTests.assertEquals((String)iStructureTemplate.getTemplateSignature(), (String)new String("myarray<T, Tibor>"));
        this.checkLineNumbers((ICElement)iStructureTemplate, 122, 123);
        List list5 = iParent.getChildrenOfType(85);
        IStructureTemplate iStructureTemplate2 = (IStructureTemplate)list5.get(0);
        CModelElementsTests.assertEquals((String)iStructureTemplate2.getElementName(), (String)new String("mystruct"));
        this.checkElementOffset((ICElement)iStructureTemplate2);
        CModelElementsTests.assertEquals((String)iStructureTemplate2.getTemplateSignature(), (String)new String("mystruct<T, Tibor>"));
        this.checkLineNumbers((ICElement)iStructureTemplate2, 125, 126);
    }

    private void checkArrays(IParent iParent) throws CModelException {
        List list = iParent.getChildrenOfType(76);
        IVariable iVariable = (IVariable)list.get(0);
        CModelElementsTests.assertEquals((String)iVariable.getElementName(), (String)new String("myArray"));
        this.checkElementOffset((ICElement)iVariable);
        CModelElementsTests.assertEquals((String)iVariable.getTypeName(), (String)new String("int[][]"));
        this.checkLineNumbers((ICElement)iVariable, 133, 133);
        List list2 = iParent.getChildrenOfType(74);
        IFunction iFunction = (IFunction)list2.get(0);
        CModelElementsTests.assertEquals((String)iFunction.getElementName(), (String)new String("main"));
        this.checkElementOffset((ICElement)iFunction);
        CModelElementsTests.assertEquals((String)iFunction.getReturnType(), (String)new String("int"));
        this.checkLineNumbers((ICElement)iFunction, 134, 136);
        int n = iFunction.getNumberOfParameters();
        if (n != 2) {
            CModelElementsTests.fail((String)"main should have two parameter!");
        }
        String[] stringArray = iFunction.getParameterTypes();
        CModelElementsTests.assertEquals((String)stringArray[0], (String)new String("int"));
        CModelElementsTests.assertEquals((String)stringArray[1], (String)new String("char*[]"));
    }

    private void checkLineNumbers(ICElement iCElement, int n, int n2) throws CModelException {
        ISourceRange iSourceRange = ((ISourceReference)iCElement).getSourceRange();
        CModelElementsTests.assertEquals((int)n, (int)iSourceRange.getStartLine());
        CModelElementsTests.assertEquals((int)n2, (int)iSourceRange.getEndLine());
    }

    private void checkElementOffset(ICElement iCElement) throws CModelException {
        String string = iCElement.getElementName();
        ISourceRange iSourceRange = ((ISourceReference)iCElement).getSourceRange();
        if (string.length() > 0) {
            CModelElementsTests.assertTrue((iSourceRange.getStartPos() <= iSourceRange.getIdStartPos() ? 1 : 0) != 0);
            CModelElementsTests.assertEquals((int)iSourceRange.getIdLength(), (int)string.length());
        } else {
            CModelElementsTests.assertEquals((int)iSourceRange.getStartPos(), (int)iSourceRange.getIdStartPos());
            if (iCElement instanceof ITypeDef) {
                CModelElementsTests.assertEquals((int)iSourceRange.getIdLength(), (int)((ITypeDef)iCElement).getTypeName().length());
            } else if (iCElement instanceof IEnumeration) {
                CModelElementsTests.assertEquals((int)iSourceRange.getIdLength(), (int)((IEnumeration)iCElement).getTypeName().length());
            } else if (iCElement instanceof IStructure) {
                CModelElementsTests.assertEquals((int)iSourceRange.getIdLength(), (int)((IStructure)iCElement).getTypeName().length());
            }
        }
    }
}

