/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CPathEntryTest
extends TestCase {
    IWorkspace workspace;
    IWorkspaceRoot root;
    IProject project_c;
    IProject project_cc;
    NullProgressMonitor monitor;
    String pluginRoot;
    static /* synthetic */ Class class$0;

    public CPathEntryTest(String string) {
        super(string);
    }

    protected void setUp() throws CoreException {
        this.workspace = ResourcesPlugin.getWorkspace();
        this.root = this.workspace.getRoot();
        this.monitor = new NullProgressMonitor();
        if (this.workspace == null) {
            CPathEntryTest.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            CPathEntryTest.fail((String)"Workspace root was not setup");
        }
        this.pluginRoot = CTestPlugin.getDefault().find((IPath)new Path("/")).getFile();
        IWorkspaceDescription iWorkspaceDescription = this.workspace.getDescription();
        iWorkspaceDescription.setAutoBuilding(false);
        this.workspace.setDescription(iWorkspaceDescription);
    }

    protected void tearDown() {
    }

    public static TestSuite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.CPathEntryTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CPathEntryTest.suite());
    }

    public void testCPathEntries() throws CoreException {
        IPathEntry[] iPathEntryArray;
        ICProject iCProject = CProjectHelper.createCProject("cpathtest", "none");
        if (iCProject == null) {
            CPathEntryTest.fail((String)"Unable to create project");
        }
        CPathEntryTest.assertTrue((String)"No cpathentries", ((iPathEntryArray = iCProject.getResolvedPathEntries()).length == 2 ? 1 : 0) != 0);
        iPathEntryArray = new IPathEntry[]{CoreModel.newIncludeEntry((IPath)new Path(""), null, (IPath)new Path("/usr/include"), (boolean)true), CoreModel.newIncludeEntry((IPath)new Path("cpaththest/foo.c"), null, (IPath)new Path("/usr/include"), (boolean)true), CoreModel.newLibraryEntry((IPath)new Path(""), null, (IPath)new Path("/usr/lib/libc.so.1"), null, null, null, (boolean)false)};
        iCProject.setRawPathEntries(iPathEntryArray, (IProgressMonitor)new NullProgressMonitor());
        iPathEntryArray = iCProject.getResolvedPathEntries();
        CPathEntryTest.assertTrue((String)"Expecting 5 pathentries", (iPathEntryArray.length == 5 ? 1 : 0) != 0);
        iCProject.setRawPathEntries(null, null);
    }

    public void testCPathEntriesDelta() throws CoreException {
        ICProject iCProject = CProjectHelper.createCProject("cpathtest", "none");
        if (iCProject == null) {
            CPathEntryTest.fail((String)"Unable to create project");
        }
        CProjectHelper.addCContainer(iCProject, "foo");
        IPathEntry[] iPathEntryArray = new IPathEntry[]{CoreModel.newIncludeEntry((IPath)new Path(""), null, (IPath)new Path("/usr/include"), (boolean)true), CoreModel.newIncludeEntry((IPath)new Path("foo"), null, (IPath)new Path("/usr/include"), (boolean)true), CoreModel.newLibraryEntry((IPath)new Path(""), null, (IPath)new Path("/usr/lib/libc.so.1"), null, null, null, (boolean)false)};
        CElementListener cElementListener = new CElementListener();
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)cElementListener);
        iCProject.setRawPathEntries(iPathEntryArray, (IProgressMonitor)new NullProgressMonitor());
        iPathEntryArray = iCProject.getResolvedPathEntries();
        iCProject.setRawPathEntries(null, null);
        CPathEntryTest.assertTrue((String)"Expecting 3 pathEntries deltas", (cElementListener.count > 1 ? 1 : 0) != 0);
    }

    public void testPathEntryContainer() throws CoreException {
        ICProject iCProject = CProjectHelper.createCProject("cpathtest", "none");
        if (iCProject == null) {
            CPathEntryTest.fail((String)"Unable to create project");
        }
        Path path = new Path("Testing/Container");
        IContainerEntry iContainerEntry = CoreModel.newContainerEntry((IPath)path);
        IPathEntryContainer iPathEntryContainer = new IPathEntryContainer((IPath)path){
            private final /* synthetic */ IPath val$containerID;
            {
                this.val$containerID = iPath;
            }

            public IPathEntry[] getPathEntries() {
                IPathEntry[] iPathEntryArray = new IPathEntry[]{CoreModel.newIncludeEntry((IPath)new Path(""), null, (IPath)new Path("/usr/include"), (boolean)true), CoreModel.newIncludeEntry((IPath)new Path("foo.c"), null, (IPath)new Path("/usr/include"), (boolean)true), CoreModel.newLibraryEntry((IPath)new Path(""), null, (IPath)new Path("/usr/lib/libc.so.1"), null, null, null, (boolean)true)};
                return iPathEntryArray;
            }

            public String getDescription() {
                return "Testing container";
            }

            public IPath getPath() {
                return this.val$containerID;
            }
        };
        CoreModel.setRawPathEntries((ICProject)iCProject, (IPathEntry[])new IPathEntry[]{iContainerEntry}, (IProgressMonitor)new NullProgressMonitor());
        CoreModel.setPathEntryContainer((ICProject[])new ICProject[]{iCProject}, (IPathEntryContainer)iPathEntryContainer, (IProgressMonitor)new NullProgressMonitor());
        IPathEntry[] iPathEntryArray = iCProject.getResolvedPathEntries();
        CPathEntryTest.assertTrue((String)"Expecting 3 pathentries from container", (iPathEntryArray.length == 5 ? 1 : 0) != 0);
    }

    class CElementListener
    implements IElementChangedListener {
        int count = 0;

        CElementListener() {
        }

        void processDelta(ICElementDelta iCElementDelta) {
            if (iCElementDelta == null) {
                return;
            }
            int n = iCElementDelta.getFlags();
            int n2 = iCElementDelta.getKind();
            if (n2 == 4 && (n & 0x800) != 0) {
                ++this.count;
            }
            ICElementDelta[] iCElementDeltaArray = iCElementDelta.getAffectedChildren();
            int n3 = 0;
            while (n3 < iCElementDeltaArray.length) {
                this.processDelta(iCElementDeltaArray[n3]);
                ++n3;
            }
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            this.processDelta(elementChangedEvent.getDelta());
        }
    }
}

