/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.tests.IntegratedCModelTest;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;

public class IStructureTests
extends IntegratedCModelTest {
    static /* synthetic */ Class class$0;

    public IStructureTests(String string) {
        super(string);
    }

    public String getSourcefileSubdir() {
        return "resources/cmodel/";
    }

    public String getSourcefileResource() {
        return "IStructure.c";
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.IStructureTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new IStructureTests("testGetChildrenOfTypeStruct"));
        testSuite.addTest((Test)new IStructureTests("testGetChildrenOfTypeClass"));
        testSuite.addTest((Test)new IStructureTests("testGetFields"));
        testSuite.addTest((Test)new IStructureTests("testGetField"));
        testSuite.addTest((Test)new IStructureTests("testGetMethods"));
        testSuite.addTest((Test)new IStructureTests("testGetMethod"));
        testSuite.addTest((Test)new IStructureTests("testIsStruct"));
        testSuite.addTest((Test)new IStructureTests("testIsClass"));
        testSuite.addTest((Test)new IStructureTests("testIsUnion"));
        testSuite.addTest((Test)new IStructureTests("testIsAbstract"));
        testSuite.addTest((Test)new IStructureTests("testGetBaseTypes"));
        testSuite.addTest((Test)new IStructureTests("testGetAccessControl"));
        testSuite.addTest((Test)new IStructureTests("testAnonymousStructObject"));
        testSuite.addTest((Test)new IStructureTests("testInnerStruct"));
        return testSuite;
    }

    public void testGetChildrenOfTypeStruct() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(67);
        String[] stringArray = new String[]{"testStruct1", "testStruct2", "testStruct3", "", "", "testStruct7", "testStruct8"};
        IStructureTests.assertEquals((int)stringArray.length, (int)list.size());
        int n = 0;
        while (n < stringArray.length) {
            IStructure iStructure = (IStructure)list.get(n);
            IStructureTests.assertNotNull((String)("Failed on " + n), (Object)iStructure);
            IStructureTests.assertEquals((String)stringArray[n], (String)iStructure.getElementName());
            ++n;
        }
    }

    public void testGetChildrenOfTypeClass() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(65);
        String[] stringArray = new String[]{"testClass1", "testClass3", "testClass4Abstract", "testClass5", "testClass6"};
        IStructureTests.assertEquals((int)stringArray.length, (int)list.size());
        int n = 0;
        while (n < stringArray.length) {
            IStructure iStructure = (IStructure)list.get(n);
            IStructureTests.assertNotNull((String)("Failed on " + n), (Object)iStructure);
            IStructureTests.assertEquals((String)stringArray[n], (String)iStructure.getElementName());
            ++n;
        }
    }

    public void testGetFields() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(67);
        IStructure iStructure = (IStructure)list.get(0);
        IField[] iFieldArray = iStructure.getFields();
        String[] stringArray = new String[]{"m_field1", "m_field2", "m_field3", "m_field4", "m_field5", "m_field6"};
        IStructureTests.assertEquals((int)stringArray.length, (int)iFieldArray.length);
        int n = 0;
        while (n < iFieldArray.length) {
            IStructureTests.assertNotNull((String)("Failed on " + n), (Object)iFieldArray[n]);
            IStructureTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iFieldArray[n].getElementName());
            ++n;
        }
    }

    public void testGetFieldsHack() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(67);
        IStructure iStructure = (IStructure)list.get(0);
        String[] stringArray = new String[]{"m_field1", "m_field2", "m_field3", "m_field4", "m_field5", "m_field6"};
        List list2 = iStructure.getChildrenOfType(72);
        IStructureTests.assertEquals((int)stringArray.length, (int)list2.size());
        int n = 0;
        while (n < list2.size()) {
            IField iField = (IField)list2.get(n);
            IStructureTests.assertNotNull((String)("Failed on " + n), (Object)iField);
            IStructureTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iField.getElementName());
            ++n;
        }
    }

    public void testGetField() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(67);
        IStructure iStructure = (IStructure)list.get(0);
        String[] stringArray = new String[]{"m_field1", "m_field2", "m_field3", "m_field4", "m_field5", "m_field6"};
        int n = 0;
        while (n < stringArray.length) {
            IField iField = iStructure.getField(stringArray[n]);
            IStructureTests.assertNotNull((String)("Failed on " + n), (Object)iField);
            ++n;
        }
        String[] stringArray2 = new String[]{"m_field7", "m_field8", "m_field9"};
        int n2 = 0;
        while (n2 < stringArray2.length) {
            IField iField = iStructure.getField(stringArray2[n2]);
            IStructureTests.assertNull((String)("Failed on " + n2), (Object)iField);
            ++n2;
        }
    }

    public void testGetMethods() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(67);
        IStructure iStructure = (IStructure)list.get(0);
        IMethodDeclaration[] iMethodDeclarationArray = iStructure.getMethods();
        String[] stringArray = new String[]{"method1", "method2", "testStruct1", "~testStruct1"};
        IStructureTests.assertEquals((int)stringArray.length, (int)iMethodDeclarationArray.length);
        int n = 0;
        while (n < iMethodDeclarationArray.length) {
            IStructureTests.assertNotNull((String)("Failed on " + n), (Object)iMethodDeclarationArray[n]);
            IStructureTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iMethodDeclarationArray[n].getElementName());
            ++n;
        }
    }

    public void testGetMethodsHack() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(67);
        IStructure iStructure = (IStructure)list.get(0);
        List list2 = iStructure.getChildrenOfType(71);
        list2.addAll(iStructure.getChildrenOfType(70));
        String[] stringArray = new String[]{"method1", "method2", "testStruct1", "~testStruct1"};
        IStructureTests.assertEquals((int)stringArray.length, (int)list2.size());
        int n = 0;
        while (n < list2.size()) {
            IMethodDeclaration iMethodDeclaration = (IMethodDeclaration)list2.get(n);
            IStructureTests.assertNotNull((String)("Failed on " + n), (Object)iMethodDeclaration);
            IStructureTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iMethodDeclaration.getElementName());
            ++n;
        }
    }

    public void testGetMethod() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(67);
        IStructure iStructure = (IStructure)list.get(0);
        String[] stringArray = new String[]{"method1", "method2", "testStruct1", "~testStruct1"};
        int n = 0;
        while (n < stringArray.length) {
            IMethodDeclaration iMethodDeclaration = iStructure.getMethod(stringArray[n]);
            IStructureTests.assertNotNull((String)("Failed on " + n), (Object)iMethodDeclaration);
            ++n;
        }
        String[] stringArray2 = new String[]{"method7", "method8", "method9"};
        int n2 = 0;
        while (n2 < stringArray2.length) {
            IMethodDeclaration iMethodDeclaration = iStructure.getMethod(stringArray2[n2]);
            IStructureTests.assertNull((String)("Failed on " + n2), (Object)iMethodDeclaration);
            ++n2;
        }
    }

    public void testIsUnion() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        ICElement iCElement = null;
        ICElement iCElement2 = null;
        try {
            iCElement = iTranslationUnit.getElement("testUnion1");
            iCElement2 = iTranslationUnit.getElement("testStruct1");
        }
        catch (CModelException cModelException) {
            IStructureTests.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
        IStructureTests.assertNotNull((Object)iCElement);
        IStructureTests.assertTrue((iCElement.getElementType() == 69 ? 1 : 0) != 0);
        IStructure iStructure = (IStructure)iCElement;
        IStructureTests.assertNotNull((Object)iStructure);
        IStructureTests.assertTrue((boolean)iStructure.isUnion());
        IStructureTests.assertNotNull((Object)iCElement2);
        IStructureTests.assertTrue((iCElement2.getElementType() != 69 ? 1 : 0) != 0);
        IStructure iStructure2 = (IStructure)iCElement2;
        IStructureTests.assertNotNull((Object)iStructure2);
        IStructureTests.assertFalse((boolean)iStructure2.isUnion());
    }

    public void testIsStruct() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        ICElement iCElement = null;
        ICElement iCElement2 = null;
        try {
            iCElement = iTranslationUnit.getElement("testStruct1");
            iCElement2 = iTranslationUnit.getElement("testClass1");
        }
        catch (CModelException cModelException) {
            IStructureTests.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
        IStructureTests.assertNotNull((Object)iCElement);
        IStructureTests.assertTrue((iCElement.getElementType() == 67 ? 1 : 0) != 0);
        IStructure iStructure = (IStructure)iCElement;
        IStructureTests.assertNotNull((Object)iStructure);
        IStructureTests.assertTrue((boolean)iStructure.isStruct());
        IStructureTests.assertNotNull((Object)iCElement2);
        IStructureTests.assertTrue((iCElement2.getElementType() != 67 ? 1 : 0) != 0);
        IStructure iStructure2 = (IStructure)iCElement2;
        IStructureTests.assertNotNull((Object)iStructure2);
        IStructureTests.assertFalse((boolean)iStructure2.isStruct());
    }

    public void testIsClass() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        ICElement iCElement = null;
        ICElement iCElement2 = null;
        try {
            iCElement = iTranslationUnit.getElement("testClass1");
            iCElement2 = iTranslationUnit.getElement("testStruct1");
        }
        catch (CModelException cModelException) {
            IStructureTests.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
        IStructureTests.assertNotNull((Object)iCElement);
        IStructureTests.assertTrue((iCElement.getElementType() == 65 ? 1 : 0) != 0);
        IStructure iStructure = (IStructure)iCElement;
        IStructureTests.assertNotNull((Object)iStructure);
        IStructureTests.assertTrue((boolean)iStructure.isClass());
        IStructureTests.assertNotNull((Object)iCElement2);
        IStructureTests.assertTrue((iCElement2.getElementType() != 65 ? 1 : 0) != 0);
        IStructure iStructure2 = (IStructure)iCElement2;
        IStructureTests.assertNotNull((Object)iStructure2);
        IStructureTests.assertFalse((boolean)iStructure2.isClass());
    }

    public void testIsAbstract() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        ICElement iCElement = null;
        ICElement iCElement2 = null;
        try {
            iCElement = iTranslationUnit.getElement("testClass4Abstract");
            iCElement2 = iTranslationUnit.getElement("testClass1");
        }
        catch (CModelException cModelException) {
            IStructureTests.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
        IStructureTests.assertNotNull((Object)iCElement);
        IStructureTests.assertTrue((iCElement.getElementType() == 65 ? 1 : 0) != 0);
        IStructure iStructure = (IStructure)iCElement;
        IStructureTests.assertNotNull((Object)iStructure);
        IStructureTests.assertTrue((boolean)iStructure.isAbstract());
        IStructureTests.assertNotNull((Object)iCElement2);
        IStructureTests.assertTrue((iCElement2.getElementType() == 65 ? 1 : 0) != 0);
        IStructure iStructure2 = (IStructure)iCElement2;
        IStructureTests.assertNotNull((Object)iStructure2);
        IStructureTests.assertFalse((boolean)iStructure2.isAbstract());
    }

    public void testGetBaseTypes() {
        String[] stringArray;
        ITranslationUnit iTranslationUnit = this.getTU();
        ICElement iCElement = null;
        String[] stringArray2 = null;
        try {
            iCElement = iTranslationUnit.getElement("testClass5");
            IStructureTests.assertNotNull((Object)iCElement);
            IStructureTests.assertTrue((iCElement.getElementType() == 65 ? 1 : 0) != 0);
            stringArray = (String[])iCElement;
            IStructureTests.assertNotNull((Object)stringArray);
            stringArray2 = stringArray.getSuperClassesNames();
        }
        catch (CModelException cModelException) {
            IStructureTests.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
        stringArray = new String[]{"testClass1", "testClass3", "testClass4Abstract"};
        IStructureTests.assertEquals((int)stringArray.length, (int)stringArray2.length);
        int n = 0;
        while (n < stringArray2.length) {
            IStructureTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)stringArray2[n]);
            ++n;
        }
    }

    public void testGetAccessControl() {
        ITranslationUnit iTranslationUnit = this.getTU();
        ICElement iCElement = null;
        String[] stringArray = null;
        try {
            iCElement = iTranslationUnit.getElement("testClass5");
            IStructureTests.assertNotNull((Object)iCElement);
            IStructureTests.assertTrue((iCElement.getElementType() == 65 ? 1 : 0) != 0);
            IStructure iStructure = (IStructure)iCElement;
            IStructureTests.assertNotNull((Object)iStructure);
            stringArray = iStructure.getSuperClassesNames();
            ASTAccessVisibility[] aSTAccessVisibilityArray = new ASTAccessVisibility[]{ASTAccessVisibility.PUBLIC, ASTAccessVisibility.PROTECTED, ASTAccessVisibility.PRIVATE};
            IStructureTests.assertEquals((int)aSTAccessVisibilityArray.length, (int)stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                ASTAccessVisibility aSTAccessVisibility = iStructure.getSuperClassAccess(stringArray[n]);
                IStructureTests.assertEquals((String)("Failed on " + n), (Object)aSTAccessVisibilityArray[n], (Object)aSTAccessVisibility);
                ++n;
            }
        }
        catch (CModelException cModelException) {
            IStructureTests.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
    }

    public void testGetStructureInfo() {
    }

    public void testAnonymousStructObject() {
        ITranslationUnit iTranslationUnit = this.getTU();
        ICElement iCElement = null;
        try {
            iCElement = iTranslationUnit.getElement("testAnonymousStructObject1");
        }
        catch (CModelException cModelException) {
            IStructureTests.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
        IStructureTests.assertNotNull((Object)iCElement);
        IStructureTests.assertEquals((int)76, (int)iCElement.getElementType());
    }

    public void testInnerStruct() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        ICElement iCElement = null;
        try {
            iCElement = iTranslationUnit.getElement("testStruct8");
        }
        catch (CModelException cModelException) {
            IStructureTests.assertNotNull((String)"CModelException thrown", (Object)((Object)cModelException));
        }
        IStructureTests.assertNotNull((Object)iCElement);
        IStructure iStructure = (IStructure)iCElement;
        IStructureTests.assertNotNull((Object)iStructure);
        String[] stringArray = new String[]{"testStruct9Inner", "testStruct10Inner"};
        List list = iStructure.getChildrenOfType(67);
        IStructureTests.assertEquals((int)stringArray.length, (int)list.size());
        int n = 0;
        while (n < stringArray.length) {
            IStructure iStructure2 = (IStructure)list.get(n);
            IStructureTests.assertNotNull((String)("Failed on " + n), (Object)iStructure2);
            IStructureTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iStructure2.getElementName());
            ++n;
        }
    }
}

