/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.tests.IntegratedCModelTest;

public class ITemplateTests
extends IntegratedCModelTest {
    static /* synthetic */ Class class$0;

    public ITemplateTests(String string) {
        super(string);
    }

    public String getSourcefileSubdir() {
        return "resources/cmodel/";
    }

    public String getSourcefileResource() {
        return "ITemplate.cpp";
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.IStructureTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ITemplateTests("testGetChildrenOfTypeTemplate"));
        testSuite.addTest((Test)new ITemplateTests("testGetNumberOfTemplateParameters"));
        testSuite.addTest((Test)new ITemplateTests("testGetTemplateParameterTypes"));
        testSuite.addTest((Test)new ITemplateTests("testGetTemplateSignature"));
        return testSuite;
    }

    public List getTemplateMethods(ITranslationUnit iTranslationUnit) throws CModelException {
        IStructure iStructure = null;
        try {
            iStructure = (IStructure)iTranslationUnit.getElement("TemplateContainer");
        }
        catch (CModelException cModelException) {
            ITemplateTests.assertNotNull((Object)((Object)cModelException));
        }
        ITemplateTests.assertNotNull((Object)iStructure);
        List list = iStructure.getChildrenOfType(90);
        list.addAll(iStructure.getChildrenOfType(91));
        return list;
    }

    public void testGetChildrenOfTypeTemplate() throws CModelException {
        ITemplate iTemplate;
        ICElement iCElement;
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(85);
        String[] stringArray = new String[]{"Map"};
        ITemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        int n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            ITemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            ITemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
        list = iTranslationUnit.getChildrenOfType(83);
        stringArray = new String[]{"nonVector"};
        ITemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            ITemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            ITemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
        list = iTranslationUnit.getChildrenOfType(87);
        stringArray = new String[]{"ArrayOverlay"};
        ITemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            ITemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            ITemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
        list = this.getTemplateMethods(iTranslationUnit);
        stringArray = new String[]{"fum", "scrum"};
        ITemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            ITemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            ITemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
        list = iTranslationUnit.getChildrenOfType(89);
        stringArray = new String[]{"nonVector<T>::first", "Foo::fum"};
        ITemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            ITemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            ITemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
        list = iTranslationUnit.getChildrenOfType(88);
        stringArray = new String[]{"IsGreaterThan"};
        ITemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            ITemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            ITemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
    }

    public void testGetNumberOfTemplateParameters() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(iTranslationUnit.getChildrenOfType(85));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(83));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(87));
        arrayList.addAll(this.getTemplateMethods(iTranslationUnit));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(89));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(88));
        int[] nArray = new int[]{3, 1, 3, 1, 1, 1, 1, 1};
        ITemplateTests.assertEquals((int)nArray.length, (int)arrayList.size());
        int n = 0;
        while (n < nArray.length) {
            ITemplate iTemplate = (ITemplate)arrayList.get(n);
            ITemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            ITemplateTests.assertEquals((String)("Failed on " + n), (int)nArray[n], (int)iTemplate.getNumberOfTemplateParameters());
            ++n;
        }
    }

    public void testGetTemplateParameterTypes() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(iTranslationUnit.getChildrenOfType(85));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(83));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(87));
        arrayList.addAll(this.getTemplateMethods(iTranslationUnit));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(89));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(88));
        String[][] stringArrayArray = new String[][]{{"Key", "Value", "SortAlgorithm"}, {"T"}, {"X", "Y", "int=16"}, {"Bar"}, {"int"}, {"T"}, {"Bar"}, {"X"}};
        ITemplateTests.assertEquals((int)stringArrayArray.length, (int)arrayList.size());
        int n = 0;
        while (n < stringArrayArray.length) {
            ITemplate iTemplate = (ITemplate)arrayList.get(n);
            ITemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            String[] stringArray = stringArrayArray[n];
            String[] stringArray2 = iTemplate.getTemplateParameterTypes();
            ITemplateTests.assertEquals((String)("Failed on " + n), (int)stringArray.length, (int)stringArray2.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                ITemplateTests.assertEquals((String)("Failed on " + n + "," + n2), (String)stringArray[n2], (String)stringArray2[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void testGetTemplateSignature() throws CModelException {
        ITranslationUnit iTranslationUnit = this.getTU();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(iTranslationUnit.getChildrenOfType(85));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(83));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(87));
        arrayList.addAll(this.getTemplateMethods(iTranslationUnit));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(89));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(88));
        String[] stringArray = new String[]{"Map<Key, Value, SortAlgorithm>", "nonVector<T>", "ArrayOverlay<X, Y, int=16>", "fum<Bar>(int) : void", "scrum<int>(void) : void", "nonVector<T>::first<T>() : const T&", "Foo::fum<Bar>(int) : void", "IsGreaterThan<X>(X, X) : bool"};
        ITemplateTests.assertEquals((int)stringArray.length, (int)arrayList.size());
        int n = 0;
        while (n < stringArray.length) {
            ITemplate iTemplate = (ITemplate)arrayList.get(n);
            ITemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            ITemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iTemplate.getTemplateSignature());
            ++n;
        }
    }
}

