/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.tests.ITemplateTests;

public class StructuralTemplateTests
extends ITemplateTests {
    static /* synthetic */ Class class$0;

    public StructuralTemplateTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.StructuralTemplateTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new StructuralTemplateTests("testGetChildrenOfTypeTemplate"));
        testSuite.addTest((Test)new StructuralTemplateTests("testGetNumberOfTemplateParameters"));
        testSuite.addTest((Test)new StructuralTemplateTests("testGetTemplateParameterTypes"));
        testSuite.addTest((Test)new StructuralTemplateTests("testGetTemplateSignature"));
        return testSuite;
    }

    public void testGetChildrenOfTypeTemplate() throws CModelException {
        ITemplate iTemplate;
        ICElement iCElement;
        this.setStructuralParse(true);
        ITranslationUnit iTranslationUnit = this.getTU();
        List list = iTranslationUnit.getChildrenOfType(85);
        String[] stringArray = new String[]{"Map"};
        StructuralTemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        int n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            StructuralTemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            StructuralTemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
        list = iTranslationUnit.getChildrenOfType(83);
        stringArray = new String[]{"nonVector"};
        StructuralTemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            StructuralTemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            StructuralTemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
        list = iTranslationUnit.getChildrenOfType(87);
        stringArray = new String[]{"ArrayOverlay"};
        StructuralTemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            StructuralTemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            StructuralTemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
        list = this.getTemplateMethods(iTranslationUnit);
        list.addAll(iTranslationUnit.getChildrenOfType(89));
        list.addAll(iTranslationUnit.getChildrenOfType(91));
        list.addAll(iTranslationUnit.getChildrenOfType(88));
        stringArray = new String[]{"fum", "scrum", "nonVector::first", "Foo::fum", "IsGreaterThan"};
        StructuralTemplateTests.assertEquals((int)stringArray.length, (int)list.size());
        n = 0;
        while (n < stringArray.length) {
            iCElement = (ICElement)list.get(n);
            iTemplate = (ITemplate)iCElement;
            StructuralTemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            StructuralTemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iCElement.getElementName());
            ++n;
        }
    }

    public void testGetNumberOfTemplateParameters() throws CModelException {
        this.setStructuralParse(true);
        ITranslationUnit iTranslationUnit = this.getTU();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(iTranslationUnit.getChildrenOfType(85));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(83));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(87));
        arrayList.addAll(this.getTemplateMethods(iTranslationUnit));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(89));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(88));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(91));
        int[] nArray = new int[]{3, 1, 3, 1, 1, 1, 1, 1};
        StructuralTemplateTests.assertEquals((int)nArray.length, (int)arrayList.size());
        int n = 0;
        while (n < nArray.length) {
            ITemplate iTemplate = (ITemplate)arrayList.get(n);
            StructuralTemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            StructuralTemplateTests.assertEquals((String)("Failed on " + n), (int)nArray[n], (int)iTemplate.getNumberOfTemplateParameters());
            ++n;
        }
    }

    public void testGetTemplateParameterTypes() throws CModelException {
        this.setStructuralParse(true);
        ITranslationUnit iTranslationUnit = this.getTU();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(iTranslationUnit.getChildrenOfType(85));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(83));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(87));
        arrayList.addAll(this.getTemplateMethods(iTranslationUnit));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(89));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(91));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(88));
        String[][] stringArrayArray = new String[][]{{"Key", "Value", "SortAlgorithm"}, {"T"}, {"X", "Y", "int=16"}, {"Bar"}, {"int"}, {"T"}, {"Bar"}, {"X"}};
        StructuralTemplateTests.assertEquals((int)stringArrayArray.length, (int)arrayList.size());
        int n = 0;
        while (n < stringArrayArray.length) {
            ITemplate iTemplate = (ITemplate)arrayList.get(n);
            StructuralTemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            String[] stringArray = stringArrayArray[n];
            String[] stringArray2 = iTemplate.getTemplateParameterTypes();
            StructuralTemplateTests.assertEquals((String)("Failed on " + n), (int)stringArray.length, (int)stringArray2.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                StructuralTemplateTests.assertEquals((String)("Failed on " + n + "," + n2), (String)stringArray[n2], (String)stringArray2[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void testGetTemplateSignature() throws CModelException {
        this.setStructuralParse(true);
        ITranslationUnit iTranslationUnit = this.getTU();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(iTranslationUnit.getChildrenOfType(85));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(83));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(87));
        arrayList.addAll(this.getTemplateMethods(iTranslationUnit));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(89));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(91));
        arrayList.addAll(iTranslationUnit.getChildrenOfType(88));
        String[] stringArray = new String[]{"Map<Key, Value, SortAlgorithm>", "nonVector<T>", "ArrayOverlay<X, Y, int=16>", "fum<Bar>(int) : void", "scrum<int>(void) : void", "nonVector::first<T>() : const T&", "Foo::fum<Bar>(int) : void", "IsGreaterThan<X>(X, X) : bool"};
        StructuralTemplateTests.assertEquals((int)stringArray.length, (int)arrayList.size());
        int n = 0;
        while (n < stringArray.length) {
            ITemplate iTemplate = (ITemplate)arrayList.get(n);
            StructuralTemplateTests.assertNotNull((String)("Failed on " + n), (Object)iTemplate);
            StructuralTemplateTests.assertEquals((String)("Failed on " + n), (String)stringArray[n], (String)iTemplate.getTemplateSignature());
            ++n;
        }
    }
}

