/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileNotFoundException;
import java.util.Stack;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.tests.TranslationUnitBaseTest;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.util.ExpectedStrings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class TranslationUnitTests
extends TranslationUnitBaseTest {
    String[] expectedStringList = new String[]{"stdio.h", "unistd.h", "func2p", "globalvar", "myenum", "mystruct", "mystruct_t", "myunion", "mytype", "func1", "func2", "main", "func3"};
    int[] expectedLines = new int[]{12, 14, 17, 20, 23, 28, 32, 35, 42, 47, 53, 58, 65, 70};
    int[] expectedTypes = new int[]{75, 75, 73, 76, 63, 67, 80, 69, 80, 74, 74, 74, 74, 74};
    static /* synthetic */ Class class$0;

    public TranslationUnitTests(String string) {
        super(string);
    }

    public static TestSuite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.TranslationUnitTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new TranslationUnitTests("testIsTranslationUnit"));
        testSuite.addTest((Test)new TranslationUnitTests("testGetChildren"));
        testSuite.addTest((Test)new TranslationUnitTests("testGetElement"));
        testSuite.addTest((Test)new TranslationUnitTests("testBug23478A"));
        testSuite.addTest((Test)new TranslationUnitTests("testBug23478B"));
        testSuite.addTest((Test)new TranslationUnitTests("testIsValidSourceUnitName"));
        return testSuite;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TranslationUnitTests.suite());
    }

    public void testIsTranslationUnit() throws CoreException, FileNotFoundException {
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        TranslationUnitTests.assertTrue((String)"A TranslationUnit", (iTranslationUnit != null ? 1 : 0) != 0);
    }

    public void testGetChildren() throws CModelException {
        ExpectedStrings expectedStrings = new ExpectedStrings(this.expectedStringList);
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        if (iTranslationUnit.hasChildren()) {
            ICElement[] iCElementArray = iTranslationUnit.getChildren();
            int n = 0;
            while (n < iCElementArray.length) {
                expectedStrings.foundString(iCElementArray[n].getElementName());
                ++n;
            }
        }
        TranslationUnitTests.assertTrue((String)("PR:23603 " + expectedStrings.getMissingString()), (boolean)expectedStrings.gotAll());
        TranslationUnitTests.assertTrue((String)expectedStrings.getExtraString(), (!expectedStrings.gotExtra() ? 1 : 0) != 0);
    }

    public void testGetElement() throws CModelException {
        Stack<String> stack = new Stack<String>();
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        int n = 0;
        while (n < this.expectedStringList.length) {
            ICElement iCElement = iTranslationUnit.getElement(this.expectedStringList[n]);
            if (iCElement == null) {
                stack.push(this.expectedStringList[n]);
            } else {
                TranslationUnitTests.assertTrue((String)("Expected:" + this.expectedStringList[n] + " Got:" + iCElement.getElementName()), (boolean)this.expectedStringList[n].equals(iCElement.getElementName()));
            }
            ++n;
        }
        if (!stack.empty()) {
            String string = new String("PR:23603 Could not get elements: ");
            while (!stack.empty()) {
                string = String.valueOf(string) + stack.pop() + " ";
            }
            TranslationUnitTests.assertTrue((String)string, (boolean)false);
        }
    }

    public void testBug23478A() throws CModelException {
        String[] stringArray = new String[]{"stdio.h", "unistd.h"};
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        int n = 0;
        while (n < stringArray.length) {
            IInclude iInclude = iTranslationUnit.getInclude(stringArray[n]);
            if (iInclude == null) {
                TranslationUnitTests.fail((String)("Unable to get include: " + stringArray[n]));
            } else {
                TranslationUnitTests.assertTrue((String)("PR:23478 Expected:" + new String("") + " Got:" + iInclude.getIncludeName()), (boolean)stringArray[n].equals(iInclude.getIncludeName()));
            }
            ++n;
        }
    }

    public void testBug23478B() throws CModelException {
        String[] stringArray = new String[]{"stdio.h", "unistd.h"};
        ExpectedStrings expectedStrings = new ExpectedStrings(stringArray);
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        IInclude[] iIncludeArray = iTranslationUnit.getIncludes();
        int n = 0;
        while (n < iIncludeArray.length) {
            expectedStrings.foundString(iIncludeArray[n].getIncludeName());
            ++n;
        }
        TranslationUnitTests.assertTrue((String)expectedStrings.getMissingString(), (boolean)expectedStrings.gotAll());
        TranslationUnitTests.assertTrue((String)expectedStrings.getExtraString(), (!expectedStrings.gotExtra() ? 1 : 0) != 0);
    }

    public void testGetElementAtLine() throws CoreException {
        Stack<String> stack = new Stack<String>();
        ITranslationUnit iTranslationUnit = CProjectHelper.findTranslationUnit(this.testProject, "exetest.c");
        int n = 0;
        while (n < this.expectedStringList.length) {
            ICElement iCElement = iTranslationUnit.getElementAtLine(this.expectedLines[n]);
            if (iCElement == null) {
                stack.push(this.expectedStringList[n]);
            } else if (this.expectedStringList[n].equals("mystruct_t")) {
                TranslationUnitTests.assertTrue((String)("PR:23603 expected:" + this.expectedStringList[n] + " Got:" + iCElement.getElementName()), (boolean)this.expectedStringList[n].equals(iCElement.getElementName()));
            } else {
                TranslationUnitTests.assertTrue((String)("Expected:" + this.expectedStringList[n] + " Got:" + iCElement.getElementName()), (boolean)this.expectedStringList[n].equals(iCElement.getElementName()));
            }
            ++n;
        }
        if (!stack.empty()) {
            String string = new String("PR: 23603 Could not get elements: ");
            while (!stack.empty()) {
                string = String.valueOf(string) + stack.pop() + " ";
            }
            TranslationUnitTests.assertTrue((String)string, (boolean)false);
        }
    }

    public void testIsValidSourceUnitName() {
        TranslationUnitTests.assertTrue((boolean)CoreModel.isValidSourceUnitName((IProject)this.testProject.getProject(), (String)"test.c"));
        TranslationUnitTests.assertFalse((boolean)CoreModel.isValidSourceUnitName((IProject)this.testProject.getProject(), (String)"test.h"));
        TranslationUnitTests.assertTrue((boolean)CoreModel.isValidSourceUnitName((IProject)this.testProject.getProject(), (String)"test.cc"));
        TranslationUnitTests.assertFalse((boolean)CoreModel.isValidSourceUnitName((IProject)this.testProject.getProject(), (String)"test.hh"));
    }
}

