/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.cdt.core.testplugin.TestPluginLauncher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WorkingCopyTests
extends TestCase {
    private ICProject fCProject;
    private IFile headerFile;
    private NullProgressMonitor monitor;
    static /* synthetic */ Class class$0;

    public static void main(String[] stringArray) {
        String string = TestPluginLauncher.getLocationFromProperties();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.WorkingCopyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestPluginLauncher.run(string, clazz, stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.WorkingCopyTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new WorkingCopyTests("testWorkingCopy"));
        return testSuite;
    }

    public WorkingCopyTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.monitor = new NullProgressMonitor();
        this.fCProject = CProjectHelper.createCCProject("TestProject1", "bin");
        this.headerFile = this.fCProject.getProject().getFile("WorkingCopyTest.h");
        if (!this.headerFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/cfiles/WorkingCopyTestStart.h")));
                this.headerFile.create((InputStream)fileInputStream, false, (IProgressMonitor)this.monitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    protected void tearDown() {
        CProjectHelper.delete(this.fCProject);
    }

    public void testWorkingCopy() throws Exception {
        ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(this.headerFile);
        WorkingCopyTests.assertNotNull((Object)iTranslationUnit);
        IWorkingCopy iWorkingCopy = iTranslationUnit.getWorkingCopy();
        WorkingCopyTests.assertNotNull((Object)iWorkingCopy);
        WorkingCopyTests.assertNotNull((Object)iWorkingCopy.getBuffer());
        WorkingCopyTests.assertTrue((boolean)iWorkingCopy.exists());
        IBuffer iBuffer = iWorkingCopy.getBuffer();
        iBuffer.append("\n class Hello{ int x; };");
        if (iTranslationUnit.getBuffer().getContents().equals(iWorkingCopy.getBuffer().getContents())) {
            WorkingCopyTests.fail((String)"Buffers should NOT be equal at this point!");
        }
        iWorkingCopy.reconcile();
        iWorkingCopy.commit(true, (IProgressMonitor)this.monitor);
        if (!iTranslationUnit.getBuffer().getContents().equals(iWorkingCopy.getBuffer().getContents())) {
            WorkingCopyTests.fail((String)"Buffers should be equal at this point!");
        }
        iWorkingCopy.destroy();
        WorkingCopyTests.assertFalse((boolean)iWorkingCopy.exists());
        Thread.sleep(1000L);
    }
}

