/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.tests.AutomatedTest;

public abstract class AutomatedFramework
extends TestCase {
    protected static ISourceElementRequestor nullCallback = new NullSourceElementRequestor();
    protected static Properties properties = new Properties();
    protected static String defaultNature;
    protected static String outputFile;
    protected static HashMap testSources;
    protected static HashMap natures;
    protected static LinkedList fileList;
    private static FilenameFilter nameFilter;
    protected static FileOutputStream report;

    static {
        outputFile = null;
        testSources = new HashMap();
        natures = new HashMap();
        fileList = new LinkedList();
        nameFilter = new Filter();
        report = null;
    }

    public AutomatedFramework() {
    }

    public AutomatedFramework(String string) {
        super(string);
    }

    protected abstract AutomatedFramework newTest(String var1);

    protected abstract void loadProperties() throws Exception;

    public abstract void doFile() throws Throwable;

    private void fillSuite(TestSuite testSuite, File file) {
        File[] fileArray = null;
        fileArray = file.isFile() ? new File[]{file} : file.listFiles();
        File file2 = null;
        String string = null;
        int n = 0;
        try {
            file2 = fileArray[n++];
            while (file2 != null) {
                if (file2.isDirectory()) {
                    this.fillSuite(testSuite, file2);
                } else if (file2.isFile() && nameFilter.accept(file2.getParentFile(), file2.getName())) {
                    try {
                        string = file2.getCanonicalPath();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (string.endsWith(".cpp") || string.endsWith(".hpp") || string.endsWith(".cc") || string.endsWith(".CC") || string.endsWith(".C") || string.endsWith(".hxx") || string.endsWith(".hh")) {
                        AutomatedTest.natures.put(string, "cpp");
                    } else if (string.endsWith(".c")) {
                        AutomatedTest.natures.put(string, "c");
                    } else {
                        AutomatedTest.natures.put(string, AutomatedTest.defaultNature);
                    }
                    AutomatedTest.fileList.add(file2);
                    testSuite.addTest((Test)this.newTest(file2.getName().replace(',', '_')));
                }
                file2 = fileArray[n++];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void reportFailed() {
        AutomatedFramework.fail((String)("Unable to open " + outputFile + "for output of results."));
    }

    public void propertiesFailed() {
        AutomatedFramework.fail((String)"Unable to load properties file.");
    }

    protected void runTest() throws Throwable {
        String string = this.getName();
        if (string.equals("propertiesFailed")) {
            this.propertiesFailed();
        } else if (string.equals("reportFailed")) {
            this.reportFailed();
        } else {
            this.doFile();
        }
    }

    public Test createSuite() {
        Object object;
        TestSuite testSuite = new TestSuite();
        try {
            this.loadProperties();
        }
        catch (Exception exception) {
            testSuite.addTest((Test)this.newTest("propertiesFailed"));
        }
        if (outputFile != null && !outputFile.equals("")) {
            try {
                object = new File(outputFile);
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
                ((File)object).createNewFile();
                report = new FileOutputStream((File)object);
            }
            catch (Exception exception) {
                testSuite.addTest((Test)this.newTest("reportFailed"));
            }
        }
        object = testSources.keySet();
        Iterator iterator = object.iterator();
        int n = object.size();
        String string = null;
        int n2 = n;
        while (n2 > 0) {
            string = (String)iterator.next();
            File file = new File(string);
            if (file.exists()) {
                defaultNature = (String)testSources.get(string);
                this.fillSuite(testSuite, file);
            }
            --n2;
        }
        return testSuite;
    }

    private static class Filter
    implements FilenameFilter {
        private Filter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".cpp") || string.endsWith(".c") || string.endsWith(".cc") || string.endsWith(".CC") || string.endsWith(".C") || string.endsWith(".h") || string.endsWith(".hh") || string.endsWith(".hpp") || string.endsWith(".hxx");
        }
    }
}

