/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.QuickParseCallback;

public class BaseASTTest
extends TestCase {
    protected ProblemCallback quickParseCallback;
    protected IParser parser;

    public BaseASTTest(String string) {
        super(string);
    }

    protected IASTCompilationUnit parse(String string, boolean bl, boolean bl2, ParserLanguage parserLanguage) throws ParserException, ParserFactoryError {
        ParserMode parserMode = bl ? ParserMode.QUICK_PARSE : ParserMode.COMPLETE_PARSE;
        this.quickParseCallback = new ProblemCallback();
        this.parser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(string.toCharArray()), (IScannerInfo)new ScannerInfo(), (ParserMode)parserMode, (ParserLanguage)parserLanguage, (ISourceElementRequestor)this.quickParseCallback, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)this.quickParseCallback, (ParserMode)parserMode, (ParserLanguage)parserLanguage, null);
        if (!this.parser.parse() && bl2) {
            throw new ParserException("Parse failure");
        }
        return this.quickParseCallback.getCompilationUnit();
    }

    protected IASTCompilationUnit parse(String string, boolean bl, boolean bl2) throws ParserException, ParserFactoryError {
        return this.parse(string, bl, bl2, ParserLanguage.CPP);
    }

    protected IASTCompilationUnit parse(String string) throws ParserException, ParserFactoryError {
        return this.parse(string, true, true);
    }

    protected IASTCompilationUnit fullParse(String string) throws ParserException, ParserFactoryError {
        return this.parse(string, false, true);
    }

    protected IASTDeclaration assertSoleDeclaration(String string) throws ParserException, ParserFactoryError {
        return this.assertSoleDeclaration(string, ParserLanguage.CPP);
    }

    protected IASTDeclaration assertSoleDeclaration(String string, ParserLanguage parserLanguage) throws ParserException, ParserFactoryError {
        Iterator iterator = null;
        try {
            iterator = this.parse(string, true, true, parserLanguage).getDeclarations();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
        BaseASTTest.assertNotNull(iterator);
        BaseASTTest.assertTrue((boolean)iterator.hasNext());
        IASTDeclaration iASTDeclaration = (IASTDeclaration)iterator.next();
        BaseASTTest.assertFalse((boolean)iterator.hasNext());
        return iASTDeclaration;
    }

    public void assertCodeFailsParse(String string) {
        this.assertCodeFailsParse(string, true, true, ParserLanguage.CPP);
    }

    public void assertCodeFailsParse(String string, boolean bl, boolean bl2, ParserLanguage parserLanguage) {
        boolean bl3;
        block3: {
            bl3 = false;
            try {
                this.parse(string, bl, bl2, parserLanguage);
                bl3 = true;
                BaseASTTest.fail((String)"We should not reach this point");
            }
            catch (Throwable throwable) {
                if (throwable instanceof ParserException) break block3;
                BaseASTTest.fail((String)("Unexpected Error: " + throwable.getMessage()));
            }
        }
        if (bl3) {
            BaseASTTest.fail((String)"The expected error did not occur.");
        }
    }

    public void assertCodeFailsFullParse(String string) {
        boolean bl;
        block3: {
            bl = false;
            try {
                this.fullParse(string);
                bl = true;
                BaseASTTest.fail((String)"We should not reach this point");
            }
            catch (Throwable throwable) {
                if (throwable instanceof ParserException) break block3;
                BaseASTTest.fail((String)("Unexpected Error: " + throwable.getMessage()));
            }
        }
        if (bl) {
            BaseASTTest.fail((String)"The expected error did not occur.");
        }
    }

    protected void assertSimpleReturnType(IASTFunction iASTFunction, IASTSimpleTypeSpecifier.Type type) {
        BaseASTTest.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier()).getType(), (Object)type);
    }

    protected void assertSimpleType(IASTTypedefDeclaration iASTTypedefDeclaration, IASTSimpleTypeSpecifier.Type type) {
        BaseASTTest.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier()).getType(), (Object)type);
    }

    protected void assertSimpleType(IASTVariable iASTVariable, IASTSimpleTypeSpecifier.Type type) {
        BaseASTTest.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getType(), (Object)type);
    }

    protected void assertParameterSimpleType(IASTParameterDeclaration iASTParameterDeclaration, IASTSimpleTypeSpecifier.Type type) {
        BaseASTTest.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTParameterDeclaration.getTypeSpecifier()).getType(), (Object)type);
    }

    protected void failedAsExpected() {
        BaseASTTest.assertFalse((String)"The expected error did not occur.", (boolean)false);
    }

    protected void assertNotReached() {
        BaseASTTest.fail((String)"We should not reach this point");
    }

    protected void assertQualifiedName(String[] stringArray, String[] stringArray2) {
        BaseASTTest.assertNotNull((Object)stringArray);
        BaseASTTest.assertNotNull((Object)stringArray2);
        BaseASTTest.assertEquals((int)stringArray.length, (int)stringArray2.length);
        int n = 0;
        while (n < stringArray.length) {
            BaseASTTest.assertEquals((String)stringArray[n], (String)stringArray2[n]);
            ++n;
        }
    }

    public class ProblemCallback
    extends QuickParseCallback
    implements ISourceElementRequestor {
        List problems = new ArrayList();

        public boolean acceptProblem(IProblem iProblem) {
            this.problems.add(iProblem);
            return super.acceptProblem(iProblem);
        }
    }
}

