/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.Iterator;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;

public class CompleteParseASTExpressionTest
extends CompleteParseBaseTest {
    public CompleteParseASTExpressionTest(String string) {
        super(string);
    }

    public void testPrimaryEmpty() throws Exception {
        Iterator iterator = this.parse("int f(char); \r\n int f(void); \r\n int x = f();").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f()");
    }

    public void testPrimaryIntegerLiteral() throws Exception {
        Iterator iterator = this.parse("int f(int, int); \n int f(int); \n int x = f(1, 2+3);").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(1, 2 + 3)");
    }

    public void testPrimaryCharLiteral() throws Exception {
        Iterator iterator = this.parse("int f(char, int); \n int f(char); \n int x = f('c');").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f('c')");
    }

    public void testPrimaryFloatLiteral() throws Exception {
        Iterator iterator = this.parse("int f(char); \n int f(float); \n int x = f(1.13);").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(1.13)");
    }

    public void testPrimaryStringLiteral() throws Exception {
        Iterator iterator = this.parse("int f(char); \n int f(char*); \n int x = f(\"str\");").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(\"str\")");
    }

    public void testPrimaryBooleanLiteral() throws Exception {
        Iterator iterator = this.parse("int f(bool); \n int f(float); \n int x = f(true);").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(true)");
    }

    public void testPrimaryThis() throws Exception {
        Iterator iterator = this.parse("class A{ int m(); }; A a;  \n int f(void); \n int f(A * a); \n int A::m(){ int x = f(this); }").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator2.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_2 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        this.callback.getReferences().iterator();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        Iterator iterator3 = this.getDeclarations((IASTScope)iASTMethod);
        IASTVariable iASTVariable = (IASTVariable)iterator3.next();
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(this)");
    }

    public void testPrimaryBracketedExpression() throws Exception {
        Iterator iterator = this.parse("int f(int, int); \n int f(int); \n int x = f(1, (2+3));").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(1, (2 + 3))");
    }

    public void testIdExpression() throws Exception {
        Iterator iterator = this.parse("class A{}a;  \n int f(A a); \n int f(void); \n int x = f(a);").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(a)");
    }

    public void testIdExpressionToPointer() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A * pa; \n int f(A *ia){} \n int f(void); \n int x = f(pa);").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(pa)");
    }

    public void testPostfixSubscript() throws Exception {
        Iterator iterator = this.parse("int pa[10]; \n int f(int ia){} \n int f(void); \n int x = f(pa[1]);").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(pa[1])");
    }

    public void testPostfixSubscriptA() throws Exception {
        Iterator iterator = this.parse("int pa[10][5] ; \n int f(int ia){} \n int f(void); \n int x = f(pa[1][2]);").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(pa[1][2])");
    }

    public void testPostfixSubscriptB() throws Exception {
        Iterator iterator = this.parse("int* pa[10][5] ; \n int f(int* ia){} \n int f(void); \n int x = f(pa[1][2]);").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(pa[1][2])");
    }

    public void testPostfixSubscriptWithReferences() throws Exception {
        Iterator iterator = this.parse("class A{}; \n A *pa[10][5] ; \n int f(A* ia){} \n int f(void); \n int x = f(pa[1][2]);").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
    }

    public void testPostfixFunctioncallBug42822() throws Exception {
        Iterator iterator = this.parse("int foo( float b );  int bar( int a, int b ); int test( void ) { int x = bar( foo( 3.0 ), foo( 5.0 ) ) ; }").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction3 = (IASTFunction)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction, 2)));
        iterator = this.getDeclarations((IASTScope)iASTFunction3);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"bar(foo(3.0), foo(5.0))");
    }

    public void testPostfixSimpletypesBug42823() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo( int anInt, short aShort, double aDouble, float aFloat, char aChar, wchar_t aWchar, signed aSigned, unsigned anUnsigned, bool aBool, long aLong );");
        stringBuffer.append("void test( void ) { int someInt = foo( int(3), short(4), double(3.0), float(4.0), char( 'a'), wchar_t( 'a' ), signed( 2 ), unsigned( 3 ), bool( false ), long( 3L ) ); }");
        Iterator iterator = this.parse(stringBuffer.toString()).getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        iterator = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(int(3), short(4), double(3.0), float(4.0), char('a'), wchar_t('a'), signed(2), unsigned(3), bool(false), long(3L))");
    }

    public void testPostfixTypenameIdentifier() throws Exception {
        Iterator iterator = this.parse("class A {}; \n int foo(); int foo( A a ); \n int x = foo( typename A() );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(typename A())");
    }

    public void testPostfixTypeNameTemplateId() throws Exception {
        Iterator iterator = this.parse(" template<class T> class A {}; int foo( A<int> a ); \n int x = foo( typename template A< int >() );").getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(typename template A<int>())");
    }

    public void testPostfixTypeNameTemplateId_2() throws Exception {
        Iterator iterator = this.parse("namespace NS{ template<class T> class A {}; } int foo( NS::A<int> a ); \n int x = foo( typename NS::template A< int >() );").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        iterator = this.getDeclarations((IASTScope)iASTNamespaceDefinition);
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        this.assertAllReferences(5, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTNamespaceDefinition, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(typename NS::template A<int>())");
    }

    public void testPostfixDotExpression() throws Exception {
        Iterator iterator = this.parse("class A {int m;}; \n A  a; \n int foo(char); int foo( int ); \n int x = foo( a.m );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a.m)");
    }

    public void testPostfixArrowExpression() throws Exception {
        Iterator iterator = this.parse("class A {int m;}; \n A * a; \n int foo(char); int foo( int ); \n int x = foo( a->m );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTClassSpecifier);
        IASTField iASTField = (IASTField)iterator2.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTField), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a->m)");
    }

    public void testPostfixIncrement() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); void test( void ) { int x = 5; int y = foo( x++ ); } ").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator2.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator2.hasNext());
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"5");
        iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(x++)");
    }

    public void testPostfixDecrement() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); void test( void ) { int x = 5; int y = foo( x-- ); } ").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator2.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator2.hasNext());
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"5");
        iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(x--)");
    }

    public void testPostfixDynamicCast() throws Exception {
        Iterator iterator = this.parse("class A {}; class B : public A{}; \n A *a; \n int foo(); int foo( B* ); \n int x = foo( dynamic_cast<B*>(a) );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(6, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(dynamic_cast<B*>(a))");
    }

    public void testPostfixReinterpretCast() throws Exception {
        Iterator iterator = this.parse("int *a; \n int foo(); int foo( double* ); \n int x = foo( reinterpret_cast<double *>(a) );").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(reinterpret_cast<double *>(a))");
    }

    public void testPostfixStaticCast() throws Exception {
        Iterator iterator = this.parse("int a; \n int foo(); int foo( char ); \n int x = foo( static_cast<char>(a) );").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(static_cast<char>(a))");
    }

    public void testPostfixConstCast() throws Exception {
        Iterator iterator = this.parse("const int a; \n int foo(); int foo( int * ); \n int x = foo( const_cast<int *>(&a) );").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(const_cast<int *>(&a))");
    }

    public void testPostfixTypeIdExpression() throws Exception {
        Iterator iterator = this.parse("int foo(char); int foo( int ); \n int x = foo( typeid(5) );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(typeid(5))");
    }

    public void testPostfixTypeIdExpression2() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A  a; \n int foo(A); int foo( int ); \n int x = foo( typeid(a) );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(typeid(a))");
    }

    public void testPostfixTypeIdTypeId() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A  a; \n int foo(A); int foo( int ); \n int x = foo( typeid(A) );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(typeid(A))");
    }

    public void testPostfixTypeIdTypeId2() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A  a; \n int foo(A); int foo( int ); \n int x = foo( typeid(const A) );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable cfr_ignored_0 = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(typeid(const A))");
    }

    public void testUnaryIncrement() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); void test( void ) { int x = 5; int y = foo( ++x ); } ").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator2.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator2.hasNext());
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"5");
        iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(++x)");
    }

    public void testUnaryDecrement() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); void test( void ) { int x = 5; int y = foo( --x ); } ").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction iASTFunction2 = (IASTFunction)iterator.next();
        Iterator iterator2 = this.getDeclarations((IASTScope)iASTFunction2);
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator2.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator2.hasNext());
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"5");
        iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(--x)");
    }

    public void testUnaryStarCastExpression() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A * pa; \n int f(A ia){} \n int f(void); \n int x = f(*pa);").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(*pa)");
    }

    public void testUnaryAmpersandCastExpression() throws Exception {
        Iterator iterator = this.parse("class A {}; \n A * pa; \n int f(A ** ia){} \n int f(void); \n int x = f(&pa);").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"f(&pa)");
    }

    public void testUnaryPlusCastExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = foo( +5 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(+5)");
    }

    public void testUnaryMinusCastExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = foo( -5 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(-5)");
    }

    public void testUnaryNotCastExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); bool b=true; int x = foo( !b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(!b)");
    }

    public void testTildeNotCastExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = 5; int y = foo( ~x );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"5");
        iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(~x)");
    }

    public void testUnarySizeofUnaryExpression() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = 5; int y = foo( sizeof(5) );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(1, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"5");
        iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(sizeof (5))");
    }

    public void testUnarySizeofTypeId() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( int ); int x = 5; int y = foo( sizeof(x) );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"5");
        iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(sizeof (x))");
    }

    public void testNewTypeId() throws Exception {
        Iterator iterator = this.parse("class A{}; void foo(); int foo( A * a ); int x = foo( new A() );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(new A())");
    }

    public void testCastExpression() throws Exception {
        Iterator iterator = this.parse("class A {}; class B : public A{}; \n B *b; \n int foo(); int foo( A* ); \n int x = foo( (A*)b );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(6, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2, 1), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo((A*)b)");
    }

    public void testMultiplicativeMultiply() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( a * b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        CompleteParseASTExpressionTest.assertEquals((int)this.callback.getReferences().size(), (int)3);
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a * b)");
    }

    public void testMultiplicativeDivide() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( b / a );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b / a)");
    }

    public void testMultiplicativeModulus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( b % a );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b % a)");
    }

    public void testAdditivePlus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( b + a );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b + a)");
    }

    public void testAdditiveMinus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( float ); int a = 3; float b=5.1 ; int x = foo( b - a );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b - a)");
    }

    public void testShiftLeft() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a << 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a << 5)");
    }

    public void testShiftRight() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a >> 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a >> 5)");
    }

    public void testRelationalLessThan() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b < 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b < 3)");
    }

    public void testRelationalGreaterThan() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b > 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b > 3)");
    }

    public void testRelationalLessThanOrEqual() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b <= 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b <= 3)");
    }

    public void testRelationalGreaterThanOrEqual() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b >= 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b >= 3)");
    }

    public void testEqualityEquals() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b == 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b == 3)");
    }

    public void testEqualityNotEquals() throws Exception {
        Iterator iterator = this.parse("void foo(); int foo( bool ); int b=5; int x = foo( b != 3 );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(b != 3)");
    }

    public void testAndExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( int ); int a = 3; int b= 5; int x = foo( a & b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a & b)");
    }

    public void testExclusiveOrExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( int ); int a = 3; int b= 5; int x = foo( a ^ b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a ^ b)");
    }

    public void testInclusiveOrExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( int ); int a = 3; int b= 5; int x = foo( a | b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a | b)");
    }

    public void testLogicalAndExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( bool ); bool a = true; bool b= false; int x = foo( a && b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a && b)");
    }

    public void testLogicalOrExpression() throws Exception {
        Iterator iterator = this.parse("int foo(); int foo( bool ); bool a = true; bool b= false; int x = foo( a || b );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(3, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable3.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a || b)");
    }

    public void testConditionalExpression() throws Exception {
        Iterator iterator = this.parse("int foo(bool); int foo(int); int a = 10, b = 4, c = 2; int x = foo( a > 5 ? b : c );").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable4 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(4, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable4.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a > 5 ? b : c)");
    }

    public void testConditionalExpressionWithReferencesA() throws Exception {
        Iterator iterator = this.parse("class A{}; class B : public A{}; int foo(); int foo(A*); A *a ; B *b; int c = 0; int x = foo( c > 5 ? b : a );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable4 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(8, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable4.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(c > 5 ? b : a)");
    }

    public void testConditionalExpressionWithReferencesB_Bug43106() throws Exception {
        Iterator iterator = this.parse("class A{}; class B : public A{}; int foo(); int foo(A&); A a ; B b; int c = 0; int x = foo( c > 5 ? b : a );").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        IASTVariable iASTVariable4 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(8, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier, 3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTClassSpecifier2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable3), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable2), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable4.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(c > 5 ? b : a)");
    }

    public void testAssignmentExpressionNormal() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a = 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a = 5)");
    }

    public void testAssignmentExpressionPlus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a += 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a += 5)");
    }

    public void testAssignmentExpressionMinus() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a -= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a -= 5)");
    }

    public void testAssignmentExpressionMulti() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a *= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a *= 5)");
    }

    public void testAssignmentExpressionDiv() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a /= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a /= 5)");
    }

    public void testAssignmentExpressionMod() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a %= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a %= 5)");
    }

    public void testAssignmentExpressionLShift() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a >>= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a >>= 5)");
    }

    public void testAssignmentExpressionRShift() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a <<= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a <<= 5)");
    }

    public void testAssignmentExpressionAnd() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a &= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a &= 5)");
    }

    public void testAssignmentExpressionOr() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a |= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a |= 5)");
    }

    public void testAssignmentExpressionXOr() throws Exception {
        Iterator iterator = this.parse("int foo(int); int foo( bool ); int a = 10; int x = foo( a ^= 5 );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTExpressionTest.assertFalse((boolean)iterator.hasNext());
        this.assertAllReferences(2, this.createTaskList(new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTVariable), new CompleteParseBaseTest.Task((ISourceElementCallbackDelegate)iASTFunction)));
        IASTExpression iASTExpression = iASTVariable2.getInitializerClause().getAssigmentExpression();
        CompleteParseASTExpressionTest.assertEquals((String)iASTExpression.toString(), (String)"foo(a ^= 5)");
    }
}

