/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class CompleteParseASTSymbolIteratorTest
extends CompleteParseBaseTest {
    protected CompilationUnitCallback callback;

    public CompleteParseASTSymbolIteratorTest(String string) {
        super(string);
    }

    protected IASTScope parse(String string, boolean bl, ParserLanguage parserLanguage) throws ParserException, ParserFactoryError {
        this.callback = new CompilationUnitCallback();
        IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(string.toCharArray()), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, (ISourceElementRequestor)this.callback, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)this.callback, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, null);
        if (!iParser.parse() && bl) {
            throw new ParserException("FAILURE");
        }
        return this.callback.getCompilationUnit();
    }

    protected Iterator getDeclarations(IASTScope iASTScope) {
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)false);
        return null;
    }

    public void testEmptyCompilationUnit() throws Exception {
        IASTScope iASTScope = this.parse("// no real code ");
        CompleteParseASTSymbolIteratorTest.assertNotNull((Object)iASTScope);
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTScope.getDeclarations().hasNext());
        try {
            iASTScope.getDeclarations().next();
            CompleteParseASTSymbolIteratorTest.assertTrue((boolean)false);
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public void testSimpleNamespace() throws Exception {
        Iterator iterator = this.parse("namespace A { }").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTNamespaceDefinition.getDeclarations().hasNext());
        try {
            iterator.remove();
            CompleteParseASTSymbolIteratorTest.assertTrue((boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testMultipleNamespaceDefinitions() throws Exception {
        Iterator iterator = this.parse("namespace A { } namespace A { }").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testNestedNamespaceDefinitions() throws Exception {
        Iterator iterator = this.parse("namespace A { namespace B { } }").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"A");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = iASTNamespaceDefinition.getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition2 = (IASTNamespaceDefinition)iterator2.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTNamespaceDefinition2.getName(), (String)"B");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator2.hasNext());
    }

    public void testEmptyClassDeclaration() throws Exception {
        Iterator iterator = this.parse("class A { };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTClassSpecifier.getName(), (String)"A");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTClassSpecifier.getDeclarations().hasNext());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testNestedSubclass() throws Exception {
        Iterator iterator = this.parse("namespace N { class A { }; } class B : protected virtual N::A { };").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = iASTNamespaceDefinition.getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator2.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator2.hasNext());
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iterator.next();
        Iterator iterator3 = iASTClassSpecifier2.getBaseClauses();
        IASTBaseSpecifier iASTBaseSpecifier = (IASTBaseSpecifier)iterator3.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((Object)iASTClassSpecifier, (Object)iASTBaseSpecifier.getParentClassSpecifier());
    }

    public void testSimpleVariable() throws Exception {
        Iterator iterator = this.parse("int x;").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTVariable.getName(), (String)"x");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleClassReferenceVariable() throws Exception {
        Iterator iterator = this.parse("class A { } a; A x;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTClassSpecifier.getDeclarations().hasNext());
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTVariable.getName(), (String)"a");
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTVariable2.getName(), (String)"x");
        CompleteParseASTSymbolIteratorTest.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable2.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testMultipleDeclaratorsVariable() throws Exception {
        Iterator iterator = this.parse("class A { }; A x, y, z;").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator.next();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTVariable.getName(), (String)"x");
        iASTVariable = (IASTVariable)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTVariable.getName(), (String)"y");
        iASTVariable = (IASTVariable)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTVariable.getName(), (String)"z");
        CompleteParseASTSymbolIteratorTest.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTClassSpecifier);
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleField() throws Exception {
        Iterator iterator = this.parse("class A { double x; };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator.next();
        Iterator iterator2 = iASTClassSpecifier.getDeclarations();
        IASTField iASTField = (IASTField)iterator2.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTField.getName(), (String)"x");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator2.hasNext());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleFunction() throws Exception {
        Iterator iterator = this.parse("void foo( void );").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTFunction.getName(), (String)"foo");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleMethod() throws Exception {
        Iterator iterator = this.parse("class A { void foo(); };").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator.next();
        IASTMethod iASTMethod = (IASTMethod)iASTClassSpecifier.getDeclarations().next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTMethod.getName(), (String)"foo");
    }

    public void testLinkageSpec() throws Exception {
        Iterator iterator = this.parse("extern \"C\" { int foo(); }").getDeclarations();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTFunction.getName(), (String)"foo");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testSimpleTypedef() throws Exception {
        Iterator iterator = this.parse("typedef int myInt;\n myInt var;").getDeclarations();
        IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTTypedefDeclaration.getName(), (String)"myInt");
        CompleteParseASTSymbolIteratorTest.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTTypedefDeclaration.getAbstractDeclarator().getTypeSpecifier()).getType(), (Object)IASTSimpleTypeSpecifier.Type.INT);
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTVariable.getName(), (String)"var");
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testOverride() throws Exception {
        Iterator iterator = this.parse("void foo();\n void foo( int );\n").getDeclarations();
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTFunction cfr_ignored_1 = (IASTFunction)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testEnumerations() throws Exception {
        Iterator iterator = this.parse("namespace A { enum E { e1, e2, e3 }; E varE;}").getDeclarations();
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        Iterator iterator2 = iASTNamespaceDefinition.getDeclarations();
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)iterator2.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTEnumerationSpecifier.getName(), (String)"E");
        this.assertQualifiedName(iASTEnumerationSpecifier.getFullyQualifiedName(), new String[]{"A", "E"});
        Iterator iterator3 = iASTEnumerationSpecifier.getEnumerators();
        IASTEnumerator iASTEnumerator = (IASTEnumerator)iterator3.next();
        IASTEnumerator iASTEnumerator2 = (IASTEnumerator)iterator3.next();
        IASTEnumerator iASTEnumerator3 = (IASTEnumerator)iterator3.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator3.hasNext());
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTEnumerator.getName(), (String)"e1");
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTEnumerator2.getName(), (String)"e2");
        CompleteParseASTSymbolIteratorTest.assertEquals((String)iASTEnumerator3.getName(), (String)"e3");
        IASTVariable iASTVariable = (IASTVariable)iterator2.next();
        CompleteParseASTSymbolIteratorTest.assertEquals((Object)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).getTypeSpecifier(), (Object)iASTEnumerationSpecifier);
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator2.hasNext());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testMethodDefinitions() throws Exception {
        Iterator iterator = this.parse(" class A { void f(); };  void A::f(){ }").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
        iterator = iASTClassSpecifier.getDeclarations();
        IASTMethod cfr_ignored_0 = (IASTMethod)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testConstructorsDestructors() throws Exception {
        Iterator iterator = this.parse("class A { A();  ~A();  };  A::A(){}  A::~A(){}").getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
        iterator = iASTClassSpecifier.getDeclarations();
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iterator.hasNext());
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod.getName().equals("A"));
        IASTMethod iASTMethod2 = (IASTMethod)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod2.getName().equals("~A"));
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testUsingDirectives() throws Exception {
        Iterator iterator = this.parse("namespace NS { int i; }  using namespace NS;").getDeclarations();
        IASTNamespaceDefinition cfr_ignored_0 = (IASTNamespaceDefinition)iterator.next();
        IASTUsingDirective cfr_ignored_1 = (IASTUsingDirective)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testUsingDeclaration() throws Exception {
        Iterator iterator = this.parse("namespace NS{ void f(); void f( int ); };  using NS::f;").getDeclarations();
        IASTNamespaceDefinition cfr_ignored_0 = (IASTNamespaceDefinition)iterator.next();
        IASTUsingDeclaration cfr_ignored_1 = (IASTUsingDeclaration)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug75482() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A { friend class B * helper(); };");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator.next();
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        iterator = iASTClassSpecifier.getDeclarations();
        IASTElaboratedTypeSpecifier cfr_ignored_0 = (IASTElaboratedTypeSpecifier)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
        iterator = iASTClassSpecifier.getFriends();
        CompleteParseASTSymbolIteratorTest.assertEquals(iterator.next(), (Object)iASTFunction);
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug77010() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" struct Example{                                \n");
        ((Writer)stringWriter).write("    int                *deref();                \n");
        ((Writer)stringWriter).write("    int const          *deref() const;          \n");
        ((Writer)stringWriter).write("    int       volatile *deref()       volatile; \n");
        ((Writer)stringWriter).write("    int const volatile *deref() const volatile; \n");
        ((Writer)stringWriter).write(" };                                             \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
        iterator = iASTClassSpecifier.getDeclarations();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTMethod.getReturnType().isConst());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTMethod.getReturnType().isVolatile());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTMethod.isConst());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTMethod.isVolatile());
        iASTMethod = (IASTMethod)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod.getReturnType().isConst());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTMethod.getReturnType().isVolatile());
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod.isConst());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTMethod.isVolatile());
        iASTMethod = (IASTMethod)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTMethod.getReturnType().isConst());
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod.getReturnType().isVolatile());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iASTMethod.isConst());
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod.isVolatile());
        iASTMethod = (IASTMethod)iterator.next();
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod.getReturnType().isConst());
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod.getReturnType().isVolatile());
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod.isConst());
        CompleteParseASTSymbolIteratorTest.assertTrue((boolean)iASTMethod.isVolatile());
        CompleteParseASTSymbolIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public static class CompilationUnitCallback
    extends NullSourceElementRequestor
    implements ISourceElementRequestor {
        IASTCompilationUnit compilationUnit;

        public void enterCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
            this.compilationUnit = iASTCompilationUnit;
        }

        public IASTCompilationUnit getCompilationUnit() {
            return this.compilationUnit;
        }
    }
}

