/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.FileBasePluginTest;
import org.eclipse.core.resources.IFile;

public class CompleteParsePluginTest
extends FileBasePluginTest {
    static /* synthetic */ Class class$0;

    public CompleteParsePluginTest(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.CompleteParsePluginTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(string, clazz);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.parser.tests.CompleteParsePluginTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new CompleteParsePluginTest("cleanupProject"));
        return testSuite;
    }

    public void testBug72219() throws Exception {
        String string = "int FOO;";
        String string2 = "#include \"foo.h\" \n   int bar;";
        this.importFile("foo.h", string);
        IFile iFile = this.importFile("code.cpp", string2);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.parse(iFile, arrayList).getDeclarations();
        CompleteParsePluginTest.assertTrue((boolean)(iterator.next() instanceof IASTVariable));
        CompleteParsePluginTest.assertTrue((boolean)(iterator.next() instanceof IASTVariable));
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
        iterator = arrayList.iterator();
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_COMPILATION_UNIT");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_COMPILATION_UNIT");
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug72219_2() throws Exception {
        String string = "int FOO;";
        String string2 = "int bar; \n #include \"foo.h\"";
        this.importFile("foo.h", string);
        IFile iFile = this.importFile("code.cpp", string2);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.parse(iFile, arrayList).getDeclarations();
        CompleteParsePluginTest.assertTrue((boolean)(iterator.next() instanceof IASTVariable));
        CompleteParsePluginTest.assertTrue((boolean)(iterator.next() instanceof IASTVariable));
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
        iterator = arrayList.iterator();
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_COMPILATION_UNIT");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_COMPILATION_UNIT");
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug72219_3() throws Exception {
        String string = "#define A \n #define B \n";
        String string2 = "int foo; \n #include \"defs.h\" \n  int bar;";
        this.importFile("defs.h", string);
        IFile iFile = this.importFile("code.cpp", string2);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.parse(iFile, arrayList).getDeclarations();
        CompleteParsePluginTest.assertTrue((boolean)(iterator.next() instanceof IASTVariable));
        CompleteParsePluginTest.assertTrue((boolean)(iterator.next() instanceof IASTVariable));
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
        iterator = arrayList.iterator();
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_COMPILATION_UNIT");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_COMPILATION_UNIT");
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
    }

    public void test72219_4() throws Exception {
        String string = "int a; \n #define A\n  int b;\n #define B\n";
        IFile iFile = this.importFile("code.cpp", string);
        ArrayList arrayList = new ArrayList();
        this.parse(iFile, arrayList);
        Iterator iterator = arrayList.iterator();
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_COMPILATION_UNIT");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_COMPILATION_UNIT");
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug72506() throws Exception {
        String string = "int i;\n";
        String string2 = "#define INCFILE(x) vers ## x\n#define xstr(x) str(x)\n#define str(x) #x\n#include xstr(INCFILE(2).h)\n";
        this.importFile("vers2.h", string);
        IFile iFile = this.importFile("code.cpp", string2);
        ArrayList arrayList = new ArrayList();
        this.parse(iFile, arrayList);
        Iterator iterator = arrayList.iterator();
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_COMPILATION_UNIT");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_COMPILATION_UNIT");
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testExpressionEvalProblems() throws Exception {
        String string = " #if 09 == 9    \n #endif         \n";
        String string2 = "int i1;         \n#include \"h.h\"\nint i2;         \n";
        this.importFile("h.h", string);
        IFile iFile = this.importFile("c.cpp", string2);
        ArrayList arrayList = new ArrayList();
        this.parse(iFile, arrayList);
        Iterator iterator = arrayList.iterator();
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_COMPILATION_UNIT");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_PROBLEM");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_COMPILATION_UNIT");
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug79339() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#ifndef _HEADER_\n");
        ((Writer)stringWriter).write("#define _HEADER_\n");
        ((Writer)stringWriter).write("#define ONE 1\n");
        ((Writer)stringWriter).write("int foo(int);\n");
        ((Writer)stringWriter).write("#endif // _HEADER_\n");
        String string = ((Object)stringWriter).toString();
        this.importFile("header.h", string);
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"header.h\"  \n");
        ((Writer)stringWriter).write("int foo2(){\n");
        ((Writer)stringWriter).write("   return foo(ONE);\n");
        ((Writer)stringWriter).write("}\n");
        String string2 = ((Object)stringWriter).toString();
        IFile iFile = this.importFile("test.cpp", string2);
        int n = string2.indexOf("foo(ONE)");
        ArrayList arrayList = new ArrayList();
        IASTNode iASTNode = this.parse(iFile, arrayList, n, n + 3);
        CompleteParsePluginTest.assertTrue((boolean)(iASTNode instanceof IASTFunction));
        IASTFunction iASTFunction = (IASTFunction)iASTNode;
        CompleteParsePluginTest.assertEquals((int)iASTFunction.getStartingLine(), (int)4);
        CompleteParsePluginTest.assertEquals((int)iASTFunction.getNameOffset(), (int)52);
        CompleteParsePluginTest.assertEquals((String)iASTFunction.getName(), (String)"foo");
        CompleteParsePluginTest.assertTrue((new String(iASTFunction.getFilename()).indexOf("header.h") > 0 ? 1 : 0) != 0);
    }

    public void testBug79810B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define __WTERMSIG(status) ((status) & 0x7f)\n");
        ((Writer)stringWriter).write("#define __WIFEXITED(status) (__WTERMSIG(status) == 0)\n");
        ((Writer)stringWriter).write("#define __WAIT_INT(status) (__extension__ ({ union { int __in; int __i; } __u; \\\n");
        ((Writer)stringWriter).write("           __u.__in = (test); __u.__i; }))\n");
        ((Writer)stringWriter).write("#define WIFEXITED(status)\t__WIFEXITED(__WAIT_INT(status))\n");
        this.importFile("header.h", ((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#include \"header.h\"  \n");
        ((Writer)stringWriter).write("void foo() {\n");
        ((Writer)stringWriter).write("int test;\n");
        ((Writer)stringWriter).write("if (WIFEXITED(test)) {}\n}\n");
        IFile iFile = this.importFile("test.cpp", ((Object)stringWriter).toString());
        ArrayList arrayList = new ArrayList();
        this.parse(iFile, arrayList);
        Iterator iterator = arrayList.iterator();
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_COMPILATION_UNIT");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_MACRO");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_INCLUSION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_FUNCTION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_CODE_BLOCK");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_CLASS_SPEC");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_FIELD");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_FIELD");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_CLASS");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_VARIABLE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_REFERENCE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_REFERENCE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_REFERENCE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_REFERENCE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ACCEPT_REFERENCE");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_CODE_BLOCK");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"ENTER_CODE_BLOCK");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_CODE_BLOCK");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_FUNCTION");
        CompleteParsePluginTest.assertEquals(iterator.next(), (Object)"EXIT_COMPILATION_UNIT");
        CompleteParsePluginTest.assertFalse((boolean)iterator.hasNext());
    }
}

