/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.Iterator;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class CompleteParseProblemTest
extends CompleteParseBaseTest {
    public CompleteParseProblemTest() {
    }

    public CompleteParseProblemTest(String string) {
        super(string);
    }

    public void testBadClassName() throws Exception {
        this.validateInvalidClassName("12345");
        this.validateInvalidClassName("*");
    }

    protected void validateInvalidClassName(String string) throws ParserException, ParserFactoryError {
        StringBuffer stringBuffer = new StringBuffer("class ");
        stringBuffer.append(string);
        stringBuffer.append(" { };");
        String string2 = stringBuffer.toString();
        this.parse(string2, false);
        CompleteParseProblemTest.assertFalse((boolean)this.callback.problems.isEmpty());
        CompleteParseProblemTest.assertEquals((int)this.callback.problems.size(), (int)1);
        IProblem iProblem = (IProblem)this.callback.problems.get(0);
        CompleteParseProblemTest.assertTrue((boolean)iProblem.checkCategory(0x4000000));
        CompleteParseProblemTest.assertEquals((int)iProblem.getID(), (int)0x4000001);
        CompleteParseProblemTest.assertEquals((int)iProblem.getSourceStart(), (int)string2.indexOf(string));
        CompleteParseProblemTest.assertEquals((int)iProblem.getSourceEnd(), (int)(string2.indexOf(string) + string.length()));
    }

    public void testBug68306() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Foo { int bar( int ); };\n");
        stringBuffer.append("int Foo::bar( int ){}\n");
        stringBuffer.append("int Foo::bar( int ){}  //error\n");
        String string = stringBuffer.toString();
        this.parse(string, false);
        CompleteParseProblemTest.assertFalse((boolean)this.callback.problems.isEmpty());
        CompleteParseProblemTest.assertEquals((int)this.callback.problems.size(), (int)1);
        IProblem iProblem = (IProblem)this.callback.problems.get(0);
        CompleteParseProblemTest.assertTrue((boolean)iProblem.checkCategory(0x8000000));
    }

    public void testBug68931() throws Exception {
        String string = "void foo(){ SomeUnknownType t; } ";
        this.parse(string, false);
        int n = string.indexOf("SomeUnknownType");
        int n2 = n + 15;
        CompleteParseProblemTest.assertFalse((boolean)this.callback.problems.isEmpty());
        CompleteParseProblemTest.assertEquals((int)this.callback.problems.size(), (int)1);
        IProblem iProblem = (IProblem)this.callback.problems.get(0);
        CompleteParseProblemTest.assertTrue((boolean)iProblem.checkCategory(0x8000000));
        CompleteParseProblemTest.assertEquals((int)iProblem.getSourceStart(), (int)n);
        CompleteParseProblemTest.assertEquals((int)iProblem.getSourceEnd(), (int)n2);
        CompleteParseProblemTest.assertEquals((int)iProblem.getID(), (int)0x8000002);
    }

    public void testBug69744() throws Exception {
        String string = "int f() {  try { } catch( foo bar ) {} catch ( ... ) {} }  int i;";
        Iterator iterator = this.parse(string, false).getDeclarations();
        int n = string.indexOf("foo");
        int n2 = n + 3;
        CompleteParseProblemTest.assertEquals((int)this.callback.problems.size(), (int)1);
        IProblem iProblem = (IProblem)this.callback.problems.get(0);
        CompleteParseProblemTest.assertEquals((int)iProblem.getSourceStart(), (int)n);
        CompleteParseProblemTest.assertEquals((int)iProblem.getSourceEnd(), (int)n2);
        CompleteParseProblemTest.assertEquals((int)iProblem.getID(), (int)0x8000002);
        IASTFunction cfr_ignored_0 = (IASTFunction)iterator.next();
        IASTVariable cfr_ignored_1 = (IASTVariable)iterator.next();
    }

    public void testBug69745() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace NS{ template < class T > int foo(){};  }   \n");
        stringBuffer.append("void f() { using NS::foo;  using NS::foo<int>;   }   \n");
        String string = stringBuffer.toString();
        this.parse(string, false);
        int n = string.indexOf("using NS::foo<int>;");
        int n2 = n + "using NS::foo<int>;".length();
        CompleteParseProblemTest.assertEquals((int)this.callback.problems.size(), (int)1);
        IProblem iProblem = (IProblem)this.callback.problems.get(0);
        CompleteParseProblemTest.assertEquals((int)iProblem.getSourceStart(), (int)n);
        CompleteParseProblemTest.assertEquals((int)iProblem.getSourceEnd(), (int)n2);
        CompleteParseProblemTest.assertEquals((int)iProblem.getID(), (int)0x8000005);
    }
}

