/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.FileManager;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FileBasePluginTest
extends TestCase {
    static NullProgressMonitor monitor;
    static IWorkspace workspace;
    static IProject project;
    static FileManager fileManager;
    static int numProjects;
    static Class className;
    static ICProject cPrj;
    public CallbackTracker callback;

    static {
        numProjects = 0;
    }

    private void initialize(Class clazz) {
        if (CCorePlugin.getDefault() != null && CCorePlugin.getDefault().getCoreModel() != null) {
            monitor = new NullProgressMonitor();
            workspace = ResourcesPlugin.getWorkspace();
            try {
                cPrj = CProjectHelper.createCCProject("ParserTestProject", "bin");
                project = cPrj.getProject();
                if (className == null || !className.equals(clazz)) {
                    className = clazz;
                    ++numProjects;
                }
            }
            catch (CoreException coreException) {}
            if (project == null) {
                throw new NullPointerException("Unable to create project");
            }
            fileManager = new FileManager();
        }
    }

    public FileBasePluginTest(String string, Class clazz) {
        super(string);
        this.initialize(clazz);
    }

    public void cleanupProject() throws Exception {
        --numProjects;
        try {
            if (numProjects == 0) {
                project.delete(true, false, (IProgressMonitor)monitor);
                project = null;
            }
        }
        catch (Throwable throwable) {}
    }

    protected void tearDown() throws Exception {
        if (project == null || !project.exists()) {
            return;
        }
        IResource[] iResourceArray = project.members();
        int n = 0;
        while (n < iResourceArray.length) {
            if (!iResourceArray[n].getName().equals(".project") && !iResourceArray[n].getName().equals(".cdtproject")) {
                try {
                    iResourceArray[n].delete(false, (IProgressMonitor)monitor);
                }
                catch (Throwable throwable) {}
            }
            ++n;
        }
    }

    protected IFolder importFolder(String string) throws Exception {
        IFolder iFolder = project.getProject().getFolder(string);
        if (!iFolder.exists()) {
            iFolder.create(false, false, (IProgressMonitor)monitor);
        }
        return iFolder;
    }

    public IFile importFile(String string, String string2) throws Exception {
        IFile iFile = project.getProject().getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, (IProgressMonitor)monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IASTScope parse(IFile iFile, List list) throws Exception {
        return this.parse(iFile, list, ParserLanguage.CPP);
    }

    protected IASTScope parse(IFile iFile, List list, ParserLanguage parserLanguage) throws Exception {
        this.callback = new CallbackTracker(list);
        InputStream inputStream = iFile.getContents();
        IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(iFile.getLocation().toOSString(), inputStream), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, (ISourceElementRequestor)this.callback, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)this.callback, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)parserLanguage, null);
        inputStream.close();
        boolean bl = iParser.parse();
        if (!bl) {
            throw new ParserException("FAILURE");
        }
        if (bl) {
            FileBasePluginTest.assertTrue((boolean)((Parser)iParser).validateCaches());
        }
        return this.callback.getCompilationUnit();
    }

    protected IASTNode parse(IFile iFile, List list, int n, int n2) throws Exception {
        return this.parse(iFile, list, n, n2, true, ParserLanguage.CPP);
    }

    protected IASTNode parse(IFile iFile, List list, int n, int n2, boolean bl, ParserLanguage parserLanguage) throws Exception {
        this.callback = new CallbackTracker(list);
        IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(iFile.getLocation().toOSString(), iFile.getCharset()), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)parserLanguage, (ISourceElementRequestor)this.callback, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)this.callback, (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)parserLanguage, null);
        IParser.ISelectionParseResult iSelectionParseResult = iParser.parse(n, n2);
        if (bl) {
            FileBasePluginTest.assertNotNull((Object)iSelectionParseResult);
            String string = iSelectionParseResult.getFilename();
            FileBasePluginTest.assertNotNull((Object)string);
            FileBasePluginTest.assertTrue((!string.equals("") ? 1 : 0) != 0);
            return (IASTNode)iSelectionParseResult.getOffsetableNamedElement();
        }
        return null;
    }

    public static class CallbackTracker
    implements ISourceElementRequestor {
        private List callbacks;
        private IASTScope compUnit;
        public static final String ACCEPT_PROBLEM = "ACCEPT_PROBLEM";
        public static final String ACCEPT_MACRO = "ACCEPT_MACRO";
        public static final String ACCEPT_VARIABLE = "ACCEPT_VARIABLE";
        public static final String ACCEPT_FUNCTION_DECL = "ACCEPT_FUNCTION_DECL";
        public static final String ACCEPT_USING_DIRECTIVE = "ACCEPT_USING_DIRECTIVE";
        public static final String ACCEPT_USING_DECL = "ACCEPT_USING_DECL";
        public static final String ACCEPT_ASM_DEF = "ACCEPT_ASM_DEF";
        public static final String ACCEPT_TYPEDEF = "ACCEPT_TYPEDEF";
        public static final String ACCEPT_ENUMERATION = "ACCEPT_ENUMERATION";
        public static final String ACCEPT_ELABORATED = "ACCEPT_ELABORATED";
        public static final String ACCEPT_ABSTRACT_TYPESPEC = "ACCEPT_ABSTRACT_TYPESPEC";
        public static final String ACCEPT_METHOD = "ACCEPT_METHOD";
        public static final String ACCEPT_FIELD = "ACCEPT_FIELD";
        public static final String ACCEPT_REFERENCE = "ACCEPT_REFERENCE";
        public static final String ACCEPT_FRIEND = "ACCEPT_FRIEND";
        public static final String ENTER_FUNCTION = "ENTER_FUNCTION";
        public static final String ENTER_CODE_BLOCK = "ENTER_CODE_BLOCK";
        public static final String ENTER_COMPILATION_UNIT = "ENTER_COMPILATION_UNIT";
        public static final String ENTER_INCLUSION = "ENTER_INCLUSION";
        public static final String ENTER_NAMESPACE = "ENTER_NAMESPACE";
        public static final String ENTER_CLASS_SPEC = "ENTER_CLASS_SPEC";
        public static final String ENTER_LINKAGE = "ENTER_LINKAGE";
        public static final String ENTER_TEMPLATE_DECL = "ENTER_TEMPLATE_DECL";
        public static final String ENTER_TEMPLATE_SPEC = "ENTER_TEMPLATE_SPEC";
        public static final String ENTER_TEMPLATE_INSTANCE = "ENTER_TEMPLATE_INSTANCE";
        public static final String ENTER_METHOD = "ENTER_METHOD";
        public static final String EXIT_FUNCTION = "EXIT_FUNCTION";
        public static final String EXIT_CODE_BLOCK = "EXIT_CODE_BLOCK";
        public static final String EXIT_METHOD = "EXIT_METHOD";
        public static final String EXIT_TEMPLATE_DECL = "EXIT_TEMPLATE_DECL";
        public static final String EXIT_TEMPLATE_SPEC = "EXIT_TEMPLATE_SPEC";
        public static final String EXIT_TEMPLATE_INSTANCE = "EXIT_TEMPLATE_INSTANCE";
        public static final String EXIT_LINKAGE = "EXIT_LINKAGE";
        public static final String EXIT_CLASS = "EXIT_CLASS";
        public static final String EXIT_NAMESPACE = "EXIT_NAMESPACE";
        public static final String EXIT_INCLUSION = "EXIT_INCLUSION";
        public static final String EXIT_COMPILATION_UNIT = "EXIT_COMPILATION_UNIT";

        public CallbackTracker(List list) {
            this.callbacks = list;
        }

        public IASTScope getCompilationUnit() {
            return this.compUnit;
        }

        public boolean acceptProblem(IProblem iProblem) {
            this.callbacks.add(ACCEPT_PROBLEM);
            return false;
        }

        public void acceptMacro(IASTMacro iASTMacro) {
            this.callbacks.add(ACCEPT_MACRO);
        }

        public void acceptVariable(IASTVariable iASTVariable) {
            this.callbacks.add(ACCEPT_VARIABLE);
        }

        public void acceptFunctionDeclaration(IASTFunction iASTFunction) {
            this.callbacks.add(ACCEPT_FUNCTION_DECL);
        }

        public void acceptUsingDirective(IASTUsingDirective iASTUsingDirective) {
            this.callbacks.add(ACCEPT_USING_DIRECTIVE);
        }

        public void acceptUsingDeclaration(IASTUsingDeclaration iASTUsingDeclaration) {
            this.callbacks.add(ACCEPT_USING_DECL);
        }

        public void acceptASMDefinition(IASTASMDefinition iASTASMDefinition) {
            this.callbacks.add(ACCEPT_ASM_DEF);
        }

        public void acceptTypedefDeclaration(IASTTypedefDeclaration iASTTypedefDeclaration) {
            this.callbacks.add(ACCEPT_TYPEDEF);
        }

        public void acceptEnumerationSpecifier(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
            this.callbacks.add(ACCEPT_ENUMERATION);
        }

        public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
            this.callbacks.add(ACCEPT_ELABORATED);
        }

        public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration) {
            this.callbacks.add(ACCEPT_ABSTRACT_TYPESPEC);
        }

        public void enterFunctionBody(IASTFunction iASTFunction) {
            this.callbacks.add(ENTER_FUNCTION);
        }

        public void exitFunctionBody(IASTFunction iASTFunction) {
            this.callbacks.add(EXIT_FUNCTION);
        }

        public void enterCodeBlock(IASTCodeScope iASTCodeScope) {
            this.callbacks.add(ENTER_CODE_BLOCK);
        }

        public void exitCodeBlock(IASTCodeScope iASTCodeScope) {
            this.callbacks.add(EXIT_CODE_BLOCK);
        }

        public void enterInclusion(IASTInclusion iASTInclusion) {
            this.callbacks.add(ENTER_INCLUSION);
        }

        public void enterNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
            this.callbacks.add(ENTER_NAMESPACE);
        }

        public void enterClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
            this.callbacks.add(ENTER_CLASS_SPEC);
        }

        public void enterLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
            this.callbacks.add(ENTER_LINKAGE);
        }

        public void enterTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
            this.callbacks.add(ENTER_TEMPLATE_DECL);
        }

        public void enterTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
            this.callbacks.add(ENTER_TEMPLATE_SPEC);
        }

        public void enterTemplateInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
            this.callbacks.add(ENTER_TEMPLATE_INSTANCE);
        }

        public void acceptMethodDeclaration(IASTMethod iASTMethod) {
            this.callbacks.add(ACCEPT_METHOD);
        }

        public void enterMethodBody(IASTMethod iASTMethod) {
            this.callbacks.add(ENTER_METHOD);
        }

        public void exitMethodBody(IASTMethod iASTMethod) {
            this.callbacks.add(EXIT_METHOD);
        }

        public void acceptField(IASTField iASTField) {
            this.callbacks.add(ACCEPT_FIELD);
        }

        public void acceptClassReference(IASTClassReference iASTClassReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptTypedefReference(IASTTypedefReference iASTTypedefReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptNamespaceReference(IASTNamespaceReference iASTNamespaceReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptEnumerationReference(IASTEnumerationReference iASTEnumerationReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptVariableReference(IASTVariableReference iASTVariableReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptFunctionReference(IASTFunctionReference iASTFunctionReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptFieldReference(IASTFieldReference iASTFieldReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptMethodReference(IASTMethodReference iASTMethodReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptEnumeratorReference(IASTEnumeratorReference iASTEnumeratorReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptParameterReference(IASTParameterReference iASTParameterReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptTemplateParameterReference(IASTTemplateParameterReference iASTTemplateParameterReference) {
            this.callbacks.add(ACCEPT_REFERENCE);
        }

        public void acceptFriendDeclaration(IASTDeclaration iASTDeclaration) {
            this.callbacks.add(ACCEPT_FRIEND);
        }

        public void exitTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
            this.callbacks.add(EXIT_TEMPLATE_DECL);
        }

        public void exitTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
            this.callbacks.add(EXIT_TEMPLATE_SPEC);
        }

        public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
            this.callbacks.add(EXIT_TEMPLATE_INSTANCE);
        }

        public void exitLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
            this.callbacks.add(ACCEPT_MACRO);
        }

        public void exitClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
            this.callbacks.add(EXIT_CLASS);
        }

        public void exitNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
            this.callbacks.add(EXIT_NAMESPACE);
        }

        public void exitInclusion(IASTInclusion iASTInclusion) {
            this.callbacks.add(EXIT_INCLUSION);
        }

        public void exitCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
            this.callbacks.add(EXIT_COMPILATION_UNIT);
        }

        public void enterCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
            this.callbacks.add(ENTER_COMPILATION_UNIT);
            this.compUnit = iASTCompilationUnit;
        }

        public CodeReader createReader(String string, Iterator iterator) {
            return ParserUtil.createReader((String)string, (Iterator)iterator);
        }
    }
}

