/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCExpression;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.tests.CompleteParseBaseTest;

public class GCCCompleteParseExtensionsTest
extends CompleteParseBaseTest {
    public GCCCompleteParseExtensionsTest() {
    }

    public GCCCompleteParseExtensionsTest(String string) {
        super(string);
    }

    public void testBug39695() throws Exception {
        Iterator iterator = this.parse("int a = __alignof__ (int);").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        GCCCompleteParseExtensionsTest.assertFalse((boolean)iterator.hasNext());
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        GCCCompleteParseExtensionsTest.assertEquals((Object)iASTExpression.getExpressionKind(), (Object)IASTGCCExpression.Kind.UNARY_ALIGNOF_TYPEID);
        GCCCompleteParseExtensionsTest.assertEquals((String)iASTExpression.toString(), (String)"__alignof__(int)");
    }

    public void testBug39684() throws Exception {
        IASTFunction iASTFunction = (IASTFunction)this.parse("typeof(foo(1)) bar () { return foo(1); }").getDeclarations().next();
        IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTFunction.getReturnType().getTypeSpecifier();
        GCCCompleteParseExtensionsTest.assertEquals((Object)iASTSimpleTypeSpecifier.getType(), (Object)IASTGCCSimpleTypeSpecifier.Type.TYPEOF);
    }

    public void testBug39698A() throws Exception {
        Iterator iterator = this.parse("int c = a <? b;").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        GCCCompleteParseExtensionsTest.assertEquals((String)ASTUtil.getExpressionString((IASTExpression)iASTExpression), (String)"a <? b");
    }

    public void testBug39698B() throws Exception {
        Iterator iterator = this.parse("int c = a >? b;").getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        IASTExpression iASTExpression = iASTVariable.getInitializerClause().getAssigmentExpression();
        GCCCompleteParseExtensionsTest.assertEquals((String)ASTUtil.getExpressionString((IASTExpression)iASTExpression), (String)"a >? b");
    }

    public void testPredefinedSymbol_bug69791() throws Exception {
        Iterator iterator = this.parse("typedef __builtin_va_list __gnuc_va_list; \n").getDeclarations();
        GCCCompleteParseExtensionsTest.assertTrue((boolean)(iterator.next() instanceof IASTTypedefDeclaration));
        GCCCompleteParseExtensionsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug39697() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("__asm__( \"CODE\" );\n");
        ((Writer)stringWriter).write("__inline__ int foo() { return 4; }\n");
        ((Writer)stringWriter).write("__const__ int constInt;\n");
        ((Writer)stringWriter).write("__volatile__ int volInt;\n");
        ((Writer)stringWriter).write("__signed__ int signedInt;\n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTASMDefinition iASTASMDefinition = (IASTASMDefinition)iterator.next();
        GCCCompleteParseExtensionsTest.assertEquals((String)iASTASMDefinition.getBody(), (String)"CODE");
        IASTFunction iASTFunction = (IASTFunction)iterator.next();
        GCCCompleteParseExtensionsTest.assertTrue((boolean)iASTFunction.isInline());
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        GCCCompleteParseExtensionsTest.assertTrue((boolean)iASTVariable.getAbstractDeclaration().isConst());
        IASTVariable iASTVariable2 = (IASTVariable)iterator.next();
        GCCCompleteParseExtensionsTest.assertTrue((boolean)iASTVariable2.getAbstractDeclaration().isVolatile());
        IASTVariable iASTVariable3 = (IASTVariable)iterator.next();
        GCCCompleteParseExtensionsTest.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTVariable3.getAbstractDeclaration().getTypeSpecifier()).isSigned());
        GCCCompleteParseExtensionsTest.assertFalse((boolean)iterator.hasNext());
        int n = 0;
        while (n < 2) {
            stringWriter = new StringWriter();
            ((Writer)stringWriter).write("int * __restrict__ resPointer1;\n");
            ((Writer)stringWriter).write("int * __restrict resPointer2;\n");
            iterator = this.parse(((Object)stringWriter).toString(), true, n == 0 ? ParserLanguage.C : ParserLanguage.CPP).getDeclarations();
            int n2 = 0;
            while (iterator.hasNext()) {
                ++n2;
                IASTVariable iASTVariable4 = (IASTVariable)iterator.next();
                Iterator iterator2 = iASTVariable4.getAbstractDeclaration().getPointerOperators();
                GCCCompleteParseExtensionsTest.assertTrue((boolean)iterator2.hasNext());
                ASTPointerOperator aSTPointerOperator = (ASTPointerOperator)iterator2.next();
                GCCCompleteParseExtensionsTest.assertFalse((boolean)iterator2.hasNext());
                GCCCompleteParseExtensionsTest.assertEquals((Object)aSTPointerOperator, (Object)ASTPointerOperator.RESTRICT_POINTER);
            }
            GCCCompleteParseExtensionsTest.assertEquals((int)n2, (int)2);
            ++n;
        }
    }

    public void testBug73954A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void f(){\t\t\t\t\t\t\t\n");
        stringWriter.write("\t__builtin_expect( 23, 2); \t\t\n");
        stringWriter.write("\t__builtin_prefetch( (const void *)0, 1, 2);\t\t\t\t\n");
        stringWriter.write("\t__builtin_huge_val();\t\t\t\n");
        stringWriter.write("\t__builtin_huge_valf();\t\t\t\n");
        stringWriter.write("\t__builtin_huge_vall();\t\t\t\n");
        stringWriter.write("\t__builtin_inf();\t\t\t\t\n");
        stringWriter.write("\t__builtin_inff();\t\t\t\t\n");
        stringWriter.write("\t__builtin_infl();\t\t\t\t\n");
        stringWriter.write("\t__builtin_nan(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nanf(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nanl(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nans(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nansf(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_nansl(\"\");\t\t\t\n");
        stringWriter.write("\t__builtin_ffs (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_clz (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_ctz (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_popcount (0);\t\t\t\n");
        stringWriter.write("\t__builtin_parity (0);\t\t\t\n");
        stringWriter.write("\t__builtin_ffsl (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_clzl (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_ctzl (0);\t\t\t\t\n");
        stringWriter.write("\t__builtin_popcountl (0);\t\t\n");
        stringWriter.write("\t__builtin_parityl (0);\t\t\t\n");
        stringWriter.write("\t__builtin_ffsll (0);\t\t\t\n");
        stringWriter.write("\t__builtin_clzll (0);\t\t\t\n");
        stringWriter.write("\t__builtin_ctzll (0);\t\t\t\n");
        stringWriter.write("\t__builtin_popcountll (0);\t\t\n");
        stringWriter.write("\t__builtin_parityll (0); \t\t\n");
        stringWriter.write("}                                 \n");
        this.parse(stringWriter.toString());
    }

    public void testBug39686() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("__complex__ double x; // complex double\n");
        ((Writer)stringWriter).write("__complex__ short int a; // complex short int\n");
        ((Writer)stringWriter).write("__complex__ float y = 2.5fi; // 2.5 imaginary float literal\n");
        ((Writer)stringWriter).write("__complex__ int z = 3i; // imaginary intege r literal\n");
        ((Writer)stringWriter).write("double v = __real__ x; // real part of expression\n");
        ((Writer)stringWriter).write("double w = __imag__ x; // imaginary part of expression\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39551B() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("_Imaginary double id = 99.99 * 1i;", true, ParserLanguage.C).getDeclarations().next();
        GCCCompleteParseExtensionsTest.assertEquals((String)iASTVariable.getName(), (String)"id");
        GCCCompleteParseExtensionsTest.assertTrue((boolean)((IASTSimpleTypeSpecifier)iASTVariable.getAbstractDeclaration().getTypeSpecifier()).isImaginary());
    }

    public void testBug39681() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("double\n");
        ((Writer)stringWriter).write("foo (double a, double b)\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("  double square (double z) { return z * z; }\n");
        ((Writer)stringWriter).write("  return square (a) + square (b);\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39677() throws Exception {
        this.parse("class B { public: B(); int a;}; B::B() : a(({ 1; })) {}");
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("B::B() : a(( { int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; }))\n");
        this.parse(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int x = ({ int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; });\n");
        this.parse(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int foo();                       \n");
        ((Writer)stringWriter).write("typeof({ int y = foo ();         \n");
        ((Writer)stringWriter).write("         int z;                  \n");
        ((Writer)stringWriter).write("         if (y > 0) z = y;       \n");
        ((Writer)stringWriter).write("         else z = - y;           \n");
        ((Writer)stringWriter).write("         z;                      \n");
        ((Writer)stringWriter).write("       }) zoot;                  \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug75401() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define va_arg __builtin_va_arg      \n");
        ((Writer)stringWriter).write("#define va_list __builtin_va_list    \n");
        ((Writer)stringWriter).write("void main( int argc, char** argv ) { \n");
        ((Writer)stringWriter).write("   va_list v;                        \n");
        ((Writer)stringWriter).write("   long l = va_arg( v, long );       \n");
        ((Writer)stringWriter).write("}                                    \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug73954B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define foo(x)                                            \\\n");
        ((Writer)stringWriter).write("  __builtin_choose_expr( 1, foo_d(x), (void)0 )             \n");
        ((Writer)stringWriter).write("int foo_d( int x );                                         \n");
        ((Writer)stringWriter).write("int main() {                                                \n");
        ((Writer)stringWriter).write("   if( __builtin_constant_p(1) &&                           \n");
        ((Writer)stringWriter).write("      __builtin_types_compatible_p( 1, 'c') )               \n");
        ((Writer)stringWriter).write("          foo(1);                                           \n");
        ((Writer)stringWriter).write("}                                                           \n");
        this.parse(((Object)stringWriter).toString(), true, ParserLanguage.C);
    }

    public void testGNUExternalTemplate_bug71603() throws Exception {
        Iterator iterator = this.parse("template <typename T> \n class A {}; \n extern template class A<int>; \n").getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        IASTClassSpecifier cfr_ignored_0 = (IASTClassSpecifier)iASTTemplateDeclaration.getOwnedDeclaration();
        IASTTemplateInstantiation cfr_ignored_1 = (IASTTemplateInstantiation)iterator.next();
        GCCCompleteParseExtensionsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug74190_g_assert_1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void log( int );               \n");
        ((Writer)stringWriter).write("void f() {                     \n");
        ((Writer)stringWriter).write("    int a = 1;                 \n");
        ((Writer)stringWriter).write("    (void)({ if( a ){ }        \n");
        ((Writer)stringWriter).write("             else{ log( a ); } \n");
        ((Writer)stringWriter).write("           });                 \n");
        ((Writer)stringWriter).write("}                              \n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug74190_g_return_if_fail() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void f() {                     \n");
        ((Writer)stringWriter).write("    (void)({ if( ( ({ 0; }) ) ) \n");
        ((Writer)stringWriter).write("            { }                \n");
        ((Writer)stringWriter).write("           });                 \n");
        ((Writer)stringWriter).write("}                              \n");
        this.parse(((Object)stringWriter).toString());
    }
}

