/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTClassSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTCompilationUnit;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTField;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDeclarationSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.StandardSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public class ParserSymbolTableTest
extends TestCase {
    private static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();
    public ParserSymbolTable table = null;
    public TypeInfoProvider provider = null;

    public ParserSymbolTableTest(String string) {
        super(string);
    }

    public ParserSymbolTable newTable() {
        return this.newTable(ParserLanguage.CPP, ParserMode.COMPLETE_PARSE);
    }

    public ParserSymbolTable newTable(ParserLanguage parserLanguage, ParserMode parserMode) {
        this.table = new ParserSymbolTable(parserLanguage, parserMode);
        this.provider = this.table.getTypeInfoProvider();
        return this.table;
    }

    public void testSimpleAdd() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray());
        iSymbol.setTypeInfo(TypeInfoProvider.newTypeInfo());
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        iContainerSymbol.addSymbol(iSymbol);
        CharArrayObjectMap charArrayObjectMap = iContainerSymbol.getContainedSymbols();
        ParserSymbolTableTest.assertEquals((int)1, (int)charArrayObjectMap.size());
        ISymbol iSymbol2 = (ISymbol)charArrayObjectMap.getAt(0);
        ParserSymbolTableTest.assertEquals((int)charArrayObjectMap.size(), (int)1);
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iSymbol2);
        ParserSymbolTableTest.assertTrue((boolean)CharArrayUtils.equals((char[])iSymbol2.getName(), (char[])"x".toCharArray()));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testSimpleLookup() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testLookupNonExistant() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.getCompilationUnit().lookup("boo".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, null);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testSimpleSetGetObject() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("x".toCharArray(), ITypeInfo.t_namespace);
        StandardSymbolExtension standardSymbolExtension = new StandardSymbolExtension((ISymbol)iContainerSymbol, null);
        iContainerSymbol.setASTExtension((ISymbolASTExtension)standardSymbolExtension);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        ISymbol iSymbol = this.table.getCompilationUnit().lookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol.getASTExtension(), (Object)standardSymbolExtension);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testHide() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray());
        iSymbol.setTypeInfo(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("x".toCharArray());
        iDerivableContainerSymbol.addSymbol(iSymbol3);
        iSymbol2 = iDerivableContainerSymbol.lookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol3);
        iSymbol2 = this.table.getCompilationUnit().lookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testContainingScopeLookup() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray());
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testParentLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("parent".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("class".toCharArray());
        iDerivableContainerSymbol2.setType(ITypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = iDerivableContainerSymbol2.lookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testAmbiguousParentLookup() throws Exception {
        this.testParentLookup();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("parent2".toCharArray());
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = (IDerivableContainerSymbol)this.table.getCompilationUnit().lookup("class".toCharArray());
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol);
        try {
            iDerivableContainerSymbol2.lookup("x".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testCircularParentLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("a".toCharArray());
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("b".toCharArray());
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol2);
        try {
            iDerivableContainerSymbol.lookup("foo".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)2);
        }
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testVirtualParentLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("C".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("A".toCharArray());
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol2, true, ASTAccessVisibility.PUBLIC, 3, null);
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("B".toCharArray());
        iDerivableContainerSymbol4.addParent((ISymbol)iDerivableContainerSymbol2, true, ASTAccessVisibility.PUBLIC, 6, null);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol3);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol4);
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol4);
        ISymbol iSymbol2 = iDerivableContainerSymbol.lookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testAmbiguousVirtualParentLookup() throws Exception {
        this.testVirtualParentLookup();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = (IDerivableContainerSymbol)iContainerSymbol.lookup("class".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol2 = (IDerivableContainerSymbol)iContainerSymbol.lookup("C".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("D".toCharArray());
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol2);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol3);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        try {
            iDerivableContainerSymbol.lookup("x".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testStaticEnumParentLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("a".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("b".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("c".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("d".toCharArray());
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol4);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("enum".toCharArray(), ITypeInfo.t_enumeration);
        ISymbol iSymbol = this.table.newSymbol("enumerator".toCharArray(), ITypeInfo.t_enumerator);
        ISymbol iSymbol2 = this.table.newSymbol("static".toCharArray(), ITypeInfo.t_int);
        iSymbol2.getTypeInfo().setBit(true, 4);
        ISymbol iSymbol3 = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol4.addSymbol((ISymbol)iContainerSymbol2);
        iDerivableContainerSymbol4.addSymbol(iSymbol2);
        iDerivableContainerSymbol4.addSymbol(iSymbol3);
        iContainerSymbol2.addSymbol(iSymbol);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol2);
        iDerivableContainerSymbol.addParent((ISymbol)iDerivableContainerSymbol3);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol4);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol4);
        try {
            iDerivableContainerSymbol.lookup("enumerator".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)true);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        try {
            iDerivableContainerSymbol.lookup("static".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)true);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        try {
            iDerivableContainerSymbol.lookup("x".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testElaboratedLookup() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("struct".toCharArray());
        iDerivableContainerSymbol2.setType(ITypeInfo.t_struct);
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("union".toCharArray());
        iContainerSymbol.setType(ITypeInfo.t_union);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("class".toCharArray());
        iDerivableContainerSymbol3.setType(ITypeInfo.t_int);
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("struct".toCharArray());
        iDerivableContainerSymbol4.setType(ITypeInfo.t_int);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("union".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_int);
        IDerivableContainerSymbol iDerivableContainerSymbol5 = this.table.newDerivableContainerSymbol("a".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol6 = this.table.newDerivableContainerSymbol("b".toCharArray());
        iDerivableContainerSymbol5.addSymbol((ISymbol)iDerivableContainerSymbol3);
        iDerivableContainerSymbol5.addSymbol((ISymbol)iDerivableContainerSymbol4);
        iDerivableContainerSymbol5.addSymbol((ISymbol)iContainerSymbol2);
        iDerivableContainerSymbol5.addParent((ISymbol)iDerivableContainerSymbol6);
        iDerivableContainerSymbol6.addSymbol((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol6.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iDerivableContainerSymbol6.addSymbol((ISymbol)iContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol5);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol6);
        ISymbol iSymbol = iDerivableContainerSymbol5.elaboratedLookup(ITypeInfo.t_class, "class".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iSymbol = iDerivableContainerSymbol5.elaboratedLookup(ITypeInfo.t_struct, "struct".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol2);
        iSymbol = iDerivableContainerSymbol5.elaboratedLookup(ITypeInfo.t_union, "union".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iContainerSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testDeclarationType() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A".toCharArray());
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("member".toCharArray());
        iContainerSymbol2.addSymbol(iSymbol);
        ISymbol iSymbol2 = iContainerSymbol.lookup("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iContainerSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("a".toCharArray());
        iSymbol3.setTypeSymbol(iSymbol2);
        iContainerSymbol.addSymbol(iSymbol3);
        iSymbol2 = iContainerSymbol.lookup("a".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol3);
        IContainerSymbol iContainerSymbol3 = (IContainerSymbol)iSymbol2.getTypeSymbol();
        ParserSymbolTableTest.assertEquals((Object)iContainerSymbol3, (Object)iContainerSymbol2);
        iSymbol2 = iContainerSymbol3.lookup("member".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testFunctionHidesClass() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("stat".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_struct);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("stat".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol = iParameterizedSymbol2.elaboratedLookup(ITypeInfo.t_struct, "stat".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iSymbol = iParameterizedSymbol2.lookup("stat".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testUsingDirectives_1() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A".toCharArray());
        iContainerSymbol.setType(ITypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("i".toCharArray());
        iContainerSymbol.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("C".toCharArray());
        iContainerSymbol3.setType(ITypeInfo.t_namespace);
        iContainerSymbol2.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol2 = this.table.newSymbol("i".toCharArray());
        iContainerSymbol3.addSymbol(iSymbol2);
        ISymbol iSymbol3 = iContainerSymbol2.lookup("C".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iContainerSymbol3);
        iContainerSymbol2.addUsingDirective(iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        iSymbol3 = iParameterizedSymbol.lookup("i".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iSymbol2);
        IContainerSymbol iContainerSymbol4 = this.table.newContainerSymbol("D".toCharArray());
        iContainerSymbol4.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol4);
        iSymbol3 = iContainerSymbol4.lookup("B".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iContainerSymbol2);
        iContainerSymbol4.addUsingDirective(iContainerSymbol2);
        iSymbol3 = iContainerSymbol4.lookup("C".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iContainerSymbol3);
        iContainerSymbol4.addUsingDirective(iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f2".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iContainerSymbol4.addSymbol((ISymbol)iParameterizedSymbol2);
        try {
            iSymbol3 = iParameterizedSymbol2.lookup("i".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f3".toCharArray());
        iParameterizedSymbol3.setType(ITypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        iSymbol3 = iParameterizedSymbol3.lookup("i".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iSymbol);
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("f4".toCharArray());
        iParameterizedSymbol4.setType(ITypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol4);
        iSymbol3 = iParameterizedSymbol4.lookup("i".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, null);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testTransitiveUsingDirective() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("M".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("i".toCharArray());
        iContainerSymbol2.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("N".toCharArray());
        iContainerSymbol3.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol2 = this.table.newSymbol("i".toCharArray());
        iContainerSymbol3.addSymbol(iSymbol2);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol3);
        ISymbol iSymbol3 = null;
        try {
            iSymbol3 = iParameterizedSymbol.lookup("i".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        iSymbol3 = iParameterizedSymbol.lookupNestedNameSpecifier("N".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iContainerSymbol3);
        iSymbol3 = ((IContainerSymbol)iSymbol3).qualifiedLookup("i".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testUsing_SameDeclarationTwice() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("a".toCharArray());
        iContainerSymbol2.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("B".toCharArray());
        iContainerSymbol3.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        IContainerSymbol iContainerSymbol4 = this.table.newContainerSymbol("C".toCharArray());
        iContainerSymbol4.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol4);
        iContainerSymbol4.addUsingDirective(iContainerSymbol2);
        IContainerSymbol iContainerSymbol5 = this.table.newContainerSymbol("BC".toCharArray());
        iContainerSymbol5.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol5);
        iContainerSymbol5.addUsingDirective(iContainerSymbol3);
        iContainerSymbol5.addUsingDirective(iContainerSymbol4);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol2 = iParameterizedSymbol.lookupNestedNameSpecifier("BC".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iContainerSymbol5);
        iSymbol2 = ((IContainerSymbol)iSymbol2).qualifiedLookup("a".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testUsing_SearchedOnce() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("b".toCharArray());
        iContainerSymbol2.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("A".toCharArray());
        iContainerSymbol3.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a".toCharArray());
        iContainerSymbol3.addSymbol(iSymbol2);
        iContainerSymbol2.addUsingDirective(iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol3 = iParameterizedSymbol.lookupNestedNameSpecifier("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iContainerSymbol3);
        ParserSymbolTableTest.assertTrue((boolean)(iSymbol3 instanceof IContainerSymbol));
        ISymbol iSymbol4 = ((IContainerSymbol)iSymbol3).qualifiedLookup("a".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol4, (Object)iSymbol2);
        iSymbol4 = ((IContainerSymbol)iSymbol3).qualifiedLookup("b".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol4, (Object)iSymbol);
        ISymbol iSymbol5 = iParameterizedSymbol.lookupNestedNameSpecifier("B".toCharArray());
        ParserSymbolTableTest.assertTrue((boolean)(iSymbol5 instanceof IContainerSymbol));
        iSymbol4 = ((IContainerSymbol)iSymbol5).qualifiedLookup("a".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol4, (Object)iSymbol2);
        iSymbol4 = ((IContainerSymbol)iSymbol5).qualifiedLookup("b".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol4, (Object)iSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testUsing_SearchedOnce_2() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("B".toCharArray());
        iContainerSymbol3.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        iContainerSymbol2.addUsingDirective(iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol2);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol3);
        ISymbol iSymbol = iParameterizedSymbol.lookup("i".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, null);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testNamespaceMemberHiding() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("x".toCharArray());
        iContainerSymbol3.setType(ITypeInfo.t_struct);
        iContainerSymbol2.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray());
        iSymbol.setType(ITypeInfo.t_int);
        iContainerSymbol2.addSymbol(iSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("y".toCharArray());
        iSymbol2.setType(ITypeInfo.t_int);
        iContainerSymbol2.addSymbol(iSymbol2);
        IContainerSymbol iContainerSymbol4 = this.table.newContainerSymbol("B".toCharArray());
        iContainerSymbol4.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol4);
        IContainerSymbol iContainerSymbol5 = this.table.newContainerSymbol("y".toCharArray());
        iContainerSymbol5.setType(ITypeInfo.t_struct);
        iContainerSymbol4.addSymbol((ISymbol)iContainerSymbol5);
        IContainerSymbol iContainerSymbol6 = this.table.newContainerSymbol("C".toCharArray());
        iContainerSymbol6.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol6);
        ISymbol iSymbol3 = iContainerSymbol6.lookup("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iContainerSymbol2);
        iContainerSymbol6.addUsingDirective(iContainerSymbol2);
        iSymbol3 = iContainerSymbol6.lookup("B".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iContainerSymbol4);
        iContainerSymbol6.addUsingDirective(iContainerSymbol4);
        iSymbol3 = iContainerSymbol6.lookupNestedNameSpecifier("C".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iContainerSymbol6);
        iSymbol3 = ((IContainerSymbol)iSymbol3).qualifiedLookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iSymbol);
        iSymbol3 = iContainerSymbol6.lookupNestedNameSpecifier("C".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iContainerSymbol6);
        try {
            iSymbol3 = ((IContainerSymbol)iSymbol3).qualifiedLookup("y".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testLookupMemberForDefinition() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("B".toCharArray());
        iContainerSymbol3.setType(ITypeInfo.t_namespace);
        iContainerSymbol2.addSymbol((ISymbol)iContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f1".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iContainerSymbol3.addSymbol((ISymbol)iParameterizedSymbol);
        iContainerSymbol2.addUsingDirective(iContainerSymbol3);
        ISymbol iSymbol = iContainerSymbol.lookupNestedNameSpecifier("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iContainerSymbol2, (Object)iSymbol);
        ParserSymbolTableTest.assertTrue((boolean)(iSymbol instanceof IContainerSymbol));
        ISymbol iSymbol2 = ((IContainerSymbol)iSymbol).lookupMemberForDefinition("f1".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, null);
        iSymbol2 = ((IContainerSymbol)iSymbol).qualifiedLookup("f1".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testUsingDeclaration() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_struct);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("E".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_enumeration);
        iDerivableContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("e".toCharArray());
        iSymbol.setType(ITypeInfo.t_enumerator);
        iContainerSymbol2.addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("C".toCharArray());
        iDerivableContainerSymbol2.setType(ITypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("D".toCharArray());
        iDerivableContainerSymbol3.setType(ITypeInfo.t_struct);
        ISymbol iSymbol2 = iContainerSymbol.lookup("B".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        ISymbol iSymbol3 = iDerivableContainerSymbol3.lookupNestedNameSpecifier("B".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iDerivableContainerSymbol);
        ParserSymbolTableTest.assertTrue((boolean)(iSymbol3 instanceof IContainerSymbol));
        iDerivableContainerSymbol3.addUsingDeclaration("f".toCharArray(), (IContainerSymbol)iSymbol3);
        iDerivableContainerSymbol3.addUsingDeclaration("e".toCharArray(), (IContainerSymbol)iSymbol3);
        iSymbol2 = iDerivableContainerSymbol3.lookupNestedNameSpecifier("C".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iDerivableContainerSymbol2);
        try {
            iDerivableContainerSymbol3.addUsingDeclaration("g".toCharArray(), (IContainerSymbol)iDerivableContainerSymbol2);
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertTrue((boolean)true);
        }
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testUsingDeclaration_2() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("A".toCharArray(), ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 0, null, false);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol = iContainerSymbol.lookupNestedNameSpecifier("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iContainerSymbol2);
        IUsingDeclarationSymbol iUsingDeclarationSymbol = iContainerSymbol.addUsingDeclaration("f".toCharArray(), iContainerSymbol2);
        ParserSymbolTableTest.assertEquals((int)iUsingDeclarationSymbol.getReferencedSymbols().size(), (int)1);
        ParserSymbolTableTest.assertEquals(iUsingDeclarationSymbol.getReferencedSymbols().get(0), (Object)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = (IParameterizedSymbol)iUsingDeclarationSymbol.getReferencedSymbols().get(0);
        iSymbol = iContainerSymbol.lookup("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol3.setType(ITypeInfo.t_function);
        iParameterizedSymbol3.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        iParameterizedSymbol3.addParameter(ITypeInfo.t_char, 0, null, false);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol3);
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("foo".toCharArray());
        iParameterizedSymbol4.setType(ITypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol4);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null);
        arrayList.add(iTypeInfo);
        iSymbol = iParameterizedSymbol4.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertTrue((boolean)iParameterizedSymbol2.hasSameParameters(iParameterizedSymbol));
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("bar".toCharArray());
        iParameterizedSymbol5.setType(ITypeInfo.t_function);
        iParameterizedSymbol5.addParameter(ITypeInfo.t_char, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol5);
        iSymbol = iParameterizedSymbol5.lookupNestedNameSpecifier("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iContainerSymbol2);
        iUsingDeclarationSymbol = iParameterizedSymbol5.addUsingDeclaration("f".toCharArray(), iContainerSymbol2);
        List list = iUsingDeclarationSymbol.getReferencedSymbols();
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iParameterizedSymbol));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iParameterizedSymbol3));
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)2);
        iSymbol = iParameterizedSymbol5.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertTrue((iSymbol != null ? 1 : 0) != 0);
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol3);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testThisPointer() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("class".toCharArray(), ITypeInfo.t_class);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("function".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iParameterizedSymbol.getTypeInfo().setBit(true, 1024);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol = iParameterizedSymbol.lookup("this".toCharArray());
        ParserSymbolTableTest.assertTrue((iSymbol != null ? 1 : 0) != 0);
        ParserSymbolTableTest.assertEquals((Object)iSymbol.getType(), (Object)ITypeInfo.t_type);
        ParserSymbolTableTest.assertEquals((Object)iSymbol.getTypeSymbol(), (Object)iDerivableContainerSymbol);
        ParserSymbolTableTest.assertTrue((boolean)iSymbol.getTypeInfo().checkBit(1024));
        ParserSymbolTableTest.assertEquals((Object)((ITypeInfo.PtrOp)iSymbol.getPtrOperators().iterator().next()).getType(), (Object)ITypeInfo.PtrOp.t_pointer);
        ParserSymbolTableTest.assertEquals((Object)iSymbol.getContainingSymbol(), (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testEnumerator() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("class".toCharArray());
        iContainerSymbol.setType(ITypeInfo.t_class);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("enumeration".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_enumeration);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("enumerator".toCharArray());
        iSymbol.setType(ITypeInfo.t_enumerator);
        iContainerSymbol2.addSymbol(iSymbol);
        ISymbol iSymbol2 = iContainerSymbol.lookup("enumerator".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ParserSymbolTableTest.assertEquals((Object)iSymbol2.getContainingSymbol(), (Object)iContainerSymbol);
        ParserSymbolTableTest.assertEquals((Object)iSymbol2.getTypeSymbol(), (Object)iContainerSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testArgumentDependentLookup() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("NS".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("T".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        iContainerSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        ISymbol iSymbol = iContainerSymbol2.lookup("T".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iParameterizedSymbol.addParameter(iSymbol, 0, null, false);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        iSymbol = iContainerSymbol.lookupNestedNameSpecifier("NS".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iContainerSymbol2);
        iSymbol = iContainerSymbol2.qualifiedLookup("T".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("parm".toCharArray());
        iSymbol2.setType(ITypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iContainerSymbol.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("main".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iParameterizedSymbol2.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_int));
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        iSymbol = iParameterizedSymbol2.lookup("parm".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iSymbol2);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol);
        arrayList.add(iTypeInfo);
        iSymbol = iParameterizedSymbol2.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testArgumentDependentLookup_2() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("NS1".toCharArray());
        iContainerSymbol2.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        iParameterizedSymbol.addParameter(ITypeInfo.t_void, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("NS2".toCharArray());
        iContainerSymbol3.setType(ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol = iContainerSymbol3.lookup("NS1".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iContainerSymbol2);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        iContainerSymbol3.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iParameterizedSymbol2.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        iParameterizedSymbol2.addParameter(ITypeInfo.t_void, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol3.addSymbol((ISymbol)iParameterizedSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A".toCharArray());
        iDerivableContainerSymbol2.setType(ITypeInfo.t_class);
        iSymbol = iContainerSymbol.lookupNestedNameSpecifier("NS2".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iContainerSymbol3);
        iSymbol = iContainerSymbol3.qualifiedLookup("B".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        iSymbol = iContainerSymbol.lookup("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a".toCharArray());
        iSymbol2.setType(ITypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iContainerSymbol.addSymbol(iSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        iSymbol = iContainerSymbol.lookup("a".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iSymbol2);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)iSymbol.getType(), (int)0, (ISymbol)iSymbol, null, (boolean)false);
        iTypeInfo.applyOperatorExpression(ITypeInfo.OperatorExpression.addressof);
        arrayList.add(iTypeInfo);
        iSymbol = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testFunctionOverloading() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("C".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 0, null, false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("foo".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iParameterizedSymbol2.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 0, null, false);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_char, 0, null, false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("foo".toCharArray());
        iParameterizedSymbol3.setType(ITypeInfo.t_function);
        iParameterizedSymbol3.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        iParameterizedSymbol3.addParameter(ITypeInfo.t_int, 0, null, false);
        iParameterizedSymbol3.addParameter(ITypeInfo.t_char, 0, null, false);
        iParameterizedSymbol3.addParameter((ISymbol)iDerivableContainerSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        ISymbol iSymbol = iContainerSymbol.lookup("C".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("c".toCharArray());
        iSymbol2.setType(ITypeInfo.t_type);
        iSymbol2.setTypeSymbol(iSymbol);
        iSymbol2.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, false, false));
        iContainerSymbol.addSymbol(iSymbol2);
        iSymbol = iContainerSymbol.lookup("c".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iSymbol2);
        ParserSymbolTableTest.assertEquals((Object)iSymbol.getTypeSymbol(), (Object)iDerivableContainerSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null);
        ITypeInfo iTypeInfo2 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null);
        ITypeInfo iTypeInfo3 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2);
        arrayList.add(iTypeInfo);
        iSymbol = iDerivableContainerSymbol.memberFunctionLookup("foo".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol);
        arrayList.add(iTypeInfo2);
        iSymbol = iDerivableContainerSymbol.memberFunctionLookup("foo".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol2);
        arrayList.add(iTypeInfo3);
        iSymbol = iDerivableContainerSymbol.memberFunctionLookup("foo".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol3);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testFunctionResolution() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_char, 0, null, true);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        arrayList.clear();
        ITypeInfo iTypeInfo2 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null);
        arrayList.add(iTypeInfo2);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        arrayList.clear();
        ITypeInfo iTypeInfo3 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_bool, (int)0, null);
        arrayList.add(iTypeInfo3);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), null);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testFunctionResolution_PointersAndBaseClasses() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray());
        iDerivableContainerSymbol2.setType(ITypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C".toCharArray());
        iDerivableContainerSymbol3.setType(ITypeInfo.t_class);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol2);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol2, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol = this.table.newSymbol("a".toCharArray());
        iSymbol.setType(ITypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, false, false));
        ISymbol iSymbol2 = this.table.newSymbol("c".toCharArray());
        iSymbol2.setType(ITypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        iSymbol2.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, false, false));
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        arrayList.clear();
        ITypeInfo iTypeInfo2 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2);
        arrayList.add(iTypeInfo2);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testFunctionResolution_TypedefsAndPointers() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("B".toCharArray());
        iSymbol.setType(ITypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol.getTypeInfo().setBit(true, 256);
        iSymbol.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, false, false));
        iContainerSymbol.addSymbol(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a".toCharArray());
        iSymbol2.setType(ITypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol(iSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("b".toCharArray());
        iSymbol3.setType(ITypeInfo.t_type);
        iSymbol3.setTypeSymbol(iSymbol);
        iContainerSymbol.addSymbol(iSymbol3);
        ISymbol iSymbol4 = this.table.newSymbol("array".toCharArray());
        iSymbol4.setType(ITypeInfo.t_type);
        iSymbol4.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol4.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_array, false, false));
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        iTypeInfo.applyOperatorExpression(ITypeInfo.OperatorExpression.addressof);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        iTypeInfo.setTypeSymbol(iSymbol3);
        iTypeInfo.getPtrOperators().clear();
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        iTypeInfo = iTypeInfo.getFinalType(null);
        iTypeInfo.applyOperatorExpression(ITypeInfo.OperatorExpression.indirection);
        arrayList.clear();
        arrayList.add(iTypeInfo);
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        iTypeInfo.setTypeSymbol(iSymbol4);
        iTypeInfo.getPtrOperators().clear();
        iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testUserDefinedConversionSequences() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray());
        iDerivableContainerSymbol2.setType(ITypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("B".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_constructor);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        iDerivableContainerSymbol2.addConstructor(iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol2, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol = this.table.newSymbol("a".toCharArray());
        iSymbol.setTypeInfo(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type));
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iContainerSymbol.addSymbol(iSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testOverloadRanking() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 1024, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, false, false), false);
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 8192, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        ISymbol iSymbol = this.table.newSymbol("i".toCharArray());
        iSymbol.setType(ITypeInfo.t_int);
        iContainerSymbol.addSymbol(iSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("s".toCharArray());
        iSymbol2.setType(ITypeInfo.t_int);
        iSymbol2.getTypeInfo().setBit(true, 8192);
        iContainerSymbol.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("main".toCharArray());
        iParameterizedSymbol3.setType(ITypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol);
        iTypeInfo.applyOperatorExpression(ITypeInfo.OperatorExpression.addressof);
        ITypeInfo iTypeInfo2 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2);
        arrayList.add(iTypeInfo);
        arrayList.add(iTypeInfo2);
        IParameterizedSymbol iParameterizedSymbol4 = null;
        try {
            iParameterizedSymbol4 = iParameterizedSymbol3.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        arrayList.clear();
        ITypeInfo iTypeInfo3 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)16384, null);
        arrayList.add(iTypeInfo);
        arrayList.add(iTypeInfo3);
        iParameterizedSymbol4 = iParameterizedSymbol3.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol2);
        arrayList.clear();
        ITypeInfo iTypeInfo4 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_char, (int)0, null);
        arrayList.add(iTypeInfo);
        arrayList.add(iTypeInfo4);
        iParameterizedSymbol4 = iParameterizedSymbol3.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol2);
        arrayList.clear();
        iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)1024, null, (ITypeInfo.PtrOp)new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, false, false), (boolean)false);
        arrayList.add(iTypeInfo);
        arrayList.add(iTypeInfo3);
        iParameterizedSymbol4 = iParameterizedSymbol3.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testUserDefinedConversionByOperator() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.getCompilationUnit();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B".toCharArray());
        iDerivableContainerSymbol.setType(ITypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A".toCharArray());
        iDerivableContainerSymbol2.setType(ITypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("A".toCharArray());
        iParameterizedSymbol.setType(ITypeInfo.t_constructor);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference), false);
        iDerivableContainerSymbol2.addConstructor(iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("operator A".toCharArray());
        iParameterizedSymbol2.setType(ITypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol3.setType(ITypeInfo.t_function);
        iParameterizedSymbol3.addParameter((ISymbol)iDerivableContainerSymbol2, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        ISymbol iSymbol = this.table.newSymbol("b".toCharArray());
        iSymbol.setType(ITypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol4 = null;
        try {
            iParameterizedSymbol4 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C".toCharArray());
        iDerivableContainerSymbol3.setType(ITypeInfo.t_class);
        iContainerSymbol.addSymbol((ISymbol)iDerivableContainerSymbol3);
        IParameterizedSymbol iParameterizedSymbol5 = this.table.newParameterizedSymbol("C".toCharArray());
        iParameterizedSymbol5.setType(ITypeInfo.t_constructor);
        iParameterizedSymbol5.addParameter((ISymbol)iDerivableContainerSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference), false);
        iDerivableContainerSymbol3.addConstructor(iParameterizedSymbol5);
        IParameterizedSymbol iParameterizedSymbol6 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol6.setType(ITypeInfo.t_function);
        iParameterizedSymbol6.addParameter((ISymbol)iDerivableContainerSymbol3, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol6);
        try {
            iParameterizedSymbol4 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        IParameterizedSymbol iParameterizedSymbol7 = this.table.newParameterizedSymbol("f".toCharArray());
        iParameterizedSymbol7.setType(ITypeInfo.t_function);
        iParameterizedSymbol7.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol7);
        iParameterizedSymbol4 = iContainerSymbol.unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol7);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testForwardClassDeclaration() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol.setIsForwardDeclaration(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.getCompilationUnit().lookup("A".toCharArray());
        ISymbol iSymbol2 = this.table.getCompilationUnit().elaboratedLookup(ITypeInfo.t_class, "A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iSymbol2);
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        ISymbol iSymbol3 = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_type);
        iSymbol3.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        iSymbol3.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        iSymbol = this.table.getCompilationUnit().lookup("A".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        ParserSymbolTableTest.assertTrue((boolean)iSymbol.isForwardDeclaration());
        iSymbol.setForwardSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        iSymbol = this.table.getCompilationUnit().lookup("a".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iSymbol3);
        ParserSymbolTableTest.assertEquals((Object)iSymbol3.getTypeSymbol(), (Object)iDerivableContainerSymbol2);
        iSymbol = this.table.getCompilationUnit().lookup("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol2);
        iSymbol = this.table.getCompilationUnit().elaboratedLookup(ITypeInfo.t_class, "A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testForwardDeclarationUsedAsFunctionParam() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol.setIsForwardDeclaration(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        ISymbol iSymbol = this.table.getCompilationUnit().lookup("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iParameterizedSymbol.addParameter(iSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        iParameterizedSymbol.getTypeInfo().setBit(true, 4);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 0, null, false);
        iParameterizedSymbol2.getTypeInfo().setBit(true, 4);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a1".toCharArray(), ITypeInfo.t_type);
        iSymbol = this.table.getCompilationUnit().lookup("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol);
        iSymbol2.setTypeSymbol(iSymbol);
        iSymbol2.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        iSymbol = this.table.getCompilationUnit().lookup("A".toCharArray());
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        ParserSymbolTableTest.assertTrue((boolean)iSymbol.isForwardDeclaration());
        iSymbol.setForwardSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("a2".toCharArray(), ITypeInfo.t_type);
        iSymbol = this.table.getCompilationUnit().lookup("A".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iDerivableContainerSymbol3);
        iSymbol3.setTypeSymbol(iSymbol);
        iSymbol3.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = iDerivableContainerSymbol2.memberFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        arrayList.clear();
        iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol3);
        arrayList.add(iTypeInfo);
        iParameterizedSymbol3 = iDerivableContainerSymbol2.memberFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testConstructors() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("A".toCharArray(), ITypeInfo.t_constructor);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference), false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("A".toCharArray(), ITypeInfo.t_constructor);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("A".toCharArray(), ITypeInfo.t_constructor);
        iParameterizedSymbol3.addParameter(ITypeInfo.t_char, 0, null, false);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol2);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol3);
        ParserSymbolTableTest.assertEquals((int)iDerivableContainerSymbol.getConstructors().size(), (int)3);
        IParameterizedSymbol iParameterizedSymbol4 = (IParameterizedSymbol)iParameterizedSymbol2.clone();
        try {
            iDerivableContainerSymbol.addConstructor(iParameterizedSymbol4);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)3);
        }
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        IParameterizedSymbol iParameterizedSymbol5 = iDerivableContainerSymbol.lookupConstructor(arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol5, (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testNamespaceAlias() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A".toCharArray(), ITypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("x".toCharArray(), ITypeInfo.t_int);
        iContainerSymbol.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B".toCharArray(), ITypeInfo.t_namespace);
        iContainerSymbol2.setForwardSymbol((ISymbol)iContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol2 = this.table.getCompilationUnit().lookup("B".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iContainerSymbol2);
        iSymbol2 = iContainerSymbol2.lookup("x".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol2, (Object)iSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testUsingNamespaceAlias() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A".toCharArray(), ITypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B".toCharArray(), ITypeInfo.t_namespace);
        iContainerSymbol2.setForwardSymbol((ISymbol)iContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol2);
        ArrayList arrayList = new ArrayList();
        IParameterizedSymbol iParameterizedSymbol2 = iContainerSymbol2.qualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
        this.table.getCompilationUnit().addUsingDirective(iContainerSymbol2);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBadParameterInfo() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol("".toCharArray(), ITypeInfo.t_void));
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, null);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol2, null);
        ISymbol iSymbol = this.table.newSymbol("".toCharArray(), ITypeInfo.t_type);
        iTypeInfo.setTypeSymbol(iSymbol);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol2, null);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testGetConditionalOperand_bug43106() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("b".toCharArray(), ITypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol);
        iTypeInfo.applyOperatorExpression(ITypeInfo.OperatorExpression.addressof);
        ITypeInfo iTypeInfo2 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2);
        iTypeInfo2.applyOperatorExpression(ITypeInfo.OperatorExpression.addressof);
        ITypeInfo iTypeInfo3 = this.table.getConditionalOperand(iTypeInfo, iTypeInfo2);
        ParserSymbolTableTest.assertEquals((Object)iTypeInfo3, (Object)iTypeInfo);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("c".toCharArray(), ITypeInfo.t_type);
        iSymbol3.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol(iSymbol3);
        ITypeInfo iTypeInfo4 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol3);
        iTypeInfo4.applyOperatorExpression(ITypeInfo.OperatorExpression.addressof);
        iTypeInfo3 = this.table.getConditionalOperand(iTypeInfo, iTypeInfo4);
        ParserSymbolTableTest.assertEquals((Object)iTypeInfo3, null);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("A".toCharArray(), ITypeInfo.t_constructor);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol3, 0, null, false);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("C".toCharArray(), ITypeInfo.t_constructor);
        iParameterizedSymbol2.addParameter((ISymbol)iDerivableContainerSymbol, 0, null, false);
        iDerivableContainerSymbol3.addConstructor(iParameterizedSymbol2);
        iTypeInfo.getPtrOperators().clear();
        iTypeInfo4.getPtrOperators().clear();
        try {
            iTypeInfo3 = this.table.getConditionalOperand(iTypeInfo, iTypeInfo4);
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testDerivedReference() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("C".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol, false, ASTAccessVisibility.PRIVATE, 0, null);
        ISymbol iSymbol = this.table.newSymbol("b".toCharArray(), ITypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("c".toCharArray(), ITypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter((ISymbol)iDerivableContainerSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference), false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.addParameter((ISymbol)iDerivableContainerSymbol2, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference), false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol3);
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol3);
        arrayList.clear();
        iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2);
        arrayList.add(iTypeInfo);
        try {
            iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testAddCopyConstructor() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_type);
        iSymbol.setTypeSymbol((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("b".toCharArray(), ITypeInfo.t_type);
        iSymbol2.setTypeSymbol((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol(iSymbol2);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol, null, (boolean)false);
        ITypeInfo iTypeInfo2 = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_type, (int)0, (ISymbol)iSymbol2, null, (boolean)false);
        ITypeInfo iTypeInfo3 = this.table.getConditionalOperand(iTypeInfo, iTypeInfo2);
        ParserSymbolTableTest.assertEquals((Object)iTypeInfo3, null);
        iDerivableContainerSymbol.addCopyConstructor();
        iDerivableContainerSymbol2.addCopyConstructor();
        iTypeInfo3 = this.table.getConditionalOperand(iTypeInfo, iTypeInfo2);
        ParserSymbolTableTest.assertEquals((Object)iTypeInfo3, (Object)iTypeInfo);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testbug43834() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_void, (int)0, null);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
        iParameterizedSymbol.addParameter(ITypeInfo.t_void, 0, null, false);
        arrayList.clear();
        iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug43503_AmbiguousUsing() throws Exception {
        this.newTable();
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A".toCharArray(), ITypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("B".toCharArray(), ITypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol = this.table.newSymbol("f".toCharArray(), ITypeInfo.t_int);
        iContainerSymbol2.addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("C".toCharArray(), ITypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol3);
        iContainerSymbol3.addUsingDirective(iContainerSymbol);
        iContainerSymbol3.addUsingDirective(iContainerSymbol2);
        try {
            iContainerSymbol3.addUsingDeclaration("f".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)0);
        }
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug43503_UnableToResolveFunction() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        try {
            this.table.getCompilationUnit().lookup("f".toCharArray());
            ParserSymbolTableTest.assertTrue((boolean)false);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            ParserSymbolTableTest.assertEquals((int)parserSymbolTableException.reason, (int)7);
        }
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug44510() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("initialize".toCharArray(), ITypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("initialize".toCharArray(), ITypeInfo.t_function);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("initialize".toCharArray(), new ArrayList());
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        iParameterizedSymbol.setIsForwardDeclaration(true);
        iParameterizedSymbol.setForwardSymbol((ISymbol)iParameterizedSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("initialize".toCharArray(), new ArrayList());
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug46882() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 0, null, false);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.addParameter(ITypeInfo.t_char, 0, null, false);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol3);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        IParameterizedSymbol iParameterizedSymbol4 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol4, (Object)iParameterizedSymbol3);
        arrayList.clear();
        iParameterizedSymbol4 = iDerivableContainerSymbol2.qualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol4, null);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testPrefixLookup_Unqualified() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        ISymbol iSymbol = this.table.newSymbol("aVar".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo".toCharArray(), ITypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("anotherVar".toCharArray(), ITypeInfo.t_int);
        iParameterizedSymbol.addSymbol(iSymbol2);
        List list = iParameterizedSymbol.prefixLookup(null, "a".toCharArray(), false, null);
        ParserSymbolTableTest.assertTrue((list != null ? 1 : 0) != 0);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)2);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol2));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testPrefixLookup_Qualified() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        ISymbol iSymbol = this.table.newSymbol("aVar".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("D".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("aField".toCharArray(), ITypeInfo.t_int);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("aMethod".toCharArray(), ITypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        List list = iDerivableContainerSymbol.prefixLookup(null, "a".toCharArray(), true, null);
        ParserSymbolTableTest.assertTrue((list != null ? 1 : 0) != 0);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)2);
        ParserSymbolTableTest.assertTrue((!list.contains(iSymbol) ? 1 : 0) != 0);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol2));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iParameterizedSymbol));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testPrefixLookup_Inheritance() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        ISymbol iSymbol = this.table.newSymbol("aVar".toCharArray(), ITypeInfo.t_int);
        ISymbol iSymbol2 = this.table.newSymbol("anotherVar".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("af".toCharArray(), ITypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol2.addParent((ISymbol)iDerivableContainerSymbol);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol3 = this.table.newSymbol("anotherVar".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol3);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("af".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_char, 0, null, false);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        List list = iDerivableContainerSymbol2.prefixLookup(null, "a".toCharArray(), true, null);
        ParserSymbolTableTest.assertTrue((list != null ? 1 : 0) != 0);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)3);
        ParserSymbolTableTest.assertTrue((!list.contains(iSymbol2) ? 1 : 0) != 0);
        ParserSymbolTableTest.assertTrue((!list.contains(iParameterizedSymbol) ? 1 : 0) != 0);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol3));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iParameterizedSymbol2));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testPrefixLookup_Ambiguities() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        ISymbol iSymbol = this.table.newSymbol("aa".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("".toCharArray(), ITypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        IContainerSymbol iContainerSymbol2 = this.table.newContainerSymbol("U".toCharArray(), ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol2);
        ISymbol iSymbol2 = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_int);
        iContainerSymbol2.addSymbol(iSymbol2);
        IContainerSymbol iContainerSymbol3 = this.table.newContainerSymbol("V".toCharArray(), ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_int);
        iContainerSymbol3.addSymbol(iSymbol3);
        IContainerSymbol iContainerSymbol4 = this.table.newContainerSymbol("W".toCharArray(), ITypeInfo.t_namespace);
        iContainerSymbol.addSymbol((ISymbol)iContainerSymbol4);
        ISymbol iSymbol4 = this.table.newSymbol("a".toCharArray(), ITypeInfo.t_int);
        iContainerSymbol4.addSymbol(iSymbol4);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol2);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol3);
        iParameterizedSymbol.addUsingDirective(iContainerSymbol4);
        List list = iParameterizedSymbol.prefixLookup(null, "a".toCharArray(), false, null);
        ParserSymbolTableTest.assertTrue((list != null ? 1 : 0) != 0);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)1);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testQualifiedUnqualifiedLookup() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("i".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("g".toCharArray(), ITypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals(null, (Object)iDerivableContainerSymbol.qualifiedLookup("i".toCharArray()));
        ParserSymbolTableTest.assertEquals((Object)iSymbol, (Object)iParameterizedSymbol.lookup("i".toCharArray()));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testVisibilityDetermination() throws Exception {
        this.newTable();
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("D".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        ISymbol iSymbol = this.table.newSymbol("i".toCharArray(), ITypeInfo.t_int);
        ISymbol iSymbol2 = this.table.newSymbol("j".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        ISymbol iSymbol3 = iDerivableContainerSymbol2.lookupForFriendship("D".toCharArray());
        ParserSymbolTableTest.assertEquals((Object)iSymbol3, (Object)iDerivableContainerSymbol);
        iDerivableContainerSymbol2.addFriend(iSymbol3);
        iDerivableContainerSymbol2.addSymbol(iSymbol);
        iDerivableContainerSymbol2.addSymbol(iSymbol2);
        ASTCompilationUnit aSTCompilationUnit = new ASTCompilationUnit((ISymbol)this.table.getCompilationUnit());
        StandardSymbolExtension standardSymbolExtension = new StandardSymbolExtension((ISymbol)this.table.getCompilationUnit(), (ASTSymbol)aSTCompilationUnit);
        this.table.getCompilationUnit().setASTExtension((ISymbolASTExtension)standardSymbolExtension);
        ASTClassSpecifier aSTClassSpecifier = new ASTClassSpecifier((ISymbol)iDerivableContainerSymbol2, ASTClassKind.CLASS, IASTClassSpecifier.ClassNameType.IDENTIFIER, ASTAccessVisibility.PUBLIC, 0, 0, 0, 0, 0, new ArrayList(), EMPTY_CHAR_ARRAY);
        StandardSymbolExtension standardSymbolExtension2 = new StandardSymbolExtension((ISymbol)iDerivableContainerSymbol2, (ASTSymbol)aSTClassSpecifier);
        iDerivableContainerSymbol2.setASTExtension((ISymbolASTExtension)standardSymbolExtension2);
        ASTField aSTField = new ASTField(iSymbol, null, null, null, 0, 0, 0, 0, 0, new ArrayList(), false, null, ASTAccessVisibility.PUBLIC, EMPTY_CHAR_ARRAY);
        StandardSymbolExtension standardSymbolExtension3 = new StandardSymbolExtension(iSymbol, (ASTSymbol)aSTField);
        iSymbol.setASTExtension((ISymbolASTExtension)standardSymbolExtension3);
        aSTField = new ASTField(iSymbol, null, null, null, 0, 0, 0, 0, 0, new ArrayList(), false, null, ASTAccessVisibility.PRIVATE, EMPTY_CHAR_ARRAY);
        standardSymbolExtension3 = new StandardSymbolExtension(iSymbol2, (ASTSymbol)aSTField);
        iSymbol2.setASTExtension((ISymbolASTExtension)standardSymbolExtension3);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol3.addParent((ISymbol)iDerivableContainerSymbol2, false, ASTAccessVisibility.PRIVATE, 0, null);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol4 = this.table.newDerivableContainerSymbol("C".toCharArray(), ITypeInfo.t_class);
        iDerivableContainerSymbol4.addParent((ISymbol)iDerivableContainerSymbol3);
        iDerivableContainerSymbol4.addParent((ISymbol)iDerivableContainerSymbol2);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol4);
        ParserSymbolTableTest.assertTrue((boolean)this.table.getCompilationUnit().isVisible(iSymbol, (IContainerSymbol)iDerivableContainerSymbol2));
        ParserSymbolTableTest.assertFalse((boolean)this.table.getCompilationUnit().isVisible(iSymbol, (IContainerSymbol)iDerivableContainerSymbol3));
        ParserSymbolTableTest.assertTrue((boolean)this.table.getCompilationUnit().isVisible(iSymbol, (IContainerSymbol)iDerivableContainerSymbol4));
        ParserSymbolTableTest.assertTrue((boolean)iDerivableContainerSymbol.isVisible(iSymbol2, (IContainerSymbol)iDerivableContainerSymbol2));
        ParserSymbolTableTest.assertFalse((boolean)iDerivableContainerSymbol.isVisible(iSymbol2, (IContainerSymbol)iDerivableContainerSymbol3));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testPrefixFiltering() throws Exception {
        this.newTable(ParserLanguage.CPP, ParserMode.COMPLETION_PARSE);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("a1".toCharArray(), ITypeInfo.t_struct);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("aFoo".toCharArray(), ITypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        ISymbol iSymbol = this.table.newSymbol("aa".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol2 = this.table.newDerivableContainerSymbol("A2".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol2);
        IDerivableContainerSymbol iDerivableContainerSymbol3 = this.table.newDerivableContainerSymbol("a3".toCharArray(), ITypeInfo.t_struct);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iDerivableContainerSymbol3);
        ISymbol iSymbol2 = this.table.newSymbol("a3".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol2.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("aF".toCharArray(), ITypeInfo.t_function);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iDerivableContainerSymbol2.addSymbol((ISymbol)iParameterizedSymbol3);
        ISymbol iSymbol3 = this.table.newSymbol("aLocal".toCharArray(), ITypeInfo.t_int);
        iParameterizedSymbol3.addSymbol(iSymbol3);
        List list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.STRUCTURES), "A".toCharArray(), false, null);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)3);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iDerivableContainerSymbol));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iDerivableContainerSymbol2));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iDerivableContainerSymbol3));
        list = iParameterizedSymbol3.prefixLookup(null, "a".toCharArray(), false, null);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)7);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iParameterizedSymbol2));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iDerivableContainerSymbol2));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol2));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iDerivableContainerSymbol));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iParameterizedSymbol));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol));
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol3));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.FUNCTIONS), "a".toCharArray(), false, null);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)1);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iParameterizedSymbol));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.METHODS), "a".toCharArray(), false, null);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)1);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iParameterizedSymbol2));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.LOCAL_VARIABLES), "a".toCharArray(), false, null);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)1);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol3));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.VARIABLES), "a".toCharArray(), false, null);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)1);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol));
        list = iParameterizedSymbol3.prefixLookup(new TypeFilter(IASTNode.LookupKind.FIELDS), "a".toCharArray(), false, null);
        ParserSymbolTableTest.assertEquals((int)list.size(), (int)1);
        ParserSymbolTableTest.assertTrue((boolean)list.contains(iSymbol2));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug43110_Ellipses() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setHasVariableArgs(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.getCompilationUnit().unqualifiedFunctionLookup("foo".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol, (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug43110_EllipsesRanking() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.setHasVariableArgs(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("foo".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null);
        arrayList.add(iTypeInfo);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("foo".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol2, (Object)iParameterizedSymbol3);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug43110_ElipsesRanking_2() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 0, null, true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("foo".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.setHasVariableArgs(true);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        ArrayList arrayList = new ArrayList();
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("foo".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol, (Object)iParameterizedSymbol3);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testIterator_1() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("global".toCharArray(), ITypeInfo.t_int);
        this.table.getCompilationUnit().addSymbol(iSymbol);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("A".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("A".toCharArray(), ITypeInfo.t_constructor);
        iDerivableContainerSymbol.addConstructor(iParameterizedSymbol);
        ISymbol iSymbol2 = this.table.newSymbol("var".toCharArray(), ITypeInfo.t_int);
        iDerivableContainerSymbol.addSymbol(iSymbol2);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("foo".toCharArray(), ITypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        Iterator iterator = this.table.getCompilationUnit().getContentsIterator();
        ParserSymbolTableTest.assertEquals(iterator.next(), (Object)iSymbol);
        IContainerSymbol iContainerSymbol = (IContainerSymbol)iterator.next();
        ParserSymbolTableTest.assertEquals((Object)iContainerSymbol, (Object)iDerivableContainerSymbol);
        ParserSymbolTableTest.assertFalse((boolean)iterator.hasNext());
        iterator = iContainerSymbol.getContentsIterator();
        ParserSymbolTableTest.assertEquals(iterator.next(), (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals(iterator.next(), (Object)iSymbol2);
        ParserSymbolTableTest.assertEquals(iterator.next(), (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertFalse((boolean)iterator.hasNext());
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testIterator_2() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("foo".toCharArray(), ITypeInfo.t_function);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol = this.table.newContainerSymbol("A".toCharArray(), ITypeInfo.t_namespace);
        this.table.getCompilationUnit().addSymbol((ISymbol)iContainerSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("bar".toCharArray(), ITypeInfo.t_function);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol2);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("bar".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.addParameter(ITypeInfo.t_int, 0, null, false);
        iContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol3);
        IDerivableContainerSymbol iDerivableContainerSymbol = this.table.newDerivableContainerSymbol("B".toCharArray(), ITypeInfo.t_class);
        this.table.getCompilationUnit().addSymbol((ISymbol)iDerivableContainerSymbol);
        iDerivableContainerSymbol.addCopyConstructor();
        IParameterizedSymbol iParameterizedSymbol4 = this.table.newParameterizedSymbol("func".toCharArray(), ITypeInfo.t_function);
        iDerivableContainerSymbol.addSymbol((ISymbol)iParameterizedSymbol4);
        IUsingDirectiveSymbol iUsingDirectiveSymbol = iParameterizedSymbol4.addUsingDirective(iContainerSymbol);
        Iterator iterator = this.table.getCompilationUnit().getContentsIterator();
        ParserSymbolTableTest.assertEquals(iterator.next(), (Object)iParameterizedSymbol);
        IContainerSymbol iContainerSymbol2 = (IContainerSymbol)iterator.next();
        ParserSymbolTableTest.assertEquals((Object)iContainerSymbol2, (Object)iContainerSymbol);
        IContainerSymbol iContainerSymbol3 = (IContainerSymbol)iterator.next();
        ParserSymbolTableTest.assertEquals((Object)iContainerSymbol3, (Object)iDerivableContainerSymbol);
        ParserSymbolTableTest.assertFalse((boolean)iterator.hasNext());
        iterator = iContainerSymbol2.getContentsIterator();
        ParserSymbolTableTest.assertEquals(iterator.next(), (Object)iParameterizedSymbol2);
        ParserSymbolTableTest.assertEquals(iterator.next(), (Object)iParameterizedSymbol3);
        ParserSymbolTableTest.assertFalse((boolean)iterator.hasNext());
        iterator = iContainerSymbol3.getContentsIterator();
        ISymbol iSymbol = (ISymbol)iterator.next();
        ParserSymbolTableTest.assertTrue((boolean)(iSymbol instanceof IParameterizedSymbol));
        ParserSymbolTableTest.assertTrue((boolean)CharArrayUtils.equals((char[])iSymbol.getName(), (char[])"B".toCharArray()));
        ParserSymbolTableTest.assertEquals((Object)iSymbol.getType(), (Object)ITypeInfo.t_constructor);
        ParserSymbolTableTest.assertEquals(iterator.next(), (Object)iParameterizedSymbol4);
        ParserSymbolTableTest.assertFalse((boolean)iterator.hasNext());
        iterator = iParameterizedSymbol4.getContentsIterator();
        ISymbol iSymbol2 = (ISymbol)iterator.next();
        ParserSymbolTableTest.assertTrue((boolean)CharArrayUtils.equals((char[])iSymbol2.getName(), (char[])"this".toCharArray()));
        ParserSymbolTableTest.assertEquals((Object)iSymbol2.getTypeSymbol(), (Object)iDerivableContainerSymbol);
        ParserSymbolTableTest.assertEquals(iterator.next(), (Object)iUsingDirectiveSymbol);
        ParserSymbolTableTest.assertFalse((boolean)iterator.hasNext());
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testLongLong() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 262144, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 16384, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)16384, null));
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)262144, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testComplex() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_float, 65536, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_float, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_float, (int)65536, null));
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_float, (int)0, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_float, (int)65536, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("g".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_float, (int)131072, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("g".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void test_Bool() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t__Bool, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 0, null, false);
        this.table.getCompilationUnit().addSymbol((ISymbol)iParameterizedSymbol2);
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t__Bool, (int)0, null));
        IParameterizedSymbol iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("g".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol2);
        arrayList.clear();
        arrayList.add(TypeInfoProvider.newTypeInfo((ITypeInfo.eType)ITypeInfo.t_int, (int)0, null));
        iParameterizedSymbol3 = this.table.getCompilationUnit().unqualifiedFunctionLookup("f".toCharArray(), arrayList);
        ParserSymbolTableTest.assertEquals((Object)iParameterizedSymbol3, (Object)iParameterizedSymbol);
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug47636FunctionParameterComparisons_1() throws Exception {
        this.newTable();
        ISymbol iSymbol = this.table.newSymbol("Int".toCharArray(), ITypeInfo.t_type);
        iSymbol.getTypeInfo().setBit(true, 256);
        iSymbol.setTypeSymbol(this.table.newSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY, ITypeInfo.t_int));
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(iSymbol, 0, null, false);
        ParserSymbolTableTest.assertTrue((boolean)iParameterizedSymbol.hasSameParameters(iParameterizedSymbol2));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug47636FunctionParameterComparisons_2() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("g".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_char, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("g".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_char, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_array), false);
        ParserSymbolTableTest.assertTrue((boolean)iParameterizedSymbol.hasSameParameters(iParameterizedSymbol2));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug47636FunctionParameterComparisons_3() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY, ITypeInfo.t_function);
        iParameterizedSymbol.setReturnType(this.table.newSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY, ITypeInfo.t_int));
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("h".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter((ISymbol)iParameterizedSymbol, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol3 = this.table.newParameterizedSymbol("h".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol3.addParameter((ISymbol)iParameterizedSymbol, 0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer), false);
        ParserSymbolTableTest.assertTrue((boolean)iParameterizedSymbol2.hasSameParameters(iParameterizedSymbol3));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }

    public void testBug47636FunctionParameterComparisons_4() throws Exception {
        this.newTable();
        IParameterizedSymbol iParameterizedSymbol = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol.addParameter(ITypeInfo.t_int, 0, null, false);
        IParameterizedSymbol iParameterizedSymbol2 = this.table.newParameterizedSymbol("f".toCharArray(), ITypeInfo.t_function);
        iParameterizedSymbol2.addParameter(ITypeInfo.t_int, 1024, null, false);
        ParserSymbolTableTest.assertTrue((boolean)iParameterizedSymbol.hasSameParameters(iParameterizedSymbol2));
        ParserSymbolTableTest.assertEquals((int)this.table.getTypeInfoProvider().numAllocated(), (int)0);
    }
}

