/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.util.Iterator;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.BaseASTTest;

public class QuickParseASTQualifiedNameTest
extends BaseASTTest {
    public QuickParseASTQualifiedNameTest(String string) {
        super(string);
    }

    public void testNamespace() throws Exception {
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)this.assertSoleDeclaration("namespace A { namespace B { int x; } }");
        this.assertQualifiedName(iASTNamespaceDefinition.getFullyQualifiedName(), new String[]{"A"});
        IASTNamespaceDefinition iASTNamespaceDefinition2 = (IASTNamespaceDefinition)iASTNamespaceDefinition.getDeclarations().next();
        this.assertQualifiedName(iASTNamespaceDefinition2.getFullyQualifiedName(), new String[]{"A", "B"});
    }

    public void testClass() throws Exception {
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)this.assertSoleDeclaration("class A { class B { int a; }; };");
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        this.assertQualifiedName(iASTClassSpecifier.getFullyQualifiedName(), new String[]{"A"});
        Iterator iterator = iASTClassSpecifier.getDeclarations();
        iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        QuickParseASTQualifiedNameTest.assertFalse((boolean)iterator.hasNext());
        iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        this.assertQualifiedName(iASTClassSpecifier.getFullyQualifiedName(), new String[]{"A", "B"});
    }

    public void testEnum() throws Exception {
        Iterator iterator = this.parse("class A { enum E1 { enumerator = 1 }; };\n namespace N { enum E2 { enumerator = 4 }; }\n").getDeclarations();
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)iterator.next();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iASTClassSpecifier.getDeclarations().next()).getTypeSpecifier();
        this.assertQualifiedName(iASTEnumerationSpecifier.getFullyQualifiedName(), new String[]{"A", "E1"});
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iterator.next();
        iASTEnumerationSpecifier = (IASTEnumerationSpecifier)((IASTAbstractTypeSpecifierDeclaration)iASTNamespaceDefinition.getDeclarations().next()).getTypeSpecifier();
        this.assertQualifiedName(iASTEnumerationSpecifier.getFullyQualifiedName(), new String[]{"N", "E2"});
        QuickParseASTQualifiedNameTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testVariable() throws Exception {
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)this.assertSoleDeclaration("namespace A { int x; namespace B { int y; } }");
        Iterator iterator = iASTNamespaceDefinition.getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        this.assertQualifiedName(iASTVariable.getFullyQualifiedName(), new String[]{"A", "x"});
        Iterator iterator2 = ((IASTNamespaceDefinition)iterator.next()).getDeclarations();
        QuickParseASTQualifiedNameTest.assertFalse((boolean)iterator.hasNext());
        iASTVariable = (IASTVariable)iterator2.next();
        this.assertQualifiedName(iASTVariable.getFullyQualifiedName(), new String[]{"A", "B", "y"});
    }

    public void testTypedef() throws Exception {
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)this.assertSoleDeclaration("namespace FLEA { typedef int GODS_INT; class ANTHONY { typedef ANTHONY * tonyPointer; }; }");
        Iterator iterator = iASTNamespaceDefinition.getDeclarations();
        this.assertQualifiedName(((IASTTypedefDeclaration)iterator.next()).getFullyQualifiedName(), new String[]{"FLEA", "GODS_INT"});
        this.assertQualifiedName(((IASTTypedefDeclaration)((IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier()).getDeclarations().next()).getFullyQualifiedName(), new String[]{"FLEA", "ANTHONY", "tonyPointer"});
    }

    public void testMembers() throws Exception {
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)this.assertSoleDeclaration("namespace John { class David { int Shannon; void Camelon(); }; } ");
        Iterator iterator = ((IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iASTNamespaceDefinition.getDeclarations().next()).getTypeSpecifier()).getDeclarations();
        this.assertQualifiedName(((IASTField)iterator.next()).getFullyQualifiedName(), new String[]{"John", "David", "Shannon"});
        this.assertQualifiedName(((IASTMethod)iterator.next()).getFullyQualifiedName(), new String[]{"John", "David", "Camelon"});
    }

    public void testFunction() throws Exception {
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)this.assertSoleDeclaration("namespace Bogdan { void Wears(); namespace Fancy { int Pants(); } }");
        Iterator iterator = iASTNamespaceDefinition.getDeclarations();
        this.assertQualifiedName(((IASTFunction)iterator.next()).getFullyQualifiedName(), new String[]{"Bogdan", "Wears"});
        this.assertQualifiedName(((IASTFunction)((IASTNamespaceDefinition)iterator.next()).getDeclarations().next()).getFullyQualifiedName(), new String[]{"Bogdan", "Fancy", "Pants"});
    }
}

