/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.tests.SpeedTest;

public class ScannerSpeedTest
extends SpeedTest {
    private static final ISourceElementRequestor CALLBACK = new NullSourceElementRequestor();
    private PrintStream stream;

    public static void main(String[] stringArray) {
        try {
            PrintStream printStream = null;
            if (stringArray.length > 0) {
                printStream = new PrintStream(new FileOutputStream(stringArray[0]));
            }
            new ScannerSpeedTest().runTest(printStream, 1);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void test() throws Exception {
        this.runTest(10);
    }

    private void runTest(PrintStream printStream, int n) throws Exception {
        this.stream = printStream;
        this.runTest(n);
    }

    private void runTest(int n) throws Exception {
        String string = "#include <windows.h>\n#include <stdio.h>\n#include <iostream>\n";
        CodeReader codeReader = new CodeReader(string.toCharArray());
        IScannerInfo iScannerInfo = this.getScannerInfo(false);
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            long l2 = this.testScan(codeReader, false, iScannerInfo, ParserLanguage.CPP);
            if (n2 > 0) {
                l += l2;
            }
            ++n2;
        }
        if (n > 1) {
            System.out.println("Average Time: " + l / (long)(n - 1) + " millisecs");
        }
    }

    protected long testScan(CodeReader codeReader, boolean bl, IScannerInfo iScannerInfo, ParserLanguage parserLanguage) throws Exception {
        ParserMode parserMode = bl ? ParserMode.QUICK_PARSE : ParserMode.COMPLETE_PARSE;
        IScanner iScanner = ParserFactory.createScanner((CodeReader)codeReader, (IScannerInfo)iScannerInfo, (ParserMode)parserMode, (ParserLanguage)parserLanguage, (ISourceElementRequestor)CALLBACK, null, (List)Collections.EMPTY_LIST);
        long l = System.currentTimeMillis();
        int n = 0;
        try {
            while (true) {
                IToken iToken = iScanner.nextToken();
                if (this.stream != null) {
                    this.stream.println(iToken.getImage());
                }
                if (iToken != null) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (EndOfFileException endOfFileException) {}
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Resulting scan took " + l2 + " millisecs " + n + " tokens");
        return l2;
    }
}

