/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.SelectionParseBaseTest;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTParameterDeclaration;

public class SelectionParseTest
extends SelectionParseBaseTest {
    public void testBaseCase_VariableReference() throws Exception {
        String string = "void f() { int x; x=3; }";
        int n = string.indexOf("x=");
        int n2 = string.indexOf(61);
        IASTNode iASTNode = this.parse(string, n, n2);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTVariable));
        SelectionParseTest.assertEquals((String)((IASTVariable)iASTNode).getName(), (String)"x");
    }

    public void testBaseCase_FunctionReference() throws Exception {
        String string = "int x(){x( );}";
        int n = string.indexOf("x( ");
        int n2 = string.indexOf("( )");
        IASTNode iASTNode = this.parse(string, n, n2);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTFunction));
        SelectionParseTest.assertEquals((String)((IASTFunction)iASTNode).getName(), (String)"x");
    }

    public void testBaseCase_Error() throws Exception {
        String string = "int x() { y( ) }";
        int n = string.indexOf("y( ");
        int n2 = string.indexOf("( )");
        SelectionParseTest.assertNull((Object)this.parse(string, n, n2, false));
    }

    public void testBaseCase_FunctionDeclaration() throws Exception {
        String string = "int x(); x( );";
        int n = string.indexOf("x()");
        int n2 = string.indexOf("()");
        IASTNode iASTNode = this.parse(string, n, n2);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTFunction));
        SelectionParseTest.assertEquals((String)((IASTFunction)iASTNode).getName(), (String)"x");
    }

    public void testBaseCase_FunctionDeclaration2() throws Exception {
        String string = "int printf( const char *, ... ); ";
        int n = string.indexOf("printf");
        int n2 = string.indexOf("( const");
        IASTNode iASTNode = this.parse(string, n, n2);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTFunction));
        SelectionParseTest.assertEquals((String)((IASTFunction)iASTNode).getName(), (String)"printf");
    }

    public void testBaseCase_VariableDeclaration() throws Exception {
        String string = "int x = 3;";
        int n = string.indexOf("x");
        int n2 = string.indexOf(" =");
        IASTNode iASTNode = this.parse(string, n, n2);
        SelectionParseTest.assertNotNull((Object)iASTNode);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTVariable));
        SelectionParseTest.assertEquals((String)((IASTVariable)iASTNode).getName(), (String)"x");
    }

    public void testBaseCase_Parameter() throws Exception {
        String string = "int main( int argc ) { int x = argc; }";
        int n = string.indexOf("argc;");
        int n2 = string.indexOf(";");
        IASTNode iASTNode = this.parse(string, n, n2);
        SelectionParseTest.assertNotNull((Object)iASTNode);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTParameterDeclaration));
        SelectionParseTest.assertEquals((String)((IASTParameterDeclaration)iASTNode).getName(), (String)"argc");
    }

    public void testBug57898() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Gonzo {  public: void playHorn(); };\n");
        ((Writer)stringWriter).write("void Gonzo::playHorn() { return; }\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) { Gonzo gonzo; gonzo.playHorn(); }\n");
        String string = ((Object)stringWriter).toString();
        int n = 0;
        while (n < 3) {
            int n2 = -1;
            int n3 = -1;
            switch (n) {
                case 0: {
                    n2 = string.indexOf("void playHorn") + 5;
                    break;
                }
                case 1: {
                    n2 = string.indexOf("::playHorn") + 2;
                    break;
                }
                case 2: {
                    n2 = string.indexOf(".playHorn") + 1;
                }
            }
            n3 = n2 + 8;
            IASTNode iASTNode = this.parse(string, n2, n3);
            SelectionParseTest.assertNotNull((Object)iASTNode);
            SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
            IASTMethod iASTMethod = (IASTMethod)iASTNode;
            SelectionParseTest.assertEquals((String)iASTMethod.getName(), (String)"playHorn");
            IASTClassSpecifier iASTClassSpecifier = iASTMethod.getOwnerClassSpecifier();
            SelectionParseTest.assertEquals((String)iASTClassSpecifier.getName(), (String)"Gonzo");
            ++n;
        }
    }

    public void testConstructorDestructorDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Gonzo { Gonzo(); ~Gonzo(); };");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(" Gonzo()") + 1;
        IASTNode iASTNode = this.parse(string, n, n + 5);
        SelectionParseTest.assertNotNull((Object)iASTNode);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        IASTMethod iASTMethod = (IASTMethod)iASTNode;
        SelectionParseTest.assertEquals((String)iASTMethod.getName(), (String)"Gonzo");
        SelectionParseTest.assertTrue((boolean)iASTMethod.isConstructor());
        n = string.indexOf("~Gonzo");
        iASTNode = this.parse(string, n, n + 6);
        SelectionParseTest.assertNotNull((Object)iASTNode);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        IASTMethod iASTMethod2 = (IASTMethod)iASTNode;
        SelectionParseTest.assertEquals((String)iASTMethod2.getName(), (String)"~Gonzo");
        SelectionParseTest.assertTrue((boolean)iASTMethod2.isDestructor());
    }

    public void testBug60264() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace Muppets { int i;\t}\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\tMuppets::i = 1; }\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("Muppets::");
        IASTNode iASTNode = this.parse(string, n, n + 7);
        SelectionParseTest.assertNotNull((Object)iASTNode);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTNamespaceDefinition));
        IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iASTNode;
        SelectionParseTest.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"Muppets");
        SelectionParseTest.assertEquals((int)iASTNamespaceDefinition.getStartingLine(), (int)1);
        n = string.indexOf("e Muppets") + 2;
        iASTNode = this.parse(string, n, n + 7);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTNamespaceDefinition));
        iASTNamespaceDefinition = (IASTNamespaceDefinition)iASTNode;
        SelectionParseTest.assertEquals((String)iASTNamespaceDefinition.getName(), (String)"Muppets");
        SelectionParseTest.assertEquals((int)iASTNamespaceDefinition.getStartingLine(), (int)1);
    }

    public void testBug61613() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Foo {  // ** (A) **\n");
        ((Writer)stringWriter).write("\tpublic:\n");
        ((Writer)stringWriter).write("Foo() {};\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int \n");
        ((Writer)stringWriter).write("main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("Foo foo;  // ** (B) **\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("class Foo") + 6;
        IASTNode iASTNode = this.parse(string, n, n + 3);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTClassSpecifier));
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTNode;
        SelectionParseTest.assertEquals((String)iASTClassSpecifier.getName(), (String)"Foo");
    }

    public void testBug60038() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Gonzo {\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("Gonzo( const Gonzo & other ){}\n");
        ((Writer)stringWriter).write("Gonzo()\t{}\n");
        ((Writer)stringWriter).write("~Gonzo(){}\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write(" Gonzo * g = new Gonzo();\n");
        ((Writer)stringWriter).write(" Gonzo * g2 = new Gonzo( *g );\n");
        ((Writer)stringWriter).write(" g->~Gonzo();\n");
        ((Writer)stringWriter).write(" return (int) g2;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case 0: {
                    n2 = string.indexOf("new Gonzo()") + 4;
                    n3 = n2 + 5;
                    break;
                }
                case 1: {
                    n2 = string.indexOf("new Gonzo( ") + 4;
                    n3 = n2 + 5;
                    break;
                }
                default: {
                    n2 = string.indexOf("->~") + 2;
                    n3 = n2 + 6;
                }
            }
            IASTNode iASTNode = this.parse(string, n2, n3);
            SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
            IASTMethod iASTMethod = (IASTMethod)iASTNode;
            switch (n) {
                case 0: 
                case 1: {
                    SelectionParseTest.assertTrue((boolean)iASTMethod.isConstructor());
                    SelectionParseTest.assertFalse((boolean)iASTMethod.isDestructor());
                    break;
                }
                default: {
                    SelectionParseTest.assertFalse((boolean)iASTMethod.isConstructor());
                    SelectionParseTest.assertTrue((boolean)iASTMethod.isDestructor());
                }
            }
            ++n;
        }
    }

    public void testMethodReference() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Sample { public:\n");
        ((Writer)stringWriter).write("  int getAnswer() const;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write(" Sample * s = new Sample();\n");
        ((Writer)stringWriter).write(" return s->getAnswer();\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("->getAnswer") + 2;
        IASTNode iASTNode = this.parse(string, n, n + 9);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        SelectionParseTest.assertEquals((String)((IASTMethod)iASTNode).getName(), (String)"getAnswer");
    }

    public void testConstructorDefinition() throws Exception {
        String string = "class ABC { public: ABC(); }; ABC::ABC(){}";
        int n = string.indexOf("::ABC") + 2;
        IASTNode iASTNode = this.parse(string, n, n + 3);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        IASTMethod iASTMethod = (IASTMethod)iASTNode;
        SelectionParseTest.assertTrue((boolean)iASTMethod.isConstructor());
    }

    public void testBug63966() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("void foo(int a) {}\n");
        ((Writer)stringWriter).write("void foo(long a) {}\n");
        ((Writer)stringWriter).write("int main(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("foo(1); \n }");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("foo(1)");
        this.parse(string, n, n + 3);
    }

    public void testBug66744() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("enum EColours { RED, GREEN, BLUE };      \n");
        ((Writer)stringWriter).write("void foo() {  EColours color = GREEN; }  \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("EColours color");
        this.parse(string, n, n + 8);
    }

    public void testBug68527() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct X;\n");
        ((Writer)stringWriter).write("struct X anA;");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("X anA");
        this.parse(string, n, n + 1);
    }

    public void testBug60407() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct ZZZ { int x, y, z; };\n");
        ((Writer)stringWriter).write("typedef struct ZZZ _FILE;\n");
        ((Writer)stringWriter).write("typedef _FILE FILE;\n");
        ((Writer)stringWriter).write("static void static_function(FILE * lcd){}\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("FILE * file = 0;\n");
        ((Writer)stringWriter).write("static_function( file );\n");
        ((Writer)stringWriter).write("return 0;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("static_function( file )");
        this.parse(string, n, n + "static_function".length());
    }

    public void testBug61800() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class B {};\n");
        ((Writer)stringWriter).write("class ABCDEF {\n");
        ((Writer)stringWriter).write(" static B stInt; };\n");
        ((Writer)stringWriter).write("B ABCDEF::stInt = 5;\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("::stInt") + 2;
        IASTNode iASTNode = this.parse(string, n, n + 5);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        SelectionParseTest.assertEquals((String)((IASTField)iASTNode).getName(), (String)"stInt");
    }

    public void testBug68739() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int fprintf( int *, const char *, ... );               \n");
        ((Writer)stringWriter).write("void boo( int * lcd ) {                                \n");
        ((Writer)stringWriter).write("  /**/fprintf( lcd, \"%c%s 0x%x\", ' ', \"bbb\", 2 );  \n");
        ((Writer)stringWriter).write("}                                                      \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("/**/fprintf") + 4;
        IASTNode iASTNode = this.parse(string, n, n + 7);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTFunction));
        SelectionParseTest.assertEquals((String)((IASTFunction)iASTNode).getName(), (String)"fprintf");
    }

    public void testBug72818() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("union Squaw\t{\tint x;\tdouble u; };\n");
        ((Writer)stringWriter).write("int\tmain(int argc, char **argv) {\n");
        ((Writer)stringWriter).write("return sizeof( Squaw );\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("sizeof( ") + "sizeof( ".length();
        IASTNode iASTNode = this.parse(string, n, n + 5);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTClassSpecifier));
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTNode;
        SelectionParseTest.assertEquals((Object)iASTClassSpecifier.getClassKind(), (Object)ASTClassKind.UNION);
        SelectionParseTest.assertEquals((String)iASTClassSpecifier.getName(), (String)"Squaw");
    }

    public void test72220() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("const int FOUND_ME = 1;\n");
        ((Writer)stringWriter).write("class Test{\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("const int findCode() const;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("const int Test::findCode() const {\n");
        ((Writer)stringWriter).write("return FOUND_ME;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("return ") + "return ".length();
        IASTNode iASTNode = this.parse(string, n, n + 8);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTVariable));
        SelectionParseTest.assertEquals((String)((IASTVariable)iASTNode).getName(), (String)"FOUND_ME");
    }

    public void testBug72721() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" class ABC { public: ABC(int); };   \n");
        ((Writer)stringWriter).write("void f() {                          \n");
        ((Writer)stringWriter).write("   int j = 1;                       \n");
        ((Writer)stringWriter).write("   new ABC( j + 1 );                \n");
        ((Writer)stringWriter).write("}                                   \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("ABC(");
        IASTNode iASTNode = this.parse(string, n, n + 3);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        SelectionParseTest.assertEquals((String)((IASTMethod)iASTNode).getName(), (String)"ABC");
        SelectionParseTest.assertTrue((boolean)((IASTMethod)iASTNode).isConstructor());
    }

    public void testBug72372() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace B {                                   \n");
        ((Writer)stringWriter).write("   class SD_02 { void f_SD(); };                \n");
        ((Writer)stringWriter).write("}                                               \n");
        ((Writer)stringWriter).write("using namespace B;                              \n");
        ((Writer)stringWriter).write("void SD_02::f_SD(){}                            \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(":f_SD");
        IASTNode iASTNode = this.parse(string, n + 1, n + 5);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        SelectionParseTest.assertEquals((String)((IASTMethod)iASTNode).getName(), (String)"f_SD");
    }

    public void testBug72372_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace A {                                   \n");
        ((Writer)stringWriter).write("   namespace B {                                \n");
        ((Writer)stringWriter).write("      void f_SD();                              \n");
        ((Writer)stringWriter).write("   }                                            \n");
        ((Writer)stringWriter).write("}                                               \n");
        ((Writer)stringWriter).write("namespace C {                                   \n");
        ((Writer)stringWriter).write("   using namespace A;                           \n");
        ((Writer)stringWriter).write("}                                               \n");
        ((Writer)stringWriter).write("void C::B::f_SD(){}                             \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(":f_SD");
        IASTNode iASTNode = this.parse(string, n + 1, n + 5);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTFunction));
        SelectionParseTest.assertEquals((String)((IASTFunction)iASTNode).getName(), (String)"f_SD");
    }

    public void testBug72713() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Deck{ void initialize(); };   \n");
        ((Writer)stringWriter).write("void Deck::initialize(){}           \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf(":initialize");
        IASTNode iASTNode = this.parse(string, n + 1, n + 11);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        SelectionParseTest.assertFalse((boolean)((IASTMethod)iASTNode).previouslyDeclared());
        SelectionParseTest.assertEquals((int)((IASTMethod)iASTNode).getNameOffset(), (int)(string.indexOf(" initialize();") + 1));
    }

    public void testBug72712() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class B{ public: B(); }; void f(){ B* b; b = new B(); }");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("new B") + 4;
        IASTNode iASTNode = this.parse(string, n, n + 1);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        SelectionParseTest.assertTrue((boolean)((IASTMethod)iASTNode).isConstructor());
    }

    public void testBug72712_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class A {};                                        \n");
        ((Writer)stringWriter).write("class B{ public: B( A* ); };                       \n");
        ((Writer)stringWriter).write("void f(){ B* b; b = new B( (A*)0 ); }              \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("(A*)") + 1;
        IASTNode iASTNode = this.parse(string, n, n + 1);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTClassSpecifier));
        SelectionParseTest.assertEquals((String)((IASTClassSpecifier)iASTNode).getName(), (String)"A");
    }

    public void testBug72814() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N{                               \n");
        ((Writer)stringWriter).write("   template < class T > class AAA { T _t };\n");
        ((Writer)stringWriter).write("}                                          \n");
        ((Writer)stringWriter).write("N::AAA<int> a;                             \n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("AAA<int>");
        IASTNode iASTNode = this.parse(string, n, n + 3);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTClassSpecifier));
        SelectionParseTest.assertEquals((String)((IASTClassSpecifier)iASTNode).getName(), (String)"AAA");
        iASTNode = this.parse(string, n, n + 8);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTClassSpecifier));
        SelectionParseTest.assertEquals((String)((IASTClassSpecifier)iASTNode).getName(), (String)"AAA");
    }

    public void testBug72710() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("class Card{\n");
        ((Writer)stringWriter).write("\tCard( int rank );\n");
        ((Writer)stringWriter).write(" int rank;\n");
        ((Writer)stringWriter).write("};\n");
        ((Writer)stringWriter).write("Card::Card( int rank ) {\n");
        ((Writer)stringWriter).write("this->rank = rank;\n");
        ((Writer)stringWriter).write("}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("this->rank") + 6;
        IASTNode iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        IASTField iASTField = (IASTField)iASTNode;
        SelectionParseTest.assertEquals((String)iASTField.getName(), (String)"rank");
    }

    public void testBug75731() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int rank() {\n");
        ((Writer)stringWriter).write("return 5;\n}\n");
        ((Writer)stringWriter).write("class Card{\n");
        ((Writer)stringWriter).write("private:\n");
        ((Writer)stringWriter).write("Card( int rank );\n");
        ((Writer)stringWriter).write("int rank;\n");
        ((Writer)stringWriter).write("public:\n");
        ((Writer)stringWriter).write("int getRank();\n};\n");
        ((Writer)stringWriter).write("Card::Card( int rank )\n{\n");
        ((Writer)stringWriter).write("this->rank = ::rank();\n");
        ((Writer)stringWriter).write("this->rank = this->rank;\n");
        ((Writer)stringWriter).write("this->rank = rank;\n");
        ((Writer)stringWriter).write("this->rank = Card::rank;\n");
        ((Writer)stringWriter).write("this->rank = getRank();\n}\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("int rank() {") + 4;
        IASTNode iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTFunction));
        IASTFunction iASTFunction = (IASTFunction)iASTNode;
        SelectionParseTest.assertEquals((String)iASTFunction.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTFunction.getNameOffset(), (int)n);
        n = string.indexOf("class Card{") + 6;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTClassSpecifier));
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTNode;
        SelectionParseTest.assertEquals((String)iASTClassSpecifier.getName(), (String)"Card");
        SelectionParseTest.assertEquals((int)iASTClassSpecifier.getNameOffset(), (int)n);
        n = string.indexOf("Card( int rank );");
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        IASTMethod iASTMethod = (IASTMethod)iASTNode;
        SelectionParseTest.assertEquals((String)iASTMethod.getName(), (String)"Card");
        SelectionParseTest.assertEquals((int)iASTMethod.getNameOffset(), (int)n);
        n = string.indexOf("Card( int rank );") + 10;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTParameterDeclaration));
        IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iASTNode;
        SelectionParseTest.assertEquals((String)iASTParameterDeclaration.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTParameterDeclaration.getNameOffset(), (int)n);
        n = string.indexOf("int rank;") + 4;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        IASTField iASTField = (IASTField)iASTNode;
        SelectionParseTest.assertEquals((String)iASTField.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTField.getNameOffset(), (int)n);
        n = string.indexOf("int getRank();") + 4;
        iASTNode = this.parse(string, n, n + 7);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        IASTMethod iASTMethod2 = (IASTMethod)iASTNode;
        SelectionParseTest.assertEquals((String)iASTMethod2.getName(), (String)"getRank");
        SelectionParseTest.assertEquals((int)iASTMethod2.getNameOffset(), (int)n);
        n = string.indexOf("Card::Card( int rank )");
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTClassSpecifier));
        IASTClassSpecifier iASTClassSpecifier2 = (IASTClassSpecifier)iASTNode;
        SelectionParseTest.assertEquals((String)iASTClassSpecifier2.getName(), (String)"Card");
        SelectionParseTest.assertEquals((int)iASTClassSpecifier2.getNameOffset(), (int)iASTClassSpecifier.getNameOffset());
        n = string.indexOf("Card::Card( int rank )") + 6;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        IASTMethod iASTMethod3 = (IASTMethod)iASTNode;
        SelectionParseTest.assertEquals((String)iASTMethod3.getName(), (String)"Card");
        SelectionParseTest.assertEquals((int)iASTMethod3.getNameOffset(), (int)iASTMethod.getNameOffset());
        n = string.indexOf("Card::Card( int rank )") + 16;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTParameterDeclaration));
        IASTParameterDeclaration iASTParameterDeclaration2 = (IASTParameterDeclaration)iASTNode;
        SelectionParseTest.assertEquals((String)iASTParameterDeclaration2.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTParameterDeclaration2.getNameOffset(), (int)n);
        n = string.indexOf("this->rank = ::rank();") + 6;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        IASTField iASTField2 = (IASTField)iASTNode;
        SelectionParseTest.assertEquals((String)iASTField2.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTField2.getNameOffset(), (int)iASTField.getNameOffset());
        n = string.indexOf("this->rank = ::rank();") + 15;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTFunction));
        IASTFunction iASTFunction2 = (IASTFunction)iASTNode;
        SelectionParseTest.assertEquals((String)iASTFunction2.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTFunction2.getNameOffset(), (int)iASTFunction.getNameOffset());
        n = string.indexOf("this->rank = this->rank;") + 6;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        IASTField iASTField3 = (IASTField)iASTNode;
        SelectionParseTest.assertEquals((String)iASTField3.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTField3.getNameOffset(), (int)iASTField.getNameOffset());
        n = string.indexOf("this->rank = this->rank;") + 19;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        IASTField iASTField4 = (IASTField)iASTNode;
        SelectionParseTest.assertEquals((String)iASTField4.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTField4.getNameOffset(), (int)iASTField.getNameOffset());
        n = string.indexOf("this->rank = rank;") + 6;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        IASTField iASTField5 = (IASTField)iASTNode;
        SelectionParseTest.assertEquals((String)iASTField5.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTField5.getNameOffset(), (int)iASTField.getNameOffset());
        n = string.indexOf("this->rank = rank;") + 13;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTParameterDeclaration));
        IASTParameterDeclaration iASTParameterDeclaration3 = (IASTParameterDeclaration)iASTNode;
        SelectionParseTest.assertEquals((String)iASTParameterDeclaration3.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTParameterDeclaration3.getNameOffset(), (int)iASTParameterDeclaration2.getNameOffset());
        n = string.indexOf("this->rank = Card::rank;") + 6;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        IASTField iASTField6 = (IASTField)iASTNode;
        SelectionParseTest.assertEquals((String)iASTField6.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTField6.getNameOffset(), (int)iASTField.getNameOffset());
        n = string.indexOf("this->rank = Card::rank;") + 19;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        IASTField iASTField7 = (IASTField)iASTNode;
        SelectionParseTest.assertEquals((String)iASTField7.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTField7.getNameOffset(), (int)iASTField.getNameOffset());
        n = string.indexOf("this->rank = getRank();") + 6;
        iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTField));
        IASTField iASTField8 = (IASTField)iASTNode;
        SelectionParseTest.assertEquals((String)iASTField8.getName(), (String)"rank");
        SelectionParseTest.assertEquals((int)iASTField8.getNameOffset(), (int)iASTField.getNameOffset());
        n = string.indexOf("this->rank = getRank();") + 13;
        iASTNode = this.parse(string, n, n + 7);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTMethod));
        IASTMethod iASTMethod4 = (IASTMethod)iASTNode;
        SelectionParseTest.assertEquals((String)iASTMethod4.getName(), (String)"getRank");
        SelectionParseTest.assertEquals((int)iASTMethod4.getNameOffset(), (int)iASTMethod2.getNameOffset());
    }

    public void testBug77989() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("namespace N {        /* A */\n");
        ((Writer)stringWriter).write("class C{};\n}\n");
        ((Writer)stringWriter).write("using namespace N;   /* B */\n");
        ((Writer)stringWriter).write("N::C c;              /* C */\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("using namespace N;") + 16;
        IASTNode iASTNode = this.parse(string, n, n + 1);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof ASTNamespaceDefinition));
        ASTNamespaceDefinition aSTNamespaceDefinition = (ASTNamespaceDefinition)iASTNode;
        SelectionParseTest.assertEquals((String)aSTNamespaceDefinition.getName(), (String)"N");
        SelectionParseTest.assertEquals((int)aSTNamespaceDefinition.getNameOffset(), (int)10);
        SelectionParseTest.assertEquals((int)aSTNamespaceDefinition.getStartingLine(), (int)1);
    }

    public void testBug78435() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int itself;          //A\n");
        ((Writer)stringWriter).write("void f(int itself){} //B\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("void f(int itself){}") + 11;
        IASTNode iASTNode = this.parse(string, n, n + 6);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof ASTParameterDeclaration));
        ASTParameterDeclaration aSTParameterDeclaration = (ASTParameterDeclaration)iASTNode;
        SelectionParseTest.assertEquals((String)aSTParameterDeclaration.getName(), (String)"itself");
        SelectionParseTest.assertEquals((int)aSTParameterDeclaration.getNameOffset(), (int)36);
        SelectionParseTest.assertEquals((int)aSTParameterDeclaration.getStartingLine(), (int)2);
    }

    public void testBug78231A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("struct Base {\n");
        ((Writer)stringWriter).write("int Data; // 1\n");
        ((Writer)stringWriter).write("struct Data; // 2\n};\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("struct Data;") + 7;
        IASTNode iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTOffsetableNamedElement));
        IASTOffsetableNamedElement iASTOffsetableNamedElement = (IASTOffsetableNamedElement)iASTNode;
        SelectionParseTest.assertEquals((String)iASTOffsetableNamedElement.getName(), (String)"Data");
        SelectionParseTest.assertEquals((int)iASTOffsetableNamedElement.getNameOffset(), (int)36);
        SelectionParseTest.assertEquals((int)iASTOffsetableNamedElement.getStartingLine(), (int)3);
    }

    public void testBug78231B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int Data;\n");
        ((Writer)stringWriter).write("struct Base {\n");
        ((Writer)stringWriter).write("int Data; // 1\n");
        ((Writer)stringWriter).write("struct Data; // 2\n};\n");
        String string = ((Object)stringWriter).toString();
        int n = string.indexOf("struct Data;") + 7;
        IASTNode iASTNode = this.parse(string, n, n + 4);
        SelectionParseTest.assertTrue((boolean)(iASTNode instanceof IASTOffsetableNamedElement));
        IASTOffsetableNamedElement iASTOffsetableNamedElement = (IASTOffsetableNamedElement)iASTNode;
        SelectionParseTest.assertEquals((String)iASTOffsetableNamedElement.getName(), (String)"Data");
        SelectionParseTest.assertEquals((int)iASTOffsetableNamedElement.getNameOffset(), (int)46);
        SelectionParseTest.assertEquals((int)iASTOffsetableNamedElement.getStartingLine(), (int)4);
    }
}

