/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.StructuralParseCallback;

public class StructuralParseTest
extends TestCase {
    protected StructuralParseCallback callback;

    protected IASTCompilationUnit parse(String string) throws ParserException, ParserFactoryError {
        return this.parse(string, true, ParserLanguage.CPP);
    }

    protected IASTCompilationUnit parse(String string, boolean bl) throws ParserException, ParserFactoryError {
        return this.parse(string, bl, ParserLanguage.CPP);
    }

    protected IASTCompilationUnit parse(String string, boolean bl, ParserLanguage parserLanguage) throws ParserException, ParserFactoryError {
        this.callback = new StructuralParseCallback();
        IParser iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(string.toCharArray()), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.STRUCTURAL_PARSE, (ParserLanguage)parserLanguage, (ISourceElementRequestor)this.callback, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)this.callback, (ParserMode)ParserMode.STRUCTURAL_PARSE, (ParserLanguage)parserLanguage, null);
        if (!iParser.parse() && bl) {
            throw new ParserException("FAILURE");
        }
        return this.callback.getCompilationUnit();
    }

    public void testBug60149() throws Exception {
        IASTCompilationUnit iASTCompilationUnit = this.parse("extern \"C\" { int v; } ");
        Iterator iterator = iASTCompilationUnit.getDeclarations();
        IASTLinkageSpecification iASTLinkageSpecification = (IASTLinkageSpecification)iterator.next();
        StructuralParseTest.assertFalse((boolean)iterator.hasNext());
        iterator = iASTLinkageSpecification.getDeclarations();
        IASTVariable iASTVariable = (IASTVariable)iterator.next();
        StructuralParseTest.assertEquals((String)iASTVariable.getName(), (String)"v");
        StructuralParseTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug60480() throws Exception {
        IASTCompilationUnit iASTCompilationUnit = this.parse("template < int > void foo();");
        Iterator iterator = iASTCompilationUnit.getDeclarations();
        IASTTemplateDeclaration iASTTemplateDeclaration = (IASTTemplateDeclaration)iterator.next();
        StructuralParseTest.assertFalse((boolean)iterator.hasNext());
        IASTFunction iASTFunction = (IASTFunction)iASTTemplateDeclaration.getOwnedDeclaration();
        StructuralParseTest.assertEquals((String)iASTFunction.getName(), (String)"foo");
    }

    public void testBug77010() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write(" struct Example{                                \n");
        ((Writer)stringWriter).write("    int                *deref();                \n");
        ((Writer)stringWriter).write("    int const          *deref() const;          \n");
        ((Writer)stringWriter).write("    int       volatile *deref()       volatile; \n");
        ((Writer)stringWriter).write("    int const volatile *deref() const volatile; \n");
        ((Writer)stringWriter).write(" };                                             \n");
        Iterator iterator = this.parse(((Object)stringWriter).toString()).getDeclarations();
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier();
        iterator = iASTClassSpecifier.getDeclarations();
        IASTMethod iASTMethod = (IASTMethod)iterator.next();
        StructuralParseTest.assertFalse((boolean)iASTMethod.getReturnType().isConst());
        StructuralParseTest.assertFalse((boolean)iASTMethod.getReturnType().isVolatile());
        StructuralParseTest.assertFalse((boolean)iASTMethod.isConst());
        StructuralParseTest.assertFalse((boolean)iASTMethod.isVolatile());
        iASTMethod = (IASTMethod)iterator.next();
        StructuralParseTest.assertTrue((boolean)iASTMethod.getReturnType().isConst());
        StructuralParseTest.assertFalse((boolean)iASTMethod.getReturnType().isVolatile());
        StructuralParseTest.assertTrue((boolean)iASTMethod.isConst());
        StructuralParseTest.assertFalse((boolean)iASTMethod.isVolatile());
        iASTMethod = (IASTMethod)iterator.next();
        StructuralParseTest.assertFalse((boolean)iASTMethod.getReturnType().isConst());
        StructuralParseTest.assertTrue((boolean)iASTMethod.getReturnType().isVolatile());
        StructuralParseTest.assertFalse((boolean)iASTMethod.isConst());
        StructuralParseTest.assertTrue((boolean)iASTMethod.isVolatile());
        iASTMethod = (IASTMethod)iterator.next();
        StructuralParseTest.assertTrue((boolean)iASTMethod.getReturnType().isConst());
        StructuralParseTest.assertTrue((boolean)iASTMethod.getReturnType().isVolatile());
        StructuralParseTest.assertTrue((boolean)iASTMethod.isConst());
        StructuralParseTest.assertTrue((boolean)iASTMethod.isVolatile());
        StructuralParseTest.assertFalse((boolean)iterator.hasNext());
    }
}

